/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wmts;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.ows.AbstractOWSRequest;
import com.vividsolutions.ows.OWService;
import com.vividsolutions.ows.wmts.Style;
import de.riwagis.util.thread.CancelableRunnable;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLegendGraphicRequest
extends AbstractOWSRequest {
    private static final Logger LOG = LoggerFactory.getLogger(GetLegendGraphicRequest.class);
    private Style style;

    public GetLegendGraphicRequest(OWService service) {
        super(service, "GetLegendGraphic");
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    @Override
    public String getURL() {
        if (this.style == null) {
            return null;
        }
        return this.style.getLegendURL();
    }

    public Image getImage(CancelableRunnable cancelable) throws IOException {
        BufferedImage bufferedImage;
        String strURL = this.getURL();
        if (StringUtils.isEmpty((CharSequence)strURL)) {
            return null;
        }
        HttpGet meth = new HttpGet(strURL);
        if (cancelable != null && cancelable.isCanceled()) {
            return null;
        }
        InputStream in = null;
        HttpResponse httpResponse = null;
        try {
            long time = System.currentTimeMillis();
            httpResponse = this.service.getServerNeedsLogin() ? WorkbenchContext.executeMethod((HttpUriRequest)meth, this.service.getCredentials()) : WorkbenchContext.executeMethod((HttpUriRequest)meth);
            in = httpResponse.getEntity().getContent();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                LOG.warn(String.format("Bogus status %d when accessing '%s'", statusCode, meth.getURI()));
            }
            bufferedImage = ImageIO.read(in);
        }
        catch (Throwable e) {
            try {
                throw new IOException(String.format("Error retrieving Image '%s': %s", strURL, e.getMessage()), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                if (httpResponse != null) {
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                }
                IOUtils.closeQuietly((Closeable)((Closeable)httpResponse));
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        if (httpResponse != null) {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        IOUtils.closeQuietly((Closeable)((Closeable)httpResponse));
        return bufferedImage;
    }
}

