/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wms.wmscapabilities;

import com.vividsolutions.ows.Capabilities;
import com.vividsolutions.ows.wms.MapLayer;
import com.vividsolutions.ows.wms.WMService;
import com.vividsolutions.ows.wms.wmscapabilities.BaseRequest;
import com.vividsolutions.ows.wms.wmscapabilities.RequestType;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class WMSCapabilities
extends Capabilities {
    private final MapLayer topLayer;
    private final int maxWidth;
    private final int maxHeight;
    private final Map<RequestType, BaseRequest> getRequests;

    public WMSCapabilities(WMService service, String title, MapLayer topLayer, Map<RequestType, BaseRequest> getRequests) {
        this(service, title, topLayer, getRequests, -1, -1);
    }

    public WMSCapabilities(WMService service, String title, MapLayer topLayer, Map<RequestType, BaseRequest> getRequests, int maxWidth, int maxHeight) {
        super(title, service);
        this.topLayer = topLayer;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.getRequests = getRequests;
    }

    @Override
    public WMService getService() {
        return (WMService)super.getService();
    }

    public MapLayer getTopLayer() {
        return this.topLayer;
    }

    public MapLayer getLayer(String lyName) {
        if (this.topLayer.getName() != null && this.topLayer.getName().equals(lyName)) {
            return this.topLayer;
        }
        return this.topLayer.getSubLayer(lyName);
    }

    public List<String> getRequestFormats(RequestType type) {
        return this.getRequests.get((Object)type).getFormats();
    }

    public String getRequestPostUrl(RequestType type) {
        return this.getRequests.get((Object)type).getDcpType().getHttp().getPost().getHref();
    }

    public String getRequestGetUrl(RequestType type) {
        if (this.getRequests.get((Object)type) == null) {
            return "";
        }
        return this.getRequests.get((Object)type).getDcpType().getHttp().getGet().getHref();
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Generated
    public Map<RequestType, BaseRequest> getGetRequests() {
        return this.getRequests;
    }
}

