/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wms.wmscapabilities;

import com.vividsolutions.ows.wms.WMService;
import com.vividsolutions.ows.wms.wmscapabilities.BaseRequest;
import com.vividsolutions.ows.wms.wmscapabilities.DCPType;
import com.vividsolutions.ows.wms.wmscapabilities.HTTP;
import com.vividsolutions.ows.wms.wmscapabilities.OnlineResource;
import com.vividsolutions.ows.wms.wmscapabilities.RequestType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class VersionedWMSRequestModel {
    protected final WMService service;
    protected final Namespace ns;

    protected VersionedWMSRequestModel(WMService service, Namespace ns) {
        this.service = service;
        this.ns = ns;
    }

    public Map<RequestType, BaseRequest> getRequests(Element requestElement) {
        HashMap<RequestType, BaseRequest> getRequests = new HashMap<RequestType, BaseRequest>();
        for (Element request : requestElement.getChildren()) {
            RequestType requestType = RequestType.getRequestByElementName(request.getName());
            OnlineResource onlineResourcePost = new OnlineResource(this.getOnlineResourceHref(request, "Post"));
            OnlineResource onlineResourceGet = new OnlineResource(this.getOnlineResourceHref(request, "Get"));
            HTTP http = new HTTP(onlineResourceGet, onlineResourcePost);
            DCPType dcpType = new DCPType(http);
            List<String> formats = this.getFormatChildren(request);
            BaseRequest baseRequest = new BaseRequest(formats, dcpType);
            getRequests.put(requestType, baseRequest);
        }
        return getRequests;
    }

    protected List<String> getFormatChildren(Element request) {
        LinkedList<String> formatList = new LinkedList<String>();
        for (Element e : request.getChildren("Format", this.ns)) {
            formatList.add(e.getValue());
        }
        return formatList;
    }

    protected String getOnlineResourceHref(Element request, String nameOfHTTPChild) {
        Namespace xlinkNamespace = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
        return this.getHttpChildByName(request, nameOfHTTPChild).flatMap(get -> Optional.ofNullable(get.getChild("OnlineResource", this.ns))).map(onlineResource -> onlineResource.getAttributeValue("href", xlinkNamespace)).orElse("");
    }

    protected Optional<Element> getHttpChildByName(Element request, String nameOfHTTPChild) {
        return Optional.ofNullable(request.getChild("DCPType", this.ns)).flatMap(dcp -> Optional.ofNullable(dcp.getChild("HTTP", this.ns))).flatMap(http -> Optional.ofNullable(http.getChild(nameOfHTTPChild, this.ns)));
    }
}

