/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wms;

import com.vividsolutions.ows.AbstractOWService;
import com.vividsolutions.ows.OWService;
import com.vividsolutions.ows.Parser;
import com.vividsolutions.ows.wms.MapLayer;
import com.vividsolutions.ows.wms.MapRequest;
import com.vividsolutions.ows.wms.WMSParser;
import com.vividsolutions.ows.wms.wmscapabilities.RequestType;
import com.vividsolutions.ows.wms.wmscapabilities.WMSCapabilities;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMService
extends AbstractOWService {
    private static final Logger LOG = LoggerFactory.getLogger(WMService.class);
    public static final String WMS_1_1_0 = "1.1.0";
    public static final String WMS_1_1_1 = "1.1.1";
    public static final String WMS_1_3_0 = "1.3.0";

    public WMService(String serverUrl, String wmsVersion) {
        super(serverUrl, wmsVersion);
    }

    public WMService(String serverUrl) {
        this(serverUrl, WMS_1_1_1);
    }

    @Override
    public OWService.OWSType getType() {
        return OWService.OWSType.WMS;
    }

    public String getLayerTitle(String layerName) {
        if (this.capabilities == null) {
            return layerName;
        }
        MapLayer ly = ((WMSCapabilities)this.capabilities).getLayer(layerName);
        if (ly == null) {
            return layerName;
        }
        return ly.getTitle();
    }

    @Override
    public WMSCapabilities getCapabilities() throws IOException {
        return (WMSCapabilities)super.getCapabilities();
    }

    public String getAppropriateGetServerUrlForRequest(RequestType type) throws IOException {
        Object url;
        Object object = url = this.isInternal() ? this.getServerUrl() : this.getCapabilities().getRequestGetUrl(type);
        if (url == null || ((String)url).isEmpty()) {
            return "";
        }
        if (!((String)url).contains("?")) {
            url = (String)url + "?";
        } else if (!((String)url).endsWith("&")) {
            url = (String)url + "&";
        }
        return url;
    }

    @Override
    public String getServerUrl() {
        return super.getServerUrl();
    }

    public MapRequest createMapRequest() throws IOException {
        MapRequest mr = new MapRequest(this);
        return mr;
    }

    @Override
    protected Parser createParser() {
        return new WMSParser();
    }
}

