/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.ows.Capabilities;
import com.vividsolutions.ows.OWService;
import com.vividsolutions.ows.Parser;
import com.vividsolutions.ows.wms.BoundingBox;
import com.vividsolutions.ows.wms.MapLayer;
import com.vividsolutions.ows.wms.WMService;
import com.vividsolutions.ows.wms.wmscapabilities.BaseRequest;
import com.vividsolutions.ows.wms.wmscapabilities.RequestType;
import com.vividsolutions.ows.wms.wmscapabilities.VersionedWMSRequestModel;
import com.vividsolutions.ows.wms.wmscapabilities.VersionedWMSRequestModelFactory;
import com.vividsolutions.ows.wms.wmscapabilities.WMSCapabilities;
import de.riwagis.util.xml.XMLSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSParser
extends Parser {
    private static final Logger LOG = LoggerFactory.getLogger(WMSParser.class);

    @Override
    public Capabilities parseCapabilities(OWService service, InputStream inStream) throws IOException {
        return switch (Objects.toString(service.getVersion())) {
            case "1.1.1", "1.1.0" -> this.parseCapabilities_1_1_1((WMService)service, inStream);
            case "1.3.0" -> this.parseCapabilities_1_3_0((WMService)service, inStream);
            default -> this.parseCapabilities_1_0_0((WMService)service, inStream);
        };
    }

    public MapLayer wmsLayerFromNode(Element layerElem) {
        String name = "";
        String title = null;
        String wmsAbstract = "";
        LinkedList<String> srsList = new LinkedList<String>();
        LinkedList<MapLayer> subLayers = new LinkedList<MapLayer>();
        BoundingBox llbbox = null;
        BoundingBox bbox = null;
        boolean queryable = false;
        ArrayList<BoundingBox> boundingBoxList = new ArrayList<BoundingBox>();
        Namespace ns = layerElem.getNamespace();
        Attribute qAtt = layerElem.getAttribute("queryable");
        if (qAtt != null && qAtt.getValue().equals("1")) {
            queryable = true;
        }
        for (Element e : layerElem.getChildren()) {
            try {
                if (e.getName().equalsIgnoreCase("Name")) {
                    name = e.getText();
                    continue;
                }
                if (e.getName().equalsIgnoreCase("Title")) {
                    title = e.getText();
                    continue;
                }
                if (e.getName().equalsIgnoreCase("Abstract")) {
                    wmsAbstract = e.getText();
                    continue;
                }
                if (e.getName().equalsIgnoreCase("SRS") || e.getName().equalsIgnoreCase("CRS")) {
                    String srsStr = e.getText();
                    while (srsStr.length() > 0) {
                        int ws = srsStr.indexOf(32);
                        if (ws > 0) {
                            srsList.add(srsStr.substring(0, ws));
                            srsStr = srsStr.substring(ws + 1);
                            continue;
                        }
                        if (srsStr.length() <= 0) continue;
                        srsList.add(srsStr);
                        srsStr = "";
                    }
                    continue;
                }
                if (e.getName().equalsIgnoreCase("EX_GeographicBoundingBox")) {
                    double minx = Double.parseDouble(e.getChild("westBoundLongitude", ns).getText());
                    double maxx = Double.parseDouble(e.getChild("eastBoundLongitude", ns).getText());
                    double miny = Double.parseDouble(e.getChild("southBoundLatitude", ns).getText());
                    double maxy = Double.parseDouble(e.getChild("northBoundLatitude", ns).getText());
                    llbbox = new BoundingBox("", minx, miny, maxx, maxy);
                    continue;
                }
                if (e.getName().equalsIgnoreCase("LatLonBoundingBox")) {
                    llbbox = this.boundingBoxFromNode(e);
                    boundingBoxList.add(llbbox);
                    continue;
                }
                if (e.getName().equalsIgnoreCase("BoundingBox")) {
                    bbox = this.boundingBoxFromNode(e);
                    boundingBoxList.add(bbox);
                    continue;
                }
                if (!e.getName().equalsIgnoreCase("Layer")) continue;
                subLayers.add(this.wmsLayerFromNode(e));
            }
            catch (Exception ex) {
                LOG.error("Exception caught in wmsLayerFromNode(): " + ex.toString(), (Throwable)ex);
            }
        }
        if (title == null) {
            title = Objects.requireNonNullElse(name, "no title");
        }
        return new MapLayer(name, title, wmsAbstract, srsList, subLayers, bbox, llbbox, boundingBoxList, queryable, false);
    }

    public BoundingBox boundingBoxFromNode(Element e) throws Exception {
        try {
            String srs = "";
            if (e.getName().equalsIgnoreCase("LatLonBoundingBox")) {
                srs = "LatLon";
            } else if (e.getName().equalsIgnoreCase("BoundingBox")) {
                Attribute attSRS = e.getAttribute("SRS");
                if (attSRS == null) {
                    attSRS = e.getAttribute("CRS");
                }
                srs = attSRS.getValue();
            }
            double minx = e.getAttribute("minx").getValue().equalsIgnoreCase("inf") ? Double.NEGATIVE_INFINITY : Double.parseDouble(e.getAttribute("minx").getValue());
            double miny = e.getAttribute("miny").getValue().equalsIgnoreCase("inf") ? Double.NEGATIVE_INFINITY : Double.parseDouble(e.getAttribute("miny").getValue());
            double maxx = e.getAttribute("maxx").getValue().equalsIgnoreCase("inf") ? Double.POSITIVE_INFINITY : Double.parseDouble(e.getAttribute("maxx").getValue());
            double maxy = e.getAttribute("maxy").getValue().equalsIgnoreCase("inf") ? Double.POSITIVE_INFINITY : Double.parseDouble(e.getAttribute("maxy").getValue());
            return new BoundingBox(srs, minx, miny, maxx, maxy);
        }
        catch (Exception ex) {
            LOG.error("Error in boundingBoxFromNode", (Throwable)ex);
            throw new Exception(I18N.get("com.vividsolutions.wms.Parser.invalid-bounding-box-element-node") + ": " + ex.toString(), ex);
        }
    }

    private Capabilities parseCapabilities_1_0_0(WMService service, InputStream inStream) throws IOException {
        try {
            LinkedList<String> formatList = new LinkedList<String>();
            Document doc = XMLSupport.build((InputStream)inStream);
            Element rElem = doc.getRootElement();
            Namespace ns = rElem.getNamespace();
            String title = WMSParser.readWMSTitle(rElem, ns);
            Element capabilityElem = rElem.getChild("Capability", ns);
            Element requestElem = capabilityElem.getChild("Request", ns);
            for (Element eFmt : requestElem.getChild("Map", ns).getChild("Format", ns).getChildren()) {
                formatList.add(eFmt.getName());
            }
            Map<RequestType, BaseRequest> requests = this.getRequests(service, requestElem, ns);
            MapLayer topLayer = this.wmsLayerFromNode(capabilityElem.getChild("Layer", ns));
            return new WMSCapabilities(service, title, topLayer, requests);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private Capabilities parseCapabilities_1_1_1(WMService service, InputStream inStream) throws IOException {
        try {
            Document doc = XMLSupport.build((InputStream)inStream);
            Element rElem = doc.getRootElement();
            Namespace ns = rElem.getNamespace();
            String title = WMSParser.readWMSTitle(rElem, ns);
            Element capabilityElem = rElem.getChild("Capability", ns);
            MapLayer topLayer = this.wmsLayerFromNode(capabilityElem.getChild("Layer", ns));
            Element requestElem = capabilityElem.getChild("Request", ns);
            Map<RequestType, BaseRequest> requests = this.getRequests(service, requestElem, ns);
            return new WMSCapabilities(service, title, topLayer, requests);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static void readFormat1_1_x(Element requestElem, Namespace ns, Collection<String> formatList) {
        for (Element eFmt : requestElem.getChild("GetMap", ns).getChildren("Format", ns)) {
            formatList.add(eFmt.getText());
        }
    }

    private Capabilities parseCapabilities_1_3_0(WMService service, InputStream inStream) throws IOException {
        try {
            Element eMaxHeight;
            Document doc = XMLSupport.build((InputStream)inStream);
            Element rElem = doc.getRootElement();
            Namespace ns = rElem.getNamespace();
            String title = WMSParser.readWMSTitle(rElem, ns);
            Element capabilityElem = rElem.getChild("Capability", ns);
            MapLayer topLayer = this.wmsLayerFromNode(capabilityElem.getChild("Layer", ns));
            int maxWidth = -1;
            int maxHeight = -1;
            Element eMaxWidth = rElem.getChild("Service", ns).getChild("MaxWidth", ns);
            if (eMaxWidth != null) {
                maxWidth = Integer.parseInt(eMaxWidth.getText());
            }
            if ((eMaxHeight = rElem.getChild("Service", ns).getChild("MaxHeight", ns)) != null) {
                maxHeight = Integer.parseInt(eMaxHeight.getText());
            }
            Element requestElem = capabilityElem.getChild("Request", ns);
            Map<RequestType, BaseRequest> requests = this.getRequests(service, requestElem, ns);
            return new WMSCapabilities(service, title, topLayer, requests, maxWidth, maxHeight);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static String readWMSTitle(Element rElem, Namespace ns) throws IOException {
        String title;
        try {
            title = rElem.getChild("Service", ns).getChild("Title", ns).getText();
        }
        catch (Exception e) {
            throw new IOException("Maybe wrong Capabilities Version! ", e);
        }
        return title;
    }

    private Map<RequestType, BaseRequest> getRequests(WMService service, Element requestElement, Namespace ns) {
        VersionedWMSRequestModel model = VersionedWMSRequestModelFactory.createRequestModel(service, ns);
        return model.getRequests(requestElement);
    }
}

