/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wms;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.ows.wms.BoundingBox;
import com.vividsolutions.ows.wms.MapLayer;
import com.vividsolutions.ows.wms.WMService;
import com.vividsolutions.ows.wms.wmscapabilities.RequestType;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.util.thread.Cancelable;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRequest {
    private static final Logger LOG = LoggerFactory.getLogger(MapRequest.class);
    private static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    private static final Set<String> TEXT_CONTENT_TYPES = Set.of("text/plain", "text/html");
    private final WMService service;
    private int imgWidth;
    private int imgHeight;
    private final List<String> layerList;
    private List<String> queryLayerList;
    private BoundingBox bbox;
    private boolean transparent;
    private String format;
    private String defaultFeatureInfoCharset;
    private String version = "1.1.1";
    private int x;
    private int y;

    public MapRequest(WMService service) throws IOException {
        this.service = service;
        this.imgWidth = 100;
        this.imgHeight = 100;
        this.layerList = new ArrayList<String>();
        this.bbox = service.getCapabilities().getTopLayer().getBoundingBox();
        this.transparent = false;
        this.format = null;
        this.version = service.getVersion();
    }

    public WMService getService() {
        return this.service;
    }

    public String getFormat() {
        return this.format;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public List<String> getLayerNames() {
        return Collections.unmodifiableList(this.layerList);
    }

    public List<String> getQueryableLayerNames() throws IOException {
        if (this.service.getCapabilities().getRequestFormats(RequestType.GET_FEATURE_INFO).isEmpty()) {
            return new ArrayList<String>();
        }
        if (this.queryLayerList == null) {
            this.queryLayerList = new ArrayList<String>();
            for (String strLy : this.layerList) {
                MapLayer ly = this.service.getCapabilities().getLayer(strLy);
                if (ly == null || !ly.getQueryable()) continue;
                this.queryLayerList.add(strLy);
            }
        }
        return Collections.unmodifiableList(this.queryLayerList);
    }

    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    public boolean getTransparent() {
        return this.transparent;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setFormat(String format) throws IllegalArgumentException {
        this.format = format;
    }

    public void setImageWidth(int imageWidth) {
        this.imgWidth = imageWidth;
    }

    public void setImageHeight(int imageHeight) {
        this.imgHeight = imageHeight;
    }

    public void setImageSize(int imageWidth, int imageHeight) {
        this.imgWidth = imageWidth;
        this.imgHeight = imageHeight;
    }

    public void setLayerNames(List<String> layerList) {
        this.layerList.clear();
        this.layerList.addAll(layerList);
        this.queryLayerList = null;
    }

    public void setBoundingBox(BoundingBox bbox) {
        this.bbox = bbox;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean getQueryable() throws IOException {
        for (String strLy : this.layerList) {
            MapLayer ly = this.service.getCapabilities().getLayer(strLy);
            if (ly == null || !ly.getQueryable()) continue;
            return true;
        }
        return false;
    }

    private static String listToString(List<String> list) {
        ArrayList<String> buf = new ArrayList<String>(list.size());
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String layer;
            String encLayer = layer = iterator.next();
            try {
                encLayer = URLEncoder.encode(layer, "UTF-8").replaceAll("\\+", "%20");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            buf.add(encLayer);
        }
        return StringUtils.join(buf.iterator(), (String)"%2C");
    }

    private String getURL() {
        try {
            StringBuilder urlBuf = new StringBuilder();
            String ver = "REQUEST=map&WMTVER=1.0";
            if ("1.1.0".equals(this.version)) {
                ver = "REQUEST=GetMap&SERVICE=WMS&VERSION=1.1.0";
            } else if ("1.1.1".equals(this.version)) {
                ver = "REQUEST=GetMap&SERVICE=WMS&VERSION=1.1.1";
            } else if ("1.3.0".equals(this.version)) {
                ver = "REQUEST=GetMap&SERVICE=WMS&VERSION=1.3.0";
            }
            String url = this.service.getAppropriateGetServerUrlForRequest(RequestType.GET_MAP);
            urlBuf.append(url).append(ver).append("&WIDTH=").append(this.imgWidth).append("&HEIGHT=").append(this.imgHeight);
            urlBuf.append("&LAYERS=").append(MapRequest.listToString(this.layerList));
            if (this.transparent && !StringUtils.equals((CharSequence)this.format, (CharSequence)"image/jpeg")) {
                urlBuf.append("&TRANSPARENT=TRUE");
            }
            if (this.format != null) {
                urlBuf.append("&FORMAT=").append(this.format);
            }
            this.appendBBox(urlBuf);
            urlBuf.append("&STYLES=");
            return urlBuf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void appendBBox(StringBuilder urlBuf) {
        if (this.bbox != null && this.bbox.getSRS() != null && !this.bbox.getSRS().equals("LatLon")) {
            CoordinateReferenceSystem crs = null;
            try {
                crs = CRS.decode((String)this.bbox.getSRS());
            }
            catch (FactoryException ex) {
                LOG.error(String.format("Konvertierung von BBOX-SRS '%s' in CRS nicht m\u00f6glich!", this.bbox.getSRS()), (Throwable)ex);
            }
            if ("1.3.0".equals(this.version) && this.bbox.getSRS().toLowerCase().startsWith("epsg")) {
                if (crs == null) {
                    urlBuf.append("&BBOX=").append(this.bbox.getMinX()).append(",").append(this.bbox.getMinY()).append(",").append(this.bbox.getMaxX()).append(",").append(this.bbox.getMaxY());
                } else if (CRSDefFactory.isAxisInverted((CoordinateReferenceSystem)crs)) {
                    urlBuf.append("&BBOX=").append(this.bbox.getMinY()).append(",").append(this.bbox.getMinX()).append(",").append(this.bbox.getMaxY()).append(",").append(this.bbox.getMaxX());
                } else {
                    urlBuf.append("&BBOX=").append(this.bbox.getMinX()).append(",").append(this.bbox.getMinY()).append(",").append(this.bbox.getMaxX()).append(",").append(this.bbox.getMaxY());
                }
            } else {
                urlBuf.append("&BBOX=").append(this.bbox.getMinX()).append(",").append(this.bbox.getMinY()).append(",").append(this.bbox.getMaxX()).append(",").append(this.bbox.getMaxY());
            }
            if ("1.3.0".equals(this.version)) {
                urlBuf.append("&CRS=");
            } else {
                urlBuf.append("&SRS=");
            }
            urlBuf.append(this.bbox.getSRS());
        }
    }

    private String getFeatureInfoURL(String strLayer) {
        try {
            StringBuilder urlBuf = new StringBuilder();
            String ver = "REQUEST=feature_info&WMTVER=1.0.0";
            if ("1.1.0".equals(this.version)) {
                ver = "REQUEST=GetFeatureInfo&SERVICE=WMS&VERSION=1.1.0";
            } else if ("1.1.1".equals(this.version)) {
                ver = "REQUEST=GetFeatureInfo&SERVICE=WMS&VERSION=1.1.1";
            } else if ("1.3.0".equals(this.version)) {
                ver = "REQUEST=GetFeatureInfo&SERVICE=WMS&VERSION=1.3.0";
            }
            String url = this.service.getAppropriateGetServerUrlForRequest(RequestType.GET_FEATURE_INFO);
            if (url.isEmpty()) {
                LOG.debug("MapRequest.getFeatureInfoURL: no server URL for info request for layer '{}'", (Object)strLayer);
                return "";
            }
            urlBuf.append(url).append(ver).append("&WIDTH=").append(this.imgWidth).append("&HEIGHT=").append(this.imgHeight);
            urlBuf.append("&LAYERS=").append(MapRequest.listToString(this.layerList));
            if (this.format != null) {
                urlBuf.append("&FORMAT=").append(this.format);
            }
            this.appendBBox(urlBuf);
            urlBuf.append("&QUERY_LAYERS=").append(URLEncoder.encode(strLayer, "UTF-8").replaceAll("\\+", "%20"));
            if ("1.3.0".equals(this.version)) {
                urlBuf.append("&I=").append(this.x);
                urlBuf.append("&J=").append(this.y);
            } else {
                urlBuf.append("&X=").append(this.x);
                urlBuf.append("&Y=").append(this.y);
            }
            String strInfoFormat = this.service.getCapabilities().getRequestFormats(RequestType.GET_FEATURE_INFO).stream().filter(infoFormat -> infoFormat.equalsIgnoreCase(CONTENT_TYPE_TEXT_HTML)).findAny().map(value -> CONTENT_TYPE_TEXT_HTML).orElse(CONTENT_TYPE_TEXT_PLAIN);
            urlBuf.append("&INFO_FORMAT=").append(strInfoFormat).append("&STYLES=&FEATURE_COUNT=100");
            return urlBuf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private String getLegendGraphicURL(String layerName) throws IOException, MalformedURLException, UnsupportedEncodingException {
        String serverURL = this.service.getAppropriateGetServerUrlForRequest(RequestType.GET_LEGEND_GRAPHIC);
        if (serverURL.isEmpty()) {
            LOG.debug("MapRequest.getLegendGraphicURL: no server URL for legend graphic request for layer '{}'", (Object)layerName);
            return "";
        }
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(serverURL);
        sbUrl.append("&SERVICE=WMS&REQUEST=GetLegendGraphic&VERSION=");
        sbUrl.append(this.getService().getVersion());
        sbUrl.append("&FORMAT=image/png&WIDTH=16&HEIGHT=16");
        sbUrl.append("&LAYER=");
        sbUrl.append(URLEncoder.encode(layerName, "UTF-8").replaceAll("\\+", "%20"));
        return sbUrl.toString();
    }

    public Image[] getLegendGraphics(Cancelable runner) throws IOException {
        Image[] images = new Image[this.layerList.size()];
        int counter = 0;
        for (String strLayer : this.layerList) {
            String strURL = this.getLegendGraphicURL(strLayer);
            if (strURL.isEmpty()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Query to WMS - URL: '%s'", strURL));
            }
            HttpGet meth = new HttpGet(strURL);
            if (runner != null && runner.isCanceled()) {
                return null;
            }
            if (this.getLayerNames().isEmpty() || this.getLayerNames().size() == 1 && StringUtils.isBlank((CharSequence)this.getLayerNames().get(0))) {
                return null;
            }
            InputStream in = null;
            HttpResponse httpResponse = null;
            try {
                long time = System.currentTimeMillis();
                httpResponse = this.service.getServerNeedsLogin() ? WorkbenchContext.executeMethod((HttpUriRequest)meth, this.service.getCredentials()) : WorkbenchContext.executeMethod((HttpUriRequest)meth);
                in = httpResponse.getEntity().getContent();
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    LOG.warn(String.format("Bogus status %d when accessing '%s'", statusCode, meth.getURI()));
                }
                BufferedImage bufferedImage = ImageIO.read(in);
                LOG.debug(String.format("WMS getImage - '%s' - Time: %d ms", strURL, System.currentTimeMillis() - time));
                images[counter] = bufferedImage;
                ++counter;
            }
            catch (Throwable e) {
                try {
                    throw new IOException(String.format("Error retrieving Image '%s': %s", strURL, e.getMessage()), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    if (httpResponse != null) {
                        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                    }
                    IOUtils.closeQuietly((Closeable)((Closeable)httpResponse));
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            if (httpResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
            IOUtils.closeQuietly((Closeable)((Closeable)httpResponse));
        }
        return images;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getImage(Cancelable runner) throws IOException {
        BufferedImage bufferedImage;
        if (this.layerList.isEmpty()) {
            LOG.debug(String.format("no WMS layers, returning empty image (%d/%d)", this.imgWidth, this.imgHeight));
            return new BufferedImage(this.imgWidth, this.imgHeight, 2);
        }
        String strURL = this.getURL();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Query to WMS - URL: '%s'", strURL));
        }
        HttpGet meth = new HttpGet(strURL);
        if (runner != null && runner.isCanceled()) {
            return null;
        }
        if (this.getLayerNames().isEmpty() || this.getLayerNames().size() == 1 && StringUtils.isBlank((CharSequence)this.getLayerNames().get(0))) {
            return null;
        }
        InputStream in = null;
        HttpResponse httpResponse = null;
        try {
            String rawResponseFormat;
            String responseFormat;
            long time = System.currentTimeMillis();
            httpResponse = this.service.getServerNeedsLogin() ? WorkbenchContext.executeMethod((HttpUriRequest)meth, this.service.getCredentials()) : WorkbenchContext.executeMethod((HttpUriRequest)meth);
            in = httpResponse.getEntity().getContent();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException(String.format("Map request with bogus status %d when accessing '%s'", statusCode, meth.getURI()));
            }
            String requestFormat = this.getFormat();
            if (!requestFormat.equals(responseFormat = StringUtils.substringBefore((String)(rawResponseFormat = httpResponse.getFirstHeader("Content-Type").getValue()), (String)";").trim())) {
                if (TEXT_CONTENT_TYPES.contains(responseFormat)) {
                    String serviceResponse = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                    throw new IOException(String.format("Response is not an image but text: %s", serviceResponse));
                }
                throw new IOException(String.format("Requested format '%s' is not matching response format '%s'", requestFormat, responseFormat));
            }
            BufferedImage bufferedImage2 = ImageIO.read(in);
            LOG.debug(String.format("WMS getImage - '%s' - Time: %d ms", strURL, System.currentTimeMillis() - time));
            bufferedImage = bufferedImage2;
        }
        catch (IOException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new IOException(String.format("Error retrieving Image '%s': %s", strURL, e2.getMessage()), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                if (httpResponse != null) {
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                }
                IOUtils.closeQuietly((Closeable)((Closeable)httpResponse));
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        if (httpResponse != null) {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        IOUtils.closeQuietly((Closeable)((Closeable)httpResponse));
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getFeatureInfo() throws IOException {
        List<String> lstLayers = this.getQueryableLayerNames();
        String[][] arrInfo = new String[3][lstLayers.size()];
        int counter = 0;
        for (String strLayer : lstLayers) {
            arrInfo[0][counter] = this.getService().getCapabilities().getLayer(strLayer).getTitle();
            arrInfo[2][counter] = this.getFeatureInfoURL(strLayer);
            HttpGet methGet = new HttpGet(arrInfo[2][counter]);
            HttpResponse httpResponse = null;
            try {
                httpResponse = this.service.getServerNeedsLogin() ? WorkbenchContext.executeMethod((HttpUriRequest)methGet, this.service.getCredentials()) : WorkbenchContext.executeMethod((HttpUriRequest)methGet);
                String htmlContent = StringUtils.isNotEmpty((CharSequence)this.defaultFeatureInfoCharset) ? EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)Charset.forName(this.defaultFeatureInfoCharset)) : EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                arrInfo[1][counter] = this.attachBaseTagToHtmlContent(htmlContent);
            }
            finally {
                if (httpResponse != null) {
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                }
                IOUtils.closeQuietly((Closeable)((Closeable)httpResponse));
            }
            ++counter;
        }
        return arrInfo;
    }

    private String attachBaseTagToHtmlContent(String htmlContent) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)htmlContent)) {
            String serverURL = this.service.getCapabilities().getRequestGetUrl(RequestType.GET_CAPABLITIES);
            String baseUrl = serverURL.substring(0, serverURL.indexOf(47, serverURL.indexOf("//") + 2));
            if (!StringUtils.containsIgnoreCase((CharSequence)htmlContent, (CharSequence)"<base") && StringUtils.containsIgnoreCase((CharSequence)htmlContent, (CharSequence)"</head>")) {
                int indexOfHeadEnding = StringUtils.indexOfIgnoreCase((CharSequence)htmlContent, (CharSequence)"</head>");
                if (indexOfHeadEnding == -1) {
                    LOG.warn("feature info is missing head end tag. Cannot insert base href url.");
                    return htmlContent;
                }
                StringBuilder sb = new StringBuilder(htmlContent);
                sb.insert(indexOfHeadEnding, "<base href=\"" + baseUrl + "/\">");
                return sb.toString();
            }
        }
        return htmlContent;
    }

    public void setVersion(String ver) {
        this.version = ver;
    }

    public void setDefaultFeatureInfoCharset(String defaultFeatureInfoCharset) {
        this.defaultFeatureInfoCharset = defaultFeatureInfoCharset;
    }
}

