/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wms;

import com.vividsolutions.ows.wms.BoundingBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MapLayer {
    private MapLayer parent = null;
    private final String name;
    private final String title;
    private final Set<String> srsList;
    private final List<MapLayer> subLayers;
    private final BoundingBox bbox;
    private final BoundingBox llbbox;
    private final boolean bolQueryable;
    private final boolean dead;
    private final String wmsAbstract;
    private Collection<BoundingBox> boundingBoxList;

    public MapLayer(String name, String title, String wmsAbstract, Collection<String> srsList, List<MapLayer> subLayers, BoundingBox bbox, BoundingBox llbbox, boolean bolQueryable, boolean dead) {
        this.name = name;
        this.title = title;
        this.wmsAbstract = wmsAbstract;
        this.srsList = new HashSet<String>(srsList);
        this.subLayers = new ArrayList<MapLayer>(subLayers);
        for (MapLayer subLy : subLayers) {
            subLy.parent = this;
        }
        this.bbox = bbox;
        this.llbbox = llbbox;
        this.bolQueryable = bolQueryable;
        this.dead = dead;
    }

    public MapLayer(String name, String title, String wmsAbstract, Collection<String> srsList, List<MapLayer> subLayers, BoundingBox bbox, BoundingBox llbbox, Collection<BoundingBox> boundingBoxList, boolean bolQueryable, boolean dead) {
        this(name, title, wmsAbstract, srsList, subLayers, bbox, llbbox, bolQueryable, dead);
        this.boundingBoxList = boundingBoxList;
    }

    public List<BoundingBox> getAllBoundingBoxList() {
        MapLayer mapLayer = this;
        List<BoundingBox> allBoundingBoxList = this.getBoundingBoxList();
        if (!allBoundingBoxList.isEmpty()) {
            return allBoundingBoxList;
        }
        while (mapLayer != null) {
            if ((mapLayer = mapLayer.getParent()) == null) {
                return allBoundingBoxList;
            }
            List<BoundingBox> subLayerBBox = mapLayer.getBoundingBoxList();
            if (subLayerBBox.isEmpty()) continue;
            return subLayerBBox;
        }
        return allBoundingBoxList;
    }

    public int numSubLayers() {
        return this.subLayers.size();
    }

    public MapLayer getSubLayer(int n) {
        return this.subLayers.get(n);
    }

    public MapLayer getSubLayer(String lyName) {
        if (this.subLayers == null) {
            return null;
        }
        for (MapLayer subLy : this.subLayers) {
            if (subLy.getName().equals(lyName)) {
                return subLy;
            }
            MapLayer subSubLy = subLy.getSubLayer(lyName);
            if (subSubLy == null) continue;
            return subSubLy;
        }
        return null;
    }

    public List<MapLayer> getSubLayerList() {
        return new ArrayList<MapLayer>(this.subLayers);
    }

    public List<MapLayer> getLayerList() {
        ArrayList<MapLayer> list = new ArrayList<MapLayer>();
        list.add(this);
        for (MapLayer currMapLayer : this.subLayers) {
            list.addAll(currMapLayer.getLayerList());
        }
        return list;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public boolean getQueryable() {
        return this.bolQueryable;
    }

    public MapLayer getParent() {
        return this.parent;
    }

    public BoundingBox getBoundingBox() {
        if (this.bbox != null) {
            return this.bbox;
        }
        if (this.parent != null) {
            return this.parent.getBoundingBox();
        }
        return null;
    }

    public BoundingBox getLatLonBoundingBox() {
        if (this.bbox != null) {
            return this.llbbox;
        }
        if (this.parent != null) {
            return this.parent.getLatLonBoundingBox();
        }
        return null;
    }

    public List<BoundingBox> getBoundingBoxList() {
        return new ArrayList<BoundingBox>(this.boundingBoxList);
    }

    public Set<String> getSRSList() {
        return Collections.unmodifiableSet(this.srsList);
    }

    public Collection<String> getFullSRSList() {
        HashSet<String> fullSRSList = new HashSet<String>(this.getSRSList());
        if (this.parent != null) {
            fullSRSList.addAll(this.parent.getFullSRSList());
        }
        return fullSRSList;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("WMSLayer {\n  name: \"" + this.name + "\"\n  title: \"" + this.title + "\"\n  srsList: " + this.srsList.toString() + "\n  subLayers: [\n");
        for (MapLayer subLayer : this.subLayers) {
            s.append(subLayer.toString()).append(", ");
        }
        s.append("  ]\n  bbox: ");
        if (this.bbox != null) {
            s.append(this.bbox.toString());
        } else {
            s.append("null");
        }
        s.append("\n}\n");
        return s.toString();
    }

    public String getAbstract() {
        return this.wmsAbstract;
    }

    public boolean isDead() {
        return this.dead;
    }
}

