/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wms;

import java.util.Collections;
import java.util.List;

public class MapImageFormatChooser {
    private boolean transparencyRequired = false;
    private boolean useLossy;
    public static final String[] IMAGE_FORMATS = new String[]{"image/gif", "image/png", "image/jpeg"};

    public MapImageFormatChooser() {
        this("1.1.0");
    }

    public MapImageFormatChooser(String wmsVersion) {
    }

    public static boolean isKnownFormat(String format) {
        for (String IMAGE_FORMATS1 : IMAGE_FORMATS) {
            if (!format.equals(IMAGE_FORMATS1)) continue;
            return true;
        }
        return false;
    }

    public void setTransparencyRequired(boolean transparencyRequired) {
        this.transparencyRequired = transparencyRequired;
    }

    public void setPreferLossyCompression(boolean useLossy) {
        this.useLossy = useLossy;
    }

    public String chooseFormat(List<String> formats) {
        if (formats.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String[] order = new String[3];
        if (this.transparencyRequired) {
            order[0] = IMAGE_FORMATS[1];
            order[1] = IMAGE_FORMATS[0];
            order[2] = IMAGE_FORMATS[2];
        } else if (this.useLossy) {
            order[0] = IMAGE_FORMATS[2];
            order[1] = IMAGE_FORMATS[1];
            order[2] = IMAGE_FORMATS[0];
        } else {
            order[0] = IMAGE_FORMATS[1];
            order[1] = IMAGE_FORMATS[2];
            order[2] = IMAGE_FORMATS[0];
        }
        formats.sort(String.CASE_INSENSITIVE_ORDER);
        for (String order1 : order) {
            if (Collections.binarySearch(formats, order1) < 0) continue;
            return order1;
        }
        return null;
    }
}

