/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.ows.Capabilities;
import com.vividsolutions.ows.GetCapabilitiesRequest;
import com.vividsolutions.ows.OWService;
import com.vividsolutions.ows.Parser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOWService
implements OWService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOWService.class);
    private static final String KEY_WMS_CAPABILITIES_CACHE = "WMS_CAPABILITIES_CACHE";
    protected Capabilities capabilities;
    protected HttpClientContext httpClientContext;
    protected String serverLoginName;
    protected String serverLoginPwd;
    protected boolean serverNeedsLogin = false;
    protected final String serverUrl;
    protected final String serverUrlExt;
    protected final String version;
    private boolean internal = false;

    protected AbstractOWService(String serverUrl, String version) {
        this.serverUrlExt = serverUrl;
        this.serverUrl = this.fixUrl(serverUrl);
        this.version = version;
        this.capabilities = null;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    private String fixUrl(String url) {
        Object fixedURL = url.trim();
        if (!((String)fixedURL).toLowerCase().startsWith("http://") && !((String)fixedURL).toLowerCase().startsWith("https://")) {
            try {
                if (JUMPWorkbench.GIS_CONTEXT != null) {
                    String strInternalServer = null;
                    if (this.getType() == OWService.OWSType.WMS) {
                        strInternalServer = (String)JUMPWorkbench.GIS_CONTEXT.getModuleApp().getModuleAppObject("GIS-WMS-SERVER");
                        if (strInternalServer.toLowerCase().startsWith("http://") || strInternalServer.toLowerCase().startsWith("https://")) {
                            strInternalServer = this.fixUrl(strInternalServer);
                            fixedURL = strInternalServer + (String)fixedURL;
                            this.internal = true;
                        }
                    } else if (this.getType() == OWService.OWSType.WMTS) {
                        strInternalServer = (String)JUMPWorkbench.GIS_CONTEXT.getModuleApp().getModuleAppObject("GIS-WMTS-SERVER");
                        fixedURL = ((String)fixedURL).replace("MAP=", "");
                        String[] keys = ((String)fixedURL).split("_");
                        fixedURL = "/" + keys[0] + "/" + keys[1];
                        fixedURL = strInternalServer + (String)fixedURL;
                        this.internal = true;
                        return fixedURL;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Fixing URL didn't work", (Throwable)e);
            }
        }
        if (!((String)fixedURL).contains("?")) {
            fixedURL = (String)fixedURL + "?";
        } else if (!((String)fixedURL).endsWith("?") && !((String)fixedURL).endsWith("&")) {
            fixedURL = (String)fixedURL + "&";
        }
        return fixedURL;
    }

    @Override
    public Capabilities getCapabilities() throws IOException {
        if (this.capabilities == null) {
            this.initialize();
        }
        return this.capabilities;
    }

    public synchronized void initialize() throws IOException {
        this.initialize(null, null);
    }

    public synchronized void initialize(Task task, RequestConfig customRequestConfig) throws IOException {
        String requestUrlString = this.createGetCapabilitiesRequest().getURL();
        HashMap<Object, Capabilities> cachedCapabilities = null;
        Object key = requestUrlString;
        if (this.serverNeedsLogin) {
            key = (String)key + "_" + Objects.requireNonNullElse(this.serverLoginName, "");
        }
        if (task != null) {
            cachedCapabilities = (HashMap<Object, Capabilities>)task.getBlackboard().get(KEY_WMS_CAPABILITIES_CACHE);
            if (cachedCapabilities == null) {
                cachedCapabilities = new HashMap<Object, Capabilities>();
            }
            if (cachedCapabilities.containsKey(key)) {
                this.capabilities = (Capabilities)cachedCapabilities.get(key);
                return;
            }
        }
        HttpGet methGet = new HttpGet(requestUrlString);
        if (customRequestConfig != null) {
            methGet.setConfig(customRequestConfig);
        }
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.serverNeedsLogin ? WorkbenchContext.executeMethod((HttpUriRequest)methGet, this.getCredentials()) : WorkbenchContext.executeMethod((HttpUriRequest)methGet);
            HttpEntity entity = httpResponse.getEntity();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Error response status: " + statusCode + "\n\nService Response:\n" + EntityUtils.toString((HttpEntity)entity));
            }
            LOG.trace("{}", (Object)entity.getContentEncoding());
            InputStream inStream = entity.getContent();
            Parser p = this.createParser();
            this.capabilities = p.parseCapabilities(this, inStream);
            if (cachedCapabilities != null) {
                cachedCapabilities.put(key, this.capabilities);
            }
        }
        catch (Exception e) {
            LOG.warn(String.format("Error query URL: %s", requestUrlString));
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Error parsing capabilities: " + e.getMessage(), e);
        }
        finally {
            if (httpResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                IOUtils.closeQuietly((Closeable)((Closeable)httpResponse));
            }
        }
    }

    @Override
    public Credentials getCredentials() throws IOException {
        if (this.serverLoginName.startsWith("NTLM:")) {
            String[] arrLogin = this.serverLoginName.substring(5).split(";");
            if (arrLogin.length != 3) {
                throw new IOException("Wrong login name for NTLM authentification. Must be like NTLM:host;domain;login");
            }
            String strHost = arrLogin[0];
            String strDomain = arrLogin[1];
            String strLogin = arrLogin[2];
            return new NTCredentials(strLogin, this.serverLoginPwd, strHost, strDomain);
        }
        return new UsernamePasswordCredentials(this.serverLoginName, this.serverLoginPwd);
    }

    @Override
    public HttpClientContext getHttpClientContext() throws IOException {
        if (this.httpClientContext == null) {
            this.httpClientContext = HttpClientContext.create();
            if (this.serverNeedsLogin) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, this.getCredentials());
                this.httpClientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        return this.httpClientContext;
    }

    @Override
    public String getServerLoginName() {
        return this.serverLoginName;
    }

    @Override
    public String getServerLoginPwd() {
        return this.serverLoginPwd;
    }

    @Override
    public boolean getServerNeedsLogin() {
        return this.serverNeedsLogin;
    }

    @Override
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public String getServerUrlExt() {
        return this.serverUrlExt;
    }

    @Override
    public String getTitle() throws IOException {
        return this.getCapabilities().getTitle();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setServerLoginName(String serverLoginName) {
        this.serverLoginName = serverLoginName;
    }

    @Override
    public void setServerLoginPwd(String serverLoginPwd) {
        this.serverLoginPwd = serverLoginPwd;
    }

    @Override
    public void setServerNeedsLogin(boolean serverNeedsLogin) {
        this.serverNeedsLogin = serverNeedsLogin;
    }

    public GetCapabilitiesRequest createGetCapabilitiesRequest() {
        return new GetCapabilitiesRequest(this);
    }

    protected abstract Parser createParser();
}

