/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.FlashStyle;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingListener;
import de.riwagis.icons.IconLoader;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

public class ZoomToSelectedItemsPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.zoom(context.getLayerViewPanel().getSelectionManager().getSelectedItems(), context.getLayerViewPanel());
        return true;
    }

    public void zoom(final Collection<Geometry> geometries, LayerViewPanel panel) throws NoninvertibleTransformException {
        if (this.envelope(geometries).isNull()) {
            return;
        }
        Envelope envGeom = this.envelope(geometries);
        Envelope proposedEnvelope = EnvelopeUtil.bufferByFraction(envGeom, 0.1);
        Envelope envView = panel.getViewport().getEnvelopeInModelCoordinates();
        proposedEnvelope = EnvelopeUtil.getProportionalEnvelope(envView, proposedEnvelope);
        RenderingListener listener = new RenderingListener(){

            @Override
            public void renderingStarted(LayerViewPanel panel) {
            }

            @Override
            public void renderingStopped(final LayerViewPanel panel) {
                final 1 internalListener = this;
                GUIUtil.invokeOnEventThreadLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            panel.getRenderingManager().removeRenderingListener(internalListener);
                            ZoomToSelectedItemsPlugIn.this.flash(geometries, panel);
                        }
                        catch (NoninvertibleTransformException noninvertibleTransformException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        panel.getRenderingManager().addRenderingListener(listener);
        panel.getViewport().zoom(proposedEnvelope);
    }

    private Envelope envelope(Collection<Geometry> geometries) {
        Envelope envelope = new Envelope();
        for (Geometry geometry : geometries) {
            envelope.expandToInclude(geometry.getEnvelopeInternal());
        }
        return envelope;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1));
    }

    public void flash(Collection<Geometry> geometries, LayerViewPanel panel) throws NoninvertibleTransformException {
        GeometryCollection gc = this.toGeometryCollection(geometries);
        if (!panel.getViewport().getEnvelopeInModelCoordinates().intersects(gc.getEnvelopeInternal())) {
            return;
        }
        panel.flash(gc, FlashStyle.DEFAULT_COLOR, 1000);
    }

    private GeometryCollection toGeometryCollection(Collection<Geometry> geometries) {
        return new GeometryFactory().createGeometryCollection(geometries.toArray(new Geometry[0]));
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"zoom_selected.svg");
    }
}

