/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.tools.ScreenScale;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class ZoomToScalePlugIn
extends AbstractPlugIn {
    private int scale = 0;
    private double oldHorizontalScale = 0.0;
    private final String text = I18N.get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.set-new-scale-to-zoom") + ":  1 : ";

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Viewport port = context.getLayerViewPanel().getViewport();
        this.oldHorizontalScale = ScreenScale.getHorizontalMapScale(port, context.getTask().getDrawingUnit());
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.zoom-to-scale"), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        double factor = (double)this.scale / this.oldHorizontalScale;
        Envelope oldEnvelope = port.getEnvelopeInModelCoordinates();
        double xc = 0.5 * (oldEnvelope.getMaxX() + oldEnvelope.getMinX());
        double yc = 0.5 * (oldEnvelope.getMaxY() + oldEnvelope.getMinY());
        double xmin = xc - 0.5 * factor * oldEnvelope.getWidth();
        double xmax = xc + 0.5 * factor * oldEnvelope.getWidth();
        double ymin = yc - 0.5 * factor * oldEnvelope.getHeight();
        double ymax = yc + 0.5 * factor * oldEnvelope.getHeight();
        Coordinate[] coords = new Coordinate[]{new Coordinate(xmin, ymin), new Coordinate(xmax, ymax)};
        LineString g1 = new GeometryFactory().createLineString(coords);
        port.zoom(g1.getEnvelopeInternal());
        return true;
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) {
        dialog.addLabel(I18N.get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.actual-scale-in-horizontal-direction") + " 1 : " + Math.round(this.oldHorizontalScale));
        int newscale = 1000;
        if (context.getTask() != null) {
            newscale = (int)Math.round(context.getTask().getScale());
        }
        JTextField txtIntField = dialog.addIntegerField(this.text, newscale, 7, this.text);
        txtIntField.addKeyListener(new KeyAdapter(this){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    dialog.setOKPressed(true);
                    dialog.setVisible(false);
                }
                if (key == 27) {
                    dialog.setOKPressed(false);
                    dialog.setVisible(false);
                }
            }
        });
        txtIntField.setSelectionStart(0);
        txtIntField.setSelectionEnd(txtIntField.getText().length());
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.scale = dialog.getInteger(this.text);
    }

    @Override
    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.zoom-to-scale");
    }
}

