/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.locationtech.jts.geom.Envelope;

public class ZoomToLayerablesPlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.get("com.vividsolutions.jump.workbench.ui.zoom.ZoomToLayerablesPlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Envelope env = this.envelopeOfSelectedLayerables(context);
        if (env.isNull()) {
            JOptionPane.showMessageDialog(context.getWorkbenchFrame(), I18N.get("com.vividsolutions.jump.workbench.ui.zoom.ZoomToLayerablesPlugIn.error"), "", 0);
            return false;
        }
        context.getLayerViewPanel().getViewport().zoom(EnvelopeUtil.bufferByFraction(env, 0.03));
        return true;
    }

    private Envelope envelopeOfSelectedLayerables(PlugInContext context) {
        Envelope envelope = new Envelope();
        for (Layerable layerable : context.getLayerNamePanel().selectedNodes(Layerable.class)) {
            Envelope layerEnv = layerable.getEnvelope();
            if (layerEnv.isNull()) continue;
            envelope.expandToInclude(layerEnv);
        }
        return envelope;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, Layerable.class)).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                return null;
            }
        });
    }
}

