/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToCoordinateDialog;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.gis.context.jump.MapContextImpl;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayFeature;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayPlugin;
import de.riwagis.util.gui.GUISupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Stroke;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ZoomToCoordinatePlugIn
extends AbstractPlugIn {
    private Coordinate lastCoordinate = new Coordinate(0.0, 0.0);
    private ZoomToCoordinateDialog dlg = null;

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        CRSDefinition crsDefProject = context.getTask().getCRSDefinition();
        if (this.dlg == null) {
            this.dlg = new ZoomToCoordinateDialog((Frame)context.getWorkbenchFrame(), crsDefProject);
            GUISupport.centreOnScreen((Component)this.dlg);
        }
        this.dlg.updateControls(crsDefProject);
        this.dlg.setVisible(true);
        if (this.dlg.wasZoomPressed()) {
            Coordinate coordinate = this.dlg.getCoordinate2Zoom();
            CRSDefinition crsDefSelection = this.dlg.getSelectedCRS();
            if (crsDefProject.getKey().equals(crsDefSelection.getKey()) || crsDefSelection.getCode() == null) {
                this.lastCoordinate = coordinate;
            } else {
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)CRSDefFactory.createCRS((String)crsDefSelection.getCode()), (CoordinateReferenceSystem)CRSDefFactory.createCRS((String)crsDefProject.getCode()), (boolean)true);
                this.lastCoordinate = (Coordinate)coordinate.clone();
                this.lastCoordinate = JTS.transform((Coordinate)this.lastCoordinate, null, (MathTransform)transform);
            }
            double dblZoomScale = this.dlg.getScale();
            context.getLayerViewPanel().getViewport().zoom(this.lastCoordinate, dblZoomScale, context.getTask().getDrawingUnit());
            GeometryFactory gf = new GeometryFactory();
            boolean bolDurable = PersistentBlackboardPlugIn.get().get(MapContextImpl.SELECTION_MARKER_DURABLE, true);
            if (bolDurable) {
                LayerViewPanel lvp = context.getLayerViewPanel();
                GenericOverlayFeature fPreview = new GenericOverlayFeature(gf.createPoint(this.lastCoordinate).buffer(lvp.getViewport().getEnvelopeInModelCoordinates().getHeight() / 30.0), (Stroke)new BasicStroke(2.0f), Color.RED, (Stroke)new BasicStroke(), new Color(0, 0, 0, 0));
                GenericOverlayPlugin.addFeature(MapContextImpl.SELECTION_MARKER_GEOMETRY, fPreview);
                lvp.copyTo();
            } else {
                JUMPWorkbench.getContext().getLayerViewPanel().flash(gf.createGeometryCollection(new Geometry[]{gf.createPoint(this.lastCoordinate)}));
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return I18N.get("ui.zoom.ZoomToCoordinatePlugIn.name");
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }
}

