/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.CoordinateFieldsDocumentListener;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.jdesktop.swingx.JXTaskPane;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomToCoordinateDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(ZoomToCoordinateDialog.class);
    private final DecimalFormat df = new DecimalFormat("#,##0.00####");
    private final NumberFormat nf = NumberFormat.getIntegerInstance();
    private double dblScale;
    private boolean bolWasZoomPressed = false;
    private volatile boolean bolInCompUpdate = false;
    private CRSDefinition sourceCRSDefinition;
    private JPanel pnlComponents;
    private JLabel lblX;
    private JFormattedTextField tfiX;
    private JLabel lblY;
    private JFormattedTextField tfiY;
    private JLabel lblScale;
    private JComboBox cmbScale;
    private JXTaskPane tskPane;
    private JLabel lblCRSSource;
    private JComboBox<CRSDefinition> cmbCRSSource;
    private JLabel lblCRSTarget;
    private JTextField tfiCRSTarget;
    private JLabel lblInfoSymbol;
    private JLabel lblInfoMessage;
    private JPanel pnlControls;
    private JButton btnZoom;
    private JButton btnCancel;

    public ZoomToCoordinateDialog(Frame parent, CRSDefinition crsDefinition) {
        super(parent, true);
        this.sourceCRSDefinition = crsDefinition;
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void initComponents() {
        this.pnlComponents = new JPanel();
        this.lblX = new JLabel();
        this.tfiX = new JFormattedTextField();
        this.lblY = new JLabel();
        this.tfiY = new JFormattedTextField();
        this.lblScale = new JLabel();
        this.cmbScale = new JComboBox();
        this.tskPane = new JXTaskPane();
        this.tskPane.setCollapsed(true);
        this.lblCRSSource = new JLabel();
        this.cmbCRSSource = new JComboBox();
        this.lblCRSTarget = new JLabel();
        this.tfiCRSTarget = new JTextField();
        this.pnlControls = new JPanel();
        this.btnZoom = new JButton();
        this.btnCancel = new JButton();
        this.lblInfoSymbol = new JLabel();
        this.lblInfoMessage = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagLayout pnlComponentsLayout = new GridBagLayout();
        pnlComponentsLayout.columnWidths = new int[]{0, 5, 0};
        pnlComponentsLayout.rowHeights = new int[]{0, 5, 0, 5, 0, 10, 0};
        this.pnlComponents.setLayout(pnlComponentsLayout);
        GridBagLayout tskPaneLayout = new GridBagLayout();
        tskPaneLayout.columnWidths = new int[]{0, 5, 0};
        tskPaneLayout.rowHeights = new int[]{0, 5, 0, 5, 0, 5, 0, 5, 0};
        this.tskPane.setLayout((LayoutManager)tskPaneLayout);
        this.lblX.setLabelFor(this.tfiX);
        this.lblX.setText("Rechtswert:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 1536;
        this.pnlComponents.add((Component)this.lblX, gridBagConstraints);
        this.tfiX.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("##,###,##0.00####"))));
        this.tfiX.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlComponents.add((Component)this.tfiX, gridBagConstraints);
        this.lblY.setLabelFor(this.tfiY);
        this.lblY.setText("Hochwert:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 1536;
        this.pnlComponents.add((Component)this.lblY, gridBagConstraints);
        this.tfiY.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("##,###,##0.00####"))));
        this.tfiY.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlComponents.add((Component)this.tfiY, gridBagConstraints);
        this.lblScale.setLabelFor(this.cmbScale);
        this.lblScale.setText("Ma\u00dfstab:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 1536;
        this.pnlComponents.add((Component)this.lblScale, gridBagConstraints);
        this.cmbScale.setEditable(true);
        this.cmbScale.setModel(new DefaultComboBoxModel<String>(new String[]{"1 : 250", "1 : 500", "1 : 1000", "1 : 2500", "1 : 5000", "1 : 10000", "1 : 25000", "1 : 50000", "1 : 100000", "1 : 500000"}));
        this.cmbScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZoomToCoordinateDialog.this.cmbScale_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlComponents.add((Component)this.cmbScale, gridBagConstraints);
        this.tskPane.setCollapsed(true);
        this.tskPane.setTitle("Advanced Options");
        this.tskPane.setOpaque(false);
        this.tskPane.setAnimated(false);
        ((JComponent)this.tskPane.getContentPane()).setOpaque(false);
        this.tskPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ZoomToCoordinateDialog.this.tskPane_onPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.pnlComponents.add((Component)this.tskPane, gridBagConstraints);
        this.lblCRSSource.setLabelFor(this.cmbCRSSource);
        this.lblCRSSource.setText("CRS from");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 1280;
        this.tskPane.add((Component)this.lblCRSSource, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tskPane.add(this.cmbCRSSource, (Object)gridBagConstraints);
        this.lblCRSTarget.setLabelFor(this.tfiCRSTarget);
        this.lblCRSTarget.setText("CRS to");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 1280;
        this.tskPane.add((Component)this.lblCRSTarget, (Object)gridBagConstraints);
        this.tfiCRSTarget.setHorizontalAlignment(2);
        this.tfiCRSTarget.setEnabled(false);
        this.tfiCRSTarget.setText("Gauss-Kr\u00fcger Zone 4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tskPane.add((Component)this.tfiCRSTarget, (Object)gridBagConstraints);
        this.lblInfoSymbol.setText("<html><font size=+0>&#9432;</html>");
        this.lblInfoSymbol.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        this.tskPane.add((Component)this.lblInfoSymbol, (Object)gridBagConstraints);
        this.lblInfoMessage.setText("<html>Info Message</html>");
        this.lblInfoMessage.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.tskPane.add((Component)this.lblInfoMessage, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnlComponents, gridBagConstraints);
        this.btnZoom.setText("zoom");
        this.btnZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZoomToCoordinateDialog.this.butZoom_onActionPerformed(evt);
            }
        });
        this.pnlControls.add(this.btnZoom);
        this.btnCancel.setText("cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZoomToCoordinateDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlControls.add(this.btnCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.pnlControls, gridBagConstraints);
        this.pack();
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.zoom.ZoomToCoordinateDialog.title"));
        this.lblX.setText(I18N.get("ui.zoom.ZoomToCoordinateDialog.x"));
        this.lblY.setText(I18N.get("ui.zoom.ZoomToCoordinateDialog.y"));
        this.lblScale.setText(I18N.get("common.scale"));
        this.tskPane.setTitle(I18N.get("ui.zoom.ZoomToCoordinateDialog.more-options"));
        this.lblCRSSource.setText(I18N.get("ui.zoom.ZoomToCoordinateDialog.source-crs"));
        this.lblCRSTarget.setText(I18N.get("ui.zoom.ZoomToCoordinateDialog.target-crs"));
        this.lblInfoMessage.setText(I18N.get("common.transform-information"));
        this.btnZoom.setText(I18N.get("ui.zoom.ZoomToCoordinateDialog.zoom"));
        this.btnCancel.setText(I18N.get("common.cancel"));
    }

    private void init() {
        this.nf.setGroupingUsed(false);
        this.cmbScale.setSelectedItem("1 : 1000");
        this.tfiX.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.tfiY.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        GUISupport.addCopyInsertPopup((JTextComponent)this.tfiX);
        GUISupport.addCopyInsertPopup((JTextComponent)this.tfiY);
        this.tfiX.getDocument().addDocumentListener(new CoordinateFieldsDocumentListener(this.tfiX, this.tfiX, this.tfiY));
        this.tfiY.getDocument().addDocumentListener(new CoordinateFieldsDocumentListener(this.tfiY, this.tfiX, this.tfiY));
        Coordinate c = JUMPWorkbench.getContext().getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates().centre();
        this.tfiX.setValue(c.x);
        this.tfiY.setValue(c.y);
        this.setSize(300, 200);
        ArrayList lstCRS = new ArrayList(CRSDefFactory.getCRSDefinitionList());
        Collections.sort(lstCRS);
        HashSet<String> keyExcpetions = new HashSet<String>(){
            {
                this.add("99999001");
                this.add("99999002");
            }
        };
        for (CRSDefinition crsDef : lstCRS) {
            String key = crsDef.getKey();
            if (keyExcpetions.contains(key)) continue;
            this.cmbCRSSource.addItem(crsDef);
        }
        this.cmbCRSSource.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ZoomToCoordinateDialog.this.cmbCRSourceItemStateChanged(evt);
            }
        });
    }

    public void updateControls(CRSDefinition crsDefinition) {
        this.sourceCRSDefinition = crsDefinition;
        if (crsDefinition.getCode() == null) {
            this.cmbCRSSource.setEnabled(false);
        } else {
            this.cmbCRSSource.setEnabled(true);
        }
        this.cmbCRSSource.setSelectedItem(crsDefinition);
        this.tfiCRSTarget.setText(crsDefinition.getName());
    }

    private void cmbScale_onActionPerformed(ActionEvent evt) {
        String strScale = (String)this.cmbScale.getSelectedItem();
        String[] arrScale = strScale.split("\\:");
        if (arrScale.length > 2) {
            this.dblScale = 1000.0;
        }
        if (arrScale.length == 2) {
            strScale = arrScale[1];
        }
        if (arrScale.length == 1) {
            strScale = arrScale[0];
        }
        try {
            DecimalFormat df = new DecimalFormat();
            df.setGroupingUsed(false);
            df.setMaximumFractionDigits(2);
            this.dblScale = df.parse(strScale.trim()).doubleValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.cmbScale.setSelectedItem("1 : " + this.nf.format(this.dblScale));
    }

    private void butZoom_onActionPerformed(ActionEvent evt) {
        this.bolWasZoomPressed = true;
        this.setVisible(false);
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolWasZoomPressed = false;
        this.setVisible(false);
    }

    public Coordinate getCoordinate2Zoom() {
        double dblX = ((Number)this.tfiX.getValue()).doubleValue();
        double dblY = ((Number)this.tfiY.getValue()).doubleValue();
        return new Coordinate(dblX, dblY);
    }

    public CRSDefinition getSelectedCRS() {
        return (CRSDefinition)this.cmbCRSSource.getSelectedItem();
    }

    public double getScale() {
        return this.dblScale;
    }

    public boolean wasZoomPressed() {
        return this.bolWasZoomPressed;
    }

    private void cmbCRSourceItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            CRSDefinition targetCRSDefinition = (CRSDefinition)evt.getItem();
            if (this.sourceCRSDefinition.getCode() == null || targetCRSDefinition.getCode() == null || targetCRSDefinition.getCode().equals(this.sourceCRSDefinition.getCode())) {
                this.lblInfoSymbol.setVisible(false);
                this.lblInfoMessage.setVisible(false);
            } else {
                this.lblInfoSymbol.setVisible(true);
                this.lblInfoMessage.setVisible(true);
            }
            this.pack();
        }
    }

    private void tskPane_onPropertyChange(PropertyChangeEvent evt) {
        this.pack();
    }
}

