/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import de.riwagis.icons.IconLoader;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.locationtech.jts.util.Assert;

public class ZoomPreviousPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Viewport viewport = context.getLayerViewPanel().getViewport();
        Assert.isTrue((boolean)viewport.getZoomHistory().hasPrev());
        viewport.getZoomHistory().setAdding(false);
        try {
            viewport.zoom(viewport.getZoomHistory().prev());
        }
        finally {
            viewport.getZoomHistory().setAdding(true);
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                LayerViewPanel layerViewPanel = WorkbenchContext.getInstance().getLayerViewPanel();
                return layerViewPanel == null || !layerViewPanel.getViewport().getZoomHistory().hasPrev() ? I18N.get("ui.zoom.ZoomPreviousPlugIn.already-at-start") : null;
            }
        });
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_arrow_left.svg");
    }
}

