/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import de.riwagis.icons.IconLoader;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class ZoomOutTool
extends DragTool {
    private static final int BOX_TOLERANCE = 4;
    private static final double ZOOM_IN_FACTOR = 2.0;

    public ZoomOutTool() {
        this.setColor(Color.black);
    }

    public static EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = new EnableCheckFactory(WorkbenchContext.getInstance());
        return checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"zoom_out.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.zoom.ZoomOutTool.zoom-in-out");
    }

    @Override
    public Cursor createCursor() {
        return ZoomOutTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_zoom_out.svg").getImage());
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        double minX = Math.min(this.getViewSource().getX(), this.getViewDestination().getX());
        double maxX = Math.max(this.getViewSource().getX(), this.getViewDestination().getX());
        double minY = Math.min(this.getViewSource().getY(), this.getViewDestination().getY());
        double maxY = Math.max(this.getViewSource().getY(), this.getViewDestination().getY());
        double widthOfNewViewAsPerceivedByOldView = maxX - minX;
        double heightOfNewViewAsPerceivedByOldView = maxY - minY;
        if (widthOfNewViewAsPerceivedByOldView == 0.0 && heightOfNewViewAsPerceivedByOldView == 0.0) {
            return;
        }
        if (widthOfNewViewAsPerceivedByOldView < 4.0 && heightOfNewViewAsPerceivedByOldView < 4.0) {
            this.zoomAt(new Point2D.Double(MathUtil.avg(minX, maxX), MathUtil.avg(minY, maxY)), 2.0);
            return;
        }
        Point2D.Double centreOfNewViewAsPerceivedByOldView = new Point2D.Double(minX + widthOfNewViewAsPerceivedByOldView / 2.0, minY + heightOfNewViewAsPerceivedByOldView / 2.0);
        this.getPanel().getViewport().zoom(centreOfNewViewAsPerceivedByOldView, widthOfNewViewAsPerceivedByOldView, heightOfNewViewAsPerceivedByOldView);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            double zoomFactor = SwingUtilities.isRightMouseButton(e) ? 2.0 : 0.5;
            this.zoomAt(e.getPoint(), zoomFactor);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private void zoomAt(Point2D p, double zoomFactor) throws NoninvertibleTransformException {
        this.getPanel().getViewport().zoomToViewPoint(p, zoomFactor);
    }

    @Override
    public boolean isRightMouseButtonUsed() {
        return true;
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
    }

    @Override
    public void deactivate() {
        super.deactivate();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }
}

