/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.geom.LineSegmentEnvelopeIntersector;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.IncrementChooser;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.RoundQuantity;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.unit.UnitFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicSliderUI;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomBar
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(ZoomBar.class);
    private Envelope lastGoodEnvelope = null;
    private final WorkbenchFrame frame;
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final JSlider slider = new JSlider();
    private final JLabel label = new JLabel();
    private DrawingUnit drawingUnit = null;
    private final IncrementChooser incrementChooser = new IncrementChooser(UnitFactory.getDefaultUnit());
    private final boolean showingSliderLabels;
    private static final String SCALE_KEY = ZoomBar.class.getName() + " - SCALE";
    private static final String CENTRE_KEY = ZoomBar.class.getName() + " - CENTRE";
    private static final String CENTRE_LOCKED_KEY = ZoomBar.class.getName() + " - CENTRE LOCKED";
    private static final String MIN_EXTENT_KEY = ZoomBar.class.getName() + " - MIN EXTENT";
    private static final String USER_DEFINED_MIN_SCALE = ZoomBar.class.getName() + " - USER DEFINED MIN SCALE";
    private static final String USER_DEFINED_MAX_SCALE = ZoomBar.class.getName() + " - USER DEFINED MAX SCALE";
    private static final String MAX_EXTENT_KEY = ZoomBar.class.getName() + " - MAX EXTENT";
    private static final String SEGMENT_CACHE_KEY = ZoomBar.class.getName() + " - SEGMENT CACHE";
    private Timer componentUpdateTimer = GUIUtil.createRestartableSingleEventTimer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ZoomBar.this.updateComponents();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    });
    private LineSegmentEnvelopeIntersector lineSegmentEnvelopeIntersector = new LineSegmentEnvelopeIntersector();
    private final LayerViewPanel dummyLayerViewPanel = new LayerViewPanel(new LayerManager(), new LayerViewPanelContext(this){

        @Override
        public void setStatusMessage(String message) {
        }

        @Override
        public void warnUser(String warning) {
        }

        @Override
        public void handleThrowable(Throwable t) {
        }
    });

    public ZoomBar(boolean showingSliderLabels, boolean showingRightSideLabel, WorkbenchFrame frame) throws NoninvertibleTransformException {
        this.frame = frame;
        this.showingSliderLabels = showingSliderLabels;
        this.setDrawingUnit(UnitFactory.getDefaultUnit());
        this.slider.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                try {
                    ZoomBar.this.updateComponents();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        });
        if (showingSliderLabels) {
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            ((Dictionary)labelTable).put(0, new JLabel(" "));
            this.slider.setLabelTable(labelTable);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LOG.warn("error initializing JB", (Throwable)ex);
        }
        if (!showingRightSideLabel) {
            this.remove(this.label);
        }
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 3 && SwingUtilities.isRightMouseButton(e)) {
                    ZoomBar.this.viewBlackboard().put(USER_DEFINED_MIN_SCALE, null);
                    ZoomBar.this.viewBlackboard().put(USER_DEFINED_MAX_SCALE, null);
                    ZoomBar.this.clearModelCaches();
                }
            }
        });
        this.slider.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                try {
                    double viewscale = ZoomBar.this.layerViewPanel().getViewport().getScale();
                    double scale = ZoomBar.this.getScale();
                    Envelope env = ZoomBar.this.layerViewPanel().getViewport().getEnvelopeInModelCoordinates();
                    double width = env.getWidth();
                    double height = env.getHeight();
                    double newwidth = width * viewscale / scale;
                    double newheight = height * viewscale / scale;
                    env.expandBy((newwidth - width) / 2.0, (newheight - height) / 2.0);
                    ZoomBar.this.layerViewPanel().getViewport().zoom(env, false);
                    ZoomBar.this.updateLabel();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        });
        if (this.slider.getUI() instanceof BasicSliderUI) {
            this.slider.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (ZoomBar.this.layerViewPanel() == ZoomBar.this.dummyLayerViewPanel) {
                        return;
                    }
                    try {
                        ZoomBar.this.slider.setToolTipText(I18N.get("ui.zoom.ZoomBar.zoom-to") + " " + ZoomBar.this.chooseGoodIncrement(ZoomBar.this.toScale(((BasicSliderUI)ZoomBar.this.slider.getUI()).valueForXPosition(e.getX()))).toString());
                    }
                    catch (NoninvertibleTransformException x) {
                        ZoomBar.this.slider.setToolTipText(I18N.get("ui.zoom.ZoomBar.zoom"));
                    }
                }
            });
        }
        this.label.setPreferredSize(new Dimension(50, this.label.getHeight()));
        this.slider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                        ZoomBar.this.gestureFinished();
                    }
                }
                catch (NoninvertibleTransformException t) {
                    ZoomBar.this.layerViewPanel().getContext().handleThrowable(t);
                }
            }
        });
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                try {
                    ZoomBar.this.gestureFinished();
                }
                catch (NoninvertibleTransformException t) {
                    ZoomBar.this.layerViewPanel().getContext().handleThrowable(t);
                }
            }
        });
        GUIUtil.addInternalFrameListener(frame.getDesktopPane(), GUIUtil.toInternalFrameListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZoomBar.this.installListenersOnCurrentPanel();
                try {
                    ZoomBar.this.updateComponents();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        }));
        this.installListenersOnCurrentPanel();
        this.updateComponents();
    }

    private void installListenersOnCurrentPanel() {
        this.installViewListeners();
        this.installModelListeners();
    }

    public final void setDrawingUnit(DrawingUnit _unit) {
        this.drawingUnit = _unit;
        this.incrementChooser.setDrawingUnit(this.drawingUnit);
    }

    private void installViewListeners() {
        String VIEW_LISTENERS_INSTALLED_KEY = Integer.toHexString(this.hashCode()) + " - VIEW LISTENERS INSTALLED";
        if (this.viewBlackboard().get(VIEW_LISTENERS_INSTALLED_KEY) != null) {
            return;
        }
        if (this.layerViewPanel() == null) {
            return;
        }
        this.layerViewPanel().getViewport().addListener(new ViewportListener(){

            @Override
            public void zoomChanged(Viewport vPort) {
                ZoomBar.this.setDrawingUnit(ZoomBar.this.layerViewPanel().getLayerManager().getTask().getDrawingUnit());
                if (!ZoomBar.this.viewBlackboard().get(CENTRE_LOCKED_KEY, false)) {
                    ZoomBar.this.viewBlackboard().put(CENTRE_KEY, null);
                }
                ZoomBar.this.viewBlackboard().put(SCALE_KEY, null);
                try {
                    if (vPort.getScale() < ZoomBar.this.getMinScale()) {
                        ZoomBar.this.viewBlackboard().put(USER_DEFINED_MIN_SCALE, ZoomBar.this.layerViewPanel().getViewport().getScale());
                    }
                    if (vPort.getScale() > ZoomBar.this.getMaxScale()) {
                        ZoomBar.this.viewBlackboard().put(USER_DEFINED_MAX_SCALE, ZoomBar.this.layerViewPanel().getViewport().getScale());
                    }
                    ZoomBar.this.updateComponents();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        });
        this.viewBlackboard().put(VIEW_LISTENERS_INSTALLED_KEY, new Object());
    }

    private void installModelListeners() {
        String MODEL_LISTENERS_INSTALLED_KEY = Integer.toHexString(this.hashCode()) + " - MODEL LISTENERS INSTALLED";
        if (this.viewBlackboard().get(MODEL_LISTENERS_INSTALLED_KEY) != null) {
            return;
        }
        if (this.layerViewPanel() == null) {
            return;
        }
        this.layerViewPanel().getLayerManager().addLayerListener(new LayerListener(){

            @Override
            public void categoryChanged(CategoryEvent e) {
            }

            @Override
            public void featuresChanged(FeatureEvent e) {
                if (e.getType() == FeatureEventType.ADDED || e.getType() == FeatureEventType.DELETED || e.getType() == FeatureEventType.GEOMETRY_MODIFIED) {
                    ZoomBar.this.clearModelCaches();
                }
            }

            @Override
            public void layerChanged(LayerEvent e) {
                if (e.getType() == LayerEventType.ADDED || e.getType() == LayerEventType.REMOVED) {
                    ZoomBar.this.clearModelCaches();
                }
            }
        });
        this.viewBlackboard().put(MODEL_LISTENERS_INSTALLED_KEY, new Object());
    }

    private void queueComponentUpdate() {
        this.componentUpdateTimer.restart();
    }

    public final void updateComponents() throws NoninvertibleTransformException {
        LayerViewPanel layerViewPanel = this.layerViewPanel();
        if (layerViewPanel == this.dummyLayerViewPanel || layerViewPanel == null) {
            this.setComponentsEnabled(false);
            return;
        }
        this.setComponentsEnabled(true);
        this.slider.setValue(this.toSliderValue(this.viewBlackboard().get(SCALE_KEY, layerViewPanel.getViewport().getScale())));
        this.updateLabel();
        this.updateSliderLabels();
    }

    private void gestureFinished() throws NoninvertibleTransformException {
        if (!this.slider.isEnabled()) {
            return;
        }
        try {
            this.viewBlackboard().put(CENTRE_LOCKED_KEY, true);
            try {
                this.layerViewPanel().getViewport().zoom(this.proposedModelEnvelope());
            }
            finally {
                this.viewBlackboard().put(CENTRE_LOCKED_KEY, false);
            }
        }
        finally {
            this.layerViewPanel().getRenderingManager().setPaintingEnabled(true);
        }
    }

    private Envelope proposedModelEnvelope() throws NoninvertibleTransformException {
        double height;
        Coordinate centre = (Coordinate)this.viewBlackboard().get(CENTRE_KEY, EnvelopeUtil.centre(this.layerViewPanel().getViewport().getEnvelopeInModelCoordinates()));
        double width = (double)this.layerViewPanel().getWidth() / this.getScale();
        Envelope proposedModelEnvelope = new Envelope(centre.x - width / 2.0, centre.x + width / 2.0, centre.y - (height = (double)this.layerViewPanel().getHeight() / this.getScale()) / 2.0, centre.y + height / 2.0);
        if (proposedModelEnvelope.getWidth() == 0.0 || proposedModelEnvelope.getHeight() == 0.0) {
            proposedModelEnvelope = this.lastGoodEnvelope;
        } else {
            this.lastGoodEnvelope = proposedModelEnvelope;
        }
        return proposedModelEnvelope;
    }

    private double getScale() throws NoninvertibleTransformException {
        return this.toScale(this.slider.getValue());
    }

    private void clearModelCaches() {
        this.modelBlackboard().put(SEGMENT_CACHE_KEY, null);
        this.modelBlackboard().put(MIN_EXTENT_KEY, null);
        this.modelBlackboard().put(MAX_EXTENT_KEY, null);
        this.queueComponentUpdate();
    }

    private int toSliderValue(double scale) throws NoninvertibleTransformException {
        return this.slider.getMaximum() - (int)((double)this.slider.getMaximum() * (MathUtil.base10Log(scale) - MathUtil.base10Log(this.getMinScale())) / (MathUtil.base10Log(this.getMaxScale()) - MathUtil.base10Log(this.getMinScale())));
    }

    private double getMinExtent() throws NoninvertibleTransformException {
        return -1.0;
    }

    private double getMaxScale() throws NoninvertibleTransformException {
        double maxScale;
        double d = maxScale = this.getMinExtent() == -1.0 || this.getMinExtent() == 0.0 ? 1000.0 : (double)(1000 * this.layerViewPanel().getWidth()) / this.getMinExtent();
        if (this.viewBlackboard().get(USER_DEFINED_MAX_SCALE) != null) {
            maxScale = Math.max(maxScale, this.viewBlackboard().getDouble(USER_DEFINED_MAX_SCALE));
        }
        return maxScale;
    }

    private double getMinScale() throws NoninvertibleTransformException {
        double minScale = 0.001;
        if (this.viewBlackboard().get(USER_DEFINED_MIN_SCALE) != null) {
            return Math.min(minScale, this.viewBlackboard().getDouble(USER_DEFINED_MIN_SCALE));
        }
        return minScale;
    }

    private double toScale(int sliderValue) throws NoninvertibleTransformException {
        double scale = Math.pow(10.0, (double)(this.slider.getMaximum() - sliderValue) * (MathUtil.base10Log(this.getMaxScale()) - MathUtil.base10Log(this.getMinScale())) / (double)this.slider.getMaximum() + MathUtil.base10Log(this.getMinScale()));
        return scale;
    }

    private void setComponentsEnabled(boolean componentsEnabled) {
        this.slider.setEnabled(componentsEnabled);
        this.label.setEnabled(componentsEnabled);
    }

    private Blackboard viewBlackboard() {
        return this.layerViewPanel() != null ? this.layerViewPanel().getBlackboard() : new Blackboard();
    }

    private Blackboard modelBlackboard() {
        return this.layerViewPanel().getLayerManager().getBlackboard();
    }

    private LayerViewPanel layerViewPanel() {
        if (!(this.frame.getActiveInternalFrame() instanceof LayerViewPanelProxy)) {
            return this.dummyLayerViewPanel;
        }
        return ((LayerViewPanelProxy)((Object)this.frame.getActiveInternalFrame())).getLayerViewPanel();
    }

    final void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.label.setText(" ");
        this.slider.setPaintLabels(true);
        this.slider.setToolTipText(I18N.get("ui.zoom.ZoomBar.zoom"));
        this.slider.setMaximum(1000);
        this.add((Component)this.slider, "Center");
        this.add((Component)this.label, "East");
    }

    private void updateLabel() throws NoninvertibleTransformException {
        this.label.setText(this.chooseGoodIncrement(this.getScale()).toString());
    }

    private RoundQuantity chooseGoodIncrement(double scale) {
        return this.incrementChooser.chooseGoodIncrement((double)this.layerViewPanel().getWidth() / scale);
    }

    private void updateSliderLabels() throws NoninvertibleTransformException {
        if (!this.showingSliderLabels) {
            return;
        }
        if (!(this.slider.getUI() instanceof BasicSliderUI)) {
            return;
        }
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        int LABEL_WIDTH = 60;
        int lastLabelPosition = -120;
        for (int i = 0; i < this.slider.getWidth(); ++i) {
            if (i < lastLabelPosition + 60) continue;
            int sliderValue = ((BasicSliderUI)this.slider.getUI()).valueForXPosition(i);
            JLabel llabel = new JLabel(this.chooseGoodIncrement(this.toScale(sliderValue)).toString());
            llabel.setFont(llabel.getFont().deriveFont(10.0f));
            ((Dictionary)labelTable).put(sliderValue, llabel);
            lastLabelPosition = i;
        }
        if (((Dictionary)labelTable).isEmpty()) {
            return;
        }
        this.slider.setLabelTable(labelTable);
    }
}

