/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import de.riwagis.icons.IconLoader;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class PanTool
extends DragTool {
    private boolean dragging = false;
    private Envelope envSource = null;
    private Coordinate crdSource = null;
    private AffineTransform affSource = null;

    public static EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = new EnableCheckFactory(WorkbenchContext.getInstance());
        return checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck();
    }

    @Override
    public Cursor createCursor() {
        return PanTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_hand.svg").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"common_hand.svg");
    }

    @Override
    public boolean isMiddleMouseButtonUsed() {
        return true;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        try {
            super.mouseDragged(e);
            if (!this.isDragApproved()) {
                return;
            }
            if (!this.dragging) {
                this.envSource = this.getPanel().getViewport().getEnvelopeInModelCoordinates();
                this.affSource = new AffineTransform(this.getPanel().getViewport().getModelToViewTransform());
                this.crdSource = this.getPanel().getViewport().toModelCoordinate(this.getViewSource(), this.affSource);
                this.dragging = true;
            }
            Coordinate crdDest = this.getPanel().getViewport().toModelCoordinate(this.getViewDestination(), this.affSource);
            double dx = crdDest.x - this.crdSource.x;
            double dy = crdDest.y - this.crdSource.y;
            Envelope envNew = new Envelope(this.envSource.getMinX() - dx, this.envSource.getMaxX() - dx, this.envSource.getMinY() - dy, this.envSource.getMaxY() - dy);
            this.getPanel().getViewport().zoom(envNew, false);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        if (!this.checkMouseButton(e)) {
            return;
        }
        this.getPanel().getRenderingManager().setPaintingEnabled(true);
        this.dragging = false;
        super.mouseReleased(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isMiddleMouseButtonUsed() && e.getButton() == 2 && e.getClickCount() > 1) {
            this.getPanel().zoomToFullExtent();
        }
        super.mouseClicked(e);
    }

    @Override
    protected Shape getShape(Point2D source, Point2D destination) {
        return null;
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        double xDisplacement = this.getModelDestination().x - this.getModelSource().x;
        double yDisplacement = this.getModelDestination().y - this.getModelSource().y;
        Envelope oldEnvelope = this.getPanel().getViewport().getEnvelopeInModelCoordinates();
        this.getPanel().getViewport().zoom(new Envelope(oldEnvelope.getMinX() - xDisplacement, oldEnvelope.getMaxX() - xDisplacement, oldEnvelope.getMinY() - yDisplacement, oldEnvelope.getMaxY() - yDisplacement));
    }
}

