/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.plugin.options.task.OverviewOptionPanel;
import de.riwagis.util.gui.ExceptionDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import lombok.Generated;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverviewPanel
extends JPanel
implements Task.PropertiesChangedListener,
ViewportListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OverviewPanel.class);
    private static final Dimension DIM_INVISIBLE = new Dimension(180, 0);
    private static final Dimension DIM_VISIBLE = new Dimension(180, 180);
    private Image img = null;
    private Task task = null;
    private Viewport vp = null;
    private Envelope env = null;
    private Point ptStartDrag = null;
    private Point ptEndDrag = null;
    private Point ptMinEnv = null;
    private Point ptMaxEnv = null;

    public OverviewPanel() {
        this.initComponents();
        try {
            this.init();
        }
        catch (Exception e) {
            log.error("Could not initialize Overview Panel", (Throwable)e);
        }
    }

    private void init() {
        this.setCursor(new Cursor(1));
        this.hideOverview();
        GUIUtil.addGraphicsDeviceChangedListener(this, evt -> {
            try {
                log.info("Display configuration changed. Repainting Overview.");
                this.reloadOverview();
            }
            catch (Exception e) {
                log.error("Could not repaint overview.", (Throwable)e);
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.img != null) {
            int maxy;
            int miny;
            int maxx;
            int minx;
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawImage(this.img, 0, 0, OverviewPanel.DIM_VISIBLE.width, OverviewPanel.DIM_VISIBLE.height, this);
            if (this.ptStartDrag != null && this.ptEndDrag != null) {
                minx = Math.min(this.ptStartDrag.x, this.ptEndDrag.x);
                maxx = Math.max(this.ptStartDrag.x, this.ptEndDrag.x);
                miny = Math.min(this.ptStartDrag.y, this.ptEndDrag.y);
                maxy = Math.max(this.ptStartDrag.y, this.ptEndDrag.y);
                g2d.drawRect(minx, miny, maxx - minx, maxy - miny);
            }
            if (this.ptMinEnv != null && this.ptMaxEnv != null) {
                minx = Math.min(this.ptMinEnv.x, this.ptMaxEnv.x);
                maxx = Math.max(this.ptMinEnv.x, this.ptMaxEnv.x);
                miny = Math.min(this.ptMinEnv.y, this.ptMaxEnv.y);
                maxy = Math.max(this.ptMinEnv.y, this.ptMaxEnv.y);
                int width = maxx - minx;
                int height = maxy - miny;
                if (width < 12) {
                    maxx = minx + width / 2 + 6;
                    minx = minx + width / 2 - 6;
                }
                if (height < 12) {
                    maxy = miny + height / 2 + 6;
                    miny = miny + height / 2 - 6;
                }
                g2d.setStroke(new BasicStroke(3.0f));
                g2d.setColor(Color.YELLOW);
                g2d.drawRect(minx, miny, maxx - minx, maxy - miny);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.setColor(Color.BLACK);
                g2d.drawRect(minx, miny, maxx - minx, maxy - miny);
                g2d.setColor(Color.BLACK);
            }
        }
    }

    public void initWithTaskFrame(TaskFrame frmTask) {
        this.task = frmTask.getTask();
        this.env = this.task.getInitialView();
        this.vp = frmTask.getLayerViewPanel().getViewport();
        this.task.addPropertiesChangedListener(this);
        this.vp.addListener(this);
    }

    public void reloadOverview() throws Exception {
        if (this.task == null) {
            return;
        }
        this.img = OverviewOptionPanel.getImage(this.task, this.env, OverviewPanel.DIM_VISIBLE.width, OverviewPanel.DIM_VISIBLE.height);
        if (this.img == null) {
            this.hideOverview();
            return;
        }
        this.showOverview();
        this.repaint();
    }

    @Override
    public void propertiesChanged(Task taskNew) {
        try {
            this.initWithTaskFrame((TaskFrame)WorkbenchContext.getFrame().getActiveInternalFrame());
            this.reloadOverview();
        }
        catch (Exception e) {
            this.hideOverview();
        }
    }

    @Override
    public void zoomChanged(Viewport vPort) {
        LayerViewPanel lvp = null;
        if (vPort.getPanel() instanceof LayerViewPanel && this.task == (lvp = (LayerViewPanel)vPort.getPanel()).getLayerManager().getTask()) {
            Envelope envZoom = vPort.getEnvelopeInModelCoordinates();
            int xmin = (int)((envZoom.getMinX() - this.env.getMinX()) / this.env.getWidth() * DIM_VISIBLE.getWidth());
            int ymin = (int)(DIM_VISIBLE.getHeight() - (envZoom.getMinY() - this.env.getMinY()) / this.env.getHeight() * DIM_VISIBLE.getHeight());
            int xmax = (int)((envZoom.getMaxX() - this.env.getMinX()) / this.env.getWidth() * DIM_VISIBLE.getWidth());
            int ymax = (int)(DIM_VISIBLE.getHeight() - (envZoom.getMaxY() - this.env.getMinY()) / this.env.getHeight() * DIM_VISIBLE.getHeight());
            this.ptMinEnv = new Point(xmin, ymin);
            this.ptMaxEnv = new Point(xmax, ymax);
            this.repaint();
        }
    }

    private Coordinate getModelPoint(Point pt) {
        double dblx = this.env.getMinX() + (double)pt.x / DIM_VISIBLE.getWidth() * this.env.getWidth();
        double dbly = this.env.getMaxY() - (double)pt.y / DIM_VISIBLE.getHeight() * this.env.getHeight();
        return new Coordinate(dblx, dbly);
    }

    private Envelope getModelEnvelope(Point pt1, Point pt2) {
        Coordinate c1 = this.getModelPoint(pt1);
        Coordinate c2 = this.getModelPoint(pt2);
        return new Envelope(c1, c2);
    }

    public void showOverview() {
        this.setEnabled(true);
        this.setVisible(true);
        this.setPreferredSize(DIM_VISIBLE);
        this.setMinimumSize(DIM_VISIBLE);
        this.setSize(DIM_VISIBLE);
    }

    public void hideOverview() {
        this.setEnabled(false);
        this.setVisible(false);
        this.setPreferredSize(DIM_INVISIBLE);
        this.setMinimumSize(DIM_INVISIBLE);
        this.setSize(DIM_INVISIBLE);
        this.task = null;
        this.env = null;
        this.vp = null;
    }

    public Task getTask() {
        return this.task;
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Component.borderColor")));
        this.setMaximumSize(new Dimension(180, 180));
        this.setMinimumSize(new Dimension(180, 180));
        this.setPreferredSize(new Dimension(180, 180));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                OverviewPanel.this.this_onMouseDragged(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OverviewPanel.this.this_onMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.this_onMouseEntered(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.this_onMouseReleased(evt);
            }
        });
        this.setLayout(new GridBagLayout());
    }

    private void this_onMouseReleased(MouseEvent evt) {
        if (this.ptStartDrag != null) {
            try {
                this.vp.zoom(this.getModelEnvelope(this.ptStartDrag, this.ptEndDrag));
            }
            catch (Exception e) {
                ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
            }
        }
        this.ptStartDrag = null;
        this.ptEndDrag = null;
        this.repaint();
    }

    private void this_onMouseDragged(MouseEvent evt) {
        if (this.ptStartDrag == null) {
            this.ptStartDrag = evt.getPoint();
        }
        this.ptEndDrag = evt.getPoint();
        this.repaint();
    }

    private void this_onMouseClicked(MouseEvent evt) {
        try {
            Point ptClick = evt.getPoint();
            Coordinate c1 = this.getModelPoint(ptClick);
            Envelope envCurrent = this.vp.getEnvelopeInModelCoordinates();
            Envelope envNew = new Envelope(c1.x - envCurrent.getWidth() / 2.0, c1.x + envCurrent.getWidth() / 2.0, c1.y - envCurrent.getHeight() / 2.0, c1.y + envCurrent.getHeight() / 2.0);
            this.vp.zoom(envNew);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void this_onMouseEntered(MouseEvent evt) {
        this.requestFocusInWindow();
    }
}

