/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.ArrayTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.crs.Transformer;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.MapSupport;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.WhiteboardImpl;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigationPanel
extends JPanel {
    private static final XStream XSTREAM = NavigationPanel.createSecuredXStream();
    private static final int EXPORT_IMPORT_VERSION = 1;
    private static final String FILE_EXTENSION_NAV = "nav";
    private static final Logger LOG = LoggerFactory.getLogger(NavigationPanel.class);
    private static final String REGION_VALUE = NavigationPanel.class.getName() + "_REGIONS";
    private static final String DEFAULT_REGION_VALUE = NavigationPanel.class.getName() + "_DEFAULT_REGION";
    private static final String LAST_EXPORT_IMPORT_FILE_BLACKBOARD_KEY = NavigationPanel.class.getName() + "_LAST_EXPORT_IMPORT_DIR";
    private final Map<String, Object[]> mapRegions = (Map)PersistentBlackboardPlugIn.get().get(REGION_VALUE, new HashMap());
    private String strDefaultRegion = PersistentBlackboardPlugIn.get().get(DEFAULT_REGION_VALUE, null);
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem menuItemRename = null;
    private JMenuItem menuItemImport = null;
    private JMenuItem menuItemExport = null;
    private JButton butDelete;
    private JButton butEdit;
    private JButton butMakeDefault;
    private JButton butNew;
    private JButton butRemoveDefault;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblRegion;
    private JList<String> lstRegion;
    private JToolBar tbaHeader;

    public NavigationPanel() {
        this.initComponents();
        this.i18n();
        try {
            this.init();
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    private void i18n() {
        this.lblRegion.setText(I18N.get("ui.zoom.ZoomTool.NavigationPanel.regions"));
        this.butDelete.setToolTipText(I18N.get("ui.zoom.ZoomTool.NavigationPanel.delete-region"));
        this.butEdit.setToolTipText(I18N.get("ui.zoom.ZoomTool.NavigationPanel.edit-region"));
        this.butNew.setToolTipText(I18N.get("ui.zoom.ZoomTool.NavigationPanel.new-region"));
        this.butMakeDefault.setToolTipText(I18N.get("ui.zoom.ZoomTool.NavigationPanel.make-default"));
        this.butRemoveDefault.setToolTipText(I18N.get("ui.zoom.ZoomTool.NavigationPanel.remove-default"));
        this.lstRegion.setToolTipText(I18N.get("ui.zoom.ZoomTool.NavigationPanel.list-tooltip-doubleclick"));
    }

    private void init() {
        this.butDelete.setMargin(new Insets(0, 0, 0, 0));
        this.butEdit.setMargin(new Insets(0, 0, 0, 0));
        this.butNew.setMargin(new Insets(0, 0, 0, 0));
        this.butMakeDefault.setMargin(new Insets(0, 0, 0, 0));
        this.butRemoveDefault.setMargin(new Insets(0, 0, 0, 0));
        this.butDelete.setIcon(IconLoader.svgIcon((String)"common_delete.svg"));
        this.butEdit.setIcon(IconLoader.svgIcon((String)"common_save.svg"));
        this.butNew.setIcon(IconLoader.svgIcon((String)"common_add.svg"));
        this.butMakeDefault.setIcon(IconLoader.svgIcon((String)"common_set_default.svg"));
        this.butRemoveDefault.setIcon(IconLoader.svgIcon((String)"common_reset_default.svg"));
        this.lstRegion.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                if (NavigationPanel.this.strDefaultRegion != null && value.toString().equals(NavigationPanel.this.strDefaultRegion) && !isSelected) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                    label.setBackground(Color.YELLOW);
                    label.setForeground(Color.BLUE);
                    label.setOpaque(true);
                    return label;
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            }
        });
        this.menuItemRename = new JMenuItem(I18N.get("common.rename"));
        this.menuItemRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationPanel.this.renameRegion();
            }
        });
        this.popup.add(this.menuItemRename);
        this.popup.addSeparator();
        this.menuItemImport = new JMenuItem(I18N.get("common.import"));
        this.menuItemImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFilter navFileFilter = GUISupport.createFileFilter((String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.file-filter"), (String[])new String[]{NavigationPanel.FILE_EXTENSION_NAV});
                JFileChooser fChoose = GUISupport.createJFileChooser((boolean)true);
                fChoose.setFileFilter(navFileFilter);
                fChoose.setDialogTitle(I18N.get("ui.zoom.ZoomTool.NavigationPanel.choose-import-file"));
                fChoose.setFileSelectionMode(0);
                fChoose.setMultiSelectionEnabled(false);
                fChoose.setAcceptAllFileFilterUsed(false);
                File lastFile = (File)PersistentBlackboardPlugIn.get().get(LAST_EXPORT_IMPORT_FILE_BLACKBOARD_KEY, (Object)null);
                if (lastFile != null && lastFile.getParentFile().exists() && lastFile.getParentFile().isDirectory()) {
                    fChoose.setSelectedFile(lastFile);
                }
                if (fChoose.showOpenDialog(NavigationPanel.this) == 0) {
                    File selFile = fChoose.getSelectedFile();
                    NavigationPanel.this.importRegions(selFile);
                    PersistentBlackboardPlugIn.get().put(LAST_EXPORT_IMPORT_FILE_BLACKBOARD_KEY, selFile);
                }
            }
        });
        this.popup.add(this.menuItemImport);
        this.menuItemExport = new JMenuItem(I18N.get("common.export"));
        this.menuItemExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFilter navFileFilter = GUISupport.createFileFilter((String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.file-filter"), (String[])new String[]{NavigationPanel.FILE_EXTENSION_NAV});
                JFileChooser fChoose = GUISupport.createJFileChooserOverwritePrompting();
                fChoose.setFileFilter(navFileFilter);
                fChoose.setDialogTitle(I18N.get("ui.zoom.ZoomTool.NavigationPanel.choose-export-file"));
                fChoose.setFileSelectionMode(0);
                fChoose.setMultiSelectionEnabled(false);
                fChoose.setAcceptAllFileFilterUsed(false);
                File lastFile = (File)PersistentBlackboardPlugIn.get().get(LAST_EXPORT_IMPORT_FILE_BLACKBOARD_KEY, (Object)null);
                if (lastFile != null && lastFile.getParentFile().exists() && lastFile.getParentFile().isDirectory()) {
                    fChoose.setSelectedFile(lastFile);
                }
                if (fChoose.showSaveDialog(NavigationPanel.this) == 0) {
                    File selFile = fChoose.getSelectedFile();
                    selFile = FileSupport.addExtension((File)selFile, (String)NavigationPanel.FILE_EXTENSION_NAV);
                    NavigationPanel.this.exportRegions(selFile);
                    PersistentBlackboardPlugIn.get().put(LAST_EXPORT_IMPORT_FILE_BLACKBOARD_KEY, selFile);
                }
            }
        });
        this.popup.add(this.menuItemExport);
        this.lstRegion.add(this.popup);
        this.displayRegions();
    }

    private void displayRegions() {
        ListListModel lstModel = new ListListModel(new ArrayList<String>(this.mapRegions.keySet()), true, null);
        this.lstRegion.setModel((ListModel<String>)lstModel);
        this.updateButtons();
    }

    private void saveRegions() {
        PersistentBlackboardPlugIn.get().put(REGION_VALUE, this.mapRegions);
        PersistentBlackboardPlugIn.get().put(DEFAULT_REGION_VALUE, this.strDefaultRegion);
        PersistentBlackboardPlugIn.saveState();
    }

    private void exportRegions(File file) {
        Whiteboard wb = WhiteboardImpl.createWhiteboard(new HashMap());
        wb.setAttribute("VERSION", 1);
        HashMap<String, Object[]> mapRegions2Export = new HashMap<String, Object[]>();
        List<String> valuesSelected = this.lstRegion.getSelectedValuesList();
        for (String listValue : valuesSelected) {
            if (!this.mapRegions.containsKey(listValue)) continue;
            mapRegions2Export.put(listValue, this.mapRegions.get(listValue));
        }
        wb.setAttribute(REGION_VALUE, mapRegions2Export);
        WhiteboardImpl.writeToFile((Whiteboard)wb, (File)file, (XStream)XSTREAM);
    }

    private void importRegions(File file) {
        Whiteboard wb = WhiteboardImpl.createWhiteboard((File)file, (XStream)XSTREAM);
        Map mapRegions2Import = (Map)wb.getAttribute(REGION_VALUE);
        if (mapRegions2Import != null) {
            for (String regionKey : mapRegions2Import.keySet()) {
                this.mapRegions.put(MapSupport.getUniqueKey(this.mapRegions, (String)regionKey), (Object[])mapRegions2Import.get(regionKey));
            }
        }
        this.saveRegions();
        this.displayRegions();
    }

    private static XStream createSecuredXStream() {
        XStream xstream = new XStream();
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.addPermission(ArrayTypePermission.ARRAYS);
        xstream.allowTypeHierarchy(Map.class);
        xstream.allowTypes(new Class[]{String.class});
        return xstream;
    }

    private void updateButtons() {
        if (this.lstRegion.getSelectedIndices().length == 0) {
            this.butEdit.setEnabled(false);
            this.butDelete.setEnabled(false);
            this.butMakeDefault.setEnabled(false);
            this.menuItemRename.setEnabled(false);
            this.menuItemExport.setEnabled(false);
        } else if (this.lstRegion.getSelectedIndices().length == 1) {
            this.butEdit.setEnabled(true);
            this.butDelete.setEnabled(true);
            this.butMakeDefault.setEnabled(true);
            this.menuItemRename.setEnabled(true);
            this.menuItemExport.setEnabled(true);
        } else {
            this.butEdit.setEnabled(false);
            this.butDelete.setEnabled(true);
            this.butMakeDefault.setEnabled(false);
            this.menuItemRename.setEnabled(false);
            this.menuItemExport.setEnabled(true);
        }
        if (this.strDefaultRegion == null) {
            this.butRemoveDefault.setEnabled(false);
        } else {
            this.butRemoveDefault.setEnabled(true);
        }
    }

    private void addRegion(String strRegionName) {
        try {
            if (this.mapRegions.containsKey(strRegionName)) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.region-already-exists"), (String)I18N.get("common.error"));
                return;
            }
            JInternalFrame iFrame = WorkbenchContext.getFrame().getActiveInternalFrame();
            if (!(iFrame instanceof TaskFrame)) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.select-task-frame"), (String)I18N.get("common.error"));
                return;
            }
            TaskFrame tFr = (TaskFrame)iFrame;
            Envelope vEnv = tFr.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
            String strEpsgCode = tFr.getTask().getCRSDefinition().getCode();
            Object[] arrEnv = new Object[]{strEpsgCode, new double[]{vEnv.getMinX(), vEnv.getMaxX(), vEnv.getMinY(), vEnv.getMaxY()}};
            this.mapRegions.put(strRegionName, arrEnv);
            this.saveRegions();
            this.displayRegions();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    private void renameRegion() {
        try {
            if (this.lstRegion.getSelectedValue() != null) {
                String strRegionNameOld = this.lstRegion.getSelectedValue();
                String strRegionNameNew = GUISupport.inputbox((Component)this, (String)I18N.get("ui.zoom.VisibilityPanel.enter-profile-name"), (String)strRegionNameOld);
                if (StringUtils.isEmpty((CharSequence)strRegionNameNew)) {
                    return;
                }
                if (!strRegionNameNew.equals(strRegionNameOld) && this.mapRegions.containsKey(strRegionNameNew)) {
                    GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.region-already-exists"), (String)I18N.get("common.error"));
                    return;
                }
                if (this.mapRegions.containsKey(strRegionNameOld)) {
                    Object[] arrEnv = this.mapRegions.remove(strRegionNameOld);
                    this.mapRegions.put(strRegionNameNew, arrEnv);
                    this.saveRegions();
                    this.displayRegions();
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    private void editRegion() {
        try {
            if (this.lstRegion.getSelectedValue() == null) {
                GUISupport.msgbox((Component)this, (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.select-region"), (String)I18N.get("common.message"));
                return;
            }
            JInternalFrame iFrame = WorkbenchContext.getFrame().getActiveInternalFrame();
            if (!(iFrame instanceof TaskFrame)) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.select-task-frame"), (String)I18N.get("common.error"));
                return;
            }
            String strRegionNameOld = this.lstRegion.getSelectedValue();
            String strRegionNameNew = GUISupport.inputbox((Component)this, (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.enter-region-name"), (String)strRegionNameOld);
            if (StringUtils.isEmpty((CharSequence)strRegionNameNew)) {
                return;
            }
            if (!strRegionNameNew.equals(strRegionNameOld) && this.mapRegions.containsKey(strRegionNameNew)) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.region-already-exists"), (String)I18N.get("common.error"));
                return;
            }
            if (this.mapRegions.containsKey(strRegionNameOld)) {
                TaskFrame tFr = (TaskFrame)iFrame;
                Envelope vEnv = tFr.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
                String strEpsgCode = tFr.getTask().getCRSDefinition().getCode();
                Object[] arrEnv = new Object[]{strEpsgCode, new double[]{vEnv.getMinX(), vEnv.getMaxX(), vEnv.getMinY(), vEnv.getMaxY()}};
                this.mapRegions.remove(strRegionNameOld);
                this.mapRegions.put(strRegionNameNew, arrEnv);
                this.saveRegions();
                GUISupport.msgbox((Component)this, (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.edit-region-ready"), (String)I18N.get("common.message"));
            }
            this.displayRegions();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    private static Envelope transformRegion(String strEpsgFrom, String strEpsgTo, double[] arrEnv) throws Exception {
        Envelope oriEnv = new Envelope(arrEnv[0], arrEnv[1], arrEnv[2], arrEnv[3]);
        if (strEpsgFrom == null || strEpsgTo == null || strEpsgFrom.length() == 0 || strEpsgTo.length() == 0) {
            return oriEnv;
        }
        if (strEpsgFrom.equals(strEpsgTo)) {
            return oriEnv;
        }
        Transformer tr = new Transformer(strEpsgFrom, strEpsgTo);
        tr.transform2d(oriEnv);
        return oriEnv;
    }

    private void zoomRegion(String strRegionName) {
        try {
            JInternalFrame iFrame = WorkbenchContext.getFrame().getActiveInternalFrame();
            if (iFrame instanceof TaskFrame) {
                TaskFrame tFr = (TaskFrame)iFrame;
                if (this.mapRegions.containsKey(strRegionName)) {
                    Object[] arrObj = this.mapRegions.get(strRegionName);
                    Envelope env = NavigationPanel.getEnvelope4Region(arrObj);
                    tFr.getLayerViewPanel().getViewport().zoom(env);
                }
            } else {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.select-task-frame"), (String)I18N.get("common.error"));
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    private void deleteRegion(List<String> regionNames) {
        for (String regionName : regionNames) {
            if (!this.mapRegions.containsKey(regionName)) continue;
            this.mapRegions.remove(regionName);
            if (this.strDefaultRegion == null || !this.strDefaultRegion.equals(regionName)) continue;
            this.strDefaultRegion = null;
        }
        this.saveRegions();
        this.displayRegions();
    }

    private void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void initComponents() {
        this.lblRegion = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstRegion = new JList();
        this.tbaHeader = new JToolBar();
        this.butNew = new JButton();
        this.butEdit = new JButton();
        this.butDelete = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.butMakeDefault = new JButton();
        this.butRemoveDefault = new JButton();
        this.jSeparator2 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.lblRegion.setText("Gespeicherte Bereiche:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblRegion, gridBagConstraints);
        this.lstRegion.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NavigationPanel.this.lstRegion_onMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                NavigationPanel.this.lstRegionMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                NavigationPanel.this.lstRegionMouseReleased(evt);
            }
        });
        this.lstRegion.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NavigationPanel.this.lstRegionKeyReleased(evt);
            }
        });
        this.lstRegion.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                NavigationPanel.this.lstRegion_onValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstRegion);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.tbaHeader.setFloatable(false);
        this.tbaHeader.setRollover(true);
        this.butNew.setFocusable(false);
        this.butNew.setHorizontalTextPosition(0);
        this.butNew.setMaximumSize(new Dimension(30, 27));
        this.butNew.setMinimumSize(new Dimension(30, 27));
        this.butNew.setPreferredSize(new Dimension(30, 27));
        this.butNew.setVerticalTextPosition(3);
        this.butNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavigationPanel.this.butNew_onActionPerformed(evt);
            }
        });
        this.tbaHeader.add(this.butNew);
        this.butEdit.setFocusable(false);
        this.butEdit.setHorizontalTextPosition(0);
        this.butEdit.setMaximumSize(new Dimension(30, 27));
        this.butEdit.setMinimumSize(new Dimension(30, 27));
        this.butEdit.setPreferredSize(new Dimension(30, 27));
        this.butEdit.setVerticalTextPosition(3);
        this.butEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavigationPanel.this.butEdit_onActionPerformed(evt);
            }
        });
        this.tbaHeader.add(this.butEdit);
        this.butDelete.setFocusable(false);
        this.butDelete.setHorizontalTextPosition(0);
        this.butDelete.setMaximumSize(new Dimension(30, 27));
        this.butDelete.setMinimumSize(new Dimension(30, 27));
        this.butDelete.setPreferredSize(new Dimension(30, 27));
        this.butDelete.setVerticalTextPosition(3);
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavigationPanel.this.butDelete_onActionPerformed(evt);
            }
        });
        this.tbaHeader.add(this.butDelete);
        this.tbaHeader.add(this.jSeparator1);
        this.butMakeDefault.setFocusable(false);
        this.butMakeDefault.setHorizontalTextPosition(0);
        this.butMakeDefault.setMaximumSize(new Dimension(30, 27));
        this.butMakeDefault.setMinimumSize(new Dimension(30, 27));
        this.butMakeDefault.setPreferredSize(new Dimension(30, 27));
        this.butMakeDefault.setVerticalTextPosition(3);
        this.butMakeDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavigationPanel.this.butMakeDefault_onActionPerformed(evt);
            }
        });
        this.tbaHeader.add(this.butMakeDefault);
        this.butRemoveDefault.setFocusable(false);
        this.butRemoveDefault.setHorizontalTextPosition(0);
        this.butRemoveDefault.setMaximumSize(new Dimension(30, 27));
        this.butRemoveDefault.setMinimumSize(new Dimension(30, 27));
        this.butRemoveDefault.setPreferredSize(new Dimension(30, 27));
        this.butRemoveDefault.setVerticalTextPosition(3);
        this.butRemoveDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavigationPanel.this.butRemoveDefault_onActionPerformed(evt);
            }
        });
        this.tbaHeader.add(this.butRemoveDefault);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tbaHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
    }

    private void lstRegion_onMouseClicked(MouseEvent evt) {
        try {
            if (evt.getClickCount() > 1 && this.lstRegion.getSelectedValue() != null) {
                this.zoomRegion(this.lstRegion.getSelectedValue());
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        try {
            if (this.lstRegion.getSelectedValue() == null) {
                GUISupport.msgbox((Component)this, (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.select-region"), (String)I18N.get("common.message"));
                return;
            }
            boolean bolDelete = GUISupport.yesnobox((Component)this, (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.delete-region-question"), (String)I18N.get("common.message"));
            if (!bolDelete) {
                return;
            }
            this.deleteRegion(this.lstRegion.getSelectedValuesList());
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void butEdit_onActionPerformed(ActionEvent evt) {
        try {
            this.editRegion();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void butNew_onActionPerformed(ActionEvent evt) {
        try {
            String strName = GUISupport.inputbox((Component)this, (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.enter-region-name"));
            if (StringUtils.isEmpty((CharSequence)strName)) {
                return;
            }
            this.addRegion(strName);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void butMakeDefault_onActionPerformed(ActionEvent evt) {
        if (this.lstRegion.getSelectedValue() == null) {
            GUISupport.msgbox((Component)this, (String)I18N.get("ui.zoom.ZoomTool.NavigationPanel.select-region"), (String)I18N.get("common.message"));
            return;
        }
        this.strDefaultRegion = this.lstRegion.getSelectedValue().toString();
        this.saveRegions();
        this.displayRegions();
    }

    private void butRemoveDefault_onActionPerformed(ActionEvent evt) {
        this.strDefaultRegion = null;
        this.saveRegions();
        this.displayRegions();
    }

    private void lstRegion_onValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void lstRegionKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 113) {
            this.renameRegion();
        }
    }

    private void lstRegionMousePressed(MouseEvent evt) {
        this.showPopup(evt);
    }

    private void lstRegionMouseReleased(MouseEvent evt) {
        this.showPopup(evt);
    }

    private static Envelope getEnvelope4Region(Object[] arrObj) throws Exception {
        String strEpsgCode = ObjectUtils.toString((Object)arrObj[0]);
        double[] arrEnv = (double[])arrObj[1];
        String strEpsgCodeTask = WorkbenchContext.getTask().getCRSDefinition().getCode();
        Envelope env = NavigationPanel.transformRegion(strEpsgCode, strEpsgCodeTask, arrEnv);
        return env;
    }

    public static Envelope getDefaultExtent() {
        try {
            Map mapRegions = (Map)PersistentBlackboardPlugIn.get().get(REGION_VALUE, new HashMap());
            String strDefaultRegion = PersistentBlackboardPlugIn.get().get(DEFAULT_REGION_VALUE, null);
            if (strDefaultRegion == null) {
                return null;
            }
            if (mapRegions.containsKey(strDefaultRegion)) {
                Object[] arrObj = (Object[])mapRegions.get(strDefaultRegion);
                return NavigationPanel.getEnvelope4Region(arrObj);
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("Error reading default extent", (Throwable)e);
            return null;
        }
    }
}

