/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.visibility.model;

import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.model.visibility.LayerableVisibility;
import com.vividsolutions.jump.workbench.model.visibility.ModelVisibility;
import com.vividsolutions.jump.workbench.model.visibility.StyleCollectionVisibility;
import com.vividsolutions.jump.workbench.ui.visibility.model.ModelVisibilityEntity;
import com.vividsolutions.jump.workbench.ui.visibility.model.StoredModelVisibility;
import com.vividsolutions.jump.workbench.ui.visibility.model.StyleCollectionStoredVisibility;
import java.util.Map;

public class LayerableStoredVisibility
extends LayerableVisibility
implements StoredModelVisibility {
    public LayerableStoredVisibility(Layerable ly, StoredModelVisibility parent) {
        super(ly, parent);
    }

    @Override
    public void saveVisi(Map<String, Object> mapVisi) {
        StringBuilder sbLyName = new StringBuilder();
        this.appendName(sbLyName);
        ModelVisibilityEntity mve = new ModelVisibilityEntity(this.getTypeOfLayerable(), this.ly.isVisible());
        int alpha = this.ly.getStyleCollections().iterator().next().getAlpha();
        mve.setAlpha(alpha);
        mapVisi.put(sbLyName.toString(), mve);
        for (ModelVisibility mv : this.getChildren()) {
            ((StoredModelVisibility)mv).saveVisi(mapVisi);
        }
    }

    @Override
    public void activateVisi(Map<String, Object> mapVisi) {
        StringBuilder sbLyName = new StringBuilder();
        this.appendName(sbLyName);
        Object oMve = mapVisi.get(sbLyName.toString());
        if (oMve instanceof ModelVisibilityEntity) {
            ModelVisibilityEntity mve = (ModelVisibilityEntity)oMve;
            this.ly.setVisible(mve.isVisible());
            for (StyleCollection sCol : this.ly.getStyleCollections()) {
                sCol.setAlpha(mve.getAlpha());
            }
        }
        for (ModelVisibility mv : this.getChildren()) {
            ((StoredModelVisibility)mv).activateVisi(mapVisi);
        }
    }

    @Override
    public void appendName(StringBuilder sb) {
        String strLyKey = this.ly.getKey().replaceAll("\\|", ",,,");
        sb.append(strLyKey);
    }

    @Override
    protected StyleCollectionVisibility getStyleCollectionVisibility(StyleCollection lyCol) {
        return new StyleCollectionStoredVisibility(lyCol, this);
    }

    private String getTypeOfLayerable() {
        if (this.ly instanceof CadLayer) {
            return "cad";
        }
        if (this.ly instanceof WMSLayer) {
            return "wms";
        }
        return "lay";
    }
}

