/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.visibility;

import com.vividsolutions.jump.workbench.ui.visibility.IVisibilityVersionConverter;
import com.vividsolutions.jump.workbench.ui.visibility.model.ModelVisibilityEntity;
import com.vividsolutions.jump.workbench.ui.visibility.model.ModelVisibilityThemingEntity;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class VisibilityVersionConverter_1_2
implements IVisibilityVersionConverter {
    Map<String, ModelVisibilityEntity> convertedMap;

    @Override
    public Map<String, Object> convertProfile(Map<String, Object> profileToConvert) throws RuntimeException {
        return this.convertProfileVersion1ToProfileVersion2(profileToConvert);
    }

    public Map<String, Object> convertProfileVersion1ToProfileVersion2(Map<String, Object> profileToConvert) {
        String key;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : profileToConvert.entrySet()) {
            key = entry.getKey();
            if (key.startsWith("cat_")) {
                Map.Entry<String, ModelVisibilityEntity> cat = this.convertCategory(entry);
                result.put(cat.getKey(), cat.getValue());
                continue;
            }
            if (!key.startsWith("lay_")) continue;
            Map.Entry<String, ModelVisibilityEntity> lay = this.convertLayer(entry);
            result.put(lay.getKey(), lay.getValue());
        }
        for (Map.Entry<String, Object> entry : profileToConvert.entrySet()) {
            key = entry.getKey();
            if (key.startsWith("th_")) {
                this.extendLayerWithThemingEntity(result, entry);
                continue;
            }
            if (key.startsWith("wms_")) {
                this.extendWMSLayerWithThemingEntity(result, entry);
                continue;
            }
            if (!key.startsWith("cad_")) continue;
            this.extendCADLayerWithThemingEntity(result, entry);
        }
        return result;
    }

    public Map.Entry<String, ModelVisibilityEntity> convertCategory(Map.Entry<String, Object> originalEntry) {
        String key = originalEntry.getKey();
        boolean visible = originalEntry.getValue() instanceof Boolean && (Boolean)originalEntry.getValue() != false;
        ModelVisibilityEntity mve = new ModelVisibilityEntity("cat", visible);
        return new AbstractMap.SimpleEntry<String, ModelVisibilityEntity>(key.substring(4, key.length() - 1), mve);
    }

    public Map.Entry<String, ModelVisibilityEntity> convertLayer(Map.Entry<String, Object> originalEntry) {
        String key = originalEntry.getKey();
        boolean visible = originalEntry.getValue() instanceof Boolean && (Boolean)originalEntry.getValue() != false;
        ModelVisibilityEntity mve = new ModelVisibilityEntity("lay", visible);
        mve.setAlpha(255);
        return new AbstractMap.SimpleEntry<String, ModelVisibilityEntity>(key.substring(4), mve);
    }

    public void extendWMSLayerWithThemingEntity(Map<String, Object> convertMap, Map.Entry<String, Object> originalEntry) {
        this.extendWMSAndCADLayerWithThemingEntity(convertMap, originalEntry, "wms", false);
    }

    public void extendCADLayerWithThemingEntity(Map<String, Object> convertMap, Map.Entry<String, Object> originalEntry) {
        this.extendWMSAndCADLayerWithThemingEntity(convertMap, originalEntry, "cad", true);
    }

    public void extendLayerWithThemingEntity(Map<String, Object> convertMap, Map.Entry<String, Object> originalEntry) {
        String key = originalEntry.getKey();
        String[] wmsSubstrings = key.substring(3).split("\\|");
        String layerName = wmsSubstrings[0];
        ModelVisibilityEntity parentMve = (ModelVisibilityEntity)convertMap.get(layerName);
        if (parentMve == null) {
            throw new RuntimeException(String.format("Layer %s not found in map. Could not convert visibility profile", layerName));
        }
        String style = wmsSubstrings.length == 3 ? wmsSubstrings[2] : "";
        String scale = wmsSubstrings[1];
        boolean visible = originalEntry.getValue() instanceof Boolean && (Boolean)originalEntry.getValue() != false;
        parentMve.addTheming(new ModelVisibilityThemingEntity(style, scale, visible));
    }

    @Override
    public boolean needsConversion(int currentVersion) {
        return currentVersion < this.getTargetVersion();
    }

    @Override
    public int getTargetVersion() {
        return 2;
    }

    private void extendWMSAndCADLayerWithThemingEntity(Map<String, Object> convertMap, Map.Entry<String, Object> originalEntry, String entityType, boolean setThemesVisible) {
        String[] singleStyles;
        if (originalEntry.getValue() == null || originalEntry.getValue().toString().isEmpty()) {
            return;
        }
        String key = originalEntry.getKey();
        String[] wmsSubstrings = key.substring(4).split("\\|");
        String layerName = wmsSubstrings[0];
        ModelVisibilityEntity parentMve = (ModelVisibilityEntity)convertMap.get(layerName);
        if (parentMve == null) {
            throw new RuntimeException(String.format("Layer %s not found in map. Could not convert visibility profile", layerName));
        }
        parentMve.setType(entityType);
        String scale = wmsSubstrings[1];
        String styleString = originalEntry.getValue() != null ? originalEntry.getValue().toString() : "";
        for (String singleStyle : singleStyles = styleString.split("\\|")) {
            parentMve.addTheming(new ModelVisibilityThemingEntity(singleStyle, scale, setThemesVisible));
        }
    }
}

