/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.visibility;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.visibility.AbstractVisibilityVersionConverter;
import com.vividsolutions.jump.workbench.ui.visibility.interfaces.UpdateVisibilityDisplayListener;
import com.vividsolutions.jump.workbench.ui.visibility.model.CategoryStoredVisibility;
import com.vividsolutions.jump.workbench.ui.visibility.model.ModelVisibilityEntity;
import com.vividsolutions.jump.workbench.ui.visibility.model.ModelVisibilityThemingEntity;
import de.riwagis.util.MapSupport;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.WhiteboardImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VisibilityProfile {
    private static final int TARGET_EXPORT_IMPORT_VERSION = 2;
    private static final XStream XSTREAM = VisibilityProfile.createSecuredXStream();
    private final List<UpdateVisibilityDisplayListener> listeners = new ArrayList<UpdateVisibilityDisplayListener>();
    private static final String PROFILE_VALUE = "com.vividsolutions.jump.workbench.ui.zoom.VisibilityPanel_PROFILES";
    protected static final String DEFAULT_PROFILE_VALUE = "com.vividsolutions.jump.workbench.ui.zoom.VisibilityPanel_DEFAULT_PROFILE";
    protected static final String VERSION_VALUE = "com.vividsolutions.jump.workbench.ui.zoom.VisibilityPanel_PROFILE_VERSION";
    public static final String FILE_EXTENSION_VIS = "visi";
    private final Map<String, Map<String, Object>> mapProfiles = (Map)PersistentBlackboardPlugIn.get().get("com.vividsolutions.jump.workbench.ui.zoom.VisibilityPanel_PROFILES", new HashMap());
    private String strDefaultProfile = PersistentBlackboardPlugIn.get().get("com.vividsolutions.jump.workbench.ui.zoom.VisibilityPanel_DEFAULT_PROFILE", null);
    private final String lastExportImportFileBlackboardKey;

    public VisibilityProfile(String lastExportImportFileBlackboardKey) {
        this.lastExportImportFileBlackboardKey = lastExportImportFileBlackboardKey;
        if (VisibilityProfile.workbenchVisibilityProfilesNeedConversion()) {
            Object oVersion = PersistentBlackboardPlugIn.get().get(VERSION_VALUE);
            int version = oVersion == null ? 1 : (Integer)oVersion;
            AbstractVisibilityVersionConverter.convertToLatestVersion(this.mapProfiles, version);
            this.saveProfiles();
        }
    }

    protected void createProfile(LayerManager lymngr, String strProfileName) {
        Map<String, Object> mapVisi = VisibilityProfile.createProfile(lymngr);
        this.mapProfiles.put(strProfileName, mapVisi);
        this.saveProfiles();
    }

    protected void renameProfile(String strProfileNameOld, String strProfileNameNew) {
        if (this.mapProfiles.containsKey(strProfileNameOld)) {
            Map<String, Object> mapVisi = this.mapProfiles.remove(strProfileNameOld);
            this.mapProfiles.put(strProfileNameNew, mapVisi);
            this.saveProfiles();
        }
    }

    protected void editProfile(LayerManager lymngr, String strProfileNameOld, String strProfileNameNew) {
        Map<String, Object> mapVisi = VisibilityProfile.createProfile(lymngr);
        this.mapProfiles.remove(strProfileNameOld);
        this.mapProfiles.put(strProfileNameNew, mapVisi);
        this.saveProfiles();
    }

    protected void deleteProfile(List<String> profileNames) {
        for (String profileName : profileNames) {
            if (!this.mapProfiles.containsKey(profileName)) continue;
            this.mapProfiles.remove(profileName);
            if (this.strDefaultProfile == null || !this.strDefaultProfile.equals(profileName)) continue;
            this.strDefaultProfile = null;
        }
        this.saveProfiles();
    }

    protected void activateProfile(String strProfileName, LayerManager lymngr) {
        if (this.mapProfiles.containsKey(strProfileName)) {
            Map<String, Object> mapVisi = this.mapProfiles.get(strProfileName);
            VisibilityProfile.activateProfile(lymngr, mapVisi);
        }
    }

    protected List<String> getProfileNames() {
        ArrayList<String> lstProfileNames = new ArrayList<String>();
        for (String currProfileName : this.getMapProfiles().keySet()) {
            lstProfileNames.add(currProfileName);
        }
        Collections.sort(lstProfileNames, String.CASE_INSENSITIVE_ORDER);
        return lstProfileNames;
    }

    protected void setDefaultProfile(String defaultProfile) {
        this.strDefaultProfile = defaultProfile;
        this.saveProfiles();
    }

    protected String getDefaultProfile() {
        return this.strDefaultProfile;
    }

    protected Map<String, Map<String, Object>> getMapProfiles() {
        return this.mapProfiles;
    }

    protected void exportProfilesToFile(File file, List<String> valuesToExport) {
        Whiteboard wb = WhiteboardImpl.createWhiteboard(new HashMap());
        wb.setAttribute("VERSION", 2);
        HashMap<String, Map<String, Object>> mapProfiles2Export = new HashMap<String, Map<String, Object>>();
        for (String listValue : valuesToExport) {
            if (!this.mapProfiles.containsKey(listValue)) continue;
            mapProfiles2Export.put(listValue, this.mapProfiles.get(listValue));
        }
        wb.setAttribute(PROFILE_VALUE, mapProfiles2Export);
        WhiteboardImpl.writeToFile((Whiteboard)wb, (File)file, (XStream)XSTREAM);
        this.putFileIntoBlackboard(file);
    }

    protected void importProfilesFromFile(File file) {
        Whiteboard wb = WhiteboardImpl.createWhiteboard((File)file, (XStream)XSTREAM);
        Map mapProfiles2Import = (Map)wb.getAttribute(PROFILE_VALUE);
        if (VisibilityProfile.importFileVisibilityProfilesNeedConversion(wb)) {
            Object oVersion = wb.getAttribute(VERSION_VALUE);
            int version = oVersion == null ? 1 : (Integer)oVersion;
            AbstractVisibilityVersionConverter.convertToLatestVersion(mapProfiles2Import, version);
        }
        if (mapProfiles2Import != null) {
            for (Map.Entry profileEntry : mapProfiles2Import.entrySet()) {
                this.mapProfiles.put(MapSupport.getUniqueKey(this.mapProfiles, (String)((String)profileEntry.getKey())), (Map)profileEntry.getValue());
            }
        }
        this.saveProfiles();
        this.putFileIntoBlackboard(file);
    }

    protected void putFileIntoBlackboard(File file) {
        PersistentBlackboardPlugIn.get().put(this.lastExportImportFileBlackboardKey, file);
    }

    protected File getFileFromBlackboard() {
        return (File)PersistentBlackboardPlugIn.get().get(this.lastExportImportFileBlackboardKey, (Object)null);
    }

    public static Map<String, Object> createProfile(LayerManager lymngr) {
        HashMap<String, Object> mapProf = new HashMap<String, Object>();
        Category catBuildIn = lymngr.getRootCatBuildIn();
        CategoryStoredVisibility rcbVisi = new CategoryStoredVisibility(catBuildIn, null);
        rcbVisi.saveVisi(mapProf);
        Category catLocal = lymngr.getRootCatLocal();
        CategoryStoredVisibility rclVisi = new CategoryStoredVisibility(catLocal, null);
        rclVisi.saveVisi(mapProf);
        return mapProf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activateProfile(LayerManager lymngr, Map<String, Object> mapVisi) {
        boolean isFiringEvents = lymngr.isFiringEvents();
        try {
            lymngr.setFiringEvents(false);
            Category catBuildIn = lymngr.getRootCatBuildIn();
            CategoryStoredVisibility rcbVisi = new CategoryStoredVisibility(catBuildIn, null);
            rcbVisi.activateVisi(mapVisi);
            Category catLocal = lymngr.getRootCatLocal();
            CategoryStoredVisibility rclVisi = new CategoryStoredVisibility(catLocal, null);
            rclVisi.activateVisi(mapVisi);
        }
        finally {
            lymngr.setFiringEvents(isFiringEvents);
            lymngr.getRootCatBuildIn().fireCategoryChanged(CategoryEventType.METADATA_CHANGED);
            lymngr.getRootCatLocal().fireCategoryChanged(CategoryEventType.METADATA_CHANGED);
        }
    }

    protected void addListener(UpdateVisibilityDisplayListener listener) {
        this.listeners.add(listener);
    }

    public static boolean workbenchVisibilityProfilesNeedConversion() {
        Object oVersion = PersistentBlackboardPlugIn.get().get(VERSION_VALUE);
        return !VisibilityProfile.compareVersionWithCurrentVersion(oVersion);
    }

    private static boolean importFileVisibilityProfilesNeedConversion(Whiteboard wb) {
        Object oVersion = wb.getAttributes().get("VERSION");
        return !VisibilityProfile.compareVersionWithCurrentVersion(oVersion);
    }

    private static boolean compareVersionWithCurrentVersion(Object oVersion) {
        int version = oVersion == null ? 1 : (Integer)oVersion;
        return Objects.equals(version, 2);
    }

    private void saveProfiles() {
        PersistentBlackboardPlugIn.get().put(PROFILE_VALUE, this.mapProfiles);
        PersistentBlackboardPlugIn.get().put(DEFAULT_PROFILE_VALUE, this.strDefaultProfile);
        PersistentBlackboardPlugIn.get().put(VERSION_VALUE, 2);
        PersistentBlackboardPlugIn.saveState();
        this.notifyListeners();
    }

    private void notifyListeners() {
        this.listeners.forEach(UpdateVisibilityDisplayListener::updateDisplay);
    }

    private static XStream createSecuredXStream() {
        XStream xstream = new XStream();
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.allowTypeHierarchy(Map.class);
        xstream.allowTypes(new Class[]{String.class, ModelVisibilityEntity.class, ModelVisibilityThemingEntity.class});
        xstream.processAnnotations(ModelVisibilityEntity.class);
        xstream.processAnnotations(ModelVisibilityThemingEntity.class);
        xstream.autodetectAnnotations(true);
        return xstream;
    }
}

