/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.visibility;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.visibility.VisibilityProfile;
import com.vividsolutions.jump.workbench.ui.visibility.interfaces.UpdateVisibilityDisplayListener;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibilityPanel
extends JPanel
implements UpdateVisibilityDisplayListener {
    private static VisibilityPanel visiPanel = null;
    private static final Logger LOG = LoggerFactory.getLogger(VisibilityPanel.class);
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem menuItemRename = null;
    private JMenuItem menuItemImport = null;
    private JMenuItem menuItemExport = null;
    private VisibilityProfile visibilityProfile;
    private JButton butDelete;
    private JButton butEdit;
    private JButton butMakeDefault;
    private JButton butNew;
    private JButton butRemoveDefault;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblProfiles;
    private JList<String> lstProfiles;
    private JToolBar tbaHeader;

    private VisibilityPanel() {
        this.initComponents();
        this.i18n();
        try {
            this.init();
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    public static VisibilityPanel instanceOf() {
        if (visiPanel == null) {
            visiPanel = new VisibilityPanel();
        }
        return visiPanel;
    }

    private void i18n() {
        this.lblProfiles.setText(I18N.get("ui.zoom.VisibilityPanel.profiles"));
        this.butDelete.setToolTipText(I18N.get("ui.zoom.VisibilityPanel.delete-profile"));
        this.butEdit.setToolTipText(I18N.get("ui.zoom.VisibilityPanel.edit-profile"));
        this.butNew.setToolTipText(I18N.get("ui.zoom.VisibilityPanel.new-profile"));
        this.butMakeDefault.setToolTipText(I18N.get("ui.zoom.VisibilityPanel.make-default"));
        this.butRemoveDefault.setToolTipText(I18N.get("ui.zoom.VisibilityPanel.remove-default"));
        this.lstProfiles.setToolTipText(I18N.get("ui.zoom.VisibilityPanel.list-tooltip-doubleclick"));
    }

    private void init() {
        this.visibilityProfile = new VisibilityProfile(VisibilityPanel.class.getName() + "_LAST_EXPORT_IMPORT_DIR");
        this.visibilityProfile.addListener(this);
        this.butDelete.setMargin(new Insets(0, 0, 0, 0));
        this.butEdit.setMargin(new Insets(0, 0, 0, 0));
        this.butNew.setMargin(new Insets(0, 0, 0, 0));
        this.butMakeDefault.setMargin(new Insets(0, 0, 0, 0));
        this.butRemoveDefault.setMargin(new Insets(0, 0, 0, 0));
        this.butDelete.setIcon(IconLoader.svgIcon((String)"common_delete.svg"));
        this.butEdit.setIcon(IconLoader.svgIcon((String)"common_save.svg"));
        this.butNew.setIcon(IconLoader.svgIcon((String)"common_add.svg"));
        this.butMakeDefault.setIcon(IconLoader.svgIcon((String)"common_set_default.svg"));
        this.butRemoveDefault.setIcon(IconLoader.svgIcon((String)"common_reset_default.svg"));
        this.lstProfiles.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean hasFocus) {
                if (VisibilityPanel.this.visibilityProfile.getDefaultProfile() != null && value.toString().equals(VisibilityPanel.this.visibilityProfile.getDefaultProfile()) && !isSelected) {
                    JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
                    label.setBackground(Color.YELLOW);
                    label.setForeground(Color.BLUE);
                    label.setOpaque(true);
                    return label;
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
            }
        });
        this.menuItemRename = new JMenuItem(I18N.get("common.rename"));
        this.menuItemRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisibilityPanel.this.renameProfile();
            }
        });
        this.popup.add(this.menuItemRename);
        this.popup.addSeparator();
        this.menuItemImport = new JMenuItem(I18N.get("common.import"));
        this.menuItemImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFilter navFileFilter = GUISupport.createFileFilter((String)I18N.get("ui.zoom.VisibilityPanel.file-filter"), (String[])new String[]{"visi"});
                JFileChooser fChoose = GUISupport.createJFileChooser((boolean)true);
                fChoose.setFileFilter(navFileFilter);
                fChoose.setDialogTitle(I18N.get("ui.zoom.VisibilityPanel.choose-import-file"));
                fChoose.setFileSelectionMode(0);
                fChoose.setMultiSelectionEnabled(false);
                fChoose.setAcceptAllFileFilterUsed(false);
                File lastFile = VisibilityPanel.this.visibilityProfile.getFileFromBlackboard();
                if (lastFile != null && lastFile.getParentFile().exists() && lastFile.getParentFile().isDirectory()) {
                    fChoose.setSelectedFile(lastFile);
                }
                if (fChoose.showOpenDialog(VisibilityPanel.this) == 0) {
                    File selFile = fChoose.getSelectedFile();
                    VisibilityPanel.this.visibilityProfile.importProfilesFromFile(selFile);
                }
            }
        });
        this.popup.add(this.menuItemImport);
        this.menuItemExport = new JMenuItem(I18N.get("common.export"));
        this.menuItemExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFilter navFileFilter = GUISupport.createFileFilter((String)I18N.get("ui.zoom.VisibilityPanel.file-filter"), (String[])new String[]{"visi"});
                JFileChooser fChoose = GUISupport.createJFileChooserOverwritePrompting();
                fChoose.setFileFilter(navFileFilter);
                fChoose.setDialogTitle(I18N.get("ui.zoom.VisibilityPanel.choose-export-file"));
                fChoose.setFileSelectionMode(0);
                fChoose.setMultiSelectionEnabled(false);
                fChoose.setAcceptAllFileFilterUsed(false);
                File lastFile = VisibilityPanel.this.visibilityProfile.getFileFromBlackboard();
                if (lastFile != null && lastFile.getParentFile().exists() && lastFile.getParentFile().isDirectory()) {
                    fChoose.setSelectedFile(lastFile);
                }
                if (fChoose.showSaveDialog(VisibilityPanel.this) == 0) {
                    File selFile = fChoose.getSelectedFile();
                    selFile = FileSupport.addExtension((File)selFile, (String)"visi");
                    VisibilityPanel.this.visibilityProfile.exportProfilesToFile(selFile, VisibilityPanel.this.lstProfiles.getSelectedValuesList());
                }
            }
        });
        this.popup.add(this.menuItemExport);
        this.lstProfiles.add(this.popup);
        this.updateDisplay();
    }

    @Override
    public void updateDisplay() {
        ArrayList<String> lstProfileNames = new ArrayList<String>(this.visibilityProfile.getMapProfiles().keySet());
        this.lstProfiles.setModel((ListModel<String>)new ListListModel(lstProfileNames, true, null));
        this.updateButtons();
    }

    private void updateButtons() {
        switch (this.lstProfiles.getSelectedIndices().length) {
            case 0: {
                this.butEdit.setEnabled(false);
                this.butDelete.setEnabled(false);
                this.butMakeDefault.setEnabled(false);
                this.menuItemRename.setEnabled(false);
                this.menuItemExport.setEnabled(false);
                break;
            }
            case 1: {
                this.butEdit.setEnabled(true);
                this.butDelete.setEnabled(true);
                this.butMakeDefault.setEnabled(true);
                this.menuItemRename.setEnabled(true);
                this.menuItemExport.setEnabled(true);
                break;
            }
            default: {
                this.butEdit.setEnabled(false);
                this.butDelete.setEnabled(true);
                this.butMakeDefault.setEnabled(false);
                this.menuItemRename.setEnabled(false);
                this.menuItemExport.setEnabled(true);
            }
        }
        this.butRemoveDefault.setEnabled(this.visibilityProfile.getDefaultProfile() != null);
    }

    public List<String> getProfileNames() {
        return this.visibilityProfile.getProfileNames();
    }

    private void addProfile(String strProfileName) {
        try {
            if (this.visibilityProfile.getMapProfiles().containsKey(strProfileName)) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.VisibilityPanel.profile-already-exists"), (String)I18N.get("common.error"));
                return;
            }
            JInternalFrame iFrame = WorkbenchContext.getFrame().getActiveInternalFrame();
            if (!(iFrame instanceof TaskFrame)) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.VisibilityPanel.select-task-frame"), (String)I18N.get("common.error"));
                return;
            }
            TaskFrame tFr = (TaskFrame)iFrame;
            Task task = tFr.getTask();
            LayerManager lymngr = task.getLayerManager();
            this.visibilityProfile.createProfile(lymngr, strProfileName);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    private void renameProfile() {
        try {
            if (this.lstProfiles.getSelectedValue() != null) {
                String strProfileNameOld = this.lstProfiles.getSelectedValue();
                String strProfileNameNew = GUISupport.inputbox((Component)this, (String)I18N.get("ui.zoom.VisibilityPanel.enter-profile-name"), (String)strProfileNameOld);
                if (StringUtils.isEmpty((CharSequence)strProfileNameNew)) {
                    return;
                }
                if (!strProfileNameNew.equals(strProfileNameOld) && this.visibilityProfile.getMapProfiles().containsKey(strProfileNameNew)) {
                    GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.VisibilityPanel.profile-already-exists"), (String)I18N.get("common.error"));
                    return;
                }
                this.visibilityProfile.renameProfile(strProfileNameOld, strProfileNameNew);
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    private void editProfile() {
        try {
            if (this.lstProfiles.getSelectedValue() == null) {
                GUISupport.msgbox((Component)this, (String)I18N.get("ui.zoom.VisibilityPanel.select-profile"), (String)I18N.get("common.message"));
                return;
            }
            JInternalFrame iFrame = WorkbenchContext.getFrame().getActiveInternalFrame();
            if (!(iFrame instanceof TaskFrame)) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.VisibilityPanel.select-task-frame"), (String)I18N.get("common.error"));
                return;
            }
            String strProfileNameOld = this.lstProfiles.getSelectedValue();
            String strProfileNameNew = GUISupport.inputbox((Component)this, (String)I18N.get("ui.zoom.VisibilityPanel.enter-profile-name"), (String)strProfileNameOld);
            if (StringUtils.isEmpty((CharSequence)strProfileNameNew)) {
                return;
            }
            if (!strProfileNameNew.equals(strProfileNameOld) && this.visibilityProfile.getMapProfiles().containsKey(strProfileNameNew)) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.VisibilityPanel.profile-already-exists"), (String)I18N.get("common.error"));
                return;
            }
            if (this.visibilityProfile.getMapProfiles().containsKey(strProfileNameOld)) {
                TaskFrame tFr = (TaskFrame)iFrame;
                Task task = tFr.getTask();
                LayerManager lymngr = task.getLayerManager();
                this.visibilityProfile.editProfile(lymngr, strProfileNameOld, strProfileNameNew);
                GUISupport.msgbox((Component)this, (String)I18N.get("ui.zoom.VisibilityPanel.edit-profile-ready"), (String)I18N.get("common.message"));
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateProfile(String strProfileName) {
        block6: {
            try {
                JInternalFrame iFrame = WorkbenchContext.getFrame().getActiveInternalFrame();
                if (iFrame instanceof TaskFrame) {
                    TaskFrame tFr = (TaskFrame)iFrame;
                    LayerManager lymngr = tFr.getTask().getLayerManager();
                    try {
                        this.visibilityProfile.activateProfile(strProfileName, lymngr);
                        break block6;
                    }
                    finally {
                        ((JPanel)((Object)tFr.getLayerNamePanel())).validate();
                        ((JPanel)((Object)tFr.getLayerNamePanel())).repaint();
                        tFr.getLayerViewPanel().repaint();
                    }
                }
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.zoom.VisibilityPanel.select-task-frame"), (String)I18N.get("common.error"));
            }
            catch (Exception e) {
                ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
                Assert.shouldNeverReachHere((String)e.getMessage());
            }
        }
    }

    public void activateProfile(String strProfileName, LayerManager lymngr) {
        if (this.visibilityProfile.getMapProfiles().containsKey(strProfileName)) {
            Map<String, Object> mapVisi = this.visibilityProfile.getMapProfiles().get(strProfileName);
            VisibilityProfile.activateProfile(lymngr, mapVisi);
        }
    }

    private void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void initComponents() {
        this.tbaHeader = new JToolBar();
        this.butNew = new JButton();
        this.butEdit = new JButton();
        this.butDelete = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.butMakeDefault = new JButton();
        this.butRemoveDefault = new JButton();
        this.jSeparator2 = new JSeparator();
        this.lblProfiles = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstProfiles = new JList();
        this.setLayout(new GridBagLayout());
        this.tbaHeader.setRollover(true);
        this.butNew.setFocusable(false);
        this.butNew.setHorizontalTextPosition(0);
        this.butNew.setMaximumSize(new Dimension(30, 27));
        this.butNew.setMinimumSize(new Dimension(30, 27));
        this.butNew.setPreferredSize(new Dimension(30, 27));
        this.butNew.setVerticalTextPosition(3);
        this.butNew.addActionListener(this::butNew_onActionPerformed);
        this.tbaHeader.add(this.butNew);
        this.butEdit.setFocusable(false);
        this.butEdit.setHorizontalTextPosition(0);
        this.butEdit.setMaximumSize(new Dimension(30, 27));
        this.butEdit.setMinimumSize(new Dimension(30, 27));
        this.butEdit.setPreferredSize(new Dimension(30, 27));
        this.butEdit.setVerticalTextPosition(3);
        this.butEdit.addActionListener(this::butEdit_onActionPerformed);
        this.tbaHeader.add(this.butEdit);
        this.butDelete.setFocusable(false);
        this.butDelete.setHorizontalTextPosition(0);
        this.butDelete.setMaximumSize(new Dimension(30, 27));
        this.butDelete.setMinimumSize(new Dimension(30, 27));
        this.butDelete.setPreferredSize(new Dimension(30, 27));
        this.butDelete.setVerticalTextPosition(3);
        this.butDelete.addActionListener(this::butDelete_onActionPerformed);
        this.tbaHeader.add(this.butDelete);
        this.tbaHeader.add(this.jSeparator1);
        this.butMakeDefault.setFocusable(false);
        this.butMakeDefault.setHorizontalTextPosition(0);
        this.butMakeDefault.setMaximumSize(new Dimension(30, 27));
        this.butMakeDefault.setMinimumSize(new Dimension(30, 27));
        this.butMakeDefault.setPreferredSize(new Dimension(30, 27));
        this.butMakeDefault.setVerticalTextPosition(3);
        this.butMakeDefault.addActionListener(this::butMakeDefault_onActionPerformed);
        this.tbaHeader.add(this.butMakeDefault);
        this.butRemoveDefault.setFocusable(false);
        this.butRemoveDefault.setHorizontalTextPosition(0);
        this.butRemoveDefault.setMaximumSize(new Dimension(30, 27));
        this.butRemoveDefault.setMinimumSize(new Dimension(30, 27));
        this.butRemoveDefault.setPreferredSize(new Dimension(30, 27));
        this.butRemoveDefault.setVerticalTextPosition(3);
        this.butRemoveDefault.addActionListener(this::butRemoveDefault_onActionPerformed);
        this.tbaHeader.add(this.butRemoveDefault);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tbaHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        this.lblProfiles.setText("Gespeicherte Profile:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblProfiles, gridBagConstraints);
        this.lstProfiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VisibilityPanel.this.lstProfiles_onMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                VisibilityPanel.this.lstProfilesMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                VisibilityPanel.this.lstProfilesMouseReleased(evt);
            }
        });
        this.lstProfiles.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VisibilityPanel.this.lstProfilesKeyReleased(evt);
            }
        });
        this.lstProfiles.addListSelectionListener(this::lstProfiles_onValueChanged);
        this.jScrollPane1.setViewportView(this.lstProfiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void lstProfiles_onMouseClicked(MouseEvent evt) {
        try {
            String selectedValue = this.lstProfiles.getSelectedValue();
            if (evt.getClickCount() > 1 && selectedValue != null) {
                this.activateProfile(selectedValue);
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        try {
            if (this.lstProfiles.getSelectedValue() == null) {
                GUISupport.msgbox((Component)this, (String)I18N.get("ui.zoom.VisibilityPanel.select-profile"), (String)I18N.get("common.message"));
                return;
            }
            boolean bolDelete = GUISupport.yesnobox((Component)this, (String)I18N.get("ui.zoom.VisibilityPanel.delete-profile-question"), (String)I18N.get("common.message"));
            if (!bolDelete) {
                return;
            }
            this.visibilityProfile.deleteProfile(this.lstProfiles.getSelectedValuesList());
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void butEdit_onActionPerformed(ActionEvent evt) {
        try {
            this.editProfile();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void butNew_onActionPerformed(ActionEvent evt) {
        try {
            String strName = GUISupport.inputbox((Component)this, (String)I18N.get("ui.zoom.VisibilityPanel.enter-profile-name"));
            if (StringUtils.isEmpty((CharSequence)strName)) {
                return;
            }
            this.addProfile(strName);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void butMakeDefault_onActionPerformed(ActionEvent evt) {
        if (this.lstProfiles.getSelectedValue() == null) {
            GUISupport.msgbox((Component)this, (String)I18N.get("ui.zoom.VisibilityPanel.select-profile"), (String)I18N.get("common.message"));
            return;
        }
        this.visibilityProfile.setDefaultProfile(this.lstProfiles.getSelectedValue());
    }

    private void butRemoveDefault_onActionPerformed(ActionEvent evt) {
        this.visibilityProfile.setDefaultProfile(null);
    }

    private void lstProfiles_onValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void lstProfilesKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 113) {
            this.renameProfile();
        }
    }

    private void lstProfilesMousePressed(MouseEvent evt) {
        this.showPopup(evt);
    }

    private void lstProfilesMouseReleased(MouseEvent evt) {
        this.showPopup(evt);
    }

    public static void activateDefaultProfile(LayerManager lymngr, boolean showUserInfo) {
        try {
            String strDefaultProfile = PersistentBlackboardPlugIn.get().get("com.vividsolutions.jump.workbench.ui.zoom.VisibilityPanel_DEFAULT_PROFILE", null);
            if (strDefaultProfile == null) {
                return;
            }
            VisibilityPanel vPanel = VisibilityPanel.instanceOf();
            vPanel.activateProfile(strDefaultProfile, lymngr);
            if (showUserInfo) {
                WorkbenchContext.getFrame().infoUser(I18N.get("ui.zoom.VisibilityPanel.default-used"));
            }
        }
        catch (Exception e) {
            LOG.error("Error activating default profile", (Throwable)e);
        }
    }

    public static void activateDefaultProfile(LayerManager lymngr) {
        VisibilityPanel.activateDefaultProfile(lymngr, true);
    }
}

