/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.tools;

import com.vividsolutions.jump.workbench.ui.Viewport;
import de.riwagis.unit.DrawingUnit;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenScale {
    private static final Logger LOG = LoggerFactory.getLogger(ScreenScale.class);

    public static double getHorizontalMapScale(Viewport port, DrawingUnit unit) {
        double SCREENRES = 96.0;
        double INCHTOUNIT = ScreenScale.getUnitLengthInInch(unit);
        double panelWidth = port.getPanel().getWidth();
        double modelWidth = port.getEnvelopeInModelCoordinates().getWidth();
        return modelWidth / (INCHTOUNIT / SCREENRES * panelWidth);
    }

    private static double getUnitLengthInInch(DrawingUnit unit) {
        if (unit == null) {
            return 2.54;
        }
        return unit.getInchInUnit();
    }

    public static double getViewportScale4MapScale(double dblMapScale, DrawingUnit unit) {
        double SCREENRES = 96.0;
        double INCHTOUNIT = ScreenScale.getUnitLengthInInch(unit);
        return SCREENRES / (INCHTOUNIT * dblMapScale);
    }

    public static double getViewportScale4ModelEnv(Viewport port, Envelope modEnv) {
        double dblPanelWidth = port.getPanel().getWidth();
        double dblEnvWidth = modEnv.getWidth();
        return dblPanelWidth / dblEnvWidth;
    }

    public static Envelope getEnvelope4MapScale(Viewport port, double dblMapScale, DrawingUnit unit) {
        double dblVpScale = port.getScale();
        double dblNewVpScale = ScreenScale.getViewportScale4MapScale(dblMapScale, unit);
        Envelope env = port.getEnvelopeInModelCoordinates();
        double dblNewWidth = env.getWidth() * dblVpScale / dblNewVpScale;
        double dblNewHeight = env.getHeight() * dblVpScale / dblNewVpScale;
        double dblCenterX = env.centre().x;
        double dblCenterY = env.centre().y;
        return new Envelope(dblCenterX - dblNewWidth / 2.0, dblCenterX + dblNewWidth / 2.0, dblCenterY - dblNewHeight / 2.0, dblCenterY + dblNewHeight / 2.0);
    }

    private ScreenScale() {
    }
}

