/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.tools;

import com.vividsolutions.jump.I18N;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class OkCancelButtonPanel
extends JPanel {
    private static final long serialVersionUID = -4703181650847522122L;
    public static final String OK_BUTTON_ACTION_COMMAND = new String("OK_BUTTON_ACTION_COMMAND");
    public static final String CANCEL_BUTTON_ACTION_COMMAND = new String("CANCEL_BUTTON_ACTION_COMMAND");
    private JButton cancelButton;
    private JButton okButton;

    public OkCancelButtonPanel() {
        this.initialize();
    }

    public void addActionListener(ActionListener listener) {
        this.getOkButton().addActionListener(listener);
        this.getCancelButton().addActionListener(listener);
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(I18N.get(OkCancelButtonPanel.class.getName() + ".cancel"));
            this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
            this.cancelButton.setFocusPainted(false);
        }
        return this.cancelButton;
    }

    public JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText(I18N.get(OkCancelButtonPanel.class.getName() + ".ok"));
            this.okButton.setActionCommand(OK_BUTTON_ACTION_COMMAND);
            this.okButton.setFocusPainted(false);
        }
        return this.okButton;
    }

    public void setOkButtonEnabled(boolean enable) {
        this.getOkButton().setEnabled(enable);
    }

    private void initialize() {
        this.setSize(300, 40);
        FlowLayout fLayout = new FlowLayout();
        fLayout.setHgap(5);
        fLayout.setVgap(5);
        fLayout.setAlignment(1);
        this.setLayout(fLayout);
        JButton butOK = this.getOkButton();
        butOK.setPreferredSize(new Dimension(100, 20));
        this.add(butOK);
        JButton butCancel = this.getCancelButton();
        butCancel.setPreferredSize(new Dimension(100, 20));
        this.add(butCancel);
        this.requestFocus();
    }

    @Override
    public void requestFocus() {
        this.okButton.setFocusable(true);
        this.okButton.requestFocus();
    }
}

