/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.tools;

import com.vividsolutions.jump.workbench.ui.tools.OkCancelButtonPanel;
import com.vividsolutions.jump.workbench.ui.tools.ValueChecker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKCancelListener
implements ActionListener {
    protected boolean okWasClicked = false;
    protected JDialog dialog = null;
    private static final Logger LOG = LoggerFactory.getLogger(OKCancelListener.class);
    protected ArrayList valueCheckers = new ArrayList();

    public OKCancelListener(JDialog dialog) {
        this.dialog = dialog;
    }

    public void addValueChecker(ValueChecker valChecker) {
        this.valueCheckers.add(valChecker);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            JButton button = (JButton)arg0.getSource();
            if (button.getActionCommand().equals(OkCancelButtonPanel.OK_BUTTON_ACTION_COMMAND)) {
                if (!this.valuesOk()) {
                    return;
                }
                this.okWasClicked = true;
            }
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }
        catch (ClassCastException e) {
            LOG.error(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    protected boolean valuesOk() {
        ValueChecker[] valueCheckerArray;
        if (this.valueCheckers.isEmpty()) {
            return true;
        }
        boolean valsOk = true;
        for (ValueChecker valueCheckerArray1 : valueCheckerArray = this.valueCheckers.toArray(new ValueChecker[0])) {
            valsOk = valsOk && valueCheckerArray1.areValuesOk();
        }
        return valsOk;
    }

    public boolean wasOkClicked() {
        return this.okWasClicked;
    }
}

