/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.toolbox;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ToolboxPanel
extends JPanel {
    private final ArrayList<AbstractButton> buttons = new ArrayList();
    private final ArrayList<WorkbenchToolBar> toolBars = new ArrayList();
    private final WorkbenchContext context = WorkbenchContext.getInstance();
    private final JPanel toolbarsPanel = new JPanel();
    private final GridLayout gridLayout1 = new GridLayout();

    public ToolboxPanel() {
        this.initComponents();
        this.toolbarsPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.add((Component)this.toolbarsPanel, "North");
    }

    public void deactivateCursorTool() {
        if (this.buttons.contains(JUMPWorkbench.getFrame().getToolBar().getSelectedCursorToolButton())) {
            JUMPWorkbench.getFrame().getToolBar().getButtonGroup().getElements().nextElement().doClick();
        }
    }

    public void updateEnabledState() {
        for (WorkbenchToolBar toolBar : this.toolBars) {
            toolBar.updateEnabledState();
        }
    }

    public AbstractButton getButton(int indexToolbar, int indexTool) {
        if (indexToolbar + 1 > this.toolBars.size() || indexToolbar < 0) {
            return null;
        }
        WorkbenchToolBar toolBar = this.toolBars.get(indexToolbar);
        return toolBar.getButton(indexTool);
    }

    public WorkbenchToolBar getToolBar() {
        if (this.toolBars.isEmpty()) {
            this.addToolBar();
        }
        return this.toolBars.get(this.toolBars.size() - 1);
    }

    public WorkbenchContext getContext() {
        return this.context;
    }

    public WorkbenchToolBar.ToolConfig add(CursorTool tool) {
        return this.add(tool, null);
    }

    public WorkbenchToolBar.ToolConfig add(CursorTool tool, EnableCheck enableCheck) {
        WorkbenchToolBar.ToolConfig config = this.getToolBar().addCursorTool(tool, enableCheck);
        JToggleButton button = config.getButton();
        this.registerButton(button);
        return config;
    }

    public void addPlugIn(PlugIn plugIn, EnableCheck enableCheck, Icon icon) {
        this.registerButton(this.getToolBar().addPlugIn(icon, plugIn, enableCheck, this.context));
    }

    private void registerButton(AbstractButton button) {
        if (button == null) {
            return;
        }
        this.buttons.add(button);
    }

    public void addToolBar() {
        this.toolBars.add(new WorkbenchToolBar(this.context, JUMPWorkbench.getFrame().getToolBar().getButtonGroup()));
        this.getToolBar().setBorder(null);
        this.getToolBar().setFloatable(false);
        this.gridLayout1.setRows(this.toolBars.size());
        this.toolbarsPanel.add(this.getToolBar());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

