/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.toolbox;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ToolboxDialog
extends JDialog {
    private GUIUtil.Location initialLocation = new GUIUtil.Location(0, false, 0, false);
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel centerPanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private final ToolboxPanel toolboxPanel = new ToolboxPanel();
    private boolean locationInitializedBeforeMakingDialogVisible = false;

    public ToolboxDialog() {
        super(JUMPWorkbench.getFrame(), "", false);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ToolboxDialog.this.toolboxPanel.deactivateCursorTool();
            }
        });
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.centerPanel.setLayout(this.borderLayout2);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.toolboxPanel, "North");
    }

    public AbstractButton getButton(int indexToolbar, int indexTool) {
        return this.toolboxPanel.getButton(indexToolbar, indexTool);
    }

    public WorkbenchToolBar getToolBar() {
        return this.toolboxPanel.getToolBar();
    }

    public WorkbenchContext getContext() {
        return this.toolboxPanel.getContext();
    }

    public WorkbenchToolBar.ToolConfig add(CursorTool tool) {
        return this.toolboxPanel.add(tool);
    }

    public WorkbenchToolBar.ToolConfig add(CursorTool tool, EnableCheck enableCheck) {
        return this.toolboxPanel.add(tool, enableCheck);
    }

    public void addPlugIn(PlugIn plugIn, EnableCheck enableCheck, Icon icon) {
        this.toolboxPanel.addPlugIn(plugIn, enableCheck, icon);
    }

    public void addToolBar() {
        this.toolboxPanel.addToolBar();
    }

    public void finishAddingComponents() {
        this.pack();
        this.initializeLocation();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.locationInitializedBeforeMakingDialogVisible) {
            this.initializeLocation();
            this.locationInitializedBeforeMakingDialogVisible = true;
        }
        super.setVisible(visible);
    }

    private void initializeLocation() {
        GUIUtil.setLocation(this, this.initialLocation, JUMPWorkbench.getFrame().getDesktopPane());
    }

    public JPanel getCenterPanel() {
        return this.centerPanel;
    }

    public void updateEnabledState() {
        this.toolboxPanel.updateEnabledState();
    }

    public void setInitialLocation(GUIUtil.Location location) {
        this.initialLocation = location;
    }
}

