/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.task;

import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorDialog;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JOptionPane;

public class TaskMonitorManager {
    public void execute(ThreadedPlugIn plugIn, PlugInContext context) {
        final TaskMonitorDialog progressDialog = new TaskMonitorDialog((Frame)context.getWorkbenchFrame(), context.getErrorHandler());
        progressDialog.setTitle(plugIn.getName());
        TaskWrapper taskWrapper = new TaskWrapper(this, plugIn, context, progressDialog);
        final Thread thread = new Thread(taskWrapper);
        progressDialog.addWindowListener(new WindowAdapter(this){
            private int attempts = 0;

            @Override
            public void windowClosing(WindowEvent e) {
                if (1 == JOptionPane.showConfirmDialog(progressDialog, StringUtil.split("Warning: Killing the process may result in data corruption or data loss. Are you sure you want to kill the process?", 80), "Kill Process", 0, 2)) {
                    return;
                }
                ++this.attempts;
                if (this.attempts > 1) {
                    progressDialog.setVisible(false);
                }
                thread.stop();
            }
        });
        progressDialog.addComponentListener(new ComponentAdapter(this){

            @Override
            public void componentShown(ComponentEvent e) {
                thread.start();
            }
        });
        GUIUtil.centreOnWindow(progressDialog);
        progressDialog.setVisible(true);
    }

    private class TaskWrapper
    implements Runnable {
        private final ThreadedPlugIn plugIn;
        private PlugInContext context;
        private final TaskMonitorDialog dialog;

        public TaskWrapper(TaskMonitorManager taskMonitorManager, ThreadedPlugIn plugIn, PlugInContext context, TaskMonitorDialog dialog) {
            this.plugIn = plugIn;
            this.context = context;
            this.dialog = dialog;
        }

        @Override
        public void run() {
            Throwable throwable = null;
            try {
                this.plugIn.run(this.dialog, this.context);
            }
            catch (Throwable t) {
                throwable = t;
            }
            finally {
                this.dialog.setVisible(false);
                if (throwable != null) {
                    this.context.getErrorHandler().handleThrowable(throwable);
                }
                this.context = null;
            }
        }
    }
}

