/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style.theming;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.ImmutableFirstElementList;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.ui.components.ColumnBasedTableModel;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import com.vividsolutions.jump.workbench.ui.style.theming.ThemeColor;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.util.lang.StringComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class ThemingTableModel
extends ColumnBasedTableModel {
    private final List<AttributeMapping> attributeMappings;
    private static final Map<ThemeColor, BiConsumer<BasicStyleModel, ColorModel>> COLOR_MAPPING_APPLIER = Map.of(ThemeColor.FILL, BasicStyleModel::setFillColor, ThemeColor.LINE, (model, color) -> {
        if (model.getLineBase() != null) {
            model.getLineBase().setLineColor(color);
        }
        if (model.getLineForeground() != null) {
            model.getLineForeground().setLineColor(color);
        }
        if (model.getLineBackground() != null) {
            model.getLineBackground().setLineColor(color);
        }
    }, ThemeColor.SYMBOL_FILL, (model, color) -> {
        if (model.getSymStyle() != null) {
            model.getSymStyle().setFillColor(color);
        }
    }, ThemeColor.SYMBOL_LINE, (model, color) -> {
        if (model.getSymStyle() != null) {
            model.getSymStyle().setLineColor(color);
        }
    }, ThemeColor.TEXT, (model, color) -> {
        if (model.getTextStyle() != null) {
            model.getTextStyle().setColorText(color);
        }
    }, ThemeColor.TEXT_BACKGROUND, (model, color) -> {
        if (model.getTextStyle() != null) {
            model.getTextStyle().setColorOpaque(color);
        }
    });
    private boolean lastSortValue = true;
    private boolean lastSortValueAscending = true;
    private boolean lastSortLabelAscending = true;
    public static final int COLOR_COLUMN = 0;
    public static final int ATTRIBUTE_COLUMN = 1;
    public static final int LABEL_COLUMN = 2;

    public ThemingTableModel(BasicStyleModel defaultStyle, Map<Object, BasicStyleModel> attributeValueToBasicStyleMap, Map<Object, String> attributeValueToLabelMap) {
        this.attributeMappings = new ImmutableFirstElementList<AttributeMapping>(new AttributeMapping(null, defaultStyle, null));
        this.setMaps(attributeValueToBasicStyleMap, attributeValueToLabelMap);
        this.setColumns(this.createColumns());
    }

    public final void setMaps(Map<Object, BasicStyleModel> attributeValueToBasicStyleMap, Map<Object, String> attributeValueToLabelMap) {
        this.attributeMappings.clear();
        for (Object attributeValue : attributeValueToBasicStyleMap.keySet()) {
            this.attributeMappings.add(new AttributeMapping(attributeValue.toString(), attributeValueToBasicStyleMap.get(attributeValue), attributeValueToLabelMap.get(attributeValue)));
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void clear() {
        this.attributeMappings.clear();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public boolean containsNullAttributeValues() {
        for (AttributeMapping attributeMapping : this.nonDefaultAttributeMappings()) {
            if (attributeMapping.getAttributeValue() != null) continue;
            return true;
        }
        return false;
    }

    protected AttributeMapping attributeMapping(int i) {
        return this.attributeMappings.get(i);
    }

    public BasicStyleModel getDefaultStyle() {
        return this.attributeMapping(0).getBasicStyle();
    }

    public void setDefaultStyle(BasicStyleModel style) {
        this.attributeMapping(0).setBasicStyle(style);
    }

    public String getDefaultLabel() {
        return this.attributeMapping(0).getLabel();
    }

    public void setDefaultLabel(String strDefaultLabel) {
        this.attributeMapping(0).setLabel(strDefaultLabel);
    }

    public void setTransparency(int _alpha, boolean bolArea, boolean bolLine, boolean bolText, boolean bolSymbol) {
        for (AttributeMapping aMap : this.attributeMappings) {
            aMap.getBasicStyle().setIntAlpha(_alpha, bolArea, bolLine, bolText, bolSymbol);
        }
    }

    public Object findDuplicateAttributeValue() {
        TreeSet<Object> set = new TreeSet<Object>();
        for (AttributeMapping attributeMapping : this.nonDefaultAttributeMappings()) {
            if (attributeMapping.getAttributeValue() == null) continue;
            if (set.contains(attributeMapping.getAttributeValue())) {
                return attributeMapping.getAttributeValue();
            }
            set.add(attributeMapping.getAttributeValue());
        }
        return null;
    }

    protected final List<ColumnBasedTableModel.Column> createColumns() {
        ArrayList<ColumnBasedTableModel.Column> columns = new ArrayList<ColumnBasedTableModel.Column>();
        columns.add(new ColumnBasedTableModel.Column(I18N.get("ui.style.ThemeStylePanel.style"), BasicStyleModel.class){

            @Override
            public Object getValueAt(int rowIndex) {
                return ThemingTableModel.this.attributeMapping(rowIndex).getBasicStyle();
            }

            @Override
            public void setValueAt(Object value, int rowIndex) {
                ThemingTableModel.this.attributeMapping(rowIndex).setBasicStyle((BasicStyleModel)value);
                ThemingTableModel.this.fireTableChanged(new TableModelEvent(ThemingTableModel.this, rowIndex));
            }
        });
        columns.add(new ColumnBasedTableModel.Column(I18N.get("ui.style.ThemeStylePanel.attribute-value"), null){

            @Override
            public Class<?> getDataClass() {
                return String.class;
            }

            @Override
            public Object getValueAt(int rowIndex) {
                return ThemingTableModel.this.attributeMapping(rowIndex).getAttributeValue();
            }

            @Override
            public void setValueAt(Object value, int rowIndex) {
                ThemingTableModel.this.attributeMapping(rowIndex).setAttributeValue(value.toString());
                ThemingTableModel.this.fireTableChanged(new AttributeValueTableModelEvent(ThemingTableModel.this, rowIndex));
            }
        });
        columns.add(new ColumnBasedTableModel.Column(I18N.get("ui.style.ThemeStylePanel.label"), String.class){

            @Override
            public Object getValueAt(int rowIndex) {
                return ThemingTableModel.this.attributeMapping(rowIndex).getLabel();
            }

            @Override
            public void setValueAt(Object value, int rowIndex) {
                ThemingTableModel.this.attributeMapping(rowIndex).setLabel((String)value);
                ThemingTableModel.this.fireTableChanged(new AttributeValueTableModelEvent(ThemingTableModel.this, rowIndex));
            }
        });
        return columns;
    }

    public void apply(ColorScheme colorScheme, boolean skipDefaultAttributeMapping, Set<ThemeColor> targets) {
        List<AttributeMapping> mapping = skipDefaultAttributeMapping ? this.nonDefaultAttributeMappings() : this.attributeMappings;
        mapping.stream().map(AttributeMapping::getBasicStyle).forEach(basicStyle -> {
            ColorModel themeColor = RiwaJumpModelUtilities.colorModelByColor(colorScheme.next());
            targets.stream().map(COLOR_MAPPING_APPLIER::get).forEach(action -> action.accept(basicStyle, themeColor));
        });
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public int getRowCount() {
        return this.attributeMappings.size();
    }

    public Map<Object, BasicStyleModel> getAttributeValueToBasicStyleMap() {
        return this.attributeValueToObjectMap(AttributeMapping::getBasicStyle);
    }

    public Map<Object, Object> getAttributeValueToLabelMap() {
        return this.attributeValueToObjectMap(AttributeMapping::getLabel);
    }

    private <R> Map<Object, R> attributeValueToObjectMap(Function<AttributeMapping, R> getter) {
        TreeMap<Object, R> attributeValueToObjectMap = new TreeMap<Object, R>();
        for (AttributeMapping attributeMapping : this.nonDefaultAttributeMappings()) {
            attributeValueToObjectMap.put(attributeMapping.getAttributeValue(), getter.apply(attributeMapping));
        }
        return attributeValueToObjectMap;
    }

    public void sortByLabelReverseOrder() {
        if (this.lastSortValue) {
            this.sortByLabel(this.lastSortLabelAscending);
        } else {
            this.sortByLabel(!this.lastSortLabelAscending);
        }
    }

    public void sortByLabelSameOrder() {
        this.sortByLabel(this.lastSortLabelAscending);
    }

    public void sortByValueReverseOrder() {
        if (this.lastSortValue) {
            this.sortByValue(!this.lastSortValueAscending);
        } else {
            this.sortByValue(this.lastSortValueAscending);
        }
    }

    public void sortByValueSameOrder() {
        this.sortByValue(this.lastSortValueAscending);
    }

    private void sortByValue(boolean ascending) {
        if (ascending) {
            Collections.sort(this.nonDefaultAttributeMappings());
        } else {
            this.nonDefaultAttributeMappings().sort(Collections.reverseOrder());
        }
        this.lastSortValueAscending = ascending;
        this.lastSortValue = true;
        this.fireTableChanged(new TableModelEvent(this));
    }

    private void sortByLabel(boolean ascending) {
        Comparator<AttributeMapping> attributeMappingLabelComparator = Comparator.comparing(AttributeMapping::getLabel, new StringComparator());
        if (ascending) {
            this.nonDefaultAttributeMappings().sort(attributeMappingLabelComparator);
        } else {
            this.nonDefaultAttributeMappings().sort(attributeMappingLabelComparator.reversed());
        }
        this.lastSortLabelAscending = ascending;
        this.lastSortValue = false;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void removeAttributeValues(int[] rows) {
        for (Integer row : CollectionUtil.reverseSortedSet(rows)) {
            int oldSize = this.attributeMappings.size();
            this.attributeMappings.remove(row);
            if (oldSize == this.attributeMappings.size()) continue;
            this.fireTableChanged(new TableModelEvent(this, row, row, -1, -1));
        }
    }

    public int insertAttributeValue(int row, ColorScheme colorScheme) {
        BasicStyleModel newStyle = (BasicStyleModel)this.attributeMappings.get(0).getBasicStyle().cloneModel();
        newStyle.setEnabled(true);
        this.attributeMappings.add(row, new AttributeMapping(null, newStyle, ""));
        this.fireTableChanged(new TableModelEvent(this, row, row, -1, 1));
        return row;
    }

    public int insertAttributeValue(int row, String strValue, String strLabel, BasicStyleModel newStyle) {
        newStyle.setEnabled(true);
        this.attributeMappings.add(row, new AttributeMapping(strValue, newStyle, strLabel));
        this.fireTableChanged(new TableModelEvent(this, row, row, -1, 1));
        return row;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex != 0 || columnIndex != 1;
    }

    protected List<AttributeMapping> nonDefaultAttributeMappings() {
        return this.attributeMappings.subList(1, this.attributeMappings.size());
    }

    protected static class AttributeMapping
    implements Comparable<AttributeMapping> {
        private String label;
        private Object attributeValue;
        private BasicStyleModel basicStyle;

        AttributeMapping(Object attributeValue, BasicStyleModel basicStyle, String label) {
            this.attributeValue = attributeValue;
            this.basicStyle = basicStyle;
            this.label = label;
        }

        public Object getAttributeValue() {
            return this.attributeValue;
        }

        public BasicStyleModel getBasicStyle() {
            return this.basicStyle;
        }

        @Override
        public int compareTo(AttributeMapping other) {
            if (this.attributeValue == null) {
                return -1;
            }
            if (other.getAttributeValue() == null) {
                return 1;
            }
            return ((Comparable)this.attributeValue).compareTo(other.getAttributeValue());
        }

        public void setAttributeValue(Object object) {
            this.attributeValue = object;
        }

        public void setBasicStyle(BasicStyleModel style) {
            this.basicStyle = style;
        }

        protected String getLabel() {
            return this.label;
        }

        protected void setLabel(String label) {
            this.label = label;
        }
    }

    public static class AttributeValueTableModelEvent
    extends TableModelEvent {
        private static final long serialVersionUID = -7588978418696047752L;

        public AttributeValueTableModelEvent(TableModel source, int row) {
            super(source, row);
        }
    }
}

