/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style.theming;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import com.vividsolutions.jump.workbench.ui.style.ThemeStylePanel;
import com.vividsolutions.jump.workbench.ui.style.theming.StaticColorThemingState;
import com.vividsolutions.jump.workbench.ui.style.theming.ThemeColor;
import com.vividsolutions.jump.workbench.ui.style.theming.ThemingTableModel;
import de.riwagis.riwajump.model.Range;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.swing.JRadioButton;
import javax.swing.event.TableModelListener;
import org.locationtech.jts.util.Assert;

public class RangeColorThemingState
extends StaticColorThemingState {
    private final ThemeStylePanel stylePanel;
    private final JRadioButton stateButton;
    private final boolean reversingColorScheme;
    private final TableModelListener tableModelListener = e -> {
        if (e instanceof ThemingTableModel.AttributeValueTableModelEvent) {
            this.getStylePanel().tableModel().sortByValueSameOrder();
        }
    };

    public RangeColorThemingState(ThemeStylePanel stylePanel, JRadioButton stateButton, Supplier<String> validatorSupplier) {
        this(stylePanel, false, stateButton, validatorSupplier);
    }

    public RangeColorThemingState(ThemeStylePanel stylePanel, boolean reversingColorScheme, JRadioButton stateButton, Supplier<String> validatorSupplier) {
        super(validatorSupplier);
        this.stylePanel = stylePanel;
        this.reversingColorScheme = reversingColorScheme;
        this.stateButton = stateButton;
    }

    @Override
    public String getAllOtherValuesDescription() {
        return I18N.get("ui.style.theming.RangeColorThemingState.values-below-these-values");
    }

    @Override
    public String getAttributeValueColumnTitle() {
        return I18N.get("ui.style.theming.RangeColorThemingState.minimum-attribute-values");
    }

    @Override
    public <T> Map<Object, T> fromExternalFormat(Map<Object, T> attributeValueToObjectMap) {
        TreeMap<Object, T> newMap = new TreeMap<Object, T>();
        for (Object o : attributeValueToObjectMap.keySet()) {
            Range range = (Range)o;
            newMap.put(range.getMin(), attributeValueToObjectMap.get(range));
        }
        return newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<Object, T> toExternalFormat(Map<Object, T> attributeValueToObjectMap) {
        if (attributeValueToObjectMap.isEmpty()) {
            return attributeValueToObjectMap;
        }
        Assert.isTrue((boolean)(attributeValueToObjectMap instanceof SortedMap));
        TreeMap<Double, T> doubleValueToObjectMap = new TreeMap<Double, T>();
        for (Object value : attributeValueToObjectMap.keySet()) {
            Double num = Double.parseDouble(value.toString());
            doubleValueToObjectMap.put(num, attributeValueToObjectMap.get(value));
        }
        Range.RangeTreeMap newMap = new Range.RangeTreeMap();
        Object previousValue = null;
        for (Object value : doubleValueToObjectMap.keySet()) {
            try {
                if (previousValue == null) continue;
                newMap.put(new Range(previousValue, true, value, false), doubleValueToObjectMap.get(previousValue));
            }
            finally {
                previousValue = value;
            }
        }
        newMap.put(new Range(previousValue, true, (Object)new Range.PositiveInfinity(), false), doubleValueToObjectMap.get(previousValue));
        return newMap;
    }

    @Override
    public void applyColorScheme(ColorScheme colorScheme, Set<ThemeColor> targets) {
        this.stylePanel.tableModel().apply(new ColorScheme(null, CollectionUtil.stretch(colorScheme.getColors(), new ArrayList(), this.stylePanel.tableModel().getRowCount())), false, targets);
    }

    @Override
    public Collection<String> getColorSchemeNames() {
        return ColorScheme.rangeColorSchemeNames();
    }

    private ThemeStylePanel getStylePanel() {
        return this.stylePanel;
    }

    private int row(Object attributeValue) {
        for (int i = 0; i < this.stylePanel.tableModel().getRowCount(); ++i) {
            Object otherAttributeValue = this.stylePanel.tableModel().getValueAt(i, 1);
            if (attributeValue == null && otherAttributeValue == null) {
                return i;
            }
            if (attributeValue == null || !attributeValue.equals(otherAttributeValue)) continue;
            return i;
        }
        Assert.shouldNeverReachHere();
        return -1;
    }

    @Override
    public void activate() {
        this.stylePanel.tableModel().addTableModelListener(this.tableModelListener);
    }

    @Override
    public void deactivate() {
        this.stylePanel.tableModel().removeTableModelListener(this.tableModelListener);
    }

    @Override
    public ColorScheme filterColorScheme(ColorScheme colorScheme) {
        if (!this.reversingColorScheme) {
            return colorScheme;
        }
        ArrayList<Color> colors = new ArrayList<Color>(colorScheme.getColors());
        Collections.reverse(colors);
        return new ColorScheme(colorScheme.getName(), colors);
    }

    @Override
    public boolean canApplyColorSchemes() {
        return true;
    }

    @Override
    public void selectMatchingUIElement() {
        this.stateButton.setSelected(true);
    }
}

