/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style.theming;

import com.vividsolutions.jump.workbench.ui.style.theming.ModificatorTableModel;
import de.riwagis.riwajump.model.style.theme.DynamicThemeModificatorModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.function.Consumer;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class BeanShellCellRendererAndEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private final JPanel editorPanel = new JPanel();
    private final JButton editButton = new JButton("...");
    private final JLabel valueLabel = new JLabel();
    private final DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
    private DynamicThemeModificatorModel currentModificator;

    public BeanShellCellRendererAndEditor(Consumer<DynamicThemeModificatorModel> beanShellPrompter) {
        this.editorPanel.setLayout(new BorderLayout());
        this.editorPanel.add((Component)this.valueLabel, "Center");
        this.editorPanel.add((Component)this.editButton, "East");
        this.editButton.addActionListener(e -> {
            beanShellPrompter.accept(this.currentModificator);
            this.valueLabel.setText(this.currentModificator.getBsh());
        });
        this.editButton.setPreferredSize(new Dimension(22, 22));
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            boolean startEditing;
            MouseEvent me = (MouseEvent)e;
            boolean bl = startEditing = me.getClickCount() >= 1;
            if (startEditing) {
                JTable table = (JTable)me.getSource();
                int row = table.rowAtPoint(me.getPoint());
                int column = table.columnAtPoint(me.getPoint());
                table.requestFocusInWindow();
                table.changeSelection(row, column, false, false);
                SwingUtilities.invokeLater(() -> table.editCellAt(row, column));
            }
            return startEditing;
        }
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentModificator = ((ModificatorTableModel)table.getModel()).getModificatorForRow(row);
        TableCellRenderer renderer = table.getCellRenderer(row, column);
        JComponent rendererComponent = (JComponent)renderer.getTableCellRendererComponent(table, value, isSelected, table.hasFocus(), row, column);
        if (rendererComponent != null) {
            this.editorPanel.setOpaque(true);
            this.editorPanel.setBorder(rendererComponent.getBorder());
            this.editorPanel.setBackground(rendererComponent.getBackground());
            this.editorPanel.setForeground(rendererComponent.getForeground());
            this.valueLabel.setBackground(rendererComponent.getBackground());
            this.valueLabel.setForeground(rendererComponent.getForeground());
        }
        this.valueLabel.setText((String)value);
        return this.editorPanel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent defaultComponent = (JComponent)this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.editorPanel.setBorder(defaultComponent.getBorder());
        this.editorPanel.setForeground(defaultComponent.getForeground());
        this.editorPanel.setBackground(defaultComponent.getBackground());
        this.editorPanel.setOpaque(isSelected);
        this.valueLabel.setForeground(defaultComponent.getForeground());
        this.valueLabel.setBackground(defaultComponent.getBackground());
        this.valueLabel.setText((String)value);
        this.editorPanel.setOpaque(isSelected);
        return this.editorPanel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.valueLabel.getText();
    }
}

