/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style.theming;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import de.riwagis.geotools.feature.bsh.FeatBshValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class AttributeDefPanel
extends JPanel {
    private String strTitle = "Tooltips";
    private String strErrorAt = "Error at";
    private boolean bolUpdateControls = true;
    private String strText = "";
    private PlugInContext context = null;
    private SimpleFeatureType featureType = null;
    private JCheckBox cboResultIsBeanShell;
    private JSeparator jSeparator1;
    private JLabel lblAttributes;
    private JLabel lblText;
    private JList lstAttributes;
    private JScrollPane scrAttributes;
    private JScrollPane scrText;
    private JTextArea txtText;

    public AttributeDefPanel(SimpleFeatureType featureType, PlugInContext context) {
        this.featureType = featureType;
        this.context = context;
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.strTitle = I18N.get("ui.style.AttributeDefPanel.title");
        this.lblAttributes.setText(I18N.get("ui.style.AttributeDefPanel.attributes"));
        this.strErrorAt = I18N.get("ui.style.AttributeDefPanel.error-at");
        this.lblText.setText(I18N.get("ui.style.AttributeDefPanel.text"));
        this.cboResultIsBeanShell.setText(I18N.get("ui.style.AttributeDefPanel.result-is-bsh"));
        this.cboResultIsBeanShell.setToolTipText(I18N.get("ui.style.AttributeDefPanel.result-is-bsh-tooltip"));
    }

    private void init() {
        this.bolUpdateControls = false;
        try {
            this.setResultIsBeanShellVisible(false);
        }
        finally {
            this.bolUpdateControls = true;
        }
        this.updateControls();
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        this.bolUpdateControls = false;
        try {
            this.txtText.setText(this.strText);
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    public String getTitle() {
        return this.strTitle;
    }

    public void setFeatureTypeRetriever(SimpleFeatureType featureType) {
        this.featureType = featureType;
        this.fillAttributes();
    }

    private void fillAttributes() {
        int i;
        this.lstAttributes.removeAll();
        this.lstAttributes.setModel(new DefaultListModel());
        String[] arrAttributes = new String[this.featureType.getAttributeCount()];
        for (i = 0; i < this.featureType.getAttributeCount(); ++i) {
            arrAttributes[i] = this.featureType.getDescriptor(i).getName().getLocalPart();
        }
        Arrays.sort(arrAttributes, String.CASE_INSENSITIVE_ORDER);
        for (i = 0; i < this.featureType.getAttributeCount(); ++i) {
            ((DefaultListModel)this.lstAttributes.getModel()).addElement(arrAttributes[i]);
        }
    }

    public void setAttributeDef(String strAttDef) {
        this.strText = strAttDef != null ? strAttDef : "";
        this.updateControls();
        this.txtText_onKeyReleased(null);
    }

    public String getAttributeDef() {
        return this.strText;
    }

    public void setResultIsBeanShellVisible(boolean visible) {
        this.cboResultIsBeanShell.setVisible(visible);
    }

    public void setResultIsBeanShell(boolean evaluateAsBeanShell) {
        this.cboResultIsBeanShell.setSelected(evaluateAsBeanShell);
    }

    public boolean isResultBeanShell() {
        return this.cboResultIsBeanShell.isSelected();
    }

    public String validateInput() {
        String strError = null;
        strError = FeatBshValidator.validateTextExpression((String)this.strText, (SimpleFeatureType)this.featureType);
        if (strError != null) {
            return this.strErrorAt + " " + this.lblText.getText();
        }
        return strError;
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.lblText = new JLabel();
        this.scrText = new JScrollPane();
        this.txtText = new JTextArea();
        this.scrAttributes = new JScrollPane();
        this.lstAttributes = new JList();
        this.lblAttributes = new JLabel();
        this.cboResultIsBeanShell = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setMinimumSize(new Dimension(450, 200));
        this.setLayout(new GridBagLayout());
        this.lblText.setText("Text:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblText, gridBagConstraints);
        this.scrText.setMinimumSize(new Dimension(24, 40));
        this.scrText.setPreferredSize(new Dimension(300, 150));
        this.txtText.setColumns(20);
        this.txtText.setFont(this.lblText.getFont());
        this.txtText.setRows(5);
        this.txtText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AttributeDefPanel.this.txtText_onFocusLost(evt);
            }
        });
        this.txtText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AttributeDefPanel.this.txtText_onKeyReleased(evt);
            }
        });
        this.scrText.setViewportView(this.txtText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.scrText, gridBagConstraints);
        this.scrAttributes.setMinimumSize(new Dimension(100, 150));
        this.scrAttributes.setPreferredSize(new Dimension(100, 150));
        this.lstAttributes.setSelectionMode(0);
        this.lstAttributes.setFocusable(false);
        this.lstAttributes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AttributeDefPanel.this.lstAttributes_onMouseClicked(evt);
            }
        });
        this.scrAttributes.setViewportView(this.lstAttributes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 3);
        this.add((Component)this.scrAttributes, gridBagConstraints);
        this.lblAttributes.setHorizontalAlignment(0);
        this.lblAttributes.setText("Attribute:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblAttributes, gridBagConstraints);
        this.cboResultIsBeanShell.setSelected(true);
        this.cboResultIsBeanShell.setText("Ergebnis ist BeanShell-Ausdruck");
        this.cboResultIsBeanShell.setToolTipText("Wenn aktiviert, wird der ausgewertete BeanShell-Ausdruck erneut als BeanShell-Ausdruck pro Feature mit dessen Attributen ausgewertet.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cboResultIsBeanShell, gridBagConstraints);
    }

    private void lstAttributes_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            String strAttName = (String)this.lstAttributes.getModel().getElementAt(this.lstAttributes.getSelectedIndex());
            AttributeDescriptor attType = this.featureType.getDescriptor(strAttName);
            Object strTempText = "";
            if (attType.getType().getBinding() == String.class) {
                strTempText = "str(\"" + strAttName + "\")";
            }
            if (attType.getType().getBinding() == Double.class) {
                strTempText = "num(\"" + strAttName + "\")";
            }
            if (attType.getType().getBinding() == Float.class) {
                strTempText = "num(\"" + strAttName + "\")";
            }
            if (attType.getType().getBinding() == Short.class) {
                strTempText = "num(\"" + strAttName + "\")";
            }
            if (attType.getType().getBinding() == BigDecimal.class) {
                strTempText = "num(\"" + strAttName + "\")";
            }
            if (attType.getType().getBinding() == Long.class) {
                strTempText = "lng(\"" + strAttName + "\")";
            }
            if (attType.getType().getBinding() == BigInteger.class) {
                strTempText = "lng(\"" + strAttName + "\")";
            }
            if (attType.getType().getBinding() == Integer.class) {
                strTempText = "integer(\"" + strAttName + "\")";
            }
            if (attType.getType().getBinding() == Byte.class) {
                strTempText = "integer(\"" + strAttName + "\")";
            }
            if (attType.getType().getBinding() == Date.class) {
                strTempText = "date(\"" + strAttName + "\")";
            }
            if (Geometry.class.isAssignableFrom(attType.getType().getBinding())) {
                strTempText = "area()";
            }
            if (this.txtText.hasFocus()) {
                if (this.strText != null && !this.strText.trim().equals("")) {
                    strTempText = " + " + (String)strTempText;
                }
                this.strText = this.strText + (String)strTempText;
            }
            this.updateControls();
        }
    }

    private void txtText_onFocusLost(FocusEvent evt) {
        this.strText = this.txtText.getText();
        this.updateControls();
    }

    private void txtText_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateTextExpression((String)this.txtText.getText(), (SimpleFeatureType)this.featureType) == null) {
            this.txtText.setForeground(Color.GREEN.darker());
        } else {
            this.txtText.setForeground(Color.RED.darker());
        }
        this.strText = this.txtText.getText();
    }
}

