/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style.text;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanelWithDB;
import com.vividsolutions.jump.workbench.ui.components.FontChooser;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.style.AttributePanel;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.text.TextPositionPanel;
import de.riwagis.geotools.feature.bsh.FeatBshValidator;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.riwajump.model.util.ColorHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.opengis.feature.simple.SimpleFeatureType;

public class TextStylePanel
extends AbstractStylePanel {
    private String strTitle = "Labels";
    private String strDegree = "degree";
    private String strGon = "gon";
    private String strPixel = "pixel";
    private String strPoint = "pt";
    private String strUnits = "units";
    private int intLengthUnitText = 0;
    private int intLengthUnit = 0;
    private int intOriUnit = 0;
    private String strPosCentroid = "centroid";
    private String strPosFirstPoint = "first point";
    private String strPosLongestSegment = "longest segment";
    private String strPosEverySegment = "every segment";
    private String strMultiLineAllLines = "all lines";
    private String strMultiLineLongestLine = "longest line";
    private String strMultiLineFirstLine = "first line";
    private String strMultiPolygonAllAreas = "all areas";
    private String strMultiPolygonLargestArea = "largest area";
    private String strMultiPolygonFirstArea = "first area";
    private boolean bolUpdateControls = true;
    private String strText = "\"Text\"";
    private String strOrient = "0";
    private String strHeight = "12";
    private String strTransLeft = "0";
    private String strTransTop = "0";
    private boolean bolTransInOri = false;
    private boolean bolShowPoint = true;
    private boolean bolShowLine = false;
    private boolean bolShowArea = false;
    private boolean bolOpaque = false;
    private String strAlignPoint = "7";
    private String strAlignLine = "5";
    private String strAlignArea = "5";
    private int intPosArea = 0;
    private int intPosLine = 0;
    private int intMultiLine = 0;
    private int intMultiPolygon = 0;
    private Font fontText = new Font("Liberation Sans", 0, 12);
    private ColorModel colorText = ColorModel.BLACK;
    private ColorModel colorOpaque = ColorModel.WHITE;
    private LayerStyleCollection sCol = null;
    private final List<Component> lstEnabled = new ArrayList<Component>();
    private boolean bolOnlyLabelFirstPoint = false;
    private AttributePanel attPanel;
    private JButton butFont;
    private JCheckBox cboOpaque;
    private JCheckBox cboShowArea;
    private JCheckBox cboShowLine;
    private JCheckBox cboShowPoint;
    private JCheckBox cboTransInOri;
    private JCheckBox chkLabelFirstPointOnly;
    private JComboBox<String> cmbLength;
    private JComboBox<String> cmbLengthText;
    private JComboBox<String> cmbMultiLine;
    private JComboBox<String> cmbMultiPolygon;
    private JComboBox<String> cmbOri;
    private JComboBox<String> cmbPosArea;
    private JComboBox<String> cmbPosLine;
    private JLabel lblHeight;
    private JLabel lblLength;
    private JLabel lblLengthText;
    private JLabel lblMultiLine;
    private JLabel lblMultiPolygon;
    private JLabel lblOpaqueColor;
    private JLabel lblOri;
    private JLabel lblOrient;
    private JLabel lblPosArea;
    private JLabel lblPosLine;
    private JLabel lblText;
    private JLabel lblTextColor;
    private JLabel lblTrans;
    private JLabel lblTransLeft;
    private JLabel lblTransTop;
    private JLabel lblUnitHeight;
    private JLabel lblUnitOrient;
    private JLabel lblUnitTrans;
    private ColorChooserPanelWithDB opaqueColorModelChooser;
    private JPanel pnlArea;
    private JPanel pnlContainer2;
    private JPanel pnlContainer3;
    private JPanel pnlContainer4;
    private JPanel pnlLine;
    private JPanel pnlPoint;
    private JPanel pnlUnit;
    private TextPositionPanel posArea;
    private TextPositionPanel posLine;
    private TextPositionPanel posPoint;
    private JScrollPane scrText;
    private JTabbedPane tabPane;
    private ColorChooserPanelWithDB textColorModelChooser;
    private JTextField txtHeight;
    private JTextField txtOrient;
    private JTextArea txtText;
    private JTextField txtTransLeft;
    private JTextField txtTransTop;

    public TextStylePanel() {
        this(null, null);
    }

    @Override
    public void updateStyles() {
        throw new UnsupportedOperationException();
    }

    public TextStylePanel(LayerStyleCollection _sCol, PlugInContext _context) {
        this.sCol = _sCol;
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.strDegree = I18N.get("common.degree");
        this.strGon = I18N.get("common.gon");
        this.strPixel = I18N.get("common.pixel");
        this.strPoint = I18N.get("common.pt");
        this.strUnits = I18N.get("common.drawing-units");
        ((TitledBorder)this.pnlUnit.getBorder()).setTitle(I18N.get("ui.style.TextStylePanel.unit"));
        this.lblLength.setText(I18N.get("ui.style.TextStylePanel.length-in"));
        this.lblLengthText.setText(I18N.get("ui.style.TextStylePanel.text-length-in"));
        this.lblOri.setText(I18N.get("ui.style.TextStylePanel.ori-in"));
        this.strPosCentroid = I18N.get("ui.style.TextStylePanel.position-centroid");
        this.strPosFirstPoint = I18N.get("ui.style.TextStylePanel.position-first-point");
        this.strPosLongestSegment = I18N.get("ui.style.TextStylePanel.position-longest-segment");
        this.strPosEverySegment = I18N.get("ui.style.TextStylePanel.position-every-segment");
        this.strMultiLineAllLines = I18N.get("ui.style.TextStylePanel.multiline-all-lines");
        this.strMultiLineLongestLine = I18N.get("ui.style.TextStylePanel.multiline-longest-line");
        this.strMultiLineFirstLine = I18N.get("ui.style.TextStylePanel.multiline-first-line");
        this.strMultiPolygonAllAreas = I18N.get("ui.style.TextStylePanel.multipolygon-all-areas");
        this.strMultiPolygonLargestArea = I18N.get("ui.style.TextStylePanel.multipolygon-biggest-area");
        this.strMultiPolygonFirstArea = I18N.get("ui.style.TextStylePanel.multipolygon-first-area");
        this.strTitle = I18N.get("ui.style.TextStylePanel.title");
        this.lblText.setText(I18N.get("ui.style.TextStylePanel.text"));
        this.lblOrient.setText(I18N.get("ui.style.TextStylePanel.orientation"));
        this.lblHeight.setText(I18N.get("ui.style.TextStylePanel.textheight"));
        this.lblTrans.setText(I18N.get("ui.style.TextStylePanel.translation"));
        this.lblTransLeft.setText(I18N.get("ui.style.TextStylePanel.left"));
        this.lblTransTop.setText(I18N.get("ui.style.TextStylePanel.top"));
        this.lblUnitHeight.setText(I18N.get("ui.style.TextStylePanel.unit"));
        this.lblUnitOrient.setText(I18N.get("ui.style.TextStylePanel.unit"));
        this.lblUnitTrans.setText(I18N.get("ui.style.TextStylePanel.unit"));
        this.butFont.setText(I18N.get("ui.style.TextStylePanel.change-font"));
        this.tabPane.setTitleAt(0, I18N.get("common.points"));
        this.tabPane.setTitleAt(1, I18N.get("common.lines"));
        this.tabPane.setTitleAt(2, I18N.get("common.areas"));
        this.cboShowPoint.setText(I18N.get("ui.style.TextStylePanel.show"));
        this.cboShowLine.setText(I18N.get("ui.style.TextStylePanel.show"));
        this.cboShowArea.setText(I18N.get("ui.style.TextStylePanel.show"));
        this.chkLabelFirstPointOnly.setText(I18N.get("ui.style.TextStylePanel.label_first_point_only"));
        this.lblPosArea.setText(I18N.get("ui.style.TextStylePanel.position"));
        this.lblPosLine.setText(I18N.get("ui.style.TextStylePanel.position"));
        this.lblMultiLine.setText(I18N.get("ui.style.TextStylePanel.multiline"));
        this.lblMultiPolygon.setText(I18N.get("ui.style.TextStylePanel.multipolygon"));
        this.cboTransInOri.setText(I18N.get("ui.style.TextStylePanel.trans-in-ori"));
        this.lblTextColor.setText(I18N.get("ui.style.TextStylePanel.text-color"));
        this.lblOpaqueColor.setText(I18N.get("ui.style.TextStylePanel.opaque-color"));
    }

    private void init() {
        this.bolUpdateControls = false;
        try {
            this.cmbLengthText.addItem(this.strPoint);
            this.cmbLengthText.addItem(this.strUnits);
            this.cmbLength.addItem(this.strPixel);
            this.cmbLength.addItem(this.strUnits);
            this.cmbOri.addItem(this.strDegree);
            this.cmbOri.addItem(this.strGon);
            this.cmbPosArea.addItem(this.strPosCentroid);
            this.cmbPosArea.addItem(this.strPosFirstPoint);
            this.cmbPosLine.addItem(this.strPosLongestSegment);
            this.cmbPosLine.addItem(this.strPosEverySegment);
            this.cmbMultiLine.addItem(this.strMultiLineAllLines);
            this.cmbMultiLine.addItem(this.strMultiLineLongestLine);
            this.cmbMultiLine.addItem(this.strMultiLineFirstLine);
            this.cmbMultiPolygon.addItem(this.strMultiPolygonAllAreas);
            this.cmbMultiPolygon.addItem(this.strMultiPolygonLargestArea);
            this.cmbMultiPolygon.addItem(this.strMultiPolygonFirstArea);
            this.posArea.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextStylePanel.this.posArea_onActionPerformed(e);
                }
            });
            this.posLine.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextStylePanel.this.posLine_onActionPerformed(e);
                }
            });
            this.posPoint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextStylePanel.this.posPoint_onActionPerformed(e);
                }
            });
            this.textColorModelChooser.setStylePanel(this);
            this.opaqueColorModelChooser.setStylePanel(this);
            this.attPanel.addTextComponent(this.txtText);
            this.attPanel.addTextComponent(this.txtOrient);
            this.attPanel.addTextComponent(this.txtHeight);
            this.attPanel.addTextComponent(this.txtTransLeft);
            this.attPanel.addTextComponent(this.txtTransTop);
            this.attPanel.addTextComponent(this.posPoint.getInternalTextField());
            this.attPanel.addTextComponent(this.posLine.getInternalTextField());
            this.attPanel.addTextComponent(this.posArea.getInternalTextField());
            this.attPanel.addTextComponent(this.textColorModelChooser.getInternalTextComponent(), true);
            this.attPanel.addTextComponent(this.opaqueColorModelChooser.getInternalTextComponent(), true);
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        this.bolUpdateControls = false;
        try {
            this.cmbLengthText.setSelectedIndex(this.intLengthUnitText);
            this.cmbLength.setSelectedIndex(this.intLengthUnit);
            this.cmbOri.setSelectedIndex(this.intOriUnit);
            this.setUnits();
            this.txtText.setText(this.strText);
            this.txtOrient.setText(this.strOrient);
            this.txtHeight.setText(this.strHeight);
            this.txtTransLeft.setText(this.strTransLeft);
            this.txtTransTop.setText(this.strTransTop);
            this.cboTransInOri.setSelected(this.bolTransInOri);
            this.cboShowArea.setSelected(this.bolShowArea);
            this.cboShowLine.setSelected(this.bolShowLine);
            this.cboShowPoint.setSelected(this.bolShowPoint);
            this.chkLabelFirstPointOnly.setSelected(this.bolOnlyLabelFirstPoint);
            this.posArea.setValue(this.strAlignArea);
            this.posLine.setValue(this.strAlignLine);
            this.posPoint.setValue(this.strAlignPoint);
            this.cboOpaque.setSelected(this.bolOpaque);
            this.lblOpaqueColor.setEnabled(this.bolOpaque);
            this.opaqueColorModelChooser.setEnabled(this.bolOpaque);
            this.cmbPosLine.setSelectedIndex(this.intPosLine);
            this.cmbMultiLine.setSelectedIndex(this.intMultiLine);
            this.cmbPosArea.setSelectedIndex(this.intPosArea);
            if (this.sCol.getLayerable() instanceof LabelLayer) {
                this.cmbOri.setEnabled(false);
                this.tabPane.setEnabledAt(1, false);
                this.tabPane.setEnabledAt(2, false);
                this.tabPane.setSelectedIndex(0);
            } else {
                this.cmbOri.setEnabled(true);
                this.tabPane.setEnabledAt(1, true);
                this.tabPane.setEnabledAt(2, true);
            }
            this.textColorModelChooser.setColorModel(this.colorText);
            this.textColorModelChooser.setAlpha(this.colorText.getAlpha());
            this.opaqueColorModelChooser.setColorModel(this.colorOpaque);
            this.opaqueColorModelChooser.setAlpha(this.colorOpaque.getAlpha());
            this.fireStyleChanged();
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled && this.isEnabled()) {
            this.lstEnabled.clear();
            this.disableContainer(this);
            super.setEnabled(false);
        }
        if (enabled && !this.isEnabled()) {
            for (Component comp : this.lstEnabled) {
                comp.setEnabled(true);
            }
            this.lstEnabled.clear();
            super.setEnabled(true);
            this.updateControls();
        }
    }

    public void disableContainer(Container pnl) {
        Component[] arrComp;
        for (Component comp : arrComp = pnl.getComponents()) {
            if (!comp.isEnabled()) continue;
            this.lstEnabled.add(comp);
            if (comp instanceof Container) {
                this.disableContainer((Container)comp);
            }
            comp.setEnabled(false);
        }
    }

    public void setTransparency(int alpha, boolean bolUseAlphaText) {
        if (bolUseAlphaText) {
            if (this.colorText != null) {
                this.colorText = ColorHelper.getAlphaColorModel((ColorModel)this.colorText, (int)alpha);
            }
            if (this.colorOpaque != null) {
                this.colorOpaque = ColorHelper.getAlphaColorModel((ColorModel)this.colorOpaque, (int)alpha);
            }
            this.opaqueColorModelChooser.setAlpha(alpha);
            this.textColorModelChooser.setAlpha(alpha);
        } else {
            if (this.colorText != null) {
                this.colorText = ColorHelper.getAlphaColorModel((ColorModel)this.colorText, (int)255);
            }
            if (this.colorOpaque != null) {
                this.colorOpaque = ColorHelper.getAlphaColorModel((ColorModel)this.colorOpaque, (int)255);
            }
            this.opaqueColorModelChooser.setAlpha(255);
            this.textColorModelChooser.setAlpha(255);
        }
    }

    @Override
    public String getTitle() {
        return this.strTitle;
    }

    @Override
    public void setStyleCollection(StyleCollection _sCol) {
        this.sCol = (LayerStyleCollection)_sCol;
        if (this.sCol != null) {
            this.setTextStyle(this.sCol.getBasicStyle().getTextStyle());
        }
    }

    @Override
    public void setFeatureRetriever(FeatureRetriever featureTypeRetriever) {
        super.setFeatureRetriever(featureTypeRetriever);
        this.fillAttributes();
    }

    private void fillAttributes() {
        SimpleFeatureType fSchema = this.getFeatureRetriever().getFeatureType();
        this.attPanel.fillAttributes(fSchema);
        this.posPoint.setFeatureType(fSchema);
        this.posLine.setFeatureType(fSchema);
        this.posArea.setFeatureType(fSchema);
    }

    public void setTextStyle(TextStyleModel textStyle) {
        if (textStyle == null) {
            return;
        }
        this.strText = textStyle.getStrText();
        this.strOrient = textStyle.getStrOrient();
        this.strHeight = textStyle.getStrHeight();
        this.strTransLeft = textStyle.getStrTransLeft();
        this.strTransTop = textStyle.getStrTransTop();
        this.bolTransInOri = textStyle.isBolTransInOri();
        this.bolShowPoint = textStyle.isBolShowPoint();
        this.bolShowLine = textStyle.isBolShowLine();
        this.bolShowArea = textStyle.isBolShowArea();
        this.bolOpaque = textStyle.isBolOpaque();
        this.strAlignPoint = textStyle.getAlignPoint();
        this.strAlignLine = textStyle.getAlignLine();
        this.strAlignArea = textStyle.getAlignArea();
        this.bolOnlyLabelFirstPoint = textStyle.isBolOnlyLabelFirstPoint();
        this.intPosArea = textStyle.getIntPosArea();
        this.intPosLine = textStyle.getIntPosLine();
        this.intMultiLine = textStyle.getIntMultiLine();
        this.intMultiPolygon = textStyle.getIntMultiPolygon();
        this.fontText = RenderUtil.getRenderer(textStyle).retrieveAwtFont();
        this.colorText = textStyle.getColorText();
        this.colorOpaque = textStyle.getColorOpaque();
        this.intLengthUnitText = textStyle.getIntUnitLengthText();
        this.intLengthUnit = textStyle.getIntUnitLength();
        this.intOriUnit = textStyle.getIntUnitOrient();
        this.updateControls();
        this.txtText_onKeyReleased(null);
        this.txtOrient_onKeyReleased(null);
        this.txtHeight_onKeyReleased(null);
        this.txtTransLeft_onKeyReleased(null);
        this.txtTransTop_onKeyReleased(null);
    }

    public TextStyleModel getTextStyle() {
        TextStyleModel textStyle = new TextStyleModel();
        textStyle.setStrText(this.strText);
        textStyle.setStrHeight(this.strHeight);
        textStyle.setStrOrient(this.strOrient);
        textStyle.setStrTransLeft(this.strTransLeft);
        textStyle.setStrTransTop(this.strTransTop);
        textStyle.setBolTransInOri(this.bolTransInOri);
        textStyle.setBolShowPoint(this.bolShowPoint);
        textStyle.setBolShowLine(this.bolShowLine);
        textStyle.setBolShowArea(this.bolShowArea);
        textStyle.setBolOpaque(this.bolOpaque);
        textStyle.setAlignPoint(this.strAlignPoint);
        textStyle.setBolOnlyLabelFirstPoint(this.bolOnlyLabelFirstPoint);
        textStyle.setAlignLine(this.strAlignLine);
        textStyle.setAlignArea(this.strAlignArea);
        textStyle.setIntPosArea(this.intPosArea);
        textStyle.setIntPosLine(this.intPosLine);
        textStyle.setIntMultiLine(this.intMultiLine);
        textStyle.setIntMultiPolygon(this.intMultiPolygon);
        textStyle.setFontText(TextRenderer.retrieveFontModel(this.fontText));
        textStyle.setColorText(this.colorText);
        textStyle.setColorOpaque(this.colorOpaque);
        textStyle.setIntUnitLengthText(this.intLengthUnitText);
        textStyle.setIntUnitLength(this.intLengthUnit);
        textStyle.setIntUnitOrient(this.intOriUnit);
        return textStyle;
    }

    private void setUnits() {
        if (this.intLengthUnitText == 0) {
            this.lblUnitHeight.setText(this.strPoint);
        } else {
            this.lblUnitHeight.setText(this.strUnits);
        }
        if (this.intLengthUnit == 0) {
            this.lblUnitTrans.setText(this.strPixel);
        } else {
            this.lblUnitTrans.setText(this.strUnits);
        }
        if (this.intOriUnit == 0) {
            this.lblUnitOrient.setText(this.strDegree);
        } else {
            this.lblUnitOrient.setText(this.strGon);
        }
    }

    @Override
    public String validateInput() {
        SimpleFeatureType fSchema = this.getFeatureRetriever().getFeatureType();
        String strError = FeatBshValidator.validateTextExpression((String)this.strText, (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.strText, strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.strHeight, (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.strHeight, strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.strOrient, (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.strOrient, strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.strTransLeft, (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.strTransLeft, strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.strTransTop, (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.strTransTop, strError);
        }
        if (!this.posPoint.validateValue()) {
            return this.getErrorMessage(this.posPoint.getValue());
        }
        if (!this.posLine.validateValue()) {
            return this.getErrorMessage(this.posLine.getValue());
        }
        if (!this.posArea.validateValue()) {
            return this.getErrorMessage(this.posArea.getValue());
        }
        if (this.colorText != null && (strError = FeatBshValidator.validateTextExpression((String)this.colorText.getBsh(), (SimpleFeatureType)fSchema)) != null) {
            return this.getErrorMessageWithDetails(this.colorText.getBsh(), strError);
        }
        if (this.bolOpaque && (strError = FeatBshValidator.validateTextExpression((String)this.colorOpaque.getBsh(), (SimpleFeatureType)fSchema)) != null) {
            return this.getErrorMessageWithDetails(this.colorOpaque.getBsh(), strError);
        }
        return strError;
    }

    private String getErrorMessage(String expression) {
        return I18N.getMessage("ui.style.TextStylePanel.validation.invalid-expression-nodetail", expression);
    }

    private String getErrorMessageWithDetails(String expression, String errorMessage) {
        return I18N.getMessage("ui.style.TextStylePanel.validation.invalid-expression", expression, errorMessage.trim());
    }

    private void initComponents() {
        this.lblOrient = new JLabel();
        this.txtOrient = new JTextField();
        this.lblUnitOrient = new JLabel();
        this.lblHeight = new JLabel();
        this.txtHeight = new JTextField();
        this.lblUnitHeight = new JLabel();
        this.lblTrans = new JLabel();
        this.lblUnitTrans = new JLabel();
        this.pnlContainer2 = new JPanel();
        this.lblTransLeft = new JLabel();
        this.txtTransLeft = new JTextField();
        this.lblTransTop = new JLabel();
        this.txtTransTop = new JTextField();
        this.pnlContainer3 = new JPanel();
        this.tabPane = new JTabbedPane();
        this.pnlPoint = new JPanel();
        this.cboShowPoint = new JCheckBox();
        this.posPoint = new TextPositionPanel();
        this.chkLabelFirstPointOnly = new JCheckBox();
        this.pnlLine = new JPanel();
        this.cboShowLine = new JCheckBox();
        this.posLine = new TextPositionPanel();
        this.lblPosLine = new JLabel();
        this.cmbPosLine = new JComboBox();
        this.lblMultiLine = new JLabel();
        this.cmbMultiLine = new JComboBox();
        this.pnlArea = new JPanel();
        this.cboShowArea = new JCheckBox();
        this.lblPosArea = new JLabel();
        this.cmbPosArea = new JComboBox();
        this.posArea = new TextPositionPanel();
        this.lblMultiPolygon = new JLabel();
        this.cmbMultiPolygon = new JComboBox();
        this.pnlUnit = new JPanel();
        this.lblLength = new JLabel();
        this.cmbLength = new JComboBox();
        this.cmbOri = new JComboBox();
        this.lblOri = new JLabel();
        this.lblLengthText = new JLabel();
        this.cmbLengthText = new JComboBox();
        this.lblText = new JLabel();
        this.pnlContainer4 = new JPanel();
        this.cboOpaque = new JCheckBox();
        this.butFont = new JButton();
        this.textColorModelChooser = new ColorChooserPanelWithDB();
        this.opaqueColorModelChooser = new ColorChooserPanelWithDB();
        this.lblOpaqueColor = new JLabel();
        this.lblTextColor = new JLabel();
        this.scrText = new JScrollPane();
        this.txtText = new JTextArea();
        this.attPanel = new AttributePanel();
        this.cboTransInOri = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.lblOrient.setText("Orientierung:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 2, 3, 2);
        this.add((Component)this.lblOrient, gridBagConstraints);
        this.txtOrient.setColumns(15);
        this.txtOrient.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TextStylePanel.this.txtOrient_onFocusLost(evt);
            }
        });
        this.txtOrient.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TextStylePanel.this.txtOrient_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.add((Component)this.txtOrient, gridBagConstraints);
        this.lblUnitOrient.setText("Einheit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 4, 3, 10);
        this.add((Component)this.lblUnitOrient, gridBagConstraints);
        this.lblHeight.setText("H\u00f6he:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 2, 3, 2);
        this.add((Component)this.lblHeight, gridBagConstraints);
        this.txtHeight.setColumns(15);
        this.txtHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TextStylePanel.this.txtHeight_onFocusLost(evt);
            }
        });
        this.txtHeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TextStylePanel.this.txtHeight_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.add((Component)this.txtHeight, gridBagConstraints);
        this.lblUnitHeight.setText("Einheit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 4, 3, 10);
        this.add((Component)this.lblUnitHeight, gridBagConstraints);
        this.lblTrans.setText("Versatz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 2, 3, 2);
        this.add((Component)this.lblTrans, gridBagConstraints);
        this.lblUnitTrans.setText("Einheit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 4, 3, 10);
        this.add((Component)this.lblUnitTrans, gridBagConstraints);
        this.pnlContainer2.setLayout(new GridBagLayout());
        this.lblTransLeft.setText("links:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlContainer2.add((Component)this.lblTransLeft, gridBagConstraints);
        this.txtTransLeft.setColumns(3);
        this.txtTransLeft.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TextStylePanel.this.txtTransLeft_onFocusLost(evt);
            }
        });
        this.txtTransLeft.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TextStylePanel.this.txtTransLeft_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlContainer2.add((Component)this.txtTransLeft, gridBagConstraints);
        this.lblTransTop.setText("oben:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlContainer2.add((Component)this.lblTransTop, gridBagConstraints);
        this.txtTransTop.setColumns(3);
        this.txtTransTop.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TextStylePanel.this.txtTransTop_onFocusLost(evt);
            }
        });
        this.txtTransTop.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TextStylePanel.this.txtTransTop_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.pnlContainer2.add((Component)this.txtTransTop, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 3, 3, 3);
        this.add((Component)this.pnlContainer2, gridBagConstraints);
        this.pnlContainer3.setLayout(new GridBagLayout());
        this.pnlPoint.setLayout(new GridBagLayout());
        this.cboShowPoint.setText("anzeigen");
        this.cboShowPoint.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboShowPoint.setMargin(new Insets(0, 0, 0, 0));
        this.cboShowPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cboShowPoint_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 6, 3, 3);
        this.pnlPoint.add((Component)this.cboShowPoint, gridBagConstraints);
        this.posPoint.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        this.posPoint.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlPoint.add((Component)this.posPoint, gridBagConstraints);
        this.chkLabelFirstPointOnly.setText("nur ersten Punkt beschriften");
        this.chkLabelFirstPointOnly.setMargin(new Insets(0, 0, 0, 0));
        this.chkLabelFirstPointOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.chkLabelFirstPointOnlyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlPoint.add((Component)this.chkLabelFirstPointOnly, gridBagConstraints);
        this.chkLabelFirstPointOnly.getAccessibleContext().setAccessibleName("ersten Punkt anzeigen");
        this.chkLabelFirstPointOnly.getAccessibleContext().setAccessibleDescription("");
        this.tabPane.addTab("Punkte", this.pnlPoint);
        this.pnlLine.setLayout(new GridBagLayout());
        this.cboShowLine.setText("anzeigen");
        this.cboShowLine.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboShowLine.setMargin(new Insets(0, 0, 0, 0));
        this.cboShowLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cboShowLine_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 6, 3, 3);
        this.pnlLine.add((Component)this.cboShowLine, gridBagConstraints);
        this.posLine.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlLine.add((Component)this.posLine, gridBagConstraints);
        this.lblPosLine.setText("Position:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlLine.add((Component)this.lblPosLine, gridBagConstraints);
        this.cmbPosLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cmbPosLine_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlLine.add(this.cmbPosLine, gridBagConstraints);
        this.lblMultiLine.setText("Bei mehreren Linien (MultiLinestring):");
        this.lblMultiLine.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlLine.add((Component)this.lblMultiLine, gridBagConstraints);
        this.lblMultiLine.getAccessibleContext().setAccessibleName("Multilines");
        this.cmbMultiLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cmbMultiLine_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlLine.add(this.cmbMultiLine, gridBagConstraints);
        this.tabPane.addTab("Linien", this.pnlLine);
        this.pnlArea.setLayout(new GridBagLayout());
        this.cboShowArea.setText("anzeigen");
        this.cboShowArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboShowArea.setMargin(new Insets(0, 0, 0, 0));
        this.cboShowArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cboShowArea_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 6, 3, 3);
        this.pnlArea.add((Component)this.cboShowArea, gridBagConstraints);
        this.lblPosArea.setText("Postion:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlArea.add((Component)this.lblPosArea, gridBagConstraints);
        this.cmbPosArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cmbPosArea_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlArea.add(this.cmbPosArea, gridBagConstraints);
        this.posArea.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlArea.add((Component)this.posArea, gridBagConstraints);
        this.lblMultiPolygon.setText("Bei mehreren Fl\u00e4chen (MultiPolygon):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlArea.add((Component)this.lblMultiPolygon, gridBagConstraints);
        this.lblMultiPolygon.getAccessibleContext().setAccessibleName("MultiPoly:");
        this.cmbMultiPolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cmbMultiPolygon_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlArea.add(this.cmbMultiPolygon, gridBagConstraints);
        this.tabPane.addTab("Flaechen", this.pnlArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlContainer3.add((Component)this.tabPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlContainer3, gridBagConstraints);
        this.pnlUnit.setBorder(BorderFactory.createTitledBorder("Einheiten"));
        this.pnlUnit.setPreferredSize(new Dimension(521, 51));
        this.pnlUnit.setLayout(new GridBagLayout());
        this.lblLength.setText("L\u00e4ngen in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add((Component)this.lblLength, gridBagConstraints);
        this.cmbLength.setMinimumSize(new Dimension(80, 20));
        this.cmbLength.setPreferredSize(new Dimension(80, 22));
        this.cmbLength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cmbLength_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add(this.cmbLength, gridBagConstraints);
        this.cmbOri.setMinimumSize(new Dimension(80, 22));
        this.cmbOri.setPreferredSize(new Dimension(80, 22));
        this.cmbOri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cmbOri_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add(this.cmbOri, gridBagConstraints);
        this.lblOri.setText("Winkel in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add((Component)this.lblOri, gridBagConstraints);
        this.lblLengthText.setText("H\u00f6he in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add((Component)this.lblLengthText, gridBagConstraints);
        this.cmbLengthText.setMinimumSize(new Dimension(80, 20));
        this.cmbLengthText.setPreferredSize(new Dimension(80, 22));
        this.cmbLengthText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cmbLengthText_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add(this.cmbLengthText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.pnlUnit, gridBagConstraints);
        this.lblText.setFont(this.lblText.getFont().deriveFont(this.lblText.getFont().getStyle() | 1));
        this.lblText.setText("Text:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(6, 2, 3, 2);
        this.add((Component)this.lblText, gridBagConstraints);
        this.pnlContainer4.setBorder(BorderFactory.createTitledBorder("Textstil"));
        this.pnlContainer4.setLayout(new GridBagLayout());
        this.cboOpaque.setText("Freistellen");
        this.cboOpaque.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboOpaque.setMargin(new Insets(0, 0, 0, 0));
        this.cboOpaque.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cboOpaque_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 8, 3, 3);
        this.pnlContainer4.add((Component)this.cboOpaque, gridBagConstraints);
        this.butFont.setText("Schriftart");
        this.butFont.setMinimumSize(new Dimension(120, 22));
        this.butFont.setPreferredSize(new Dimension(120, 22));
        this.butFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.butFont_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.pnlContainer4.add((Component)this.butFont, gridBagConstraints);
        this.textColorModelChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.textColorModelChooserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlContainer4.add((Component)this.textColorModelChooser, gridBagConstraints);
        this.opaqueColorModelChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.opaqueColorModelChooserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlContainer4.add((Component)this.opaqueColorModelChooser, gridBagConstraints);
        this.lblOpaqueColor.setText("Freistellung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlContainer4.add((Component)this.lblOpaqueColor, gridBagConstraints);
        this.lblTextColor.setText("Textfarbe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlContainer4.add((Component)this.lblTextColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlContainer4, gridBagConstraints);
        this.scrText.setHorizontalScrollBarPolicy(31);
        this.scrText.setMinimumSize(new Dimension(24, 40));
        this.txtText.setColumns(20);
        this.txtText.setFont(this.txtOrient.getFont());
        this.txtText.setRows(1);
        this.txtText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TextStylePanel.this.txtText_onFocusLost(evt);
            }
        });
        this.txtText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TextStylePanel.this.txtText_onKeyReleased(evt);
            }
        });
        this.scrText.setViewportView(this.txtText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.add((Component)this.scrText, gridBagConstraints);
        this.attPanel.setMinimumSize(new Dimension(120, 39));
        this.attPanel.setPreferredSize(new Dimension(120, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.attPanel, gridBagConstraints);
        this.cboTransInOri.setText("in Orientierungsrichtung");
        this.cboTransInOri.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboTransInOri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextStylePanel.this.cboTransInOriActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cboTransInOri, gridBagConstraints);
    }

    private void cmbOri_onActionPerformed(ActionEvent evt) {
        this.intOriUnit = this.cmbOri.getSelectedIndex();
        this.updateControls();
    }

    private void cmbLength_onActionPerformed(ActionEvent evt) {
        this.intLengthUnit = this.cmbLength.getSelectedIndex();
        this.updateControls();
    }

    private void cboOpaque_onActionPerformed(ActionEvent evt) {
        this.bolOpaque = this.cboOpaque.isSelected();
        if (this.colorOpaque == null) {
            this.colorOpaque = ColorModel.WHITE;
        }
        this.updateControls();
    }

    private void txtTransTop_onFocusLost(FocusEvent evt) {
        this.strTransTop = this.txtTransTop.getText();
        this.updateControls();
    }

    private void txtTransTop_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateCalcExpression((String)this.txtTransTop.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtTransTop.setForeground(Color.GREEN.darker());
        } else {
            this.txtTransTop.setForeground(Color.RED.darker());
        }
        this.strTransTop = this.txtTransTop.getText();
        this.fireStyleChanged();
    }

    private void txtTransLeft_onFocusLost(FocusEvent evt) {
        this.strTransLeft = this.txtTransLeft.getText();
        this.updateControls();
    }

    private void txtTransLeft_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateCalcExpression((String)this.txtTransLeft.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtTransLeft.setForeground(Color.GREEN.darker());
        } else {
            this.txtTransLeft.setForeground(Color.RED.darker());
        }
        this.strTransLeft = this.txtTransLeft.getText();
        this.fireStyleChanged();
    }

    private void txtHeight_onFocusLost(FocusEvent evt) {
        this.strHeight = this.txtHeight.getText();
        this.updateControls();
    }

    private void txtHeight_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateCalcExpression((String)this.txtHeight.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtHeight.setForeground(Color.GREEN.darker());
        } else {
            this.txtHeight.setForeground(Color.RED.darker());
        }
        this.strHeight = this.txtHeight.getText();
        this.fireStyleChanged();
    }

    private void txtOrient_onFocusLost(FocusEvent evt) {
        this.strOrient = this.txtOrient.getText();
        this.updateControls();
    }

    private void txtOrient_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateCalcExpression((String)this.txtOrient.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtOrient.setForeground(Color.GREEN.darker());
        } else {
            this.txtOrient.setForeground(Color.RED.darker());
        }
        this.strOrient = this.txtOrient.getText();
        this.fireStyleChanged();
    }

    private void txtText_onFocusLost(FocusEvent evt) {
        this.strText = this.txtText.getText();
        this.updateControls();
    }

    private void txtText_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateTextExpression((String)this.txtText.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtText.setForeground(Color.GREEN.darker());
        } else {
            this.txtText.setForeground(Color.RED.darker());
        }
        this.strText = this.txtText.getText();
        this.fireStyleChanged();
    }

    private void butFont_onActionPerformed(ActionEvent evt) {
        Font newFont = FontChooser.showDialog((JDialog)SwingUtilities.windowForComponent(this), I18N.get("ui.style.TextStylePanel.change-font"), this.fontText);
        if (newFont == null) {
            return;
        }
        this.fontText = newFont;
        this.updateControls();
    }

    private void posArea_onActionPerformed(ActionEvent evt) {
        this.strAlignArea = this.posArea.getValue();
        this.updateControls();
    }

    private void posLine_onActionPerformed(ActionEvent evt) {
        this.strAlignLine = this.posLine.getValue();
        this.updateControls();
    }

    private void posPoint_onActionPerformed(ActionEvent evt) {
        this.strAlignPoint = this.posPoint.getValue();
        this.updateControls();
    }

    private void cmbPosArea_onActionPerformed(ActionEvent evt) {
        this.intPosArea = this.cmbPosArea.getSelectedIndex();
        this.updateControls();
    }

    private void cboShowArea_onActionPerformed(ActionEvent evt) {
        this.bolShowArea = this.cboShowArea.isSelected();
        this.updateControls();
    }

    private void cboShowLine_onActionPerformed(ActionEvent evt) {
        this.bolShowLine = this.cboShowLine.isSelected();
        this.updateControls();
    }

    private void cboShowPoint_onActionPerformed(ActionEvent evt) {
        this.bolShowPoint = this.cboShowPoint.isSelected();
        this.updateControls();
    }

    private void cmbLengthText_onActionPerformed(ActionEvent evt) {
        this.intLengthUnitText = this.cmbLengthText.getSelectedIndex();
        this.updateControls();
    }

    private void cboTransInOriActionPerformed(ActionEvent evt) {
        this.bolTransInOri = this.cboTransInOri.isSelected();
        this.updateControls();
    }

    private void textColorModelChooserActionPerformed(ActionEvent evt) {
        this.colorText = this.colorText == null ? this.textColorModelChooser.getColorChooserColorModel() : ColorHelper.getAlphaColorModel((ColorModel)this.textColorModelChooser.getColorChooserColorModel(), (int)this.colorText.getAlpha());
        this.updateControls();
    }

    private void opaqueColorModelChooserActionPerformed(ActionEvent evt) {
        this.colorOpaque = this.colorOpaque == null ? this.opaqueColorModelChooser.getColorChooserColorModel() : ColorHelper.getAlphaColorModel((ColorModel)this.opaqueColorModelChooser.getColorChooserColorModel(), (int)this.colorOpaque.getAlpha());
        this.updateControls();
    }

    private void chkLabelFirstPointOnlyActionPerformed(ActionEvent evt) {
        this.bolOnlyLabelFirstPoint = this.chkLabelFirstPointOnly.isSelected();
        this.updateControls();
    }

    private void cmbMultiLine_onActionPerformed(ActionEvent evt) {
        this.intMultiLine = this.cmbMultiLine.getSelectedIndex();
        this.updateControls();
    }

    private void cmbPosLine_onActionPerformed(ActionEvent evt) {
        this.intPosLine = this.cmbPosLine.getSelectedIndex();
        this.updateControls();
    }

    private void cmbMultiPolygon_onActionPerformed(ActionEvent evt) {
        this.intMultiPolygon = this.cmbMultiPolygon.getSelectedIndex();
        this.updateControls();
    }
}

