/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style.text;

import com.vividsolutions.jump.I18N;
import de.riwagis.geotools.feature.bsh.FeatBshValidator;
import de.riwagis.util.StringSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.opengis.feature.simple.SimpleFeatureType;

public class TextPositionPanel
extends JPanel {
    private String strValue = "7";
    private final HashMap<JRadioButton, String> mapValues = new HashMap();
    private final ArrayList lstListeners = new ArrayList();
    private boolean bolFireEvents = true;
    private SimpleFeatureType ft = null;
    private ButtonGroup butgrpPosition;
    private JLabel lblText;
    private JRadioButton opt1;
    private JRadioButton opt2;
    private JRadioButton opt3;
    private JRadioButton opt4;
    private JRadioButton opt5;
    private JRadioButton opt6;
    private JRadioButton opt7;
    private JRadioButton opt8;
    private JRadioButton opt9;
    private JTextField txtValue;

    public TextPositionPanel() {
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.lblText.setText(I18N.get("ui.style.text.TextPositionPanel.insertion-point"));
    }

    private void init() {
        this.butgrpPosition.add(this.opt1);
        this.butgrpPosition.add(this.opt2);
        this.butgrpPosition.add(this.opt3);
        this.butgrpPosition.add(this.opt4);
        this.butgrpPosition.add(this.opt5);
        this.butgrpPosition.add(this.opt6);
        this.butgrpPosition.add(this.opt7);
        this.butgrpPosition.add(this.opt8);
        this.butgrpPosition.add(this.opt9);
        this.mapValues.put(this.opt1, "1");
        this.mapValues.put(this.opt2, "2");
        this.mapValues.put(this.opt3, "3");
        this.mapValues.put(this.opt4, "4");
        this.mapValues.put(this.opt5, "5");
        this.mapValues.put(this.opt6, "6");
        this.mapValues.put(this.opt7, "7");
        this.mapValues.put(this.opt8, "8");
        this.mapValues.put(this.opt9, "9");
        this.opt7.setSelected(true);
        this.txtValue.setText("7");
    }

    public void setFeatureType(SimpleFeatureType _ft) {
        this.ft = _ft;
    }

    public String getValue() {
        return this.strValue;
    }

    public void setValue(String _strValue) {
        this.bolFireEvents = false;
        try {
            if (_strValue == null) {
                _strValue = "7";
            }
            if (this.strValue.equals(_strValue)) {
                return;
            }
            this.setValueToOpts(_strValue);
            this.txtValue.setText(_strValue);
            this.strValue = _strValue;
            this.validateValue();
        }
        finally {
            this.bolFireEvents = true;
        }
        this.fireActionEvent();
    }

    private void setValueTxtInternal(String _strValue) {
        this.bolFireEvents = false;
        try {
            if (_strValue == null) {
                _strValue = "7";
            }
            if (this.strValue.equals(_strValue)) {
                return;
            }
            this.setValueToOpts(_strValue);
            this.strValue = _strValue;
            this.validateValue();
        }
        finally {
            this.bolFireEvents = true;
        }
        this.fireActionEvent();
    }

    public boolean validateValue() {
        if (this.strValue == null || this.strValue.trim().length() == 0) {
            this.txtValue.setForeground(Color.RED.darker());
            return false;
        }
        if (StringSupport.isNumeric((String)this.strValue)) {
            try {
                int intValue = Integer.parseInt(this.strValue);
                if (intValue < 1 || intValue > 9) {
                    this.txtValue.setForeground(Color.RED.darker());
                    return false;
                }
            }
            catch (NumberFormatException ne) {
                this.txtValue.setForeground(Color.RED.darker());
                return false;
            }
        }
        if (this.ft == null) {
            this.txtValue.setForeground(Color.BLACK);
            return true;
        }
        if (FeatBshValidator.validateTextExpression((String)this.strValue, (SimpleFeatureType)this.ft) == null) {
            this.txtValue.setForeground(Color.GREEN.darker());
            return true;
        }
        this.txtValue.setForeground(Color.RED.darker());
        return false;
    }

    private void setValueToOpts(String _strValue) {
        for (JRadioButton opt : this.mapValues.keySet()) {
            if (!_strValue.equals(this.mapValues.get(opt))) continue;
            opt.setSelected(true);
            break;
        }
    }

    public void addActionListener(ActionListener listener) {
        this.lstListeners.add(listener);
    }

    private void fireActionEvent() {
        ActionEvent e = new ActionEvent(this, 0, "");
        for (ActionListener listener : this.lstListeners) {
            listener.actionPerformed(e);
        }
    }

    public boolean hasTextFocus() {
        return this.txtValue.hasFocus();
    }

    public JTextField getInternalTextField() {
        return this.txtValue;
    }

    private void initComponents() {
        this.butgrpPosition = new ButtonGroup();
        this.opt1 = new JRadioButton();
        this.opt4 = new JRadioButton();
        this.opt2 = new JRadioButton();
        this.opt7 = new JRadioButton();
        this.opt5 = new JRadioButton();
        this.opt6 = new JRadioButton();
        this.opt3 = new JRadioButton();
        this.opt8 = new JRadioButton();
        this.opt9 = new JRadioButton();
        this.lblText = new JLabel();
        this.txtValue = new JTextField();
        this.setLayout(new GridBagLayout());
        this.opt1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.opt1.setMargin(new Insets(0, 0, 0, 0));
        this.opt1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPositionPanel.this.opt1_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.opt1, gridBagConstraints);
        this.opt4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.opt4.setMargin(new Insets(0, 0, 0, 0));
        this.opt4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPositionPanel.this.opt4_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.opt4, gridBagConstraints);
        this.opt2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.opt2.setMargin(new Insets(0, 0, 0, 0));
        this.opt2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPositionPanel.this.opt2_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.opt2, gridBagConstraints);
        this.opt7.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.opt7.setMargin(new Insets(0, 0, 0, 0));
        this.opt7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPositionPanel.this.opt7_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.opt7, gridBagConstraints);
        this.opt5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.opt5.setMargin(new Insets(0, 0, 0, 0));
        this.opt5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPositionPanel.this.opt5_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.opt5, gridBagConstraints);
        this.opt6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.opt6.setMargin(new Insets(0, 0, 0, 0));
        this.opt6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPositionPanel.this.opt6_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.opt6, gridBagConstraints);
        this.opt3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.opt3.setMargin(new Insets(0, 0, 0, 0));
        this.opt3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPositionPanel.this.opt3_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.opt3, gridBagConstraints);
        this.opt8.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.opt8.setMargin(new Insets(0, 0, 0, 0));
        this.opt8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPositionPanel.this.opt8_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.opt8, gridBagConstraints);
        this.opt9.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.opt9.setMargin(new Insets(0, 0, 0, 0));
        this.opt9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPositionPanel.this.opt9_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.opt9, gridBagConstraints);
        this.lblText.setText("Texteinf\u00fcgepunkt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 2, 3, 2);
        this.add((Component)this.lblText, gridBagConstraints);
        this.txtValue.setColumns(10);
        this.txtValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TextPositionPanel.this.txtValue_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtValue, gridBagConstraints);
    }

    private void opt9_onActionPerformed(ActionEvent evt) {
        if (!this.bolFireEvents) {
            return;
        }
        this.setValue(this.mapValues.get(this.opt9));
    }

    private void opt8_onActionPerformed(ActionEvent evt) {
        if (!this.bolFireEvents) {
            return;
        }
        this.setValue(this.mapValues.get(this.opt8));
    }

    private void opt7_onActionPerformed(ActionEvent evt) {
        if (!this.bolFireEvents) {
            return;
        }
        this.setValue(this.mapValues.get(this.opt7));
    }

    private void opt6_onActionPerformed(ActionEvent evt) {
        if (!this.bolFireEvents) {
            return;
        }
        this.setValue(this.mapValues.get(this.opt6));
    }

    private void opt5_onActionPerformed(ActionEvent evt) {
        if (!this.bolFireEvents) {
            return;
        }
        this.setValue(this.mapValues.get(this.opt5));
    }

    private void opt4_onActionPerformed(ActionEvent evt) {
        if (!this.bolFireEvents) {
            return;
        }
        this.setValue(this.mapValues.get(this.opt4));
    }

    private void opt3_onActionPerformed(ActionEvent evt) {
        if (!this.bolFireEvents) {
            return;
        }
        this.setValue(this.mapValues.get(this.opt3));
    }

    private void opt2_onActionPerformed(ActionEvent evt) {
        if (!this.bolFireEvents) {
            return;
        }
        this.setValue(this.mapValues.get(this.opt2));
    }

    private void opt1_onActionPerformed(ActionEvent evt) {
        if (!this.bolFireEvents) {
            return;
        }
        this.setValue(this.mapValues.get(this.opt1));
    }

    private void txtValue_onKeyReleased(KeyEvent evt) {
        if (!this.bolFireEvents) {
            return;
        }
        this.setValueTxtInternal(this.txtValue.getText());
    }
}

