/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style.text;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.text.TextStylePanel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStyleTextPanel
extends AbstractStylePanel
implements BasicStylePanel {
    private static final Logger LOG = LoggerFactory.getLogger(BasicStyleTextPanel.class);
    private LayerStyleCollection sCol;
    private boolean bolUpdateControls = true;
    private boolean bolRenderText = false;
    private KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code != 27 && code == 10) {
                BasicStyleTextPanel.this.updateControls();
            }
        }
    };
    private JCheckBox cboText;
    private TextStylePanel textStylePanel;

    public BasicStyleTextPanel() {
        this.initComponents();
    }

    public BasicStyleTextPanel(LayerStyleCollection _sCol, PlugInContext _context) {
        this.bolUpdateControls = false;
        try {
            this.initComponents();
            this.i18n();
            this.init();
            this.setStyleCollection(_sCol);
            this.updateControls();
            GUISupport.addKeyListenersRecursively((Component)this, (KeyListener)this.keyListener);
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void i18n() {
        this.cboText.setText(I18N.get("ui.style.BasicStyleTextPanel.text"));
    }

    public final void init() {
        this.textStylePanel.setStyleCollection(this.sCol);
        this.textStylePanel.addStyleChangedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicStyleTextPanel.this.updateControls();
            }
        });
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        try {
            this.bolUpdateControls = false;
            this.cboText.setSelected(this.bolRenderText);
            this.setEnabledState();
            this.fireStyleChanged();
            this.setEnabledState();
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void setEnabledState() {
        this.textStylePanel.setEnabled(this.bolRenderText);
    }

    @Override
    public void setTransparency(int _alpha, boolean bolArea, boolean bolLine, boolean bolText, boolean bolSymbol) {
        this.textStylePanel.setTransparency(_alpha, bolText);
    }

    @Override
    public void updateBasicStyle(BasicStyleModel basicStyle) {
        basicStyle.setRenderingText(this.bolRenderText);
        TextStyleModel txtStyle = this.textStylePanel.getTextStyle();
        basicStyle.setTextStyle(txtStyle);
    }

    @Override
    public boolean isStyleActive() {
        return this.bolRenderText;
    }

    @Override
    public void setBasicStyle(BasicStyleModel basicStyle) {
        this.bolRenderText = basicStyle.isRenderingText();
        if (this.bolRenderText && basicStyle.getTextStyle() != null) {
            this.textStylePanel.setTextStyle(basicStyle.getTextStyle());
            this.textStylePanel.setTransparency(basicStyle.getIntAlpha(), basicStyle.isBolUseAlphaText());
        }
        this.updateControls();
    }

    @Override
    public String validateInput() {
        try {
            SimpleFeatureType fSchema = this.getFeatureRetriever().getFeatureType();
            String strError = null;
            if (this.bolRenderText) {
                strError = this.textStylePanel.validateInput();
            }
            return strError;
        }
        catch (Exception e) {
            LOG.warn("Error at validation of VectorStylePanel", (Throwable)e);
            return e.getMessage();
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.BasicStyleTextPanel.title");
    }

    @Override
    public final void setStyleCollection(StyleCollection _sCol) {
        this.sCol = (LayerStyleCollection)_sCol;
        this.bolUpdateControls = false;
        try {
            this.textStylePanel.setStyleCollection(this.sCol);
            this.setBasicStyle(this.sCol.getBasicStyle());
        }
        finally {
            this.bolUpdateControls = true;
        }
        this.updateControls();
    }

    @Override
    public void setFeatureRetriever(FeatureRetriever featureTypeRetriever) {
        this.textStylePanel.setFeatureRetriever(featureTypeRetriever);
        super.setFeatureRetriever(featureTypeRetriever);
    }

    @Override
    public void updateStyles() {
        throw new UnsupportedOperationException();
    }

    private void initComponents() {
        this.cboText = new JCheckBox();
        this.textStylePanel = new TextStylePanel();
        this.setLayout(new GridBagLayout());
        this.cboText.setText("Beschriftung anzeigen");
        this.cboText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboText.setMargin(new Insets(0, 0, 0, 0));
        this.cboText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleTextPanel.this.cboText_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 7, 3, 2);
        this.add((Component)this.cboText, gridBagConstraints);
        this.textStylePanel.setStyleCollection(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.textStylePanel, gridBagConstraints);
    }

    private void cboText_onActionPerformed(ActionEvent evt) {
        this.bolRenderText = this.cboText.isSelected();
        this.updateControls();
    }
}

