/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style.symbol;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanelWithDB;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.style.AttributePanel;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import de.riwagis.geotools.feature.bsh.FeatBshValidator;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.model.util.ColorHelper;
import de.riwagis.riwajump.symbol.SymbolStore;
import de.riwagis.riwajump.symbol.gui.SymbolListDialog;
import de.riwagis.riwajump.symbol.model.SMDCollection;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.opengis.feature.simple.SimpleFeatureType;

public class SymbolStylePanel
extends AbstractStylePanel {
    private String strTitle = "Symbols";
    private String strDegree = "degree";
    private String strGon = "gon";
    private String strPixel = "pixel";
    private String strUnits = "units";
    private String strPosCentroid = "centroid";
    private String strPosFirstPoint = "first point";
    private boolean bolUpdateControls = false;
    private boolean blockEvents = false;
    private LayerStyleCollection sCol = null;
    private SymbolStyleModel symStyle = new SymbolStyleModel();
    private SymbolListDialog dlgSymList = null;
    private final List<Component> lstEnabled = new ArrayList<Component>();
    private AttributePanel attPanel;
    private JButton butAreaSymbol;
    private JButton butEndSymbol;
    private JButton butLineSymbol;
    private JButton butPtSymbol;
    private JButton butStartSymbol;
    private JCheckBox cboAreaInOri;
    private JCheckBox cboAreaRatio;
    private JCheckBox cboEndRatio;
    private JCheckBox cboLineRatio;
    private JCheckBox cboPtInOri;
    private JCheckBox cboPtRatio;
    private JCheckBox cboStartRatio;
    private JCheckBox chkOverwriteAreaColor;
    private JCheckBox chkOverwriteLineColor;
    private ColorChooserPanelWithDB clrModelFill;
    private ColorChooserPanelWithDB clrModelLine;
    private JComboBox cmbAreaPos;
    private JComboBox cmbLength;
    private JComboBox cmbLengthSymbol;
    private JComboBox cmbOri;
    private JComboBox cmbSymbolSource;
    private JLabel jLabel1;
    private JLabel lblAngle;
    private JLabel lblAreaHeight;
    private JLabel lblAreaLeft;
    private JLabel lblAreaOri;
    private JLabel lblAreaShift;
    private JLabel lblAreaSymbol;
    private JLabel lblAreaTop;
    private JLabel lblAreaWidth;
    private JLabel lblEndHeight;
    private JLabel lblEndOri;
    private JLabel lblEndSymbol;
    private JLabel lblEndWidth;
    private JLabel lblLineDist;
    private JLabel lblLineHeight;
    private JLabel lblLineOffset;
    private JLabel lblLineSymbol;
    private JLabel lblLineWidth;
    private JLabel lblPtHeight;
    private JLabel lblPtLeft;
    private JLabel lblPtOri;
    private JLabel lblPtShift;
    private JLabel lblPtSymbol;
    private JLabel lblPtTop;
    private JLabel lblPtWidth;
    private JLabel lblSize;
    private JLabel lblSizeSymbol;
    private JLabel lblStartHeight;
    private JLabel lblStartOri;
    private JLabel lblStartSymbol;
    private JLabel lblStartWidth;
    private JLabel lblSymbolSource;
    private JPanel pnlArea;
    private JPanel pnlEnd;
    private JPanel pnlLine;
    private JPanel pnlPoint;
    private JPanel pnlSource;
    private JPanel pnlStart;
    private JPanel pnlUnits;
    private JTabbedPane tabPane;
    private JTextField txtAreaHeight;
    private JTextField txtAreaLeft;
    private JTextField txtAreaOri;
    private JTextField txtAreaSymbol;
    private JTextField txtAreaTop;
    private JTextField txtAreaWidth;
    private JTextField txtEndHeight;
    private JTextField txtEndOri;
    private JTextField txtEndSymbol;
    private JTextField txtEndWidth;
    private JTextField txtLineDist;
    private JTextField txtLineHeight;
    private JTextField txtLineOffset;
    private JTextField txtLineSymbol;
    private JTextField txtLineWidth;
    private JTextField txtPtHeight;
    private JTextField txtPtLeft;
    private JTextField txtPtOri;
    private JTextField txtPtSymbol;
    private JTextField txtPtTop;
    private JTextField txtPtWidth;
    private JTextField txtStartHeight;
    private JTextField txtStartOri;
    private JTextField txtStartSymbol;
    private JTextField txtStartWidth;

    public SymbolStylePanel() {
        this(null, null);
    }

    public SymbolStylePanel(LayerStyleCollection _sCol, PlugInContext _context) {
        this.sCol = _sCol;
        this.initComponents();
        this.i18n();
        this.init();
        this.setStyleCollection(this.sCol);
    }

    @Override
    public void updateStyles() {
        throw new UnsupportedOperationException();
    }

    private void i18n() {
        this.strDegree = I18N.get("common.degree");
        this.strGon = I18N.get("common.gon");
        this.strPixel = I18N.get("common.pixel");
        this.strUnits = I18N.get("common.drawing-units");
        this.strPosCentroid = I18N.get("ui.style.SymbolStylePanel.position-centroid");
        this.strPosFirstPoint = I18N.get("ui.style.SymbolStylePanel.position-first-point");
        this.strTitle = I18N.get("ui.style.SymbolStylePanel.title");
        this.lblSymbolSource.setText(I18N.get("ui.style.SymbolStylePanel.symbolsource"));
        ((TitledBorder)this.pnlUnits.getBorder()).setTitle(I18N.get("ui.style.SymbolStylePanel.units"));
        this.lblAngle.setText(I18N.get("ui.style.SymbolStylePanel.angle-in"));
        this.lblSizeSymbol.setText(I18N.get("ui.style.SymbolStylePanel.symbol-size-in"));
        this.lblSize.setText(I18N.get("ui.style.SymbolStylePanel.size-in"));
        this.lblPtSymbol.setText(I18N.get("ui.style.SymbolStylePanel.symbol"));
        this.cboPtRatio.setText(I18N.get("ui.style.SymbolStylePanel.keep-ratio"));
        this.lblPtWidth.setText(I18N.get("ui.style.SymbolStylePanel.width"));
        this.lblPtHeight.setText(I18N.get("ui.style.SymbolStylePanel.height"));
        this.lblPtLeft.setText(I18N.get("ui.style.SymbolStylePanel.shift-left"));
        this.lblPtTop.setText(I18N.get("ui.style.SymbolStylePanel.shift-top"));
        this.lblPtOri.setText(I18N.get("ui.style.SymbolStylePanel.ori"));
        this.lblPtShift.setText(I18N.get("ui.style.SymbolStylePanel.shift"));
        this.cboPtInOri.setText(I18N.get("ui.style.SymbolStylePanel.shift-in-ori"));
        this.lblStartSymbol.setText(I18N.get("ui.style.SymbolStylePanel.symbol"));
        this.cboStartRatio.setText(I18N.get("ui.style.SymbolStylePanel.keep-ratio"));
        this.lblStartWidth.setText(I18N.get("ui.style.SymbolStylePanel.width"));
        this.lblStartHeight.setText(I18N.get("ui.style.SymbolStylePanel.height"));
        this.lblStartOri.setText(I18N.get("ui.style.SymbolStylePanel.ori"));
        this.lblEndSymbol.setText(I18N.get("ui.style.SymbolStylePanel.symbol"));
        this.cboEndRatio.setText(I18N.get("ui.style.SymbolStylePanel.keep-ratio"));
        this.lblEndWidth.setText(I18N.get("ui.style.SymbolStylePanel.width"));
        this.lblEndHeight.setText(I18N.get("ui.style.SymbolStylePanel.height"));
        this.lblEndOri.setText(I18N.get("ui.style.SymbolStylePanel.ori"));
        this.lblLineSymbol.setText(I18N.get("ui.style.SymbolStylePanel.symbol"));
        this.cboLineRatio.setText(I18N.get("ui.style.SymbolStylePanel.keep-ratio"));
        this.lblLineWidth.setText(I18N.get("ui.style.SymbolStylePanel.width"));
        this.lblLineHeight.setText(I18N.get("ui.style.SymbolStylePanel.height"));
        this.lblLineDist.setText(I18N.get("ui.style.SymbolStylePanel.distance"));
        this.lblLineOffset.setText(I18N.get("ui.style.SymbolStylePanel.shift-to-line"));
        this.lblAreaSymbol.setText(I18N.get("ui.style.SymbolStylePanel.symbol"));
        this.cboAreaRatio.setText(I18N.get("ui.style.SymbolStylePanel.keep-ratio"));
        this.lblAreaWidth.setText(I18N.get("ui.style.SymbolStylePanel.width"));
        this.lblAreaHeight.setText(I18N.get("ui.style.SymbolStylePanel.height"));
        this.lblAreaLeft.setText(I18N.get("ui.style.SymbolStylePanel.shift-left"));
        this.lblAreaTop.setText(I18N.get("ui.style.SymbolStylePanel.shift-top"));
        this.lblAreaOri.setText(I18N.get("ui.style.SymbolStylePanel.ori"));
        this.lblAreaShift.setText(I18N.get("ui.style.SymbolStylePanel.shift"));
        this.cboAreaInOri.setText(I18N.get("ui.style.SymbolStylePanel.shift-in-ori"));
        this.tabPane.setTitleAt(0, I18N.get("ui.style.SymbolStylePanel.points"));
        this.tabPane.setTitleAt(1, I18N.get("ui.style.SymbolStylePanel.line-start"));
        this.tabPane.setTitleAt(2, I18N.get("ui.style.SymbolStylePanel.line-end"));
        this.tabPane.setTitleAt(3, I18N.get("ui.style.SymbolStylePanel.line-course"));
        this.tabPane.setTitleAt(4, I18N.get("ui.style.SymbolStylePanel.area"));
        this.chkOverwriteAreaColor.setText(I18N.get("ui.style.SymbolStylePanel.overwrite-area-color"));
        this.chkOverwriteLineColor.setText(I18N.get("ui.style.SymbolStylePanel.overwrite-line-color"));
    }

    private void init() {
        this.blockEvents = true;
        try {
            this.cmbLengthSymbol.addItem(this.strPixel);
            this.cmbLengthSymbol.addItem(this.strUnits);
            this.cmbLength.addItem(this.strPixel);
            this.cmbLength.addItem(this.strUnits);
            this.cmbOri.addItem(this.strDegree);
            this.cmbOri.addItem(this.strGon);
            this.cmbAreaPos.addItem(this.strPosCentroid);
            this.cmbAreaPos.addItem(this.strPosFirstPoint);
            this.tabPane.remove(3);
            this.bolUpdateControls = true;
            this.clrModelLine.setStylePanel(this);
            this.clrModelFill.setStylePanel(this);
            this.attPanel.addTextComponent(this.txtPtSymbol);
            this.attPanel.addTextComponent(this.txtPtWidth);
            this.attPanel.addTextComponent(this.txtPtHeight);
            this.attPanel.addTextComponent(this.txtPtOri);
            this.attPanel.addTextComponent(this.txtPtLeft);
            this.attPanel.addTextComponent(this.txtPtTop);
            this.attPanel.addTextComponent(this.txtStartSymbol);
            this.attPanel.addTextComponent(this.txtStartWidth);
            this.attPanel.addTextComponent(this.txtStartHeight);
            this.attPanel.addTextComponent(this.txtStartOri);
            this.attPanel.addTextComponent(this.txtEndSymbol);
            this.attPanel.addTextComponent(this.txtEndWidth);
            this.attPanel.addTextComponent(this.txtEndHeight);
            this.attPanel.addTextComponent(this.txtEndOri);
            this.attPanel.addTextComponent(this.txtLineSymbol);
            this.attPanel.addTextComponent(this.txtLineWidth);
            this.attPanel.addTextComponent(this.txtLineHeight);
            this.attPanel.addTextComponent(this.txtLineOffset);
            this.attPanel.addTextComponent(this.txtLineDist);
            this.attPanel.addTextComponent(this.txtAreaSymbol);
            this.attPanel.addTextComponent(this.txtAreaWidth);
            this.attPanel.addTextComponent(this.txtAreaHeight);
            this.attPanel.addTextComponent(this.txtAreaOri);
            this.attPanel.addTextComponent(this.txtAreaLeft);
            this.attPanel.addTextComponent(this.txtAreaTop);
            this.attPanel.addTextComponent(this.clrModelFill.getInternalTextComponent(), true);
            this.attPanel.addTextComponent(this.clrModelLine.getInternalTextComponent(), true);
        }
        finally {
            this.blockEvents = false;
        }
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        this.bolUpdateControls = false;
        try {
            this.cmbLengthSymbol.setSelectedIndex(this.symStyle.getIntUnitSizeSymbol());
            this.cmbLength.setSelectedIndex(this.symStyle.getIntUnitSize());
            this.cmbOri.setSelectedIndex(this.symStyle.getIntUnitAngle());
            this.cmbSymbolSource.setSelectedItem(this.symStyle.getStrStorename());
            this.chkOverwriteAreaColor.setSelected(this.symStyle.isBolOverwriteAreaColor());
            this.chkOverwriteLineColor.setSelected(this.symStyle.isBolOverwriteLineColor());
            if (this.symStyle.getLineColor() == null) {
                this.symStyle.setLineColor(ColorModel.BLUE);
            }
            this.clrModelLine.setColorModel(this.symStyle.getLineColor());
            this.clrModelLine.setAlpha(this.symStyle.getLineColor().getAlpha());
            if (this.symStyle.getFillColor() == null) {
                this.symStyle.setFillColor(ColorModel.BLUE);
            }
            this.clrModelFill.setColorModel(this.symStyle.getFillColor());
            this.clrModelFill.setAlpha(this.symStyle.getFillColor().getAlpha());
            if (this.symStyle.isBolOverwriteLineColor()) {
                this.clrModelLine.setEnabled(true);
            } else {
                this.clrModelLine.setEnabled(false);
            }
            if (this.symStyle.isBolOverwriteAreaColor()) {
                this.clrModelFill.setEnabled(true);
            } else {
                this.clrModelFill.setEnabled(false);
            }
            this.txtPtSymbol.setText(this.symStyle.getStrPtSymbol());
            this.txtPtWidth.setText(this.symStyle.getStrPtWidth());
            this.txtPtHeight.setText(this.symStyle.getStrPtHeight());
            this.txtPtOri.setText(this.symStyle.getStrPtOri());
            this.txtPtLeft.setText(this.symStyle.getStrPtShiftLeft());
            this.txtPtTop.setText(this.symStyle.getStrPtShiftTop());
            this.cboPtRatio.setSelected(this.symStyle.isBolPtRatio());
            if (this.symStyle.isBolPtRatio()) {
                this.txtPtHeight.setEnabled(false);
            } else {
                this.txtPtHeight.setEnabled(true);
            }
            this.cboPtInOri.setSelected(this.symStyle.isBolPtShiftInOri());
            this.txtStartSymbol.setText(this.symStyle.getStrStartSymbol());
            this.txtStartWidth.setText(this.symStyle.getStrStartWidth());
            this.txtStartHeight.setText(this.symStyle.getStrStartHeight());
            this.txtStartOri.setText(this.symStyle.getStrStartOri());
            this.cboStartRatio.setSelected(this.symStyle.isBolStartRatio());
            if (this.symStyle.isBolStartRatio()) {
                this.txtStartHeight.setEnabled(false);
            } else {
                this.txtStartHeight.setEnabled(true);
            }
            this.txtEndSymbol.setText(this.symStyle.getStrEndSymbol());
            this.txtEndWidth.setText(this.symStyle.getStrEndWidth());
            this.txtEndHeight.setText(this.symStyle.getStrEndHeight());
            this.txtEndOri.setText(this.symStyle.getStrEndOri());
            this.cboEndRatio.setSelected(this.symStyle.isBolEndRatio());
            if (this.symStyle.isBolEndRatio()) {
                this.txtEndHeight.setEnabled(false);
            } else {
                this.txtEndHeight.setEnabled(true);
            }
            this.txtLineSymbol.setText(this.symStyle.getStrLineSymbol());
            this.txtLineWidth.setText(this.symStyle.getStrLineWidth());
            this.txtLineHeight.setText(this.symStyle.getStrLineHeight());
            this.txtLineDist.setText(this.symStyle.getStrLineDist());
            this.txtLineOffset.setText(this.symStyle.getStrLineShift());
            this.cboLineRatio.setSelected(this.symStyle.isBolLineRatio());
            if (this.symStyle.isBolLineRatio()) {
                this.txtLineHeight.setEnabled(false);
            } else {
                this.txtLineHeight.setEnabled(true);
            }
            this.txtAreaSymbol.setText(this.symStyle.getStrAreaSymbol());
            this.txtAreaWidth.setText(this.symStyle.getStrAreaWidth());
            this.txtAreaHeight.setText(this.symStyle.getStrAreaHeight());
            this.txtAreaOri.setText(this.symStyle.getStrAreaOri());
            this.txtAreaLeft.setText(this.symStyle.getStrAreaShiftLeft());
            this.txtAreaTop.setText(this.symStyle.getStrAreaShiftTop());
            this.cboAreaRatio.setSelected(this.symStyle.isBolAreaRatio());
            if (this.symStyle.isBolAreaRatio()) {
                this.txtAreaHeight.setEnabled(false);
            } else {
                this.txtAreaHeight.setEnabled(true);
            }
            this.cmbAreaPos.setSelectedIndex(this.symStyle.getIntAreaPos());
            this.cboAreaInOri.setSelected(this.symStyle.isBolAreaShiftInOri());
            if (this.sCol.getLayerable() instanceof LabelLayer) {
                this.cmbOri.setEnabled(false);
                this.tabPane.setEnabledAt(1, false);
                this.tabPane.setEnabledAt(2, false);
                this.tabPane.setEnabledAt(3, false);
                this.tabPane.setSelectedIndex(0);
            } else {
                this.cmbOri.setEnabled(true);
                this.tabPane.setEnabledAt(1, true);
                this.tabPane.setEnabledAt(2, true);
                this.tabPane.setEnabledAt(3, true);
            }
            this.fireStyleChanged();
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    @Override
    public String getTitle() {
        return this.strTitle;
    }

    public void setTransparency(int _alpha, boolean bolSymbol) {
        if (bolSymbol) {
            if (this.symStyle.getLineColor() != null) {
                this.symStyle.setLineColor(ColorHelper.getAlphaColorModel((ColorModel)this.symStyle.getLineColor(), (int)_alpha));
            }
            this.clrModelLine.setAlpha(_alpha);
            if (this.symStyle.getFillColor() != null) {
                this.symStyle.setFillColor(ColorHelper.getAlphaColorModel((ColorModel)this.symStyle.getFillColor(), (int)_alpha));
            }
            this.clrModelFill.setAlpha(_alpha);
        } else {
            if (this.symStyle.getLineColor() != null) {
                this.symStyle.setLineColor(ColorHelper.getAlphaColorModel((ColorModel)this.symStyle.getLineColor(), (int)255));
            }
            this.clrModelLine.setAlpha(255);
            if (this.symStyle.getFillColor() != null) {
                this.symStyle.setFillColor(ColorHelper.getAlphaColorModel((ColorModel)this.symStyle.getFillColor(), (int)255));
            }
            this.clrModelFill.setAlpha(255);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled && this.isEnabled()) {
            this.lstEnabled.clear();
            this.disableContainer(this);
            super.setEnabled(false);
        }
        if (enabled && !this.isEnabled()) {
            for (Component comp : this.lstEnabled) {
                comp.setEnabled(true);
            }
            this.lstEnabled.clear();
            super.setEnabled(true);
        }
    }

    public void disableContainer(Container pnl) {
        Component[] arrComp;
        for (Component comp : arrComp = pnl.getComponents()) {
            if (!comp.isEnabled()) continue;
            this.lstEnabled.add(comp);
            if (comp instanceof Container) {
                this.disableContainer((Container)comp);
            }
            comp.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setStyleCollection(StyleCollection _sCol) {
        this.blockEvents = true;
        try {
            this.sCol = (LayerStyleCollection)_sCol;
            if (this.sCol != null) {
                this.cmbSymbolSource.removeAllItems();
                this.cmbSymbolSource.addItem("_buildIn");
                SMDCollection smdCol = this.getSMDCollection();
                for (SymbolstoreMetadata smd : smdCol) {
                    this.cmbSymbolSource.addItem(smd.getName());
                }
            }
        }
        finally {
            this.blockEvents = false;
        }
        if (this.sCol != null) {
            this.setSymbolStyle(this.sCol.getBasicStyle().getSymStyle());
        }
    }

    @Override
    public void setFeatureRetriever(FeatureRetriever featureTypeRetriever) {
        super.setFeatureRetriever(featureTypeRetriever);
        this.fillAttributes();
    }

    private SMDCollection getSMDCollection() {
        return this.sCol.getLayer().getLayerManager().getTask().getLocalSymbolStores();
    }

    public void setSymbolStyle(SymbolStyleModel _symStyle) {
        this.symStyle = _symStyle == null ? new SymbolStyleModel() : (SymbolStyleModel)_symStyle.cloneModel();
        this.updateControls();
    }

    public SymbolStyleModel getSymbolStyle() {
        return this.symStyle;
    }

    private void fillAttributes() {
        SimpleFeatureType fSchema = this.getFeatureRetriever().getFeatureType();
        this.attPanel.fillAttributes(fSchema);
    }

    @Override
    public String validateInput() {
        SimpleFeatureType fSchema = this.getFeatureRetriever().getFeatureType();
        String strError = null;
        if ((StringUtils.isNotBlank((CharSequence)this.symStyle.getStrPtSymbol()) || StringUtils.isNotBlank((CharSequence)this.symStyle.getStrStartSymbol()) || StringUtils.isNotBlank((CharSequence)this.symStyle.getStrEndSymbol()) || StringUtils.isNotBlank((CharSequence)this.symStyle.getStrAreaSymbol())) && StringUtils.isBlank((CharSequence)this.symStyle.getStrStorename())) {
            return I18N.get("ui.style.SymbolStylePanel.validation.error-symbol-but-no-store");
        }
        strError = FeatBshValidator.validateTextExpression((String)this.symStyle.getStrPtSymbol(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrPtSymbol(), strError);
        }
        strError = FeatBshValidator.validateTextExpression((String)this.symStyle.getStrStartSymbol(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrStartSymbol(), strError);
        }
        strError = FeatBshValidator.validateTextExpression((String)this.symStyle.getStrEndSymbol(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrEndSymbol(), strError);
        }
        strError = FeatBshValidator.validateTextExpression((String)this.symStyle.getStrAreaSymbol(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrAreaSymbol(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrPtWidth(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrPtWidth(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrPtHeight(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrPtHeight(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrPtOri(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrPtOri(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrPtShiftLeft(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrPtShiftLeft(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrPtShiftTop(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrPtShiftTop(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrStartWidth(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrStartWidth(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrStartHeight(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrStartHeight(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrStartOri(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrStartOri(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrEndWidth(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrEndWidth(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrEndHeight(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrEndHeight(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrEndOri(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrEndOri(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrLineWidth(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrLineWidth(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrLineHeight(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrLineHeight(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrLineDist(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrLineDist(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrLineShift(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrLineShift(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrAreaWidth(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrAreaWidth(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrAreaHeight(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrAreaHeight(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrAreaOri(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrAreaOri(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrAreaShiftLeft(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrAreaShiftLeft(), strError);
        }
        strError = FeatBshValidator.validateCalcExpression((String)this.symStyle.getStrAreaShiftTop(), (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getStrAreaShiftTop(), strError);
        }
        if (this.symStyle.isBolOverwriteLineColor() && (strError = FeatBshValidator.validateTextExpression((String)this.symStyle.getLineColor().getBsh(), (SimpleFeatureType)fSchema)) != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getLineColor().getBsh(), strError);
        }
        if (this.symStyle.isBolOverwriteAreaColor() && (strError = FeatBshValidator.validateTextExpression((String)this.symStyle.getFillColor().getBsh(), (SimpleFeatureType)fSchema)) != null) {
            return this.getErrorMessageWithDetails(this.symStyle.getFillColor().getBsh(), strError);
        }
        return strError;
    }

    private String getErrorMessageWithDetails(String expression, String errorMessage) {
        return I18N.getMessage("ui.style.SymbolStylePanel.validation.invalid-expression", expression, errorMessage.trim());
    }

    private SymbolListDialog getSymList() {
        Window parent = SwingUtilities.windowForComponent(this);
        if (parent instanceof Frame) {
            this.dlgSymList = new SymbolListDialog((Frame)parent, true);
        }
        if (parent instanceof Dialog) {
            this.dlgSymList = new SymbolListDialog((Dialog)parent, true);
        }
        GUIUtil.centreOnScreen(this.dlgSymList);
        return this.dlgSymList;
    }

    private void initComponents() {
        this.pnlSource = new JPanel();
        this.lblSymbolSource = new JLabel();
        this.cmbSymbolSource = new JComboBox();
        this.chkOverwriteAreaColor = new JCheckBox();
        this.chkOverwriteLineColor = new JCheckBox();
        this.clrModelLine = new ColorChooserPanelWithDB();
        this.clrModelFill = new ColorChooserPanelWithDB();
        this.tabPane = new JTabbedPane();
        this.pnlPoint = new JPanel();
        this.lblPtHeight = new JLabel();
        this.txtPtSymbol = new JTextField();
        this.butPtSymbol = new JButton();
        this.lblPtWidth = new JLabel();
        this.txtPtHeight = new JTextField();
        this.lblPtSymbol = new JLabel();
        this.txtPtWidth = new JTextField();
        this.cboPtRatio = new JCheckBox();
        this.txtPtLeft = new JTextField();
        this.lblPtLeft = new JLabel();
        this.lblPtTop = new JLabel();
        this.txtPtTop = new JTextField();
        this.lblPtOri = new JLabel();
        this.txtPtOri = new JTextField();
        this.cboPtInOri = new JCheckBox();
        this.lblPtShift = new JLabel();
        this.pnlStart = new JPanel();
        this.txtStartSymbol = new JTextField();
        this.lblStartSymbol = new JLabel();
        this.butStartSymbol = new JButton();
        this.lblStartHeight = new JLabel();
        this.txtStartHeight = new JTextField();
        this.txtStartWidth = new JTextField();
        this.txtStartOri = new JTextField();
        this.lblStartOri = new JLabel();
        this.lblStartWidth = new JLabel();
        this.cboStartRatio = new JCheckBox();
        this.pnlEnd = new JPanel();
        this.lblEndSymbol = new JLabel();
        this.txtEndSymbol = new JTextField();
        this.butEndSymbol = new JButton();
        this.lblEndWidth = new JLabel();
        this.txtEndWidth = new JTextField();
        this.lblEndOri = new JLabel();
        this.txtEndOri = new JTextField();
        this.cboEndRatio = new JCheckBox();
        this.txtEndHeight = new JTextField();
        this.lblEndHeight = new JLabel();
        this.pnlLine = new JPanel();
        this.lblLineSymbol = new JLabel();
        this.txtLineSymbol = new JTextField();
        this.lblLineWidth = new JLabel();
        this.txtLineWidth = new JTextField();
        this.lblLineOffset = new JLabel();
        this.lblLineHeight = new JLabel();
        this.txtLineHeight = new JTextField();
        this.lblLineDist = new JLabel();
        this.cboLineRatio = new JCheckBox();
        this.butLineSymbol = new JButton();
        this.txtLineOffset = new JTextField();
        this.txtLineDist = new JTextField();
        this.pnlArea = new JPanel();
        this.lblAreaHeight = new JLabel();
        this.txtAreaSymbol = new JTextField();
        this.butAreaSymbol = new JButton();
        this.lblAreaWidth = new JLabel();
        this.txtAreaHeight = new JTextField();
        this.lblAreaSymbol = new JLabel();
        this.txtAreaWidth = new JTextField();
        this.cboAreaRatio = new JCheckBox();
        this.txtAreaLeft = new JTextField();
        this.lblAreaLeft = new JLabel();
        this.lblAreaTop = new JLabel();
        this.txtAreaTop = new JTextField();
        this.lblAreaOri = new JLabel();
        this.txtAreaOri = new JTextField();
        this.jLabel1 = new JLabel();
        this.cmbAreaPos = new JComboBox();
        this.cboAreaInOri = new JCheckBox();
        this.lblAreaShift = new JLabel();
        this.pnlUnits = new JPanel();
        this.cmbOri = new JComboBox();
        this.lblSizeSymbol = new JLabel();
        this.lblAngle = new JLabel();
        this.cmbLength = new JComboBox();
        this.lblSize = new JLabel();
        this.cmbLengthSymbol = new JComboBox();
        this.attPanel = new AttributePanel();
        this.setLayout(new GridBagLayout());
        this.pnlSource.setLayout(new GridBagLayout());
        this.lblSymbolSource.setFont(this.lblSymbolSource.getFont().deriveFont(this.lblSymbolSource.getFont().getStyle() | 1));
        this.lblSymbolSource.setText("Symbolquelle:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.pnlSource.add((Component)this.lblSymbolSource, gridBagConstraints);
        this.cmbSymbolSource.setEditable(true);
        this.cmbSymbolSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cmbSymbolSource_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.pnlSource.add((Component)this.cmbSymbolSource, gridBagConstraints);
        this.chkOverwriteAreaColor.setText("Fl\u00e4chenfarben \u00fcberschreiben");
        this.chkOverwriteAreaColor.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkOverwriteAreaColor.setMargin(new Insets(0, 0, 0, 0));
        this.chkOverwriteAreaColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.chkOverwriteAreaColor_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 0, 3);
        this.pnlSource.add((Component)this.chkOverwriteAreaColor, gridBagConstraints);
        this.chkOverwriteLineColor.setText("Linienfarben \u00fcberschreiben");
        this.chkOverwriteLineColor.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.chkOverwriteLineColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.chkOverwriteLineColor_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 9, 0, 3);
        this.pnlSource.add((Component)this.chkOverwriteLineColor, gridBagConstraints);
        this.clrModelLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.clrModelLineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlSource.add((Component)this.clrModelLine, gridBagConstraints);
        this.clrModelFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.clrModelFillActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlSource.add((Component)this.clrModelFill, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlSource, gridBagConstraints);
        this.tabPane.setTabLayoutPolicy(1);
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SymbolStylePanel.this.tabPane_onStateChanged(evt);
            }
        });
        this.pnlPoint.setLayout(new GridBagLayout());
        this.lblPtHeight.setText("H\u00f6he:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlPoint.add((Component)this.lblPtHeight, gridBagConstraints);
        this.txtPtSymbol.setColumns(10);
        this.txtPtSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtPtSymbol_onFocusLost(evt);
            }
        });
        this.txtPtSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtPtSymbol_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 0);
        this.pnlPoint.add((Component)this.txtPtSymbol, gridBagConstraints);
        this.butPtSymbol.setText("...");
        this.butPtSymbol.setMargin(new Insets(0, 2, 0, 2));
        this.butPtSymbol.setMaximumSize(new Dimension(22, 22));
        this.butPtSymbol.setMinimumSize(new Dimension(22, 22));
        this.butPtSymbol.setPreferredSize(new Dimension(22, 22));
        this.butPtSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.butPtSymbol_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 2, 3, 3);
        this.pnlPoint.add((Component)this.butPtSymbol, gridBagConstraints);
        this.lblPtWidth.setText("Breite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlPoint.add((Component)this.lblPtWidth, gridBagConstraints);
        this.txtPtHeight.setColumns(5);
        this.txtPtHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtPtHeight_onFocusLost(evt);
            }
        });
        this.txtPtHeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtPtHeight_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPoint.add((Component)this.txtPtHeight, gridBagConstraints);
        this.lblPtSymbol.setText("Symbol:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlPoint.add((Component)this.lblPtSymbol, gridBagConstraints);
        this.txtPtWidth.setColumns(5);
        this.txtPtWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtPtWidth_onFocusLost(evt);
            }
        });
        this.txtPtWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtPtWidth_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPoint.add((Component)this.txtPtWidth, gridBagConstraints);
        this.cboPtRatio.setText("Seitenverh\u00e4ltnisse beibehalten");
        this.cboPtRatio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboPtRatio.setMargin(new Insets(0, 0, 0, 0));
        this.cboPtRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cboPtRatio_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPoint.add((Component)this.cboPtRatio, gridBagConstraints);
        this.txtPtLeft.setColumns(15);
        this.txtPtLeft.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtPtLeft_onFocusLost(evt);
            }
        });
        this.txtPtLeft.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtPtLeft_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPoint.add((Component)this.txtPtLeft, gridBagConstraints);
        this.lblPtLeft.setText("Versatz links:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPoint.add((Component)this.lblPtLeft, gridBagConstraints);
        this.lblPtTop.setText("Versatz oben:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPoint.add((Component)this.lblPtTop, gridBagConstraints);
        this.txtPtTop.setColumns(15);
        this.txtPtTop.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtPtTop_onFocusLost(evt);
            }
        });
        this.txtPtTop.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtPtTop_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPoint.add((Component)this.txtPtTop, gridBagConstraints);
        this.lblPtOri.setText("Orientierung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlPoint.add((Component)this.lblPtOri, gridBagConstraints);
        this.txtPtOri.setColumns(15);
        this.txtPtOri.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtPtOri_onFocusLost(evt);
            }
        });
        this.txtPtOri.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtPtOri_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPoint.add((Component)this.txtPtOri, gridBagConstraints);
        this.cboPtInOri.setText("in Orientierungsrichtung");
        this.cboPtInOri.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboPtInOri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cboPtInOriActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPoint.add((Component)this.cboPtInOri, gridBagConstraints);
        this.lblPtShift.setText("Versatz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPoint.add((Component)this.lblPtShift, gridBagConstraints);
        this.tabPane.addTab("Punkte", this.pnlPoint);
        this.pnlStart.setLayout(new GridBagLayout());
        this.txtStartSymbol.setColumns(10);
        this.txtStartSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtStartSymbol_onFocusLost(evt);
            }
        });
        this.txtStartSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtStartSymbol_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 0);
        this.pnlStart.add((Component)this.txtStartSymbol, gridBagConstraints);
        this.lblStartSymbol.setText("Symbol:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlStart.add((Component)this.lblStartSymbol, gridBagConstraints);
        this.butStartSymbol.setText("...");
        this.butStartSymbol.setMargin(new Insets(0, 2, 0, 2));
        this.butStartSymbol.setMaximumSize(new Dimension(22, 22));
        this.butStartSymbol.setMinimumSize(new Dimension(22, 22));
        this.butStartSymbol.setPreferredSize(new Dimension(22, 22));
        this.butStartSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.butStartSymbol_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 2, 3, 3);
        this.pnlStart.add((Component)this.butStartSymbol, gridBagConstraints);
        this.lblStartHeight.setText("H\u00f6he:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlStart.add((Component)this.lblStartHeight, gridBagConstraints);
        this.txtStartHeight.setColumns(5);
        this.txtStartHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtStartHeight_onFocusLost(evt);
            }
        });
        this.txtStartHeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtStartHeight_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlStart.add((Component)this.txtStartHeight, gridBagConstraints);
        this.txtStartWidth.setColumns(5);
        this.txtStartWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtStartWidth_onFocusLost(evt);
            }
        });
        this.txtStartWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtStartWidth_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlStart.add((Component)this.txtStartWidth, gridBagConstraints);
        this.txtStartOri.setColumns(15);
        this.txtStartOri.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtStartOri_onFocusLost(evt);
            }
        });
        this.txtStartOri.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtStartOri_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlStart.add((Component)this.txtStartOri, gridBagConstraints);
        this.lblStartOri.setText("Orientierung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlStart.add((Component)this.lblStartOri, gridBagConstraints);
        this.lblStartWidth.setText("Breite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlStart.add((Component)this.lblStartWidth, gridBagConstraints);
        this.cboStartRatio.setText("Seitenverh\u00e4ltnisse beibehalten");
        this.cboStartRatio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboStartRatio.setMargin(new Insets(0, 0, 0, 0));
        this.cboStartRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cboStartRatio_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlStart.add((Component)this.cboStartRatio, gridBagConstraints);
        this.tabPane.addTab("Linienanfang", this.pnlStart);
        this.pnlEnd.setLayout(new GridBagLayout());
        this.lblEndSymbol.setText("Symbol:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlEnd.add((Component)this.lblEndSymbol, gridBagConstraints);
        this.txtEndSymbol.setColumns(10);
        this.txtEndSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtEndSymbol_onFocusLost(evt);
            }
        });
        this.txtEndSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtEndSymbol_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 0);
        this.pnlEnd.add((Component)this.txtEndSymbol, gridBagConstraints);
        this.butEndSymbol.setText("...");
        this.butEndSymbol.setMargin(new Insets(0, 2, 0, 2));
        this.butEndSymbol.setMaximumSize(new Dimension(22, 22));
        this.butEndSymbol.setMinimumSize(new Dimension(22, 22));
        this.butEndSymbol.setPreferredSize(new Dimension(22, 22));
        this.butEndSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.butEndSymbol_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 2, 3, 3);
        this.pnlEnd.add((Component)this.butEndSymbol, gridBagConstraints);
        this.lblEndWidth.setText("Breite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlEnd.add((Component)this.lblEndWidth, gridBagConstraints);
        this.txtEndWidth.setColumns(5);
        this.txtEndWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtEndWidth_onFocusLost(evt);
            }
        });
        this.txtEndWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtEndWidth_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlEnd.add((Component)this.txtEndWidth, gridBagConstraints);
        this.lblEndOri.setText("Orientierung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlEnd.add((Component)this.lblEndOri, gridBagConstraints);
        this.txtEndOri.setColumns(15);
        this.txtEndOri.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtEndOri_onFocusLost(evt);
            }
        });
        this.txtEndOri.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtEndOri_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlEnd.add((Component)this.txtEndOri, gridBagConstraints);
        this.cboEndRatio.setText("Seitenverh\u00e4ltnisse beibehalten");
        this.cboEndRatio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboEndRatio.setMargin(new Insets(0, 0, 0, 0));
        this.cboEndRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cboEndRatio_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlEnd.add((Component)this.cboEndRatio, gridBagConstraints);
        this.txtEndHeight.setColumns(5);
        this.txtEndHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtEndHeight_onFocusLost(evt);
            }
        });
        this.txtEndHeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtEndHeight_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlEnd.add((Component)this.txtEndHeight, gridBagConstraints);
        this.lblEndHeight.setText("H\u00f6he:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlEnd.add((Component)this.lblEndHeight, gridBagConstraints);
        this.tabPane.addTab("Linienende", this.pnlEnd);
        this.pnlLine.setLayout(new GridBagLayout());
        this.lblLineSymbol.setText("Symbol:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlLine.add((Component)this.lblLineSymbol, gridBagConstraints);
        this.txtLineSymbol.setColumns(10);
        this.txtLineSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtLineSymbol_onFocusLost(evt);
            }
        });
        this.txtLineSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtLineSymbol_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 0);
        this.pnlLine.add((Component)this.txtLineSymbol, gridBagConstraints);
        this.lblLineWidth.setText("Breite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlLine.add((Component)this.lblLineWidth, gridBagConstraints);
        this.txtLineWidth.setColumns(5);
        this.txtLineWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtLineWidth_onFocusLost(evt);
            }
        });
        this.txtLineWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtLineWidth_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLine.add((Component)this.txtLineWidth, gridBagConstraints);
        this.lblLineOffset.setText("Versatz (senkr.):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlLine.add((Component)this.lblLineOffset, gridBagConstraints);
        this.lblLineHeight.setText("H\u00f6he:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlLine.add((Component)this.lblLineHeight, gridBagConstraints);
        this.txtLineHeight.setColumns(5);
        this.txtLineHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtLineHeight_onFocusLost(evt);
            }
        });
        this.txtLineHeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtLineHeight_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLine.add((Component)this.txtLineHeight, gridBagConstraints);
        this.lblLineDist.setText("Abstand:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlLine.add((Component)this.lblLineDist, gridBagConstraints);
        this.cboLineRatio.setText("Seitenverh\u00e4ltnisse beibehalten");
        this.cboLineRatio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboLineRatio.setMargin(new Insets(0, 0, 0, 0));
        this.cboLineRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cboLineRatio_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLine.add((Component)this.cboLineRatio, gridBagConstraints);
        this.butLineSymbol.setText("...");
        this.butLineSymbol.setMargin(new Insets(0, 2, 0, 2));
        this.butLineSymbol.setMaximumSize(new Dimension(22, 22));
        this.butLineSymbol.setMinimumSize(new Dimension(22, 22));
        this.butLineSymbol.setPreferredSize(new Dimension(22, 22));
        this.butLineSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.butLineSymbol_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 2, 3, 3);
        this.pnlLine.add((Component)this.butLineSymbol, gridBagConstraints);
        this.txtLineOffset.setColumns(15);
        this.txtLineOffset.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtLineOffset_onFocusLost(evt);
            }
        });
        this.txtLineOffset.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtLineOffset_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLine.add((Component)this.txtLineOffset, gridBagConstraints);
        this.txtLineDist.setColumns(15);
        this.txtLineDist.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtLineDist_onFocusLost(evt);
            }
        });
        this.txtLineDist.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtLineDist_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLine.add((Component)this.txtLineDist, gridBagConstraints);
        this.tabPane.addTab("Linienverlauf", this.pnlLine);
        this.pnlArea.setLayout(new GridBagLayout());
        this.lblAreaHeight.setText("H\u00f6he:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlArea.add((Component)this.lblAreaHeight, gridBagConstraints);
        this.txtAreaSymbol.setColumns(10);
        this.txtAreaSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtAreaSymbol_onFocusLost(evt);
            }
        });
        this.txtAreaSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtAreaSymbol_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 0);
        this.pnlArea.add((Component)this.txtAreaSymbol, gridBagConstraints);
        this.butAreaSymbol.setText("...");
        this.butAreaSymbol.setMargin(new Insets(0, 2, 0, 2));
        this.butAreaSymbol.setMaximumSize(new Dimension(22, 22));
        this.butAreaSymbol.setMinimumSize(new Dimension(22, 22));
        this.butAreaSymbol.setPreferredSize(new Dimension(22, 22));
        this.butAreaSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.butAreaSymbol_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 2, 3, 3);
        this.pnlArea.add((Component)this.butAreaSymbol, gridBagConstraints);
        this.lblAreaWidth.setText("Breite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlArea.add((Component)this.lblAreaWidth, gridBagConstraints);
        this.txtAreaHeight.setColumns(5);
        this.txtAreaHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtAreaHeight_onFocusLost(evt);
            }
        });
        this.txtAreaHeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtAreaHeight_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlArea.add((Component)this.txtAreaHeight, gridBagConstraints);
        this.lblAreaSymbol.setText("Symbol:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlArea.add((Component)this.lblAreaSymbol, gridBagConstraints);
        this.txtAreaWidth.setColumns(5);
        this.txtAreaWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtAreaWidth_onFocusLost(evt);
            }
        });
        this.txtAreaWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtAreaWidth_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlArea.add((Component)this.txtAreaWidth, gridBagConstraints);
        this.cboAreaRatio.setText("Seitenverh\u00e4ltnisse beibehalten");
        this.cboAreaRatio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboAreaRatio.setMargin(new Insets(0, 0, 0, 0));
        this.cboAreaRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cboAreaRatio_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlArea.add((Component)this.cboAreaRatio, gridBagConstraints);
        this.txtAreaLeft.setColumns(5);
        this.txtAreaLeft.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtAreaLeft_onFocusLost(evt);
            }
        });
        this.txtAreaLeft.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtAreaLeft_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlArea.add((Component)this.txtAreaLeft, gridBagConstraints);
        this.lblAreaLeft.setText("Versatz links:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlArea.add((Component)this.lblAreaLeft, gridBagConstraints);
        this.lblAreaTop.setText("oben:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlArea.add((Component)this.lblAreaTop, gridBagConstraints);
        this.txtAreaTop.setColumns(5);
        this.txtAreaTop.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtAreaTop_onFocusLost(evt);
            }
        });
        this.txtAreaTop.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtAreaTop_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlArea.add((Component)this.txtAreaTop, gridBagConstraints);
        this.lblAreaOri.setText("Orientierung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlArea.add((Component)this.lblAreaOri, gridBagConstraints);
        this.txtAreaOri.setColumns(15);
        this.txtAreaOri.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SymbolStylePanel.this.txtAreaOri_onFocusLost(evt);
            }
        });
        this.txtAreaOri.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolStylePanel.this.txtAreaOri_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlArea.add((Component)this.txtAreaOri, gridBagConstraints);
        this.jLabel1.setText("Position:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlArea.add((Component)this.jLabel1, gridBagConstraints);
        this.cmbAreaPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cmbAreaPos_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlArea.add((Component)this.cmbAreaPos, gridBagConstraints);
        this.cboAreaInOri.setText("in Orientierungsrichtung");
        this.cboAreaInOri.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboAreaInOri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cboAreaInOriActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlArea.add((Component)this.cboAreaInOri, gridBagConstraints);
        this.lblAreaShift.setText("Versatz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlArea.add((Component)this.lblAreaShift, gridBagConstraints);
        this.tabPane.addTab("Flaechen", this.pnlArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabPane, gridBagConstraints);
        this.pnlUnits.setBorder(BorderFactory.createTitledBorder("Einheiten"));
        this.pnlUnits.setPreferredSize(new Dimension(521, 51));
        this.pnlUnits.setLayout(new GridBagLayout());
        this.cmbOri.setMinimumSize(new Dimension(80, 22));
        this.cmbOri.setPreferredSize(new Dimension(80, 22));
        this.cmbOri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cmbOri_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnits.add((Component)this.cmbOri, gridBagConstraints);
        this.lblSizeSymbol.setText("Symbolgr\u00f6\u00dfe in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnits.add((Component)this.lblSizeSymbol, gridBagConstraints);
        this.lblAngle.setText("Winkel in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnits.add((Component)this.lblAngle, gridBagConstraints);
        this.cmbLength.setMinimumSize(new Dimension(80, 22));
        this.cmbLength.setPreferredSize(new Dimension(80, 22));
        this.cmbLength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cmbLength_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnits.add((Component)this.cmbLength, gridBagConstraints);
        this.lblSize.setText("L\u00e4ngen in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnits.add((Component)this.lblSize, gridBagConstraints);
        this.cmbLengthSymbol.setMinimumSize(new Dimension(80, 22));
        this.cmbLengthSymbol.setPreferredSize(new Dimension(80, 22));
        this.cmbLengthSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolStylePanel.this.cmbLengthSymbol_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnits.add((Component)this.cmbLengthSymbol, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.pnlUnits, gridBagConstraints);
        this.attPanel.setMinimumSize(new Dimension(100, 40));
        this.attPanel.setPreferredSize(new Dimension(100, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add((Component)this.attPanel, gridBagConstraints);
    }

    private void cmbOri_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setIntUnitAngle(this.cmbOri.getSelectedIndex());
        this.updateControls();
    }

    private void cmbLength_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setIntUnitSize(this.cmbLength.getSelectedIndex());
        this.updateControls();
    }

    private void txtAreaSymbol_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateTextExpression((String)this.txtAreaSymbol.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtAreaSymbol.setForeground(Color.GREEN.darker());
        } else {
            this.txtAreaSymbol.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrAreaSymbol(this.txtAreaSymbol.getText());
        this.fireStyleChanged();
    }

    private void txtLineSymbol_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateTextExpression((String)this.txtLineSymbol.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtLineSymbol.setForeground(Color.GREEN.darker());
        } else {
            this.txtLineSymbol.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrLineSymbol(this.txtLineSymbol.getText());
        this.fireStyleChanged();
    }

    private void txtEndSymbol_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateTextExpression((String)this.txtEndSymbol.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtEndSymbol.setForeground(Color.GREEN.darker());
        } else {
            this.txtEndSymbol.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrEndSymbol(this.txtEndSymbol.getText());
        this.fireStyleChanged();
    }

    private void txtStartSymbol_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateTextExpression((String)this.txtStartSymbol.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtStartSymbol.setForeground(Color.GREEN.darker());
        } else {
            this.txtStartSymbol.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrStartSymbol(this.txtStartSymbol.getText());
        this.fireStyleChanged();
    }

    private void txtPtSymbol_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateTextExpression((String)this.txtPtSymbol.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtPtSymbol.setForeground(Color.GREEN.darker());
        } else {
            this.txtPtSymbol.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrPtSymbol(this.txtPtSymbol.getText());
        this.fireStyleChanged();
    }

    private void cmbAreaPos_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setIntAreaPos(this.cmbAreaPos.getSelectedIndex());
        this.updateControls();
    }

    private void txtAreaOri_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtAreaOri.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtAreaOri.setForeground(Color.GREEN.darker());
        } else {
            this.txtAreaOri.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrAreaOri(this.txtAreaOri.getText());
        this.fireStyleChanged();
    }

    private void txtAreaOri_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrAreaOri(this.txtAreaOri.getText());
        this.updateControls();
    }

    private void txtAreaTop_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtAreaTop.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtAreaTop.setForeground(Color.GREEN.darker());
        } else {
            this.txtAreaTop.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrAreaShiftTop(this.txtAreaTop.getText());
        this.fireStyleChanged();
    }

    private void txtAreaTop_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrAreaShiftTop(this.txtAreaTop.getText());
        this.updateControls();
    }

    private void txtAreaLeft_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtAreaLeft.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtAreaLeft.setForeground(Color.GREEN.darker());
        } else {
            this.txtAreaLeft.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrAreaShiftLeft(this.txtAreaLeft.getText());
        this.fireStyleChanged();
    }

    private void txtAreaLeft_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrAreaShiftLeft(this.txtAreaLeft.getText());
        this.updateControls();
    }

    private void cboAreaRatio_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setBolAreaRatio(this.cboAreaRatio.isSelected());
        this.updateControls();
    }

    private void txtAreaWidth_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtAreaWidth.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtAreaWidth.setForeground(Color.GREEN.darker());
        } else {
            this.txtAreaWidth.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrAreaWidth(this.txtAreaWidth.getText());
        this.fireStyleChanged();
    }

    private void txtAreaWidth_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrAreaWidth(this.txtAreaWidth.getText());
        this.updateControls();
    }

    private void txtAreaHeight_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtAreaHeight.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtAreaHeight.setForeground(Color.GREEN.darker());
        } else {
            this.txtAreaHeight.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrAreaHeight(this.txtAreaHeight.getText());
        this.fireStyleChanged();
    }

    private void txtAreaHeight_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrAreaHeight(this.txtAreaHeight.getText());
        this.updateControls();
    }

    private void butAreaSymbol_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        try {
            if (this.symStyle.getStrStorename() == null || this.symStyle.getStrStorename().length() == 0) {
                return;
            }
            SymbolListDialog dlg = this.getSymList();
            SymbolStore store = RenderUtil.getSymbolStore(this.symStyle.getStrStorename(), this.sCol.getTask());
            dlg.setSymbolStore(store);
            dlg.selectSymbol(this.symStyle.getStrAreaSymbol());
            dlg.setVisible(true);
            if (dlg.wasOKPressed()) {
                this.symStyle.setStrAreaSymbol("\"" + dlg.getSymbolName() + "\"");
                this.updateControls();
            }
            dlg.setVisible(false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private void txtAreaSymbol_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrAreaSymbol(this.txtAreaSymbol.getText());
        this.updateControls();
    }

    private void chkOverwriteAreaColor_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setBolOverwriteAreaColor(this.chkOverwriteAreaColor.isSelected());
        this.updateControls();
    }

    private void tabPane_onStateChanged(ChangeEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.updateControls();
    }

    private void txtLineDist_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtLineDist.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtLineDist.setForeground(Color.GREEN.darker());
        } else {
            this.txtLineDist.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrLineDist(this.txtLineDist.getText());
        this.fireStyleChanged();
    }

    private void txtLineDist_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrLineDist(this.txtLineDist.getText());
        this.updateControls();
    }

    private void txtLineOffset_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtLineOffset.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtLineOffset.setForeground(Color.GREEN.darker());
        } else {
            this.txtLineOffset.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrLineShift(this.txtLineOffset.getText());
        this.fireStyleChanged();
    }

    private void txtLineOffset_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrLineShift(this.txtLineOffset.getText());
        this.updateControls();
    }

    private void txtLineHeight_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtLineHeight.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtLineHeight.setForeground(Color.GREEN.darker());
        } else {
            this.txtLineHeight.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrLineHeight(this.txtLineHeight.getText());
        this.fireStyleChanged();
    }

    private void txtLineHeight_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrLineHeight(this.txtLineHeight.getText());
        this.updateControls();
    }

    private void txtLineWidth_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtLineWidth.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtLineWidth.setForeground(Color.GREEN.darker());
        } else {
            this.txtLineWidth.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrLineWidth(this.txtLineWidth.getText());
        this.fireStyleChanged();
    }

    private void txtLineWidth_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrLineWidth(this.txtLineWidth.getText());
        this.updateControls();
    }

    private void cboLineRatio_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setBolLineRatio(this.cboLineRatio.isSelected());
        this.updateControls();
    }

    private void butLineSymbol_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        try {
            if (this.symStyle.getStrStorename() == null || this.symStyle.getStrStorename().length() == 0) {
                return;
            }
            SymbolListDialog dlg = this.getSymList();
            SymbolStore store = RenderUtil.getSymbolStore(this.symStyle.getStrStorename(), this.sCol.getTask());
            dlg.setSymbolStore(store);
            dlg.selectSymbol(this.symStyle.getStrLineSymbol());
            dlg.setVisible(true);
            if (dlg.wasOKPressed()) {
                this.symStyle.setStrLineSymbol("\"" + dlg.getSymbolName() + "\"");
                this.updateControls();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private void txtLineSymbol_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrLineSymbol(this.txtLineSymbol.getText());
        this.updateControls();
    }

    private void butEndSymbol_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        try {
            if (this.symStyle.getStrStorename() == null || this.symStyle.getStrStorename().length() == 0) {
                return;
            }
            SymbolListDialog dlg = this.getSymList();
            SymbolStore store = RenderUtil.getSymbolStore(this.symStyle.getStrStorename(), this.sCol.getTask());
            dlg.setSymbolStore(store);
            dlg.selectSymbol(this.symStyle.getStrEndSymbol());
            dlg.setVisible(true);
            if (dlg.wasOKPressed()) {
                this.symStyle.setStrEndSymbol("\"" + dlg.getSymbolName() + "\"");
                this.updateControls();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private void txtEndSymbol_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrEndSymbol(this.txtEndSymbol.getText());
        this.updateControls();
    }

    private void txtStartOri_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtStartOri.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtStartOri.setForeground(Color.GREEN.darker());
        } else {
            this.txtStartOri.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrStartOri(this.txtStartOri.getText());
        this.fireStyleChanged();
    }

    private void txtStartOri_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrStartOri(this.txtStartOri.getText());
        this.updateControls();
    }

    private void txtStartWidth_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtStartWidth.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtStartWidth.setForeground(Color.GREEN.darker());
        } else {
            this.txtStartWidth.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrStartWidth(this.txtStartWidth.getText());
        this.fireStyleChanged();
    }

    private void txtStartWidth_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrStartWidth(this.txtStartWidth.getText());
        this.updateControls();
    }

    private void cboStartRatio_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setBolStartRatio(this.cboStartRatio.isSelected());
        this.updateControls();
    }

    private void butStartSymbol_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        try {
            if (this.symStyle.getStrStorename() == null || this.symStyle.getStrStorename().length() == 0) {
                return;
            }
            SymbolListDialog dlg = this.getSymList();
            SymbolStore store = RenderUtil.getSymbolStore(this.symStyle.getStrStorename(), this.sCol.getTask());
            dlg.setSymbolStore(store);
            dlg.selectSymbol(this.symStyle.getStrStartSymbol());
            dlg.setVisible(true);
            if (dlg.wasOKPressed()) {
                this.symStyle.setStrStartSymbol("\"" + dlg.getSymbolName() + "\"");
                this.updateControls();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private void txtStartSymbol_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrStartSymbol(this.txtStartSymbol.getText());
        this.updateControls();
    }

    private void txtPtTop_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrPtShiftTop(this.txtPtTop.getText());
        this.updateControls();
    }

    private void txtPtTop_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtPtTop.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtPtTop.setForeground(Color.GREEN.darker());
        } else {
            this.txtPtTop.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrPtShiftTop(this.txtPtTop.getText());
        this.fireStyleChanged();
    }

    private void txtPtLeft_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtPtLeft.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtPtLeft.setForeground(Color.GREEN.darker());
        } else {
            this.txtPtLeft.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrPtShiftLeft(this.txtPtLeft.getText());
        this.fireStyleChanged();
    }

    private void txtPtLeft_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrPtShiftLeft(this.txtPtLeft.getText());
        this.updateControls();
    }

    private void txtPtOri_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtPtOri.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtPtOri.setForeground(Color.GREEN.darker());
        } else {
            this.txtPtOri.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrPtOri(this.txtPtOri.getText());
        this.fireStyleChanged();
    }

    private void txtPtOri_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrPtOri(this.txtPtOri.getText());
        this.updateControls();
    }

    private void txtPtHeight_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtPtHeight.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtPtHeight.setForeground(Color.GREEN.darker());
        } else {
            this.txtPtHeight.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrPtHeight(this.txtPtHeight.getText());
        this.fireStyleChanged();
    }

    private void txtPtHeight_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrPtHeight(this.txtPtHeight.getText());
        this.updateControls();
    }

    private void txtPtWidth_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtPtWidth.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtPtWidth.setForeground(Color.GREEN.darker());
        } else {
            this.txtPtWidth.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrPtWidth(this.txtPtWidth.getText());
        this.fireStyleChanged();
    }

    private void txtPtWidth_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrPtWidth(this.txtPtWidth.getText());
        this.updateControls();
    }

    private void cboPtRatio_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setBolPtRatio(this.cboPtRatio.isSelected());
        this.updateControls();
    }

    private void cmbSymbolSource_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrStorename(this.cmbSymbolSource.getSelectedItem().toString());
        this.updateControls();
    }

    private void butPtSymbol_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        try {
            if (this.symStyle.getStrStorename() == null || this.symStyle.getStrStorename().length() == 0) {
                return;
            }
            SymbolListDialog dlg = this.getSymList();
            SymbolStore store = RenderUtil.getSymbolStore(this.symStyle.getStrStorename(), this.sCol.getTask());
            dlg.setSymbolStore(store);
            dlg.selectSymbol(this.symStyle.getStrPtSymbol());
            dlg.setVisible(true);
            if (dlg.wasOKPressed()) {
                this.symStyle.setStrPtSymbol("\"" + dlg.getSymbolName() + "\"");
                this.updateControls();
            }
            dlg.setVisible(false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private void txtPtSymbol_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrPtSymbol(this.txtPtSymbol.getText());
        this.updateControls();
    }

    private void chkOverwriteLineColor_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setBolOverwriteLineColor(this.chkOverwriteLineColor.isSelected());
        this.updateControls();
    }

    private void cmbLengthSymbol_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setIntUnitSizeSymbol(this.cmbLengthSymbol.getSelectedIndex());
        this.updateControls();
    }

    private void cboPtInOriActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setBolPtShiftInOri(this.cboPtInOri.isSelected());
        this.updateControls();
    }

    private void cboAreaInOriActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setBolAreaShiftInOri(this.cboAreaInOri.isSelected());
        this.updateControls();
    }

    private void clrModelLineActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        ColorModel currentColorModel = this.symStyle.getLineColor();
        if (currentColorModel == null) {
            this.symStyle.setLineColor(this.clrModelLine.getColorChooserColorModel());
        } else {
            this.symStyle.setLineColor(ColorHelper.getAlphaColorModel((ColorModel)this.clrModelLine.getColorChooserColorModel(), (int)currentColorModel.getAlpha()));
        }
        this.updateControls();
    }

    private void clrModelFillActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        ColorModel currentColorModel = this.symStyle.getFillColor();
        if (currentColorModel == null) {
            this.symStyle.setFillColor(this.clrModelFill.getColorChooserColorModel());
        } else {
            this.symStyle.setFillColor(ColorHelper.getAlphaColorModel((ColorModel)this.clrModelFill.getColorChooserColorModel(), (int)currentColorModel.getAlpha()));
        }
        this.updateControls();
    }

    private void cboEndRatio_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setBolEndRatio(this.cboEndRatio.isSelected());
        this.updateControls();
    }

    private void txtEndWidth_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtEndWidth.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtEndWidth.setForeground(Color.GREEN.darker());
        } else {
            this.txtEndWidth.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrEndWidth(this.txtEndWidth.getText());
        this.fireStyleChanged();
    }

    private void txtEndWidth_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrEndWidth(this.txtEndWidth.getText());
        this.updateControls();
    }

    private void txtEndHeight_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtEndHeight.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtEndHeight.setForeground(Color.GREEN.darker());
        } else {
            this.txtEndHeight.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrEndHeight(this.txtEndHeight.getText());
        this.fireStyleChanged();
    }

    private void txtEndHeight_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrEndHeight(this.txtEndHeight.getText());
        this.updateControls();
    }

    private void txtEndOri_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtEndOri.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtEndOri.setForeground(Color.GREEN.darker());
        } else {
            this.txtEndOri.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrEndOri(this.txtEndOri.getText());
        this.fireStyleChanged();
    }

    private void txtEndOri_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrEndOri(this.txtEndOri.getText());
        this.updateControls();
    }

    private void txtStartHeight_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (FeatBshValidator.validateCalcExpression((String)this.txtStartHeight.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtStartHeight.setForeground(Color.GREEN.darker());
        } else {
            this.txtStartHeight.setForeground(Color.RED.darker());
        }
        this.symStyle.setStrStartHeight(this.txtStartHeight.getText());
        this.fireStyleChanged();
    }

    private void txtStartHeight_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.symStyle.setStrStartHeight(this.txtStartHeight.getText());
        this.updateControls();
    }
}

