/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style.symbol;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.symbol.SymbolStylePanel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStyleSymbolPanel
extends AbstractStylePanel
implements BasicStylePanel {
    private static final Logger LOG = LoggerFactory.getLogger(BasicStyleSymbolPanel.class);
    private LayerStyleCollection sCol;
    private boolean bolUpdateControls = true;
    private boolean bolRenderSymbol = false;
    private boolean bolRenderSymbolLineAreaPoints = false;
    private KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code != 27 && code == 10) {
                BasicStyleSymbolPanel.this.updateControls();
            }
        }
    };
    private JCheckBox cboShowLinePoints;
    private JCheckBox cboSymbol;
    private SymbolStylePanel symbolStylePanel;

    public BasicStyleSymbolPanel() {
        this.initComponents();
    }

    public BasicStyleSymbolPanel(LayerStyleCollection _sCol, PlugInContext _context) {
        this.bolUpdateControls = false;
        try {
            this.initComponents();
            this.i18n();
            this.init();
            this.setStyleCollection(_sCol);
            this.updateControls();
            GUISupport.addKeyListenersRecursively((Component)this, (KeyListener)this.keyListener);
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void i18n() {
        this.cboShowLinePoints.setText(I18N.get("ui.style.BasicStyleSymbolPanel.show-line-points"));
        this.cboSymbol.setText(I18N.get("ui.style.BasicStyleSymbolPanel.symbol"));
    }

    public final void init() {
        this.symbolStylePanel.setStyleCollection(this.sCol);
        this.symbolStylePanel.addStyleChangedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicStyleSymbolPanel.this.updateControls();
            }
        });
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        try {
            this.bolUpdateControls = false;
            this.cboSymbol.setSelected(this.bolRenderSymbol);
            this.cboShowLinePoints.setSelected(this.bolRenderSymbolLineAreaPoints);
            this.setEnabledState();
            this.fireStyleChanged();
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void setEnabledState() {
        this.cboShowLinePoints.setEnabled(this.bolRenderSymbol);
        this.symbolStylePanel.setEnabled(this.bolRenderSymbol);
    }

    @Override
    public void setTransparency(int _alpha, boolean bolArea, boolean bolLine, boolean bolText, boolean bolSymbol) {
        this.symbolStylePanel.setTransparency(_alpha, bolSymbol);
    }

    @Override
    public void updateBasicStyle(BasicStyleModel basicStyle) {
        basicStyle.setRenderingSymbol(this.bolRenderSymbol);
        if (this.bolRenderSymbol) {
            SymbolStyleModel symStyle = (SymbolStyleModel)this.symbolStylePanel.getSymbolStyle().cloneModel();
            symStyle.setBolRenderLineAreaPoints(this.bolRenderSymbolLineAreaPoints);
            basicStyle.setSymStyle(symStyle);
        } else {
            basicStyle.setSymStyle(null);
        }
    }

    @Override
    public boolean isStyleActive() {
        return this.bolRenderSymbol;
    }

    @Override
    public void setBasicStyle(BasicStyleModel basicStyle) {
        this.bolRenderSymbol = basicStyle.isRenderingSymbol();
        if (this.bolRenderSymbol && basicStyle.getSymStyle() != null) {
            this.bolRenderSymbolLineAreaPoints = basicStyle.getSymStyle().isBolRenderLineAreaPoints();
            this.symbolStylePanel.setSymbolStyle((SymbolStyleModel)basicStyle.getSymStyle().cloneModel());
            this.symbolStylePanel.setTransparency(basicStyle.getIntAlpha(), basicStyle.isBolUseAlphaSymbol());
        } else {
            this.bolRenderSymbolLineAreaPoints = false;
        }
        this.updateControls();
    }

    @Override
    public String validateInput() {
        try {
            SimpleFeatureType fSchema = this.getFeatureRetriever().getFeatureType();
            String strError = null;
            if (this.bolRenderSymbol) {
                strError = this.symbolStylePanel.validateInput();
            }
            return strError;
        }
        catch (Exception e) {
            LOG.warn("Error at validation of BasicStyleSymbolPanel", (Throwable)e);
            return e.getMessage();
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.BasicStyleSymbolPanel.title");
    }

    @Override
    public final void setStyleCollection(StyleCollection _sCol) {
        this.sCol = (LayerStyleCollection)_sCol;
        this.bolUpdateControls = false;
        try {
            this.symbolStylePanel.setStyleCollection(this.sCol);
            this.setBasicStyle(this.sCol.getBasicStyle());
        }
        finally {
            this.bolUpdateControls = true;
        }
        this.updateControls();
    }

    @Override
    public void setFeatureRetriever(FeatureRetriever featureTypeRetriever) {
        this.symbolStylePanel.setFeatureRetriever(featureTypeRetriever);
        super.setFeatureRetriever(featureTypeRetriever);
    }

    @Override
    public void updateStyles() {
        throw new UnsupportedOperationException();
    }

    private void initComponents() {
        this.cboSymbol = new JCheckBox();
        this.cboShowLinePoints = new JCheckBox();
        this.symbolStylePanel = new SymbolStylePanel();
        this.setLayout(new GridBagLayout());
        this.cboSymbol.setText("Symbole anzeigen");
        this.cboSymbol.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboSymbol.setMargin(new Insets(0, 0, 0, 0));
        this.cboSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleSymbolPanel.this.cboSymbol_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 7, 3, 2);
        this.add((Component)this.cboSymbol, gridBagConstraints);
        this.cboShowLinePoints.setText("Symbole bei Linien- und Fl\u00e4chenpunkte anzeigen");
        this.cboShowLinePoints.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboShowLinePoints.setMargin(new Insets(0, 0, 0, 0));
        this.cboShowLinePoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleSymbolPanel.this.cboShowLinePointsbolShowLinePoints_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 18, 3, 2);
        this.add((Component)this.cboShowLinePoints, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.symbolStylePanel, gridBagConstraints);
    }

    private void cboSymbol_onActionPerformed(ActionEvent evt) {
        this.bolRenderSymbol = this.cboSymbol.isSelected();
        this.updateControls();
    }

    private void cboShowLinePointsbolShowLinePoints_onActionPerformed(ActionEvent evt) {
        this.bolRenderSymbolLineAreaPoints = this.cboShowLinePoints.isSelected();
        this.updateControls();
    }
}

