/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style.scale;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.components.IntegerTextField;
import com.vividsolutions.jump.workbench.ui.style.LayerStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import com.vividsolutions.jump.workbench.ui.style.scale.StyleCollectionFactory;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleRangeStylePanel
extends JPanel
implements LayerStylePanel {
    private static final Logger LOG = LoggerFactory.getLogger(ScaleRangeStylePanel.class);
    private boolean doUpdateControls = true;
    private Collection<StyleCollection> lstStyleCollections;
    private StyleCollection activeSCol = null;
    private boolean scaleDependentRenderingEnabled = false;
    private StylePanel stylePanel = null;
    private Layerable layerable = null;
    private JButton butAdd;
    private JButton butChange;
    private JButton butDelete;
    private JCheckBox cboUseRange;
    private JComboBox<StyleCollection> cmbRanges;
    private JPanel pnlRanges;
    private JPanel pnlStyle;

    public ScaleRangeStylePanel(Collection<StyleCollection> _lstStyleCollections) {
        try {
            this.doUpdateControls = false;
            this.lstStyleCollections = _lstStyleCollections;
            StyleCollection defaultSCol = this.getDefaultStyleCollection();
            this.layerable = defaultSCol.getLayerable();
            this.scaleDependentRenderingEnabled = defaultSCol.getLayerable().isScaleDependentRenderingEnabled();
            this.initComponents();
            this.i18n();
            if (this.scaleDependentRenderingEnabled) {
                this.setActiveStyleCollection(this.getStyleCollectionForScale());
            } else {
                this.setActiveStyleCollection(defaultSCol);
            }
        }
        finally {
            this.doUpdateControls = true;
        }
        this.updateControls();
    }

    public void setStylePanel(StylePanel _stylePanel) {
        this.stylePanel = _stylePanel;
        if (this.stylePanel != null) {
            this.pnlStyle.removeAll();
            this.pnlStyle.add((Component)((Object)this.stylePanel));
            this.pnlStyle.validate();
            this.pnlStyle.repaint();
        }
    }

    private ScaleRangeDialog getScaleRangeDialog(int intMode) {
        Window parent = SwingUtilities.windowForComponent(this);
        if (parent instanceof Frame) {
            return new ScaleRangeDialog((Frame)parent, intMode);
        }
        if (parent instanceof Dialog) {
            return new ScaleRangeDialog((Dialog)parent, intMode);
        }
        return null;
    }

    private void i18n() {
        ((TitledBorder)this.pnlStyle.getBorder()).setTitle(I18N.get("ui.style.ScaleRangeStylePanel.style"));
        this.cboUseRange.setText(I18N.get("ui.style.ScaleRangeStylePanel.userange"));
        this.butAdd.setToolTipText(I18N.get("ui.style.ScaleRangeStylePanel.add"));
        this.butChange.setToolTipText(I18N.get("ui.style.ScaleRangeStylePanel.change"));
        this.butDelete.setToolTipText(I18N.get("ui.style.ScaleRangeStylePanel.delete"));
        this.butAdd.setIcon(IconLoader.svgIconSmall((String)"common_add.svg"));
        this.butChange.setIcon(IconLoader.svgIconSmall((String)"common_edit.svg"));
        this.butDelete.setIcon(IconLoader.svgIconSmall((String)"common_delete.svg"));
    }

    @Override
    public UndoableCommand updateLayer() {
        this.setStylesToActiveStyleCollection();
        ScaleRangeUndoableCommand undo = new ScaleRangeUndoableCommand(this.layerable, this.scaleDependentRenderingEnabled, this.getStyleCollections());
        return undo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLayerable(Layerable _layer) {
        StyleCollection lastActiveScol = this.activeSCol;
        Layerable lastActiveLayer = this.layerable;
        this.layerable = _layer;
        this.doUpdateControls = false;
        try {
            this.activeSCol = null;
            this.lstStyleCollections = new ArrayList<StyleCollection>(_layer.cloneStyleCollections());
            this.scaleDependentRenderingEnabled = this.getDefaultStyleCollection().getLayerable().isScaleDependentRenderingEnabled();
            if (this.scaleDependentRenderingEnabled) {
                if (lastActiveScol != null && lastActiveLayer != null && lastActiveScol.getMaxScale() != null && lastActiveScol.getMinScale() != null && lastActiveLayer == this.layerable) {
                    for (StyleCollection objSCol : this.lstStyleCollections) {
                        StyleCollection sCol = objSCol;
                        if (sCol.getMaxScale() == null || sCol.getMinScale() == null || !sCol.getMaxScale().equals(lastActiveScol.getMaxScale()) || !sCol.getMinScale().equals(lastActiveScol.getMinScale())) continue;
                        this.setActiveStyleCollection(sCol);
                        break;
                    }
                }
                if (this.activeSCol == null) {
                    this.setActiveStyleCollection(this.getStyleCollectionForScale());
                }
            } else {
                StyleCollection defaultScol = this.getDefaultStyleCollection();
                this.setActiveStyleCollection(defaultScol);
                this.lstStyleCollections.clear();
                this.lstStyleCollections.add(defaultScol);
            }
            this.updateDialogTitle();
        }
        finally {
            this.doUpdateControls = true;
        }
        this.updateControls();
    }

    private void updateControls() {
        if (!this.doUpdateControls) {
            return;
        }
        try {
            this.doUpdateControls = false;
            this.cboUseRange.setSelected(this.scaleDependentRenderingEnabled);
            if (this.scaleDependentRenderingEnabled) {
                Collections.sort((List)this.lstStyleCollections);
                this.cmbRanges.setEnabled(true);
                this.butAdd.setEnabled(true);
                this.butChange.setEnabled(true);
                this.butDelete.setEnabled(true);
            } else {
                this.cmbRanges.setEnabled(false);
                this.butAdd.setEnabled(false);
                this.butChange.setEnabled(false);
                this.butDelete.setEnabled(false);
            }
            this.refillCmbRanges();
            this.updateDialogTitle();
        }
        finally {
            this.doUpdateControls = true;
        }
    }

    private void refillCmbRanges() {
        this.cmbRanges.removeAllItems();
        if (this.scaleDependentRenderingEnabled) {
            for (StyleCollection sCol : this.lstStyleCollections) {
                if (sCol.getDefault()) continue;
                this.cmbRanges.addItem(sCol);
            }
            this.cmbRanges.setSelectedItem(this.activeSCol);
        } else {
            this.cmbRanges.addItem(this.getDefaultStyleCollection());
        }
    }

    private void updateDialogTitle() {
        if (this.activeSCol == null) {
            return;
        }
        try {
            Window parent = SwingUtilities.windowForComponent(this);
            if (parent instanceof Dialog) {
                ((Dialog)parent).setTitle(I18N.get("ui.style.SelectChangeStylesPlugIn.name") + " - " + this.activeSCol.getLayerable().getName() + " (" + String.valueOf(this.activeSCol) + ")");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.ScaleRangeStylePanel.title");
    }

    @Override
    public String validateInput() {
        if (this.stylePanel != null) {
            return this.stylePanel.validateInput();
        }
        return null;
    }

    private StyleCollection getDefaultStyleCollection() {
        for (StyleCollection defaultStyleCollection : this.lstStyleCollections) {
            if (!defaultStyleCollection.getDefault()) continue;
            return defaultStyleCollection;
        }
        return null;
    }

    private StyleCollection getStyleCollectionForScale() {
        StyleCollection defaultSCol = this.getDefaultStyleCollection();
        double scale = defaultSCol.getLayerable().getLayerManager().getScreenScale();
        StyleCollection firstScaleStyleCollection = null;
        for (StyleCollection sCol : this.lstStyleCollections) {
            if (sCol.getDefault()) continue;
            if (firstScaleStyleCollection == null) {
                firstScaleStyleCollection = sCol;
            }
            if (!(sCol.getMinScale() < scale) || !(sCol.getMaxScale() > scale)) continue;
            return sCol;
        }
        return firstScaleStyleCollection;
    }

    public StyleCollection getActiveStyleCollection() {
        return this.activeSCol;
    }

    private void setActiveStyleCollection(StyleCollection sCol) {
        if (this.activeSCol != null) {
            this.setStylesToActiveStyleCollection();
        }
        this.activeSCol = sCol;
        this.setStyleCollectionToPanels();
        this.updateDialogTitle();
    }

    public void setStylesToActiveStyleCollection() {
        if (this.activeSCol == null) {
            return;
        }
        if (this.stylePanel != null) {
            this.stylePanel.updateStyles();
        }
    }

    public void setStyleCollectionToPanels() {
        if (this.activeSCol == null) {
            return;
        }
        if (this.stylePanel != null) {
            this.stylePanel.setStyleCollection(this.activeSCol);
        }
    }

    public void setFeatureRetrieverToPanels() {
        if (this.stylePanel != null) {
            this.stylePanel.setFeatureRetriever(this.stylePanel.getFeatureRetriever());
        }
    }

    public static boolean isScaleRangeValid(Double _minScale, Double _maxScale, Collection<StyleCollection> _lstStyleCollections) {
        boolean bolValid = true;
        for (StyleCollection sCol : _lstStyleCollections) {
            if (sCol.getDefault()) continue;
            if (sCol.getMaxScale() > _minScale && sCol.getMinScale() < _minScale) {
                bolValid = false;
                break;
            }
            if (sCol.getMaxScale() > _maxScale && sCol.getMinScale() < _maxScale) {
                bolValid = false;
                break;
            }
            if (!(sCol.getMaxScale() <= _maxScale) || !(sCol.getMinScale() >= _minScale)) continue;
            bolValid = false;
            break;
        }
        return bolValid;
    }

    public Collection<StyleCollection> getStyleCollections() {
        return this.lstStyleCollections;
    }

    public boolean isScaleDependentRenderingEnabled() {
        return this.scaleDependentRenderingEnabled;
    }

    private StyleCollection cloneActiveSColForNewDefaultSCol() {
        StyleCollection sCol = this.activeSCol.clone();
        sCol.setDefault(true);
        sCol.setMaxScale(null);
        sCol.setMinScale(null);
        return sCol;
    }

    private StyleCollection fetchNewDefaultBasicStyleCollection(Layerable layer) {
        StyleCollection styleCollection = layer.createNewDefaultStyleCollection();
        styleCollection.setLayerable(layer);
        styleCollection.setDefault(true);
        return styleCollection;
    }

    private void initComponents() {
        this.pnlRanges = new JPanel();
        this.cboUseRange = new JCheckBox();
        this.cmbRanges = new JComboBox();
        this.butAdd = new JButton();
        this.butChange = new JButton();
        this.butDelete = new JButton();
        this.pnlStyle = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pnlRanges.setLayout(new GridBagLayout());
        this.cboUseRange.setText("Ma\u00dfstabsbereiche verwenden");
        this.cboUseRange.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboUseRange.setMargin(new Insets(0, 0, 0, 0));
        this.cboUseRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScaleRangeStylePanel.this.cboUseRange_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.pnlRanges.add((Component)this.cboUseRange, gridBagConstraints);
        this.cmbRanges.setPreferredSize(new Dimension(150, 22));
        this.cmbRanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScaleRangeStylePanel.this.cmbRanges_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlRanges.add(this.cmbRanges, gridBagConstraints);
        this.butAdd.setMaximumSize(new Dimension(22, 22));
        this.butAdd.setMinimumSize(new Dimension(22, 22));
        this.butAdd.setPreferredSize(new Dimension(22, 22));
        this.butAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScaleRangeStylePanel.this.butAdd_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlRanges.add((Component)this.butAdd, gridBagConstraints);
        this.butChange.setPreferredSize(new Dimension(22, 22));
        this.butChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScaleRangeStylePanel.this.butChange_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlRanges.add((Component)this.butChange, gridBagConstraints);
        this.butDelete.setPreferredSize(new Dimension(22, 22));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScaleRangeStylePanel.this.butDelete_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlRanges.add((Component)this.butDelete, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlRanges, gridBagConstraints);
        this.pnlStyle.setBorder(BorderFactory.createTitledBorder("Darstellung"));
        this.pnlStyle.setLayout(new GridLayout(1, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlStyle, gridBagConstraints);
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        int intDelete = JOptionPane.showConfirmDialog(this, I18N.get("ui.style.ScaleRangeStylePanel.delete.question"), "", 0);
        if (intDelete == 0) {
            this.lstStyleCollections.remove(this.activeSCol);
            if (this.lstStyleCollections.size() < 2) {
                this.scaleDependentRenderingEnabled = false;
                this.lstStyleCollections.clear();
                this.lstStyleCollections.add(this.cloneActiveSColForNewDefaultSCol());
                this.activeSCol = null;
                this.scaleDependentRenderingEnabled = false;
                this.setActiveStyleCollection(this.getDefaultStyleCollection());
            } else {
                this.activeSCol = null;
                this.setActiveStyleCollection(this.getStyleCollectionForScale());
            }
            this.updateControls();
        }
    }

    private void butChange_onActionPerformed(ActionEvent evt) {
        ScaleRangeDialog srDialog = this.getScaleRangeDialog(0);
        srDialog.setMinScale(this.activeSCol.getMinScale());
        srDialog.setMaxScale(this.activeSCol.getMaxScale());
        srDialog.setVisible(true);
        if (srDialog.getOK()) {
            ArrayList<StyleCollection> lstColCheck = new ArrayList<StyleCollection>();
            for (StyleCollection sCol : this.lstStyleCollections) {
                if (sCol == this.activeSCol) continue;
                lstColCheck.add(sCol);
            }
            if (!ScaleRangeStylePanel.isScaleRangeValid(srDialog.getMinScale(), srDialog.getMaxScale(), lstColCheck)) {
                JOptionPane.showMessageDialog(this, I18N.get("ui.style.ScaleRangeStylePanel.invalidrange"));
                this.butChange_onActionPerformed(evt);
                return;
            }
            this.activeSCol.setMaxScale(srDialog.getMaxScale());
            this.activeSCol.setMinScale(srDialog.getMinScale());
            this.updateControls();
        }
    }

    private void butAdd_onActionPerformed(ActionEvent evt) {
        ScaleRangeDialog srDialog = this.getScaleRangeDialog(1);
        Double minScaleToSet = 0.0;
        Double maxScaleToSet = 5000.0;
        for (StyleCollection lstStyleCollection : this.lstStyleCollections) {
            StyleCollection sCol = lstStyleCollection;
            if (sCol.getDefault() || !(sCol.getMaxScale() > minScaleToSet)) continue;
            minScaleToSet = sCol.getMaxScale();
        }
        if (minScaleToSet != 0.0) {
            maxScaleToSet = minScaleToSet * 2.0;
        }
        srDialog.setMinScale(minScaleToSet);
        srDialog.setMaxScale(maxScaleToSet);
        srDialog.setVisible(true);
        if (srDialog.getOK()) {
            StyleCollection sCol;
            Layerable layer = this.getDefaultStyleCollection().getLayerable();
            if (this.activeSCol == null) {
                sCol = StyleCollectionFactory.produceStyleCollection(layer);
            } else {
                if (!this.activeSCol.getDefault()) {
                    GUISupport.msgbox((Component)this, (String)("<html>" + I18N.get("ui.style.ScaleRangeStylePanel.hint-copy-from") + " " + this.activeSCol.toString() + "<br><br>" + I18N.get("ui.style.ScaleRangeStylePanel.hint-scale") + "</html>"), (String)I18N.get("common.message"));
                }
                this.setStylesToActiveStyleCollection();
                sCol = this.activeSCol.clone();
                sCol.setDefault(false);
            }
            if (!ScaleRangeStylePanel.isScaleRangeValid(srDialog.getMinScale(), srDialog.getMaxScale(), this.lstStyleCollections)) {
                JOptionPane.showMessageDialog(this, I18N.get("ui.style.ScaleRangeStylePanel.invalidrange"));
                this.butAdd_onActionPerformed(evt);
                return;
            }
            sCol.setMaxScale(srDialog.getMaxScale());
            sCol.setMinScale(srDialog.getMinScale());
            if (this.lstStyleCollections.size() < 2) {
                this.lstStyleCollections.clear();
                this.lstStyleCollections.add(this.fetchNewDefaultBasicStyleCollection(layer));
            }
            this.lstStyleCollections.add(sCol);
            this.setActiveStyleCollection(sCol);
            this.updateControls();
        }
    }

    private void cmbRanges_onActionPerformed(ActionEvent evt) {
        if (!this.doUpdateControls) {
            return;
        }
        this.setActiveStyleCollection((StyleCollection)this.cmbRanges.getSelectedItem());
    }

    private void cboUseRange_onActionPerformed(ActionEvent evt) {
        if (!this.doUpdateControls) {
            return;
        }
        this.scaleDependentRenderingEnabled = this.cboUseRange.isSelected();
        if (this.scaleDependentRenderingEnabled) {
            if (this.lstStyleCollections.size() < 2) {
                this.butAdd_onActionPerformed(null);
                if (this.lstStyleCollections.size() < 2) {
                    this.cboUseRange.setSelected(false);
                    this.scaleDependentRenderingEnabled = false;
                }
                return;
            }
            this.setActiveStyleCollection(this.getStyleCollectionForScale());
        } else {
            boolean bolYes;
            String strCopyFrom = "Default";
            if (this.activeSCol != null) {
                strCopyFrom = this.activeSCol.toString();
            }
            if (!(bolYes = GUISupport.yesnobox((Component)this, (String)("<html>" + I18N.get("ui.style.ScaleRangeStylePanel.warning-styles-get-lost") + " " + strCopyFrom + "</html>"), (String)I18N.get("common.alert")))) {
                this.cboUseRange.setSelected(true);
                return;
            }
            if (this.activeSCol != null) {
                this.setStylesToActiveStyleCollection();
                if (this.getDefaultStyleCollection() != null) {
                    this.lstStyleCollections.remove(this.getDefaultStyleCollection());
                }
                this.lstStyleCollections.add(this.cloneActiveSColForNewDefaultSCol());
            }
            this.setActiveStyleCollection(this.getDefaultStyleCollection());
            if (this.activeSCol != null) {
                ArrayList<StyleCollection> lstRetain = new ArrayList<StyleCollection>();
                lstRetain.add(this.activeSCol);
                this.lstStyleCollections.retainAll(lstRetain);
            }
        }
        this.updateControls();
    }

    private class ScaleRangeDialog
    extends JDialog {
        public static final int UPDATE_MODE = 0;
        public static final int INSERT_MODE = 1;
        private final JLabel lblFrom;
        private final JLabel lblTo;
        private final IntegerTextField txtFrom;
        private final IntegerTextField txtTo;
        private final JButton butOK;
        private final JButton butCancel;
        private boolean bolOK;
        private int intMode;

        ScaleRangeDialog(Dialog _parentDialog, int _intMode) {
            super(_parentDialog, true);
            this.lblFrom = new JLabel();
            this.lblTo = new JLabel();
            this.txtFrom = new IntegerTextField();
            this.txtTo = new IntegerTextField();
            this.butOK = new JButton();
            this.butCancel = new JButton();
            this.bolOK = false;
            this.init(_intMode);
        }

        ScaleRangeDialog(Frame _parentFrame, int _intMode) {
            super(_parentFrame, true);
            this.lblFrom = new JLabel();
            this.lblTo = new JLabel();
            this.txtFrom = new IntegerTextField();
            this.txtTo = new IntegerTextField();
            this.butOK = new JButton();
            this.butCancel = new JButton();
            this.bolOK = false;
            this.init(_intMode);
        }

        private void init(int _intMode) {
            this.setMode(_intMode);
            GUIUtil.centreOnScreen(this);
            this.setDefaultCloseOperation(1);
            this.setResizable(false);
            this.initialize();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    ScaleRangeDialog.this.txtFrom.selectAll();
                    ScaleRangeDialog.this.txtFrom.grabFocus();
                }
            });
            this.pack();
        }

        public void setOK(boolean _bolOK) {
            this.bolOK = _bolOK;
        }

        public boolean getOK() {
            return this.bolOK;
        }

        public void setMode(int _intMode) {
            this.intMode = _intMode;
            switch (this.intMode) {
                case 0: {
                    this.setTitle(I18N.get("ui.style.ScaleRangeStylePanel.ScaleRangeDialog.edit"));
                    break;
                }
                case 1: {
                    this.setTitle(I18N.get("ui.style.ScaleRangeStylePanel.ScaleRangeDialog.add"));
                }
            }
        }

        public Double getMinScale() {
            return Double.parseDouble(this.txtFrom.getText());
        }

        public Double getMaxScale() {
            return Double.parseDouble(this.txtTo.getText());
        }

        public void setMinScale(Double dblScale) {
            DecimalFormat df = new DecimalFormat("0");
            this.txtFrom.setText(df.format(dblScale));
        }

        public void setMaxScale(Double dblScale) {
            DecimalFormat df = new DecimalFormat("0");
            this.txtTo.setText(df.format(dblScale));
        }

        private void initialize() {
            GridBagLayout gbLayout = new GridBagLayout();
            this.setLayout(gbLayout);
            this.lblFrom.setText(I18N.get("ui.style.ScaleRangeStylePanel.ScaleRangeDialog.from"));
            GUIUtil.addGridBagComponent(this, this.lblFrom, gbLayout, 0, 0, 2, 1, 13, 0, new Insets(10, 10, 0, 0));
            this.lblTo.setText(I18N.get("ui.style.ScaleRangeStylePanel.ScaleRangeDialog.to"));
            GUIUtil.addGridBagComponent(this, this.lblTo, gbLayout, 0, 1, 2, 1, 13, 0, new Insets(10, 10, 0, 0));
            this.txtFrom.setPreferredSize(new Dimension(200, 20));
            this.txtFrom.setColumns(20);
            this.txtFrom.setHorizontalAlignment(4);
            this.txtFrom.setText("0");
            GUIUtil.addGridBagComponent(this, this.txtFrom, gbLayout, 2, 0, 3, 1, 17, 0, new Insets(10, 10, 0, 10));
            this.txtTo.setPreferredSize(new Dimension(200, 20));
            this.txtTo.setColumns(20);
            this.txtTo.setHorizontalAlignment(4);
            this.txtTo.setText("5000");
            GUIUtil.addGridBagComponent(this, this.txtTo, gbLayout, 2, 1, 3, 1, 17, 0, new Insets(10, 10, 0, 10));
            this.butOK.setText(I18N.get("ui.style.ScaleRangeStylePanel.ScaleRangeDialog.ok"));
            this.butOK.setPreferredSize(new Dimension(100, 20));
            GUIUtil.addGridBagComponent(this, this.butOK, gbLayout, 2, 2, 1, 1, 17, 0, new Insets(10, 10, 0, 0));
            this.butCancel.setText(I18N.get("ui.style.ScaleRangeStylePanel.ScaleRangeDialog.cancel"));
            this.butCancel.setPreferredSize(new Dimension(100, 20));
            GUIUtil.addGridBagComponent(this, this.butCancel, gbLayout, 3, 2, 1, 1, 17, 0, new Insets(10, 10, 0, 10));
            GridBagConstraints gbcFiller = new GridBagConstraints();
            gbcFiller.weightx = 5.0;
            gbcFiller.weighty = 5.0;
            GUIUtil.addGridBagComponent(this, new JPanel(), gbLayout, gbcFiller, 0, -1, 5, 0, 10, 0, new Insets(0, 0, 0, 0));
            this.butOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScaleRangeDialog.this.butOK_onClick(e);
                }
            });
            this.butCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScaleRangeDialog.this.butCancel_onClick(e);
                }
            });
            this.txtTo.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ScaleRangeDialog.this.txtTo_onFocusGained(e);
                }
            });
            this.txtFrom.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ScaleRangeDialog.this.txtFrom_onFocusGained(e);
                }
            });
        }

        public void butCancel_onClick(ActionEvent e) {
            this.setVisible(false);
            this.setOK(false);
        }

        public void butOK_onClick(ActionEvent e) {
            this.setVisible(false);
            this.setOK(true);
        }

        public void txtTo_onFocusGained(FocusEvent e) {
            this.txtTo.selectAll();
        }

        public void txtFrom_onFocusGained(FocusEvent e) {
            this.txtFrom.selectAll();
        }

        public void txtTo_onKeyTyped(KeyEvent e) {
            char[] chrdata = new char[]{e.getKeyChar()};
            String strKey = new String(chrdata);
            try {
                Integer.parseInt(strKey);
            }
            catch (NumberFormatException err) {
                e.setKeyCode(0);
                LOG.warn(String.format("unable to parse key '%s': %s", strKey, err.getMessage()));
            }
        }

        public void txtFrom_onKeyTyped(KeyEvent e) {
            try {
                Integer.parseInt(this.txtFrom.getText());
            }
            catch (NumberFormatException err) {
                LOG.warn(String.format("unable to parse number '%s': %s", this.txtFrom.getText(), err.getMessage()));
            }
        }
    }

    private static class ScaleRangeUndoableCommand
    extends UndoableCommand {
        private Layerable ly = null;
        private boolean oldScaleDependentRendering;
        private final boolean newScaleDependentRendering;
        private Collection<StyleCollection> oldStyles = null;
        private Collection<StyleCollection> newStyles = null;

        ScaleRangeUndoableCommand(Layerable layer, boolean scaleDependentRenderingEnables, Collection<StyleCollection> styles) {
            super("ScaleRangePanel");
            this.ly = layer;
            this.getOldProperties();
            this.newScaleDependentRendering = scaleDependentRenderingEnables;
            this.newStyles = styles;
        }

        @Override
        public void execute() {
            this.ly.setStyleCollections(this.newStyles);
            this.ly.setScaleDependentRenderingEnabled(this.newScaleDependentRendering);
        }

        @Override
        public void unexecute() {
            this.ly.setStyleCollections(this.oldStyles);
            this.ly.setScaleDependentRenderingEnabled(this.oldScaleDependentRendering);
        }

        private void getOldProperties() {
            this.oldScaleDependentRendering = this.ly.isScaleDependentRenderingEnabled();
            this.oldStyles = this.ly.cloneStyleCollections();
        }
    }
}

