/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style.buildin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.TransparencyPanel;
import com.vividsolutions.jump.workbench.ui.WindowVisibleKeeper;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyleFactory;
import de.riwagis.icons.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ChangeUserDefinedTransparencyDialog
extends JDialog {
    private static final int EVENT_DELAY = 500;
    private boolean blockSliderEvent = false;
    private final Timer delayedEventTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ChangeUserDefinedTransparencyDialog.this.updateTransparencyForSelectedLayers();
            ChangeUserDefinedTransparencyDialog.this.delayedEventTimer.stop();
        }
    });
    private JPanel btnPanel;
    private JButton butReset;
    private JButton butResetAll;
    private JSeparator jSeparator1;
    private JLabel lblLayer;
    private JLabel lblLayerName;
    private JLabel lblTransparency;
    private TransparencyPanel transparencyPanel;

    public ChangeUserDefinedTransparencyDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.i18n();
        this.init();
        this.setLocation(parent.getLocation().x + 50, parent.getLocation().y + 100);
        Dimension windowsSize = new Dimension(380, 140);
        this.setSize(windowsSize);
        this.setMinimumSize(windowsSize);
        WindowVisibleKeeper.keepFrameVisibleOnDeviceChanges(this);
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.style.buildin.ChangeBuildInLayersStyleDialog.title"));
        this.butReset.setIcon(IconLoader.svgIcon((String)"layer_undo.svg"));
        this.butReset.setToolTipText(I18N.get("ui.style.buildin.ChangeBuildInLayersStyleDialog.reset-tooltip"));
        this.butResetAll.setIcon(IconLoader.svgIcon((String)"layer_undo_all.svg"));
        this.butResetAll.setToolTipText(I18N.get("ui.style.buildin.ChangeBuildInLayersStyleDialog.reset-all-tooltip"));
        this.lblLayer.setText(I18N.get("common.layer") + ":");
        this.lblTransparency.setText(I18N.get("ui.style.buildin.ChangeBuildInLayersStyleDialog.transparency"));
    }

    private void init() {
        this.delayedEventTimer.setRepeats(false);
        this.delayedEventTimer.setInitialDelay(500);
        this.transparencyPanel.addChangeListener(e -> {
            if (this.blockSliderEvent) {
                return;
            }
            this.delayedEventTimer.stop();
            this.delayedEventTimer.restart();
        });
    }

    @Override
    public void setVisible(boolean bolVisi) {
        super.setVisible(bolVisi);
        if (bolVisi) {
            this.updateComponents();
        }
    }

    private boolean isAllowedLayer(Layerable candidate) {
        return candidate.getStyleCollections().stream().anyMatch(sc -> sc.canUserAdjustAlpha());
    }

    void enableCheck() {
        if (this.isVisible()) {
            this.updateComponents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComponents() {
        LayerNamePanel lnp = WorkbenchContext.getInstance().getLayerNamePanel();
        if (lnp == null) {
            SwingUtilities.invokeLater(() -> this.setVisible(false));
            return;
        }
        List<Layerable> selectedLayers = this.getSelectedSupportedLayers();
        if (selectedLayers.isEmpty()) {
            this.transparencyPanel.setEnabled(false);
            this.lblLayerName.setText(I18N.get("ui.style.buildin.ChangeBuildInLayersStyleDialog.select-buildin-layer"));
        } else {
            if (selectedLayers.size() > 1) {
                this.lblLayerName.setText(I18N.get("ui.style.buildin.ChangeBuildInLayersStyleDialog.multiple-layers"));
            } else {
                this.lblLayerName.setText(selectedLayers.get(0).getName());
            }
            this.transparencyPanel.setEnabled(true);
            LayerViewPanel lvp = WorkbenchContext.getInstance().getLayerViewPanel();
            StyleCollection sCol = ExportStyleFactory.getStyleCollection4Scale(selectedLayers.get(0), lvp.getViewport().getScale());
            int alpha = sCol.getAlpha();
            try {
                this.blockSliderEvent = true;
                this.transparencyPanel.getSlider().setValue(255 - alpha);
            }
            finally {
                this.blockSliderEvent = false;
            }
        }
    }

    private List<Layerable> getSelectedSupportedLayers() {
        LayerNamePanel lnp = WorkbenchContext.getInstance().getLayerNamePanel();
        if (lnp == null) {
            return Collections.emptyList();
        }
        ArrayList<Layerable> lstLy = new ArrayList<Layerable>();
        Collection<Category> colCat = lnp.getSelectedCategories();
        for (Category cat : colCat) {
            for (Layerable candidate : cat.getAllLayerables()) {
                if (!this.isAllowedLayer(candidate) || lstLy.contains(candidate)) continue;
                lstLy.add(candidate);
            }
        }
        Collection<Layerable> colLy = lnp.selectedNodes(Layerable.class);
        for (Layerable candidate : colLy) {
            if (!this.isAllowedLayer(candidate) || lstLy.contains(candidate)) continue;
            lstLy.add(candidate);
        }
        return lstLy;
    }

    private void updateTransparencyForSelectedLayers() {
        List<Layerable> selectedLayers = this.getSelectedSupportedLayers();
        for (Layerable ly : selectedLayers) {
            this.adjustLayer(ly, this.transparencyPanel.getAlpha());
        }
        this.repaintLayers(selectedLayers);
    }

    private void repaintLayers(Collection<Layerable> colLyChanged) {
        WorkbenchContext.getInstance().getLayerViewPanel().getRenderingManager().render(colLyChanged.iterator());
    }

    private void resetAlphaForLayers(Collection<Layerable> layerables) {
        HashSet<Layerable> layersToRepaint = new HashSet<Layerable>();
        for (Layerable ly : layerables) {
            for (StyleCollection sCol : ly.getStyleCollections()) {
                if (!sCol.canUserAdjustAlpha()) continue;
                sCol.resetAlpha();
                layersToRepaint.add(ly);
            }
        }
        this.repaintLayers(layersToRepaint);
        this.enableCheck();
    }

    private void adjustLayer(Layerable ly, int alpha) {
        for (StyleCollection sCol : ly.getStyleCollections()) {
            sCol.setAlpha(alpha);
        }
    }

    private void initComponents() {
        this.btnPanel = new JPanel();
        this.butReset = new JButton();
        this.butResetAll = new JButton();
        this.jSeparator1 = new JSeparator();
        this.lblLayer = new JLabel();
        this.lblLayerName = new JLabel();
        this.lblTransparency = new JLabel();
        this.transparencyPanel = new TransparencyPanel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(380, 140));
        this.setPreferredSize(new Dimension(380, 140));
        this.getContentPane().setLayout(new GridBagLayout());
        this.btnPanel.setLayout(new FlowLayout(1, 1, 1));
        this.butReset.setHorizontalAlignment(2);
        this.butReset.setMargin(new Insets(1, 1, 1, 1));
        this.butReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeUserDefinedTransparencyDialog.this.butReset_onActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.butReset);
        this.butResetAll.setHorizontalAlignment(2);
        this.butResetAll.setMargin(new Insets(1, 1, 1, 1));
        this.butResetAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeUserDefinedTransparencyDialog.this.butResetAll_onActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.butResetAll);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.btnPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.lblLayer.setHorizontalAlignment(11);
        this.lblLayer.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.getContentPane().add((Component)this.lblLayer, gridBagConstraints);
        this.lblLayerName.setFont(this.lblLayerName.getFont().deriveFont(this.lblLayerName.getFont().getStyle() | 1, this.lblLayerName.getFont().getSize() + 1));
        this.lblLayerName.setText("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.getContentPane().add((Component)this.lblLayerName, gridBagConstraints);
        this.lblTransparency.setHorizontalAlignment(11);
        this.lblTransparency.setText("Transparency:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 9, 3, 3);
        this.getContentPane().add((Component)this.lblTransparency, gridBagConstraints);
        this.transparencyPanel.setMinimumSize(new Dimension(122, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.getContentPane().add((Component)this.transparencyPanel, gridBagConstraints);
        this.pack();
    }

    private void butReset_onActionPerformed(ActionEvent evt) {
        this.resetAlphaForLayers(this.getSelectedSupportedLayers());
    }

    private void butResetAll_onActionPerformed(ActionEvent evt) {
        Set<Layerable> allLayerables = WorkbenchContext.getInstance().getLayerViewPanel().getLayerManager().getLayerablesUnordered(Layerable.class);
        this.resetAlphaForLayers(allLayerables);
    }
}

