/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.theming.ThemeRetriever;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.style.AreaPreviewPanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStyleLineAreaPanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStyleTooltipPanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStyleTransPanel;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import com.vividsolutions.jump.workbench.ui.style.ThemeStylePanel;
import com.vividsolutions.jump.workbench.ui.style.symbol.BasicStyleSymbolPanel;
import com.vividsolutions.jump.workbench.ui.style.text.BasicStyleTextPanel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.riwajump.model.style.theme.ThemeModel;
import de.riwagis.util.StringSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeatureType;

public class VectorLayerStylePanel
extends AbstractStylePanel {
    private LayerStyleCollection sCol;
    private PlugInContext context = null;
    private boolean bolUpdateControls = true;
    private boolean useTheming = false;
    private boolean themingPanelActive = false;
    private final List<StylePanel> themingStylePanels = new ArrayList<StylePanel>();
    private final List<StylePanel> defaultStylePanels = new ArrayList<StylePanel>();
    private final List<StylePanel> commonStylePanels = new ArrayList<StylePanel>();
    private BasicStyleModel bStyle = new BasicStyleModel();
    private ColorThemingStyleModel thStyle = new ColorThemingStyleModel();
    private boolean blockPanelEvents = false;
    private JCheckBox cboTheme;
    private JLabel lblPreviewArea;
    private JPanel pnlPreview;
    private JPanel previewPanelArea;
    private JPanel previewPanelSymbol;
    private JPanel previewPanelText;
    private JTabbedPane tabPane;

    public VectorLayerStylePanel(LayerStyleCollection _sCol, PlugInContext _context) {
        this.sCol = _sCol;
        this.context = _context;
        this.initComponents();
        this.i18n();
        this.init();
        this.updateControls();
    }

    private void i18n() {
        this.cboTheme.setText(I18N.get("ui.style.VectorLayerStylePanel.theme"));
        this.lblPreviewArea.setText(I18N.get("ui.style.VectorLayerStylePanel.preview"));
    }

    private void init() {
        this.commonStylePanels.add(new BasicStyleTransPanel(this.sCol, this.context));
        this.commonStylePanels.add(new BasicStyleTooltipPanel(this.sCol, this.context));
        this.themingStylePanels.add(new ThemeStylePanel(this.sCol, this.context));
        this.defaultStylePanels.add(new BasicStyleLineAreaPanel(this.sCol, this.context));
        this.defaultStylePanels.add(new BasicStyleSymbolPanel(this.sCol, this.context));
        this.defaultStylePanels.add(new BasicStyleTextPanel(this.sCol, this.context));
        this.addTabPanels(this.commonStylePanels);
        this.addTabPanels(this.defaultStylePanels);
        this.themingPanelActive = false;
        ActionListener styleChangedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VectorLayerStylePanel.this.blockPanelEvents) {
                    return;
                }
                StylePanel pnl = (StylePanel)e.getSource();
                if (pnl instanceof BasicStylePanel) {
                    ((BasicStylePanel)((Object)pnl)).updateBasicStyle(VectorLayerStylePanel.this.bStyle);
                    VectorLayerStylePanel.this.updatePreview();
                    VectorLayerStylePanel.this.updateTabLabels();
                    if (pnl instanceof BasicStyleTransPanel) {
                        VectorLayerStylePanel.this.updateTransparencyInOtherPanels();
                    }
                }
                if (pnl instanceof ThemeStylePanel) {
                    VectorLayerStylePanel.this.bStyle = ((ThemeStylePanel)pnl).getSelectedStyle();
                    VectorLayerStylePanel.this.updatePreview();
                }
            }
        };
        this.addPanelListener(styleChangedListener, this.commonStylePanels);
        this.addPanelListener(styleChangedListener, this.defaultStylePanels);
        this.addPanelListener(styleChangedListener, this.themingStylePanels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransparencyInOtherPanels() {
        this.blockPanelEvents = true;
        try {
            ThemeStylePanel thPanel = (ThemeStylePanel)this.getStylePanelByClass(ThemeStylePanel.class, this.themingStylePanels);
            thPanel.setTransparency(this.bStyle.getIntAlpha(), this.bStyle.isBolUseAlphaArea(), this.bStyle.isBolUseAlphaLine(), this.bStyle.isBolUseAlphaText(), this.bStyle.isBolUseAlphaSymbol());
            for (StylePanel pnl : this.defaultStylePanels) {
                if (!(pnl instanceof BasicStylePanel)) continue;
                ((BasicStylePanel)((Object)pnl)).setTransparency(this.bStyle.getIntAlpha(), this.bStyle.isBolUseAlphaArea(), this.bStyle.isBolUseAlphaLine(), this.bStyle.isBolUseAlphaText(), this.bStyle.isBolUseAlphaSymbol());
            }
        }
        finally {
            this.blockPanelEvents = false;
        }
    }

    private void addPanelListener(ActionListener listen, List<StylePanel> lstPanels) {
        for (StylePanel pnl : lstPanels) {
            pnl.addStyleChangedListener(listen);
        }
    }

    private void updateTabLabels() {
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            if (this.tabPane.getComponentAt(i) instanceof BasicStylePanel && this.tabPane.getComponentAt(i) instanceof StylePanel) {
                BasicStylePanel bspnl = (BasicStylePanel)((Object)this.tabPane.getComponentAt(i));
                StylePanel spnl = (StylePanel)((Object)this.tabPane.getComponentAt(i));
                if (bspnl.isStyleActive()) {
                    this.tabPane.setTitleAt(i, "<html><b>" + spnl.getTitle() + "</b></html>");
                } else {
                    this.tabPane.setTitleAt(i, spnl.getTitle());
                }
            }
            if (this.tabPane.getComponentAt(i) instanceof ThemeStylePanel) {
                StylePanel spnl = (StylePanel)((Object)this.tabPane.getComponentAt(i));
                this.tabPane.setTitleAt(i, "<html><b>" + spnl.getTitle() + "</b></html>");
            }
            if (!(this.tabPane.getComponentAt(i) instanceof BasicStyleLineAreaPanel)) continue;
            boolean lineAndAreaEnabled = !(this.sCol.getLayerable() instanceof LabelLayer);
            this.tabPane.setEnabledAt(i, lineAndAreaEnabled);
            if (lineAndAreaEnabled || this.tabPane.getSelectedIndex() != i) continue;
            this.tabPane.setSelectedIndex(i + 1);
        }
    }

    private void addTabPanels(List<StylePanel> lstPanels) {
        int idx = this.tabPane.getSelectedIndex();
        for (StylePanel pnl : lstPanels) {
            this.tabPane.add(pnl.getTitle(), (Component)((Object)pnl));
        }
        if (this.tabPane.getTabCount() > ++idx) {
            this.tabPane.setSelectedIndex(idx);
        }
    }

    private void removeTabPanels(List<StylePanel> lstPanels) {
        for (StylePanel pnl : lstPanels) {
            this.tabPane.remove((Component)((Object)pnl));
        }
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        this.bolUpdateControls = false;
        try {
            this.cboTheme.setSelected(this.useTheming);
            if (this.useTheming) {
                if (!this.themingPanelActive) {
                    this.removeTabPanels(this.defaultStylePanels);
                    this.addTabPanels(this.themingStylePanels);
                    this.themingPanelActive = true;
                }
            } else if (this.themingPanelActive) {
                this.removeTabPanels(this.themingStylePanels);
                this.addTabPanels(this.defaultStylePanels);
                this.themingPanelActive = false;
            }
            this.updatePreview();
            this.updateTabLabels();
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private BasicStyleModel makePreviewBasicStyle(BasicStyleModel oriBas) {
        float linewidth;
        BasicStyleModel basStyle = (BasicStyleModel)oriBas.cloneModel();
        int nextDefaultLineWidth = 1;
        if (basStyle.getLineForeground() != null) {
            if (basStyle.getLengthUnit() == 0 && StringSupport.isNumeric((String)basStyle.getLineForeground().getLineWidth())) {
                linewidth = Float.parseFloat(basStyle.getLineForeground().getLineWidth());
                basStyle.getLineForeground().setLineWidthFloat(Math.min(2.0f, linewidth));
            } else {
                basStyle.getLineForeground().setLineWidthFloat((float)nextDefaultLineWidth);
            }
            nextDefaultLineWidth = 3;
        } else {
            nextDefaultLineWidth = 2;
        }
        if (basStyle.getLineBase() != null) {
            if (basStyle.getLengthUnit() == 0 && StringSupport.isNumeric((String)basStyle.getLineBase().getLineWidth())) {
                linewidth = Float.parseFloat(basStyle.getLineBase().getLineWidth());
                basStyle.getLineBase().setLineWidthFloat(Math.min(8.0f, linewidth));
            } else {
                basStyle.getLineBase().setLineWidthFloat((float)nextDefaultLineWidth);
            }
            nextDefaultLineWidth += 2;
        }
        if (basStyle.getLineBackground() != null) {
            if (basStyle.getLengthUnit() == 0 && StringSupport.isNumeric((String)basStyle.getLineBackground().getLineWidth())) {
                linewidth = Float.parseFloat(basStyle.getLineBackground().getLineWidth());
                basStyle.getLineBackground().setLineWidthFloat(Math.min(16.0f, linewidth));
            } else {
                basStyle.getLineBackground().setLineWidthFloat((float)nextDefaultLineWidth);
            }
        }
        if (basStyle.getLengthUnit() != 0 || !StringSupport.isNumeric((String)basStyle.getFillSymWidth())) {
            basStyle.setFillSymWidth("10");
        }
        if (basStyle.getLengthUnit() != 0) {
            basStyle.setLengthUnit(0);
        }
        basStyle.setRenderingText(false);
        basStyle.setRenderingSymbol(false);
        RenderUtil.getRenderer(basStyle).initialize(this.sCol);
        return basStyle;
    }

    private void updatePreview() {
        if (this.bStyle == null) {
            ((AreaPreviewPanel)this.previewPanelArea).setStyle(null);
            ((AreaPreviewPanel)this.previewPanelSymbol).setStyle(null);
            ((AreaPreviewPanel)this.previewPanelText).setStyle(null);
            return;
        }
        if (this.bStyle.isRenderingFill() || this.bStyle.doesRenderLine()) {
            BasicStyleModel prevBStyle = this.makePreviewBasicStyle(this.bStyle);
            ((AreaPreviewPanel)this.previewPanelArea).setStyle((StyleModel)prevBStyle);
        } else {
            ((AreaPreviewPanel)this.previewPanelArea).setStyle(null);
        }
        if (this.bStyle.isRenderingSymbol()) {
            SymbolStyleModel prevSymStyle = (SymbolStyleModel)this.bStyle.getSymStyle().cloneModel();
            String strPrevSymName = RenderUtil.getSymbolName(prevSymStyle);
            prevSymStyle.setStrPtSymbol(strPrevSymName);
            prevSymStyle.setStrStartSymbol("");
            prevSymStyle.setStrEndSymbol("");
            prevSymStyle.setStrAreaSymbol("");
            prevSymStyle.setStrPtHeight("30");
            prevSymStyle.setStrPtWidth("30");
            prevSymStyle.setBolPtRatio(true);
            prevSymStyle.setStrPtShiftLeft("0");
            prevSymStyle.setStrPtShiftTop("0");
            prevSymStyle.setStrPtOri("0");
            RenderUtil.getRenderer(prevSymStyle).initialize(this.sCol);
            ((AreaPreviewPanel)this.previewPanelSymbol).setStyle((StyleModel)prevSymStyle);
        } else {
            ((AreaPreviewPanel)this.previewPanelSymbol).setStyle(null);
        }
        if (this.bStyle.isRenderingText()) {
            TextStyleModel prevTxtStyle = (TextStyleModel)this.bStyle.getTextStyle().cloneModel();
            prevTxtStyle.setStrText("\"Abc123\"");
            prevTxtStyle.setStrOrient("0");
            prevTxtStyle.setStrTransLeft("0");
            if (prevTxtStyle.getIntUnitLengthText() == 1 || !StringSupport.isNumeric((String)Objects.requireNonNullElse(prevTxtStyle.getStrHeight(), ""))) {
                prevTxtStyle.setIntUnitLengthText(0);
                prevTxtStyle.setStrHeight("12");
            }
            prevTxtStyle.setIntUnitLength(0);
            prevTxtStyle.setStrTransTop("0");
            prevTxtStyle.setIntUnitLength(0);
            prevTxtStyle.setAlignPoint("7");
            prevTxtStyle.setBolShowPoint(true);
            RenderUtil.getRenderer(prevTxtStyle).initialize(this.sCol);
            ((AreaPreviewPanel)this.previewPanelText).setStyle((StyleModel)prevTxtStyle);
        } else {
            ((AreaPreviewPanel)this.previewPanelText).setStyle(null);
        }
    }

    @Override
    public String validateInput() {
        StringBuilder sbError = new StringBuilder();
        for (StylePanel pnl : this.commonStylePanels) {
            this.validatePanel(pnl, sbError);
        }
        List<StylePanel> stylePanels = this.useTheming ? this.themingStylePanels : this.defaultStylePanels;
        for (StylePanel pnl : stylePanels) {
            this.validatePanel(pnl, sbError);
        }
        if (sbError.length() > 0) {
            return sbError.toString();
        }
        return null;
    }

    private void validatePanel(StylePanel pnl, StringBuilder sbError) {
        String strError = pnl.validateInput();
        if (strError == null) {
            return;
        }
        if (sbError.length() > 0) {
            sbError.append("\n");
        }
        sbError.append(pnl.getTitle()).append(": ").append(strError);
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.VectorLayerStylePanel.title");
    }

    private void setFeatureTypeRetriever(List<StylePanel> lstPanels, FeatureRetriever featureTypeRetriever) {
        for (StylePanel pnl : lstPanels) {
            pnl.setFeatureRetriever(featureTypeRetriever);
        }
    }

    @Override
    public void setFeatureRetriever(FeatureRetriever featureTypeRetriever) {
        this.setFeatureTypeRetriever(this.commonStylePanels, featureTypeRetriever);
        this.setFeatureTypeRetriever(this.defaultStylePanels, featureTypeRetriever);
        this.setFeatureTypeRetriever(this.themingStylePanels, featureTypeRetriever);
        super.setFeatureRetriever(featureTypeRetriever);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStyleCollection(StyleCollection _sCol) {
        this.blockPanelEvents = true;
        try {
            this.sCol = (LayerStyleCollection)_sCol;
            SimpleFeatureType fSchema = this.getFeatureRetriever().getFeatureType();
            this.useTheming = !this.sCol.getBasicStyle().isEnabled();
            this.bStyle = this.sCol.getBasicStyle();
            this.thStyle = this.useTheming ? ColorThemingRenderer.get(this.sCol) : null;
            if (this.useTheming) {
                ColorThemingStyleModel thStyle = ColorThemingRenderer.get(this.sCol);
                this.bStyle = thStyle.getDefaultStyle();
            }
            this.setFeatureRetriever(this.getFeatureRetriever());
            this.setStyleCollection(this.commonStylePanels);
            this.setStyleCollection(this.defaultStylePanels);
            this.setStyleCollection(this.themingStylePanels);
        }
        finally {
            this.blockPanelEvents = false;
        }
        this.updateControls();
    }

    private void setStyleCollection(List<StylePanel> lstPanels) {
        for (StylePanel pnl : lstPanels) {
            pnl.setStyleCollection(this.sCol);
        }
    }

    private StylePanel getStylePanelByClass(Class clazz, List<StylePanel> lstPanels) {
        for (StylePanel pnl : lstPanels) {
            if (!pnl.getClass().equals(clazz)) continue;
            return pnl;
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public void updateStyles() {
        if (this.useTheming) {
            this.sCol.getBasicStyle().setEnabled(false);
            this.sCol.removeStyle((StyleModel)ColorThemingRenderer.get(this.sCol));
            ThemeStylePanel themePanel = (ThemeStylePanel)this.getStylePanelByClass(ThemeStylePanel.class, this.themingStylePanels);
            this.thStyle = themePanel.getColorThemingStyle();
            this.thStyle.setEnabled(true);
            this.sCol.addStyle((StyleModel)this.thStyle);
            BasicStyleTransPanel transPanel = (BasicStyleTransPanel)this.getStylePanelByClass(BasicStyleTransPanel.class, this.commonStylePanels);
            transPanel.updateBasicStyle(this.thStyle.getDefaultStyle());
            ThemeRetriever retriever = (ThemeRetriever)this.thStyle.getThemeSource().getIntelligence();
            Collection<ThemeModel> themes = retriever.getThemesOrEmptyOnError(this.sCol.getLayer());
            for (ThemeModel model : themes) {
                transPanel.updateBasicStyle(model.getStyle());
            }
            RenderUtil.getRenderer(this.thStyle).clearLegendLabelCache();
        } else {
            if (this.sCol.getStyle(ColorThemingStyleModel.class) != null) {
                this.sCol.removeStyle((StyleModel)this.sCol.getStyle(ColorThemingStyleModel.class));
            }
            this.sCol.removeStyle((StyleModel)this.sCol.getBasicStyle());
            this.sCol.addStyle((StyleModel)new BasicStyleModel());
            this.sCol.getBasicStyle().setEnabled(true);
            for (StylePanel pnl : this.defaultStylePanels) {
                if (!(pnl instanceof BasicStylePanel)) continue;
                ((BasicStylePanel)((Object)pnl)).updateBasicStyle(this.sCol.getBasicStyle());
            }
        }
        for (StylePanel pnl : this.commonStylePanels) {
            if (!(pnl instanceof BasicStylePanel)) continue;
            ((BasicStylePanel)((Object)pnl)).updateBasicStyle(this.sCol.getBasicStyle());
        }
        RenderUtil.getRenderer(this.sCol.getBasicStyle()).clearLegendLabelCache();
    }

    private void initComponents() {
        this.cboTheme = new JCheckBox();
        this.tabPane = new JTabbedPane();
        this.lblPreviewArea = new JLabel();
        this.pnlPreview = new JPanel();
        this.previewPanelArea = new AreaPreviewPanel();
        this.previewPanelText = new AreaPreviewPanel();
        this.previewPanelSymbol = new AreaPreviewPanel();
        this.setRequestFocusEnabled(false);
        this.setLayout(new GridBagLayout());
        this.cboTheme.setText("thematische Darstellung");
        this.cboTheme.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboTheme.setMargin(new Insets(0, 0, 0, 0));
        this.cboTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorLayerStylePanel.this.cboTheme_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 7, 3, 2);
        this.add((Component)this.cboTheme, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabPane, gridBagConstraints);
        this.lblPreviewArea.setText("Vorschau");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 17, 0, 0);
        this.add((Component)this.lblPreviewArea, gridBagConstraints);
        this.pnlPreview.setLayout(new GridBagLayout());
        this.previewPanelArea.setBackground(new Color(255, 255, 255));
        this.previewPanelArea.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Component.borderColor")));
        this.previewPanelArea.setMaximumSize(new Dimension(100, 60));
        this.previewPanelArea.setMinimumSize(new Dimension(80, 60));
        this.previewPanelArea.setPreferredSize(new Dimension(80, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 4, 6);
        this.pnlPreview.add((Component)this.previewPanelArea, gridBagConstraints);
        this.previewPanelText.setBackground(new Color(255, 255, 255));
        this.previewPanelText.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Component.borderColor")));
        this.previewPanelText.setMaximumSize(new Dimension(80, 60));
        this.previewPanelText.setMinimumSize(new Dimension(80, 60));
        this.previewPanelText.setPreferredSize(new Dimension(80, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 3, 5);
        this.pnlPreview.add((Component)this.previewPanelText, gridBagConstraints);
        this.previewPanelSymbol.setBackground(new Color(255, 255, 255));
        this.previewPanelSymbol.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Component.borderColor")));
        this.previewPanelSymbol.setMaximumSize(new Dimension(80, 60));
        this.previewPanelSymbol.setMinimumSize(new Dimension(80, 60));
        this.previewPanelSymbol.setPreferredSize(new Dimension(60, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 3, 5);
        this.pnlPreview.add((Component)this.previewPanelSymbol, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlPreview, gridBagConstraints);
    }

    private void cboTheme_onActionPerformed(ActionEvent evt) {
        this.useTheming = this.cboTheme.isSelected();
        if (this.useTheming) {
            this.thStyle = ColorThemingRenderer.get(this.sCol);
            ThemeRetriever retriever = (ThemeRetriever)this.thStyle.getThemeSource().getIntelligence();
            if (retriever.getThemesOrEmptyOnError(this.sCol.getLayer()).isEmpty()) {
                this.thStyle.setDefaultStyle((BasicStyleModel)this.bStyle.cloneModel());
            }
            this.thStyle.setEnabled(true);
            this.bStyle = this.thStyle.getDefaultStyle();
            this.setStyleCollection(this.themingStylePanels);
        }
        if (!this.useTheming) {
            int option = JOptionPane.showConfirmDialog(this, I18N.get("ui.style.ThemeStylePanel.refill-warning"), "", 0);
            if (option == 1) {
                this.useTheming = true;
            }
            this.bStyle = this.sCol.getBasicStyle();
            this.bStyle.setEnabled(true);
        }
        this.updateControls();
        MultiInputDialog.fitDialogToContent(SwingUtilities.getWindowAncestor(this));
    }
}

