/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.components.CheckBoxList;
import com.vividsolutions.jump.workbench.ui.components.ColorPanel;
import com.vividsolutions.jump.workbench.ui.components.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorSchemeListCellRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingRenderer;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStyleDialog;
import com.vividsolutions.jump.workbench.ui.style.BasicStyleListCellRenderer;
import com.vividsolutions.jump.workbench.ui.style.DynamicThemeSourcePanel;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.ThemeSourcePanel;
import com.vividsolutions.jump.workbench.ui.style.theming.AttributeDefPanel;
import com.vividsolutions.jump.workbench.ui.style.theming.DiscreteColorThemingState;
import com.vividsolutions.jump.workbench.ui.style.theming.DynamicColorThemingState;
import com.vividsolutions.jump.workbench.ui.style.theming.RangeColorThemingState;
import com.vividsolutions.jump.workbench.ui.style.theming.ThemeColor;
import com.vividsolutions.jump.workbench.ui.style.theming.ThemingTableModel;
import de.riwagis.geotools.feature.bsh.FeatBshStringBuilder;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.theme.BasicStaticThemeSourceModel;
import de.riwagis.riwajump.model.style.theme.DynamicThemeSourceModel;
import de.riwagis.riwajump.model.style.theme.StaticDiscreteThemeSourceModel;
import de.riwagis.riwajump.model.style.theme.StaticRangeThemeSourceModel;
import de.riwagis.riwajump.model.style.theme.ThemeSourceModel;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeStylePanel
extends AbstractStylePanel {
    private static final Logger LOG = LoggerFactory.getLogger(ThemeStylePanel.class);
    private static final long serialVersionUID = 8359921150953076496L;
    private boolean useElseFilter = true;
    private String strAttribute = null;
    private ColorScheme colorSchemeForInserts = null;
    private ColorThemingStyleModel style;
    private static final String CUSTOM_ENTRY = I18N.get("ui.style.ThemeStylePanel.custom");
    public static final String TITLE = I18N.get("ui.style.ThemeStylePanel.title");
    public static final String COLOR_SCHEME_KEY = ThemeStylePanel.class.getName() + " - COLOR SCHEME";
    private int alpha = 205;
    private boolean bolUseAlphaArea = true;
    private boolean bolUseAlphaLine = true;
    private boolean bolUseAlphaText = true;
    private boolean bolUseAlphaSymbol = true;
    private final PlugInContext context;
    private BasicStyleDialog basicStyleDialog = null;
    private boolean basicStyleDialogEverVisible = false;
    private final BasicStyleListCellRenderer<Object> basicStyleListCellRenderer = new BasicStyleListCellRenderer();
    private final Collection<ErrorMessage> errorMessages = new HashSet<ErrorMessage>();
    private DiscreteColorThemingState discreteColorThemingState = null;
    private RangeColorThemingState rangeColorThemingState = null;
    private DynamicColorThemingState dynamicColorThemingState = null;
    private State state = null;
    private final DefaultTableCellRenderer allOtherValuesRenderer = new DefaultTableCellRenderer();
    private LayerStyleCollection sCol;
    private boolean blockEvents = false;
    private AttributeDefPanel pnlAttDef = null;
    private DynamicThemeSourcePanel dynamicThemeSourcePanel = new DynamicThemeSourcePanel(new DynamicThemeSourcePanel.ThemeStyleController(){

        @Override
        public void promptAttributeDefinitionWithEscapeOption(SimpleFeatureType featureType, DynamicThemeSourcePanel.BeanShellDefinition current, Consumer<DynamicThemeSourcePanel.BeanShellDefinition> updater) {
            ThemeStylePanel.this.promptAttDefDialog(featureType, true, current, updater);
        }

        @Override
        public void promptAttributeDefinition(SimpleFeatureType featureType, String current, Consumer<String> updater) {
            ThemeStylePanel.this.promptAttDefDialog(featureType, current, updater);
        }

        @Override
        public void promptBasicStyleDialog(BasicStyleModel basicStyleModel) {
            this.setBasicStyleToDialog(basicStyleModel);
            ThemeStylePanel.this.promptBasicStyleDialog();
        }

        @Override
        public void setBasicStyleToDialog(BasicStyleModel basicStyleModel) {
            if (basicStyleModel == null) {
                return;
            }
            BasicStyleDialog styleDialog = ThemeStylePanel.this.getBasicStyleDialog();
            try {
                styleDialog.setBlockStyleChangedEvents(true);
                styleDialog.setBasicStyle((BasicStyleModel)basicStyleModel.cloneModel());
            }
            finally {
                styleDialog.setBlockStyleChangedEvents(false);
            }
        }

        @Override
        public FeatureRetriever getFeatureRetriever() {
            return ThemeStylePanel.this.getFeatureRetriever();
        }

        @Override
        public LayerStyleCollection getStyleCollection() {
            return ThemeStylePanel.this.sCol;
        }

        @Override
        public PlugInContext getContext() {
            return ThemeStylePanel.this.context;
        }

        @Override
        public void fireStyleChanged() {
            ThemeStylePanel.this.fireStyleChanged();
        }
    });
    private ThemeSourcePanel staticThemeSourcePanel = new ThemeSourcePanel(){

        @Override
        public void updateStyleFromDialog(BasicStyleDialog basicStyleDialog) {
            int selectedRow = ThemeStylePanel.this.tblTheme.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            selectedRow = ThemeStylePanel.this.tblTheme.convertRowIndexToModel(selectedRow);
            BasicStyleModel style1 = (BasicStyleModel)ThemeStylePanel.this.tblTheme.getModel().getValueAt(selectedRow, 0);
            if (style1 == null) {
                return;
            }
            basicStyleDialog.updateBasicStyle(style1);
            ThemeStylePanel.this.tblTheme.getModel().setValueAt(style1, selectedRow, 0);
        }

        @Override
        void updateFromModel() {
            ThemeStylePanel.this.refillTableByStyle();
        }

        @Override
        void stopEditing() {
            ThemeStylePanel.this.stopCellEditing();
        }

        @Override
        void refreshBasicStyleDialog() {
            if (ThemeStylePanel.this.tblTheme.getModel().getRowCount() > 0) {
                ThemeStylePanel.this.tblTheme.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
    };
    private ThemeSourcePanel activeThemeSourcePanel;
    private ButtonGroup bugThemeType;
    private JButton butAdd;
    private JButton butAttributeDef;
    private JButton butAutoFill;
    private JButton butDelete;
    private JCheckBox cboUseElseFilter;
    private JComboBox<String> cmbColorScheme;
    private JPanel editorPanel;
    private JLabel lblAttribute;
    private JLabel lblColorScheme;
    private JLabel lblStatus;
    private JRadioButton rbThemeTypedDynamicValues;
    private JRadioButton rbThemeTypedStaticRanged;
    private JRadioButton rbThemeTypedStaticValues;
    private JScrollPane scrollPane;
    private JPanel staticEditorPanel;
    private JTable tblTheme;
    private JPanel toolbarPanel;
    private JTextField txtAttributeDef;
    private JPanel typePanel;
    private final TableCellEditor basicStyleTableCellEditor = new BasicStyleTableCellEditor();

    public ThemeStylePanel(LayerStyleCollection _sCol, PlugInContext _context) {
        this.sCol = _sCol;
        this.style = ColorThemingRenderer.get(_sCol);
        this.context = _context;
        this.initComponents();
        this.i18n();
        this.init();
        this.setStyleCollection(_sCol);
    }

    private void i18n() {
        this.lblAttribute.setText(I18N.get("ui.style.ThemeStylePanel.attribute"));
        this.rbThemeTypedStaticRanged.setText(I18N.get("ui.style.ThemeStylePanel.static-ranges"));
        this.rbThemeTypedStaticValues.setText(I18N.get("ui.style.ThemeStylePanel.static-values"));
        this.rbThemeTypedDynamicValues.setText(I18N.get("ui.style.ThemeStylePanel.dynamic-values"));
        this.lblColorScheme.setText(I18N.get("ui.style.ThemeStylePanel.color-scheme"));
        this.butAttributeDef.setText(I18N.get("ui.style.ThemeStylePanel.att-settungs"));
    }

    private void init() {
        boolean oldBlockEvents = this.blockEvents;
        try {
            this.blockEvents = true;
            this.butAdd.setIcon(IconLoader.svgIcon((String)"common_add.svg"));
            this.butAdd.setToolTipText(I18N.get("ui.style.ThemeStylePanel.insert-row"));
            this.butDelete.setIcon(IconLoader.svgIcon((String)"common_delete.svg"));
            this.butDelete.setToolTipText(I18N.get("ui.style.ThemeStylePanel.delete-row"));
            this.butAutoFill.setIcon(IconLoader.svgIcon((String)"layer_add_dataset.svg", (int)18));
            this.butAutoFill.setToolTipText(I18N.get("ui.style.ThemeStylePanel.autofill-themes"));
            this.initColorSchemeComboBox(this.sCol.getLayer().getLayerManager());
            this.discreteColorThemingState = new DiscreteColorThemingState(this.tblTheme, this.rbThemeTypedStaticValues, () -> this.validateStaticSourceInput());
            this.rangeColorThemingState = new RangeColorThemingState(this, this.rbThemeTypedStaticRanged, () -> this.validateStaticSourceInput());
            this.dynamicColorThemingState = new DynamicColorThemingState(this.rbThemeTypedDynamicValues, this.dynamicThemeSourcePanel);
            this.state = this.discreteColorThemingState;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            this.initTable();
        }
        finally {
            this.blockEvents = oldBlockEvents;
        }
    }

    private void updateControls() {
        boolean oldBlockEvents = this.blockEvents;
        try {
            this.blockEvents = true;
            this.state.selectMatchingUIElement();
            this.cboUseElseFilter.setSelected(this.useElseFilter);
            this.cboUseElseFilter.setText(I18N.getMessage("ui.style.ThemeStylePanel.use-else-filter", this.state.getAllOtherValuesDescription()));
            this.dynamicThemeSourcePanel.showDefaultLabel(this.useElseFilter);
            this.butAutoFill.setEnabled(this.state.canAutoFillTable());
            this.txtAttributeDef.setText(this.strAttribute);
            this.tblTheme.repaint();
            this.cmbColorScheme.repaint();
            boolean errorActive = this.setErrorMessage(new ErrorMessage(I18N.get("ui.style.ThemeStylePanel.cannot-colour-theme-layer-with-no-attributes")), this.getFeatureRetriever().getFeatureType().getAttributeCount() == 0);
            if (!errorActive) {
                this.setErrorMessage(new ErrorMessage(I18N.get("ui.style.ThemeStylePanel.table-must-not-be-empty")), this.tblTheme.getRowCount() == 0);
            }
            this.updateErrorDisplay();
            this.fireStyleChanged();
        }
        finally {
            this.blockEvents = oldBlockEvents;
        }
    }

    private void initColorSchemeComboBox(LayerManager layerManager) {
        this.cmbColorScheme.setRenderer(new ColorSchemeListCellRenderer(){

            @Override
            protected void color(ColorPanel colorPanel, Color fillColor, Color lineColor) {
                super.color(colorPanel, GUIUtil.alphaColor(fillColor, ThemeStylePanel.this.alpha), GUIUtil.alphaColor(lineColor, ThemeStylePanel.this.alpha));
            }

            @Override
            protected ColorScheme colorScheme(String name) {
                return ThemeStylePanel.this.state.filterColorScheme(super.colorScheme(name));
            }
        });
    }

    public ColorThemingStyleModel getColorThemingStyle() {
        this.activeThemeSourcePanel.stopEditing();
        ColorThemingStyleModel thStyle = new ColorThemingStyleModel();
        thStyle.setUseElseFilter(this.useElseFilter);
        try {
            this.copyOverThemeSourceFromUI(thStyle);
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError("Could not clone theme source", ex);
        }
        thStyle.setAttributeName(this.getAttributeName());
        thStyle.getDefaultStyle().setIntAlpha(this.alpha);
        thStyle.getDefaultStyle().setBolUseAlphaArea(this.bolUseAlphaArea);
        thStyle.getDefaultStyle().setBolUseAlphaLine(this.bolUseAlphaLine);
        thStyle.getDefaultStyle().setBolUseAlphaText(this.bolUseAlphaText);
        thStyle.getDefaultStyle().setBolUseAlphaSymbol(this.bolUseAlphaSymbol);
        thStyle.getDefaultStyle().setEnabled(this.useElseFilter);
        return thStyle;
    }

    private void fillInStaticThemes(BasicStaticThemeSourceModel<?> source) {
        for (Object keyObj : source.getAttributeValueToBasicStyleMap().keySet()) {
            BasicStyleModel basicStyle = (BasicStyleModel)source.getAttributeValueToBasicStyleMap().get(keyObj);
            basicStyle.setIntAlpha(this.alpha);
            basicStyle.setBolUseAlphaArea(this.bolUseAlphaArea);
            basicStyle.setBolUseAlphaLine(this.bolUseAlphaLine);
            basicStyle.setBolUseAlphaText(this.bolUseAlphaText);
            basicStyle.setBolUseAlphaSymbol(this.bolUseAlphaSymbol);
        }
    }

    private void copyOverThemeSourceFromUI(ColorThemingStyleModel thStyle) throws CloneNotSupportedException {
        DynamicThemeSourceModel sourceModel;
        if (this.rbThemeTypedDynamicValues.isSelected()) {
            sourceModel = this.dynamicThemeSourcePanel.getThemeSource().clone();
        } else if (this.rbThemeTypedStaticValues.isSelected()) {
            sourceModel = new StaticDiscreteThemeSourceModel(this.state.toExternalFormat(this.tableModel().getAttributeValueToBasicStyleMap()), this.state.toExternalFormat(this.tableModel().getAttributeValueToLabelMap()), this.tableModel().getDefaultStyle());
            sourceModel.setDefaultLabel(this.tableModel().getDefaultLabel());
            this.fillInStaticThemes((BasicStaticThemeSourceModel)sourceModel);
        } else if (this.rbThemeTypedStaticRanged.isSelected()) {
            sourceModel = new StaticRangeThemeSourceModel(this.state.toExternalFormat(this.tableModel().getAttributeValueToBasicStyleMap()), this.state.toExternalFormat(this.tableModel().getAttributeValueToLabelMap()), this.tableModel().getDefaultStyle());
            sourceModel.setDefaultLabel(this.tableModel().getDefaultLabel());
            this.fillInStaticThemes((BasicStaticThemeSourceModel)sourceModel);
        } else {
            throw new AssertionError((Object)"Unknown Theme Style Source Type");
        }
        thStyle.setThemeSource((ThemeSourceModel)sourceModel);
    }

    private void createThemeSourceFromUI(ColorThemingStyleModel thStyle) {
        DynamicThemeSourceModel sourceModel;
        if (this.rbThemeTypedDynamicValues.isSelected()) {
            sourceModel = new DynamicThemeSourceModel();
        } else if (this.rbThemeTypedStaticValues.isSelected()) {
            sourceModel = new StaticDiscreteThemeSourceModel();
        } else if (this.rbThemeTypedStaticRanged.isSelected()) {
            sourceModel = new StaticRangeThemeSourceModel();
        } else {
            throw new AssertionError((Object)"Unknown Theme Style Source Type");
        }
        try {
            ThemeSourceModel oldSource = thStyle.getThemeSource();
            if (oldSource instanceof DynamicThemeSourceModel) {
                sourceModel.setDefaultStyle(oldSource.getDefaultStyle().clone());
                sourceModel.setDefaultLabel(oldSource.getDefaultLabel());
            } else {
                sourceModel.setDefaultStyle(this.tableModel().getDefaultStyle().clone());
                sourceModel.setDefaultLabel(this.tableModel().getDefaultLabel());
            }
        }
        catch (CloneNotSupportedException e) {
            LOG.error("Could not clone default basic style.", (Throwable)e);
        }
        thStyle.setThemeSource((ThemeSourceModel)sourceModel);
    }

    @Override
    public final void setStyleCollection(StyleCollection _sCol) {
        int selectedRowModel;
        boolean oldBlockEvents = this.blockEvents;
        try {
            this.blockEvents = true;
            if (this.basicStyleDialog != null) {
                this.basicStyleDialog.setBlockStyleChangedEvents(true);
            }
            this.sCol = (LayerStyleCollection)_sCol;
            this.basicStyleListCellRenderer.initialize(this.sCol);
            this.style = ColorThemingRenderer.get(this.sCol);
            this.useElseFilter = this.style.isUseElseFilter();
            this.strAttribute = this.style.getAttributeName();
            this.setState(this.style.getThemeSource());
            this.activeThemeSourcePanel.updateFromModel();
            if (this.basicStyleDialog != null) {
                this.basicStyleDialog.setStyleCollection(_sCol);
            }
        }
        finally {
            this.blockEvents = oldBlockEvents;
            if (this.basicStyleDialog != null) {
                this.basicStyleDialog.setBlockStyleChangedEvents(false);
                this.activeThemeSourcePanel.refreshBasicStyleDialog();
            }
        }
        int selectedRowView = this.tblTheme.getSelectedRow();
        int n = selectedRowModel = selectedRowView == -1 ? -1 : this.tblTheme.convertRowIndexToModel(selectedRowView);
        if (this.basicStyleDialog != null && selectedRowModel < this.tblTheme.getRowCount() && selectedRowModel > -1) {
            this.tblTheme.getSelectionModel().setSelectionInterval(selectedRowView, selectedRowView);
        }
        this.updateControls();
    }

    @Override
    public final void setFeatureRetriever(FeatureRetriever ftRetriever) {
        if (this.basicStyleDialog != null) {
            this.basicStyleDialog.setFeatureTypeRetriever(ftRetriever);
        }
        super.setFeatureRetriever(ftRetriever);
        this.updateControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ThemeSourceModel source) {
        State newState;
        if (source instanceof DynamicThemeSourceModel) {
            this.updateEditorPanel(this.dynamicThemeSourcePanel);
            this.dynamicThemeSourcePanel.setThemeSource(source);
            newState = this.dynamicColorThemingState;
        } else if (source instanceof StaticDiscreteThemeSourceModel) {
            this.updateEditorPanel(this.staticThemeSourcePanel);
            newState = this.discreteColorThemingState;
        } else if (source instanceof StaticRangeThemeSourceModel) {
            this.updateEditorPanel(this.staticThemeSourcePanel);
            newState = this.rangeColorThemingState;
        } else {
            throw new AssertionError((Object)"Unknown Theme Source Model");
        }
        this.state.deactivate();
        boolean oldBlockEvents = this.blockEvents;
        try {
            this.blockEvents = true;
            this.cmbColorScheme.setModel(new DefaultComboBoxModel<String>(new Vector<String>(newState.getColorSchemeNames())));
            this.cmbColorScheme.setSelectedItem(this.sCol.getLayer().getLayerManager().getBlackboard().get(COLOR_SCHEME_KEY, this.cmbColorScheme.getItemAt(0)));
        }
        finally {
            this.blockEvents = oldBlockEvents;
        }
        this.state = newState;
        this.activeThemeSourcePanel.updateFromModel();
        this.state.activate();
        this.editorPanel.revalidate();
        this.editorPanel.repaint();
    }

    private void updateEditorPanel(ThemeSourcePanel newPanel) {
        if (this.activeThemeSourcePanel == newPanel) {
            return;
        }
        this.editorPanel.removeAll();
        this.editorPanel.add(newPanel);
        this.activeThemeSourcePanel = newPanel;
    }

    private int attributeColumn() {
        return this.tblTheme.convertColumnIndexToView(1);
    }

    private int labelColumn() {
        return this.tblTheme.convertColumnIndexToView(2);
    }

    private int colorColumn() {
        return this.tblTheme.convertColumnIndexToView(0);
    }

    private Map<Object, BasicStyleModel> attributeValueToBasicStyleMap() {
        if (!this.colorThemingAttributeValid()) {
            return new TreeMap<Object, BasicStyleModel>();
        }
        return this.state.fromExternalFormat(((BasicStaticThemeSourceModel)this.style.getThemeSource()).getAttributeValueToBasicStyleMap());
    }

    private Map<Object, String> attributeValueToLabelMap() {
        if (!this.colorThemingAttributeValid()) {
            return new TreeMap<Object, String>();
        }
        return this.state.fromExternalFormat(((BasicStaticThemeSourceModel)this.style.getThemeSource()).getAttributeValueToLabelMap());
    }

    private boolean colorThemingAttributeValid() {
        return this.strAttribute != null && this.strAttribute.trim().length() != 0;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    public void setTransparency(int _alpha, boolean bolArea, boolean bolLine, boolean bolText, boolean bolSymbol) {
        this.alpha = _alpha;
        this.bolUseAlphaArea = bolArea;
        this.bolUseAlphaLine = bolLine;
        this.bolUseAlphaText = bolText;
        this.bolUseAlphaSymbol = bolSymbol;
        this.tableModel().setTransparency(_alpha, bolArea, bolLine, bolText, bolSymbol);
        this.updateControls();
    }

    public void refillTableByStyle() {
        this.stopCellEditing();
        this.tableModel().clear();
        if (this.strAttribute == null || this.strAttribute.trim().length() == 0) {
            return;
        }
        this.tableModel().setDefaultStyle(this.style.getDefaultStyle());
        this.tableModel().setDefaultLabel(this.style.getDefaultLabel());
        this.tableModel().setMaps(this.attributeValueToBasicStyleMap(), this.attributeValueToLabelMap());
        this.tableModel().sortByValueSameOrder();
    }

    public void refillTableByDataStore() {
        this.stopCellEditing();
        BasicStyleModel defaultStyle = this.tableModel().getDefaultStyle();
        this.tableModel().clear();
        if (this.strAttribute == null || this.strAttribute.trim().length() == 0) {
            return;
        }
        WaitDialog dlgWait = new WaitDialog(SwingUtilities.windowForComponent(this), I18N.get("ui.style.ThemeStylePanel.please-wait-collection-styles"), () -> {});
        HashSet setThemeValues = new HashSet();
        Runnable run = () -> {
            try {
                FeatBshStringBuilder sbFeat = FeatBshStringBuilder.getInstance((String)this.strAttribute);
                try (FeatureIterator<SimpleFeature> fi = this.getFeatureRetriever().getFeatureIterator((Filter)Filter.INCLUDE);){
                    while (fi.hasNext()) {
                        if (!dlgWait.isVisible()) {
                            setThemeValues.clear();
                            return;
                        }
                        SimpleFeature feat = (SimpleFeature)fi.next();
                        sbFeat.setFeature(feat);
                        String strValue = sbFeat.getString();
                        if (!setThemeValues.contains(strValue)) {
                            setThemeValues.add(strValue);
                            SwingUtilities.invokeLater(() -> this.tableModel().insertAttributeValue(this.tableModel().getRowCount(), strValue, strValue, (BasicStyleModel)defaultStyle.cloneModel()));
                        }
                        if (this.tableModel().getRowCount() <= 500) continue;
                        throw new Exception("Too many different values. Max. 500.");
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error loading theme values", (Throwable)e);
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setCancelable(true);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            GUISupport.msgbox((Component)this, (String)dlgWait.getError().getMessage(), (String)I18N.get("common.error"));
        }
    }

    public void applyColorScheme() {
        this.stopCellEditing();
        if (!this.state.canApplyColorSchemes()) {
            return;
        }
        Collection<ThemeColor> colors = this.requestColorTargets();
        if (colors.isEmpty()) {
            return;
        }
        this.state.applyColorScheme(this.state.filterColorScheme(ColorScheme.create((String)this.cmbColorScheme.getSelectedItem())), new LinkedHashSet<ThemeColor>(colors));
    }

    private Collection<ThemeColor> requestColorTargets() {
        this.cmbColorScheme.hidePopup();
        CheckBoxList<ThemeColor> colorList = new CheckBoxList<ThemeColor>(List.of(ThemeColor.values()), tc -> ThemeColor.TRANSLATIONS.getOrDefault(tc, "???"));
        JScrollPane scrollableList = new JScrollPane(colorList);
        int result = JOptionPane.showConfirmDialog(this.cmbColorScheme, scrollableList, I18N.get("ui.style.ThemeStylePanel.apply-to-targets.chooser-title"), 2, -1);
        if (result != 0) {
            return Collections.emptySet();
        }
        Set<ThemeColor> checkedValues = colorList.getCheckedValues();
        if (checkedValues.isEmpty()) {
            return Collections.emptySet();
        }
        return EnumSet.copyOf(checkedValues);
    }

    private String getAttributeName() {
        return this.strAttribute;
    }

    public ThemingTableModel tableModel() {
        return (ThemingTableModel)this.tblTheme.getModel();
    }

    public LayerStyleCollection getLayerStyleCollection() {
        return this.sCol;
    }

    private void initTable() {
        this.tblTheme.setModel(new ThemingTableModel(this.style.getDefaultStyle(), new TreeMap(), new TreeMap()){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex == 0 && columnIndex == 1) {
                    return ThemeStylePanel.this.state.getAllOtherValuesDescription();
                }
                return super.getValueAt(rowIndex, columnIndex);
            }
        });
        TableRowSorter<ThemingTableModel> sorter = new TableRowSorter<ThemingTableModel>(this.tableModel());
        RowFilter<ThemingTableModel, Integer> tableRowFilter = new RowFilter<ThemingTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ThemingTableModel, ? extends Integer> entry) {
                if (ThemeStylePanel.this.useElseFilter) {
                    return true;
                }
                return entry.getIdentifier() != 0;
            }
        };
        sorter.setRowFilter(tableRowFilter);
        this.tblTheme.setRowSorter(sorter);
        this.tblTheme.createDefaultColumnsFromModel();
        this.tblTheme.setRowSelectionAllowed(true);
        this.tblTheme.getSelectionModel().addListSelectionListener(e -> {
            if (this.blockEvents) {
                return;
            }
            int selectedRow = this.tblTheme.getSelectedRow();
            if (this.tblTheme.getModel().getRowCount() == 0 || selectedRow == -1) {
                return;
            }
            selectedRow = this.tblTheme.convertRowIndexToModel(selectedRow);
            BasicStyleModel style1 = (BasicStyleModel)this.tblTheme.getModel().getValueAt(selectedRow, 0);
            if (style1 == null) {
                return;
            }
            this.getBasicStyleDialog().setBlockStyleChangedEvents(true);
            try {
                this.getBasicStyleDialog().setBasicStyle((BasicStyleModel)style1.cloneModel());
            }
            finally {
                this.getBasicStyleDialog().setBlockStyleChangedEvents(false);
                this.getBasicStyleDialog().validateInputAndSetErrorState();
            }
            this.updateControls();
        });
        this.tblTheme.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (ThemeStylePanel.this.basicStyleDialog != null) {
                    ThemeStylePanel.this.basicStyleDialog.setVisible(false);
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.tblTheme.getColumnModel().getColumn(this.colorColumn()).setCellRenderer((table, value, isSelected, hasFocus, row, column) -> this.basicStyleListCellRenderer.getListCellRendererComponent(new JList(), value, row, isSelected, hasFocus));
        this.tblTheme.getColumnModel().getColumn(this.colorColumn()).setCellEditor(this.basicStyleTableCellEditor);
        this.tblTheme.getModel().addTableModelListener(e -> {
            this.updateControls();
            Object duplicateAttributeValue = this.tableModel().findDuplicateAttributeValue();
            this.setErrorMessage(new ErrorMessage(I18N.get("ui.style.ThemeStylePanel.table-must-not-have-duplicate-attribute-values"), "(" + String.valueOf(duplicateAttributeValue) + ")"), duplicateAttributeValue != null);
            this.setErrorMessage(new ErrorMessage(I18N.get("ui.style.ThemeStylePanel.table-must-not-have-null-attribute-values")), this.tableModel().containsNullAttributeValues());
        });
        int colorWidth = 100;
        this.tblTheme.getColumnModel().getColumn(this.colorColumn()).setPreferredWidth(colorWidth);
        this.tblTheme.getColumnModel().getColumn(this.colorColumn()).setMinWidth(colorWidth);
        this.tblTheme.getColumnModel().getColumn(this.colorColumn()).setMaxWidth(colorWidth);
        this.tblTheme.setRowHeight(23);
        final JPopupMenu pMenu = new JPopupMenu();
        JMenuItem menuItemEdit = new JMenuItem(I18N.get("common.edit"));
        menuItemEdit.addActionListener(e -> {
            if (this.tblTheme.getSelectedRow() == -1) {
                GUISupport.msgbox((Component)this.tblTheme, (String)I18N.get("ui.style.ThemeStylePanel.please-select-row"), (String)I18N.get("common.message"));
                return;
            }
            this.stopCellEditing();
            this.promptBasicStyleDialog();
        });
        pMenu.add(menuItemEdit);
        pMenu.addSeparator();
        JMenuItem menuItemCopy = new JMenuItem(I18N.get("common.copy"));
        menuItemCopy.addActionListener(e -> {
            int selectedRow = this.tblTheme.getSelectedRow();
            if (selectedRow == -1) {
                GUISupport.msgbox((Component)this.tblTheme, (String)I18N.get("ui.style.ThemeStylePanel.please-select-row"), (String)I18N.get("common.message"));
                return;
            }
            this.stopCellEditing();
            selectedRow = this.tblTheme.convertRowIndexToModel(selectedRow);
            BasicStyleModel newStyle = (BasicStyleModel)((BasicStyleModel)this.tblTheme.getModel().getValueAt(selectedRow, 0)).cloneModel();
            this.tableModel().insertAttributeValue(selectedRow, this.tblTheme.getModel().getValueAt(selectedRow, 1).toString(), this.tblTheme.getModel().getValueAt(selectedRow, 2).toString(), newStyle);
            if (this.tblTheme.getSelectedRowCount() == 0) {
                this.tblTheme.scrollRectToVisible(this.tblTheme.getCellRect(this.tblTheme.getRowCount() - 1, 0, true));
            } else {
                int firstSelectedRow = this.tblTheme.getSelectedRows()[0];
                this.tblTheme.clearSelection();
                this.tblTheme.addRowSelectionInterval(firstSelectedRow, firstSelectedRow);
            }
        });
        pMenu.add(menuItemCopy);
        pMenu.addSeparator();
        JMenuItem menuItemDelete = new JMenuItem(I18N.get("common.delete"));
        menuItemDelete.addActionListener(e -> {
            if (this.tblTheme.getSelectedRow() == -1) {
                GUISupport.msgbox((Component)this.tblTheme, (String)I18N.get("ui.style.ThemeStylePanel.please-select-row"), (String)I18N.get("common.message"));
                return;
            }
            this.stopCellEditing();
            int[] rows = this.tblTheme.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = this.tblTheme.convertRowIndexToModel(rows[i]);
            }
            this.tableModel().removeAttributeValues(rows);
        });
        pMenu.add(menuItemDelete);
        class PopupListener
        extends MouseAdapter {
            PopupListener() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    pMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
        PopupListener popupListener = new PopupListener();
        this.tblTheme.addMouseListener(popupListener);
    }

    public BasicStyleModel getSelectedStyle() {
        int selectedRow = this.tblTheme.getSelectedRow();
        if (selectedRow == -1) {
            return this.style.getDefaultStyle();
        }
        selectedRow = this.tblTheme.convertRowIndexToModel(selectedRow);
        return (BasicStyleModel)this.tblTheme.getModel().getValueAt(selectedRow, 0);
    }

    private BasicStyleDialog getBasicStyleDialog() {
        if (this.basicStyleDialog == null) {
            this.basicStyleDialog = new BasicStyleDialog(SwingUtilities.windowForComponent(this), false, this.sCol, this.context);
            this.basicStyleDialog.setTitle(TITLE);
            this.basicStyleDialog.setFeatureTypeRetriever(this.getFeatureRetriever());
            this.basicStyleDialog.setStyleCollection(this.sCol);
            this.basicStyleDialog.pack();
            this.basicStyleDialog.setMinimumSize(this.basicStyleDialog.getSize());
            this.basicStyleDialog.addStyleChangedListener(e -> this.activeThemeSourcePanel.updateStyleFromDialog(this.basicStyleDialog));
        }
        return this.basicStyleDialog;
    }

    private void promptBasicStyleDialog() {
        if (!this.basicStyleDialogEverVisible) {
            Window win = SwingUtilities.windowForComponent(this);
            this.basicStyleDialog.setLocation(win.getLocation().x + win.getWidth(), win.getLocation().y + 100);
        }
        this.getBasicStyleDialog().setVisible(true);
        this.getBasicStyleDialog().validateInputAndSetErrorState();
        this.basicStyleDialogEverVisible = true;
    }

    private boolean setErrorMessage(ErrorMessage message, boolean enabled) {
        this.errorMessages.remove(message);
        if (enabled) {
            this.errorMessages.add(message);
        }
        this.updateErrorDisplay();
        return enabled;
    }

    private void updateErrorDisplay() {
        String errorMessage = this.state.validate();
        if (errorMessage != null) {
            this.lblStatus.setText(errorMessage);
            this.lblStatus.setIcon(IconLoader.svgIconSmall((String)"common_attention.svg"));
        } else {
            this.lblStatus.setText(" ");
            this.lblStatus.setIcon(null);
        }
    }

    @Override
    public String validateInput() {
        StringBuilder sbError = new StringBuilder();
        try {
            this.stopCellEditing();
            String strErrorTableModel = this.state.validate();
            if (sbError.length() > 0) {
                sbError.append("\n");
            }
            if (StringUtils.isBlank((String)this.txtAttributeDef.getText())) {
                sbError.append(I18N.get("ui.style.ThemeStylePanel.attribute-should-not-be-empty")).append("\n");
            }
            if (strErrorTableModel != null) {
                sbError.append(strErrorTableModel);
            }
            if (sbError.length() > 0) {
                return sbError.toString();
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn("Error at validation of ThemeStylePanel", (Throwable)e);
            return e.getMessage();
        }
    }

    private String validateStaticSourceInput() {
        if (this.errorMessages.isEmpty()) {
            return null;
        }
        return this.errorMessages.iterator().next().toString();
    }

    private void stopCellEditing() {
        this.basicStyleTableCellEditor.stopCellEditing();
        if (this.tblTheme.getCellEditor() instanceof DefaultCellEditor) {
            this.tblTheme.getCellEditor().stopCellEditing();
        }
    }

    private ColorScheme getColorSchemeForInserts() {
        if (this.colorSchemeForInserts == null || !this.colorSchemeForInserts.getName().equalsIgnoreCase((String)this.cmbColorScheme.getSelectedItem())) {
            this.colorSchemeForInserts = ColorScheme.create((String)this.cmbColorScheme.getSelectedItem());
        }
        return this.colorSchemeForInserts;
    }

    private void promptAttDefDialog(SimpleFeatureType featureType, String currentBsh, Consumer<String> updater) {
        this.promptAttDefDialog(featureType, false, new DynamicThemeSourcePanel.BeanShellDefinition(currentBsh, false), newVal -> updater.accept(newVal.getSource()));
    }

    private void promptAttDefDialog(SimpleFeatureType featureType, boolean reEvaluationPossible, DynamicThemeSourcePanel.BeanShellDefinition current, Consumer<DynamicThemeSourcePanel.BeanShellDefinition> updater) {
        if (this.pnlAttDef == null) {
            this.pnlAttDef = new AttributeDefPanel(featureType, this.context);
        }
        this.pnlAttDef.setFeatureTypeRetriever(featureType);
        this.pnlAttDef.setAttributeDef(current.getSource());
        this.pnlAttDef.setResultIsBeanShellVisible(reEvaluationPossible);
        this.pnlAttDef.setResultIsBeanShell(current.isResultBeanShell());
        OKCancelPanel okCancelPanel = new OKCancelPanel();
        Window window = SwingUtilities.windowForComponent(this);
        JDialog dialog = new JDialog((Dialog)window, this.pnlAttDef.getTitle(), true);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)this.pnlAttDef, "Center");
        dialog.getContentPane().add((Component)okCancelPanel, "South");
        okCancelPanel.addActionListener(e -> {
            if (this.pnlAttDef.validateInput() != null && okCancelPanel.wasOKPressed()) {
                JOptionPane.showMessageDialog(this.pnlAttDef, this.pnlAttDef.validateInput(), I18N.get("common.alert"), 0);
            } else {
                dialog.setVisible(false);
            }
        });
        dialog.pack();
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
        if (okCancelPanel.wasOKPressed()) {
            updater.accept(new DynamicThemeSourcePanel.BeanShellDefinition(this.pnlAttDef.getAttributeDef(), this.pnlAttDef.isResultBeanShell()));
        }
    }

    private void initComponents() {
        this.bugThemeType = new ButtonGroup();
        this.lblAttribute = new JLabel();
        this.butAttributeDef = new JButton();
        this.cboUseElseFilter = new JCheckBox();
        this.typePanel = new JPanel();
        this.rbThemeTypedStaticValues = new JRadioButton();
        this.rbThemeTypedDynamicValues = new JRadioButton();
        this.rbThemeTypedStaticRanged = new JRadioButton();
        this.editorPanel = new JPanel();
        this.staticEditorPanel = this.staticThemeSourcePanel;
        this.scrollPane = new JScrollPane();
        this.tblTheme = new JTable(){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                TableCellRenderer renderer = this.getCellRendererProper(row, column);
                return renderer;
            }

            private TableCellRenderer getCellRendererProper(int row, int column) {
                if (row == 0 && column == ThemeStylePanel.this.attributeColumn()) {
                    return ThemeStylePanel.this.allOtherValuesRenderer;
                }
                if (row == 0 && column == ThemeStylePanel.this.labelColumn()) {
                    return ThemeStylePanel.this.allOtherValuesRenderer;
                }
                TableCellRenderer renderer = super.getCellRenderer(row, column);
                if (renderer instanceof JLabel) {
                    ((JLabel)((Object)renderer)).setHorizontalAlignment(2);
                }
                return renderer;
            }
        };
        this.toolbarPanel = new JPanel();
        this.butAdd = new JButton();
        this.butDelete = new JButton();
        this.lblStatus = new JLabel(){

            @Override
            public void setText(String text) {
                super.setText(text);
                this.setToolTipText(text);
            }
        };
        this.butAutoFill = new JButton();
        this.cmbColorScheme = new JComboBox();
        this.lblColorScheme = new JLabel();
        this.txtAttributeDef = new JTextField();
        this.setLayout(new GridBagLayout());
        this.lblAttribute.setText("Attribut:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.add((Component)this.lblAttribute, gridBagConstraints);
        this.butAttributeDef.setText("Einstellungen");
        this.butAttributeDef.setMaximumSize(new Dimension(120, 23));
        this.butAttributeDef.setMinimumSize(new Dimension(120, 23));
        this.butAttributeDef.setPreferredSize(new Dimension(120, 23));
        this.butAttributeDef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeStylePanel.this.butAttributeDef_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 2);
        this.add((Component)this.butAttributeDef, gridBagConstraints);
        this.cboUseElseFilter.setText("Else Filter");
        this.cboUseElseFilter.setBorder(null);
        this.cboUseElseFilter.setMargin(new Insets(0, 0, 0, 0));
        this.cboUseElseFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeStylePanel.this.cboUseElseFilter_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.add((Component)this.cboUseElseFilter, gridBagConstraints);
        this.typePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.typePanel.setLayout(new GridBagLayout());
        this.bugThemeType.add(this.rbThemeTypedStaticValues);
        this.rbThemeTypedStaticValues.setText("Einzelwerte statisch");
        this.rbThemeTypedStaticValues.setBorder(null);
        this.rbThemeTypedStaticValues.setFocusTraversalPolicyProvider(true);
        this.rbThemeTypedStaticValues.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThemeStylePanel.this.themeTypeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.typePanel.add((Component)this.rbThemeTypedStaticValues, gridBagConstraints);
        this.bugThemeType.add(this.rbThemeTypedDynamicValues);
        this.rbThemeTypedDynamicValues.setText("Einzelwerte dynamisch");
        this.rbThemeTypedDynamicValues.setBorder(null);
        this.rbThemeTypedDynamicValues.setFocusTraversalPolicyProvider(true);
        this.rbThemeTypedDynamicValues.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThemeStylePanel.this.themeTypeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.typePanel.add((Component)this.rbThemeTypedDynamicValues, gridBagConstraints);
        this.bugThemeType.add(this.rbThemeTypedStaticRanged);
        this.rbThemeTypedStaticRanged.setText("Wertebereich");
        this.rbThemeTypedStaticRanged.setBorder(null);
        this.rbThemeTypedStaticRanged.setFocusTraversalPolicyProvider(true);
        this.rbThemeTypedStaticRanged.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThemeStylePanel.this.themeTypeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.typePanel.add((Component)this.rbThemeTypedStaticRanged, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.typePanel, gridBagConstraints);
        this.editorPanel.setLayout(new BorderLayout());
        this.staticEditorPanel.setLayout(new GridBagLayout());
        this.scrollPane.setPreferredSize(new Dimension(400, 150));
        this.tblTheme.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.scrollPane.setViewportView(this.tblTheme);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.staticEditorPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.toolbarPanel.setLayout(new GridBagLayout());
        this.butAdd.setMaximumSize(new Dimension(22, 22));
        this.butAdd.setMinimumSize(new Dimension(22, 22));
        this.butAdd.setPreferredSize(new Dimension(22, 22));
        this.butAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeStylePanel.this.butAdd_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.toolbarPanel.add((Component)this.butAdd, gridBagConstraints);
        this.butDelete.setMaximumSize(new Dimension(22, 22));
        this.butDelete.setMinimumSize(new Dimension(22, 22));
        this.butDelete.setPreferredSize(new Dimension(22, 22));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeStylePanel.this.butDelete_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.toolbarPanel.add((Component)this.butDelete, gridBagConstraints);
        this.lblStatus.setForeground(new Color(255, 0, 0));
        this.lblStatus.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        this.lblStatus.setMaximumSize(new Dimension(4, 22));
        this.lblStatus.setMinimumSize(new Dimension(4, 22));
        this.lblStatus.setPreferredSize(new Dimension(4, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.toolbarPanel.add((Component)this.lblStatus, gridBagConstraints);
        this.butAutoFill.setMaximumSize(new Dimension(22, 22));
        this.butAutoFill.setMinimumSize(new Dimension(22, 22));
        this.butAutoFill.setPreferredSize(new Dimension(22, 22));
        this.butAutoFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeStylePanel.this.butAutoFill_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.toolbarPanel.add((Component)this.butAutoFill, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.staticEditorPanel.add((Component)this.toolbarPanel, gridBagConstraints);
        this.cmbColorScheme.setPreferredSize(new Dimension(300, 22));
        this.cmbColorScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeStylePanel.this.cmbColorScheme_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.staticEditorPanel.add(this.cmbColorScheme, gridBagConstraints);
        this.lblColorScheme.setText("Farb-Schema:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.staticEditorPanel.add((Component)this.lblColorScheme, gridBagConstraints);
        this.editorPanel.add((Component)this.staticEditorPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.editorPanel, gridBagConstraints);
        this.txtAttributeDef.setEditable(false);
        this.txtAttributeDef.setPreferredSize(new Dimension(80, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtAttributeDef, gridBagConstraints);
    }

    private void butAttributeDef_onActionPerformed(ActionEvent evt) {
        this.promptAttDefDialog(this.getFeatureRetriever().getFeatureType(), this.strAttribute, newVal -> {
            this.strAttribute = newVal;
        });
        this.updateControls();
    }

    private void cboUseElseFilter_onActionPerformed(ActionEvent evt) {
        this.useElseFilter = this.cboUseElseFilter.isSelected();
        this.tblTheme.getRowSorter().allRowsChanged();
        this.tblTheme.updateUI();
        this.updateControls();
    }

    private void butAutoFill_onActionPerformed(ActionEvent evt) {
        boolean bolContinue = GUISupport.yesnobox((Component)this, (String)I18N.get("ui.style.ThemeStylePanel.autofill-warning"), (String)I18N.get("common.alert"));
        if (bolContinue) {
            this.refillTableByDataStore();
        }
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        this.deleteAttribute();
    }

    private void butAdd_onActionPerformed(ActionEvent evt) {
        this.insertAttribute();
    }

    private void cmbColorScheme_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.stopCellEditing();
        this.sCol.getLayer().getLayerManager().getBlackboard().put(COLOR_SCHEME_KEY, this.cmbColorScheme.getSelectedItem());
        this.applyColorScheme();
        this.colorSchemeForInserts = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void themeTypeChanged(ItemEvent evt) {
        if (this.blockEvents || evt.getStateChange() != 1) {
            return;
        }
        boolean oldBlockEvents = this.blockEvents;
        try {
            this.blockEvents = true;
            this.stopCellEditing();
            int option = JOptionPane.showConfirmDialog(this, I18N.get("ui.style.ThemeStylePanel.refill-warning"), I18N.get("common.message"), 0);
            if (option != 0) {
                this.updateControls();
                return;
            }
            if (this.basicStyleDialog != null) {
                this.basicStyleDialog.setVisible(false);
            }
            this.createThemeSourceFromUI(this.style);
            this.setState(this.style.getThemeSource());
            this.tableModel().clear();
            this.updateControls();
            MultiInputDialog.fitDialogToContent(SwingUtilities.getWindowAncestor(this));
        }
        finally {
            this.blockEvents = oldBlockEvents;
        }
    }

    @Override
    public void updateStyles() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void insertAttribute() {
        this.stopCellEditing();
        int selectedRowView = this.tblTheme.getSelectedRow();
        int selectedRowModel = 1;
        if (selectedRowView != -1) {
            selectedRowModel = this.tblTheme.convertRowIndexToModel(selectedRowView);
        }
        this.tableModel().insertAttributeValue(this.tblTheme.getSelectedRowCount() > 0 ? selectedRowModel : this.tableModel().getRowCount(), this.getColorSchemeForInserts());
        if (this.tblTheme.getSelectedRowCount() == 0) {
            this.tblTheme.scrollRectToVisible(this.tblTheme.getCellRect(this.tblTheme.getRowCount() - 1, 0, true));
        }
        if (this.tblTheme.getSelectedRowCount() != 0) {
            this.tblTheme.clearSelection();
            this.tblTheme.addRowSelectionInterval(selectedRowView, selectedRowView);
        }
    }

    public void deleteAttribute() {
        if (this.tblTheme.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, I18N.get("ui.style.ThemeStylePanel.at-least-1-row-must-be-selected"));
            return;
        }
        this.stopCellEditing();
        int[] rows = this.tblTheme.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = this.tblTheme.convertRowIndexToModel(rows[i]);
        }
        this.tableModel().removeAttributeValues(rows);
    }

    public static interface State {
        public String getAllOtherValuesDescription();

        public ColorScheme filterColorScheme(ColorScheme var1);

        public void activate();

        public void deactivate();

        public Collection<String> getColorSchemeNames();

        public boolean canApplyColorSchemes();

        public void applyColorScheme(ColorScheme var1, Set<ThemeColor> var2);

        public String getAttributeValueColumnTitle();

        public <T> Map<Object, T> toExternalFormat(Map<Object, T> var1);

        public <T> Map<Object, T> fromExternalFormat(Map<Object, T> var1);

        public void selectMatchingUIElement();

        default public boolean canAutoFillTable() {
            return false;
        }

        default public String validate() {
            return null;
        }
    }

    private class BasicStyleTableCellEditor
    implements TableCellEditor {
        private final DefaultComboBoxModel<Object> comboBoxModel = new DefaultComboBoxModel();
        private final DefaultCellEditor editor;
        private final JComboBox<Object> comboBox = new JComboBox<Object>(this.comboBoxModel){

            @Override
            public void setSelectedItem(Object anObject) {
                if (anObject == CUSTOM_ENTRY) {
                    ThemeStylePanel.this.promptBasicStyleDialog();
                    return;
                }
                super.setSelectedItem(anObject);
            }
        };

        public BasicStyleTableCellEditor() {
            this.comboBox.setRenderer(ThemeStylePanel.this.basicStyleListCellRenderer);
            this.editor = new DefaultCellEditor(this.comboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.comboBoxModel.removeAllElements();
            this.comboBoxModel.addElement(CUSTOM_ENTRY);
            this.comboBoxModel.addElement(value);
            for (Color color : ColorScheme.create((String)ThemeStylePanel.this.cmbColorScheme.getSelectedItem()).getColors()) {
                this.comboBoxModel.addElement(new BasicStyleModel(RiwaJumpModelUtilities.colorModelByColor(color)));
            }
            this.comboBoxModel.setSelectedItem(value);
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.editor.isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.editor.shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.editor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.editor.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.editor.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.editor.removeCellEditorListener(l);
        }
    }

    private static class ErrorMessage {
        private final String commonPart;
        private final String specificPart;

        ErrorMessage(String commonPart) {
            this(commonPart, "");
        }

        ErrorMessage(String commonPart, String specificPart) {
            this.commonPart = commonPart;
            this.specificPart = specificPart;
        }

        public final String getCommonPart() {
            return this.commonPart;
        }

        public int hashCode() {
            return this.commonPart.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ErrorMessage)) {
                Assert.shouldNeverReachHere();
            }
            return this.commonPart.equals(((ErrorMessage)obj).getCommonPart());
        }

        public String toString() {
            return this.commonPart + this.specificPart;
        }
    }
}

