/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.COpt;
import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.model.WMTSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.EditCadLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.dim.EditDimLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.EditRedlineLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.raster.ChangeRasterImagePropertiesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.wms.EditWMSQueryPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.wmts.EditWMTSQueryPlugIn;
import com.vividsolutions.jump.workbench.ui.style.ChangeStylesPlugIn;
import de.riwagis.icons.IconLoader;
import java.util.Iterator;
import javax.swing.ImageIcon;

public class SelectChangeStylesPlugIn
extends AbstractPlugIn {
    private final ChangeRasterImagePropertiesPlugIn changeRasterImagePropertiesPlugIn = new ChangeRasterImagePropertiesPlugIn();
    private final EditWMSQueryPlugIn editWMSQueryPlugIn = new EditWMSQueryPlugIn();
    private final EditWMTSQueryPlugIn editWMTSQueryPlugIn = new EditWMTSQueryPlugIn();
    private final EditRedlineLayerPlugIn editRedlineLayerPlugIn = new EditRedlineLayerPlugIn();
    private final EditDimLayerPlugIn editDimLayerPlugIn = new EditDimLayerPlugIn();
    private final EditCadLayerPlugIn editCadLayerPlugIn = new EditCadLayerPlugIn();
    private final ChangeStylesPlugIn changeStylesPlugIn = new ChangeStylesPlugIn();

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_palette.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Iterator<Layerable> i = context.getLayerNamePanel().selectedNodes(Layerable.class).iterator();
        if (!i.hasNext()) {
            return false;
        }
        Layerable lyr = i.next();
        this.showChangeStyleDialog(context, lyr);
        return true;
    }

    public boolean showChangeStyleDialog(PlugInContext context, Layerable lyr) throws Exception {
        if (COpt.VIEWER || lyr.isBuildIn()) {
            if (lyr instanceof RedlineLayer) {
                return this.editRedlineLayerPlugIn.execute(context);
            }
            return false;
        }
        if (lyr instanceof Layer) {
            if (lyr instanceof RedlineLayer) {
                return this.editRedlineLayerPlugIn.execute(context);
            }
            if (lyr instanceof DimLayer) {
                return this.editDimLayerPlugIn.execute(context);
            }
            if (lyr instanceof CadLayer) {
                return this.editCadLayerPlugIn.execute(context);
            }
            return this.changeStylesPlugIn.execute(context);
        }
        if (lyr instanceof RasterImageLayer) {
            return this.changeRasterImagePropertiesPlugIn.execute(context);
        }
        if (lyr instanceof WMSLayer) {
            return this.editWMSQueryPlugIn.execute(context);
        }
        if (lyr instanceof WMTSLayer) {
            return this.editWMTSQueryPlugIn.execute(context);
        }
        return false;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLocalOrRedlineLayerablesMustBeSelectedCheck(1, Layerable.class)).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class)).add(checkFactory.createExactlyNCategoriesMustBeSelectedCheck(0));
    }

    @Override
    public String getName() {
        return I18N.get("ui.style.SelectChangeStylesPlugIn.name") + "...";
    }
}

