/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.ui.components.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class LinePatternPanel
extends JPanel {
    private String[] linePatterns = new String[]{"1", "3", "5", "5,1", "7", "7,12", "9", "9,2", "9,3,2,3", "15,6", "20,3"};
    private JComboBox linePatternCombo;

    public LinePatternPanel() {
        this.initComponents();
        this.linePatternCombo.updateUI();
    }

    public void addActionListener(ActionListener listener) {
        this.linePatternCombo.addActionListener(listener);
    }

    @Override
    public void setForeground(Color col) {
        super.setForeground(col);
        if (this.linePatternCombo != null) {
            this.linePatternCombo.setForeground(col);
        }
    }

    public void addDocumentListener(DocumentListener listener) {
        ((JTextField)this.linePatternCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(listener);
    }

    public void setSelectedIndex(int i) {
        this.linePatternCombo.setSelectedIndex(i);
    }

    public int getSelectedIndex() {
        return this.linePatternCombo.getSelectedIndex();
    }

    public void setSelectedPattern(String strPattern) {
        this.linePatternCombo.setSelectedItem(strPattern);
    }

    public String getSelectedPattern() {
        return LinePatternPanel.cleanPattern((String)this.linePatternCombo.getSelectedItem());
    }

    public String[] getLinePatterns() {
        return this.linePatterns;
    }

    public void setLinePatterns(String[] _linePatterns) {
        this.linePatterns = _linePatterns;
        this.linePatternCombo.removeAllItems();
        for (String linePattern : this.linePatterns) {
            this.linePatternCombo.addItem(linePattern);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.linePatternCombo.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.linePatternCombo.setEditable(editable);
    }

    public static String cleanPattern(String linePattern) {
        Object pattern = "";
        StringTokenizer tokenizer = new StringTokenizer(StringUtil.replaceAll(linePattern, ",", " "));
        while (tokenizer.hasMoreTokens()) {
            pattern = (String)pattern + tokenizer.nextToken() + " ";
        }
        return StringUtil.replaceAll(((String)pattern).trim(), " ", ",");
    }

    private void initComponents() {
        this.linePatternCombo = new JComboBox(this.linePatterns){
            {
                final ValidatingTextField.Cleaner cleaner = new ValidatingTextField.Cleaner(this){

                    @Override
                    public String clean(String text) {
                        Object pattern = "";
                        StringTokenizer tokenizer = new StringTokenizer(StringUtil.replaceAll(text, ",", " "));
                        while (tokenizer.hasMoreTokens()) {
                            pattern = (String)pattern + tokenizer.nextToken() + " ";
                        }
                        return StringUtil.replaceAll(((String)pattern).trim(), " ", ",");
                    }
                };
                BasicComboBoxEditor editor = new BasicComboBoxEditor();
                this.setEditor(editor);
                this.setEditable(true);
                ValidatingTextField.installValidationBehavior((JTextField)editor.getEditorComponent(), new ValidatingTextField.Validator(){

                    @Override
                    public boolean isValid(String text) {
                        try {
                            LineRenderer.toArray(cleaner.clean(text), 1.0f, 0.0);
                            return true;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                }, cleaner);
                this.setRenderer(new ListCellRenderer(this){
                    private JPanel panel = new JPanel(){
                        private int lineWidth = 2;

                        @Override
                        protected void paintComponent(Graphics g) {
                            super.paintComponent(g);
                            Graphics2D g2 = (Graphics2D)g;
                            if (linePattern.length() > 0) {
                                g2.setStroke(new BasicStroke(this.lineWidth, 0, 2, 1.0f, LineRenderer.toArray(linePattern, this.lineWidth, 0.0), 0.0f));
                            } else {
                                g2.setStroke(new BasicStroke(this.lineWidth, 0, 2, 1.0f));
                            }
                            g2.draw(new Line2D.Double(0.0, (double)panel.getHeight() / 2.0, panel.getWidth(), (double)panel.getHeight() / 2.0));
                        }
                    };
                    private String linePattern;

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        this.linePattern = (String)value;
                        this.panel.setForeground(UIManager.getColor(isSelected ? "ComboBox.selectionForeground" : "ComboBox.foreground"));
                        this.panel.setBackground(UIManager.getColor(isSelected ? "ComboBox.selectionBackground" : "ComboBox.background"));
                        this.panel.setPreferredSize(new Dimension(10, 20));
                        return this.panel;
                    }
                });
            }
        };
        this.setMinimumSize(new Dimension(23, 22));
        this.setLayout(new GridBagLayout());
        this.linePatternCombo.setMinimumSize(new Dimension(23, 22));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.linePatternCombo, gridBagConstraints);
    }
}

