/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.model.redline.RedlineDataStore;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.components.IntegerTextField;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.SaveRedlineLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.wms.WMSStylePanel;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.style.LayerStylePanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerNamePanel
extends AbstractStylePanel
implements WMSStylePanel,
LayerStylePanel {
    private static final Logger LOG = LoggerFactory.getLogger(LayerNamePanel.class);
    private final JCheckBox chkEdit = new JCheckBox();
    private final JCheckBox chkVisibleInViewer = new JCheckBox();
    private final JCheckBox chkSelectable = new JCheckBox();
    private final JScrollPane scrollPane1 = new JScrollPane();
    private final JLabel lblDesc = new JLabel();
    private final JLabel lblKey = new JLabel();
    private final JLabel lblName = new JLabel();
    private final JLabel lblPrio = new JLabel();
    private final JLabel lblFile = new JLabel();
    private final JTextArea txtDesc = new JTextArea();
    private final JTextField txtKey = new JTextField();
    private final JTextField txtName = new JTextField();
    private final JTextField txtPrio = new IntegerTextField();
    private final JTextField txtFile = new JTextField();
    private final JButton btnFile = new JButton();
    private LayerManager lyMngr = null;
    private Layerable layer = null;

    public LayerNamePanel(Layerable _layer) {
        this.initComponents();
        this.setLayerable(_layer);
    }

    @Override
    public void setStyleCollection(StyleCollection _sCol) {
    }

    @Override
    public final void setLayerable(Layerable _layer) {
        this.layer = _layer;
        this.updateComponents();
    }

    public void setLayerManager(LayerManager _lyMngr) {
        this.lyMngr = _lyMngr;
    }

    @Override
    public String validateInput() {
        String strNewFile;
        if (this.txtKey.getText().length() == 0) {
            return I18N.get("ui.style.LayerNamePanel.layerkey-not-empty");
        }
        if (this.layer.getLayerManager() != null ? this.layer.getLayerManager().hasLayerable(this.txtKey.getText()) && !this.layer.getKey().equals(this.txtKey.getText()) : this.lyMngr.hasLayerable(this.txtKey.getText())) {
            return I18N.get("ui.style.LayerNamePanel.layerkey-already-exists");
        }
        if (this.layer instanceof RedlineLayer && !StringUtils.trimToEmpty((String)(strNewFile = this.txtFile.getText())).isEmpty()) {
            RedlineDataStore ds = ((RedlineLayer)this.layer).getDataStore();
            File oldFile = ds.getFileInternal();
            strNewFile = this.addSuffix(strNewFile, ".rly");
            this.txtFile.setText(strNewFile);
            File newFile = new File(strNewFile);
            if (!newFile.equals(oldFile) && newFile.exists()) {
                return I18N.get("ui.style.LayerNamePanel.file-already-exists");
            }
        }
        return null;
    }

    private String addSuffix(String str, String strSuffix) {
        if (str.toLowerCase().endsWith(strSuffix.toLowerCase())) {
            return str;
        }
        return str + strSuffix;
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.LayerNamePanel.title");
    }

    @Override
    public void updateStyles() {
    }

    @Override
    public UndoableCommand updateLayer() {
        try {
            return new LayerNameUndoableCommand(this.layer, this.txtKey.getText(), this.txtName.getText(), this.txtDesc.getText(), Integer.parseInt(this.txtPrio.getText()), this.chkVisibleInViewer.isSelected(), this.chkEdit.isSelected(), this.chkSelectable.isSelected(), StringUtils.trimToNull((String)this.txtFile.getText()));
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
            return new UndoableCommand(this, "LayerNamePanel"){

                @Override
                public void execute() {
                }

                @Override
                public void unexecute() {
                }
            };
        }
    }

    private void updateComponents() {
        this.txtKey.setText(this.layer.getKey());
        this.txtName.setText(this.layer.getName());
        if (this.layer instanceof AbstractLayerable) {
            this.txtDesc.setEnabled(true);
            this.txtDesc.setText(this.layer.getDescription());
        } else {
            this.txtDesc.setText("");
            this.txtDesc.setEnabled(false);
        }
        if (this.layer instanceof Layer) {
            if (this.layer instanceof RedlineLayer) {
                this.lblKey.setVisible(false);
                this.txtKey.setVisible(false);
                this.chkEdit.setEnabled(true);
                this.chkSelectable.setEnabled(true);
                this.chkVisibleInViewer.setEnabled(false);
                this.chkVisibleInViewer.setVisible(false);
                this.txtPrio.setEnabled(true);
                this.lblFile.setVisible(true);
                this.txtFile.setVisible(true);
                RedlineDataStore ds = ((RedlineLayer)this.layer).getDataStore();
                File file = ds.getFileInternal();
                this.txtFile.setText(ObjectUtils.toString((Object)file));
                this.btnFile.setVisible(true);
            } else {
                this.chkEdit.setEnabled(true);
                this.chkSelectable.setEnabled(true);
                this.chkVisibleInViewer.setEnabled(true);
                this.txtPrio.setEnabled(true);
                if (((Layer)this.layer).isDrawingLast()) {
                    this.txtPrio.setEnabled(false);
                }
            }
            Layer tmpLayer = (Layer)this.layer;
            this.chkEdit.setSelected(tmpLayer.isEditableInternal());
            this.chkSelectable.setSelected(tmpLayer.isSelectable());
        } else {
            this.chkEdit.setEnabled(false);
            this.chkSelectable.setEnabled(false);
            this.chkVisibleInViewer.setEnabled(true);
        }
        this.txtPrio.setText("" + this.layer.getRenderPrio());
        this.chkVisibleInViewer.setSelected(this.layer.isVisibleInViewerTree());
    }

    private void initComponents() {
        this.txtPrio.setHorizontalAlignment(11);
        this.lblKey.setText(I18N.get("ui.style.LayerNamePanel.layerkey"));
        this.lblName.setText(I18N.get("ui.style.LayerNamePanel.layername"));
        this.lblPrio.setText(I18N.get("ui.style.LayerNamePanel.layerprio"));
        this.lblDesc.setText(I18N.get("ui.style.LayerNamePanel.layerdesc"));
        this.chkEdit.setText(I18N.get("ui.style.LayerNamePanel.editable"));
        this.chkSelectable.setText(I18N.get("ui.style.LayerNamePanel.selectable"));
        this.chkVisibleInViewer.setText(I18N.get("ui.style.LayerNamePanel.visible-in-viewer"));
        this.lblFile.setText(I18N.get("ui.style.LayerNamePanel.filepath"));
        this.txtFile.setText("");
        this.btnFile.setText(I18N.get("ui.style.LayerNamePanel.filebutton"));
        this.btnFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (LayerNamePanel.this.layer instanceof RedlineLayer) {
                    JFileChooser fileChooser = new JFileChooser(){

                        @Override
                        public void approveSelection() {
                            File file = super.getSelectedFile();
                            if (file == null) {
                                return;
                            }
                            if (!file.getAbsolutePath().toLowerCase().endsWith(".rly")) {
                                file = new File(file.getAbsolutePath() + ".rly");
                                super.setSelectedFile(file);
                            }
                            if (file.exists()) {
                                JOptionPane.showMessageDialog(WorkbenchContext.getFrame(), I18N.get("ui.style.LayerNamePanel.file-already-exists"), I18N.get("common.error"), 0);
                                return;
                            }
                            super.approveSelection();
                        }
                    };
                    RedlineDataStore ds = ((RedlineLayer)LayerNamePanel.this.layer).getDataStore();
                    Blackboard bb = PersistentBlackboardPlugIn.get();
                    File file = ds.getFileInternal();
                    if (file == null) {
                        if (bb.contains(SaveRedlineLayerPlugIn.CURRENT_FILE_KEY)) {
                            String strPath = (String)bb.get(SaveRedlineLayerPlugIn.CURRENT_FILE_KEY);
                            fileChooser.setCurrentDirectory(new File(strPath).getParentFile());
                        }
                        fileChooser.setSelectedFile(new File(LayerNamePanel.this.addSuffix(LayerNamePanel.this.txtName.getText(), ".rly")));
                    } else {
                        fileChooser.setSelectedFile(file);
                    }
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setMultiSelectionEnabled(false);
                    FileFilter rlyFilter = GUIUtil.createFileFilter(I18N.get("ui.plugin.io.layer.SaveRedlineLayerPlugIn.FileFilterName"), new String[]{"rly"});
                    fileChooser.addChoosableFileFilter(rlyFilter);
                    fileChooser.setFileFilter(rlyFilter);
                    fileChooser.setFileSelectionMode(0);
                    int intRetVal = fileChooser.showSaveDialog(WorkbenchContext.getFrame());
                    if (intRetVal == 1) {
                        return;
                    }
                    file = fileChooser.getSelectedFile();
                    LayerNamePanel.this.txtFile.setText(file.getAbsolutePath());
                    bb.put(SaveRedlineLayerPlugIn.CURRENT_FILE_KEY, file.getAbsolutePath());
                } else {
                    Assert.shouldNeverReachHere((String)"selected Layer is no RedlineLayer");
                }
            }
        });
        this.lblFile.setVisible(false);
        this.txtFile.setVisible(false);
        this.btnFile.setVisible(false);
        this.txtDesc.setColumns(45);
        this.txtDesc.setLineWrap(true);
        this.txtDesc.setRows(2);
        this.txtDesc.setFont(this.txtName.getFont());
        this.scrollPane1.setViewportView(this.txtDesc);
        GridBagLayout gbLayout = new GridBagLayout();
        this.setLayout(gbLayout);
        JPanel layerPanel = new JPanel();
        GUIUtil.addGridBagComponent(this, layerPanel, gbLayout, 0, 0, 1, 1, 17, 0, new Insets(2, 10, 2, 2));
        GridBagConstraints gbcFiller = new GridBagConstraints();
        gbcFiller.weightx = 5.0;
        gbcFiller.weighty = 5.0;
        GUIUtil.addGridBagComponent(this, new JPanel(), gbLayout, gbcFiller, 0, 2, 0, 0, 10, 1, new Insets(0, 0, 0, 0));
        GridBagLayout gbLayout2 = new GridBagLayout();
        layerPanel.setLayout(gbLayout2);
        GUIUtil.addGridBagComponent(layerPanel, this.lblKey, gbLayout2, 0, 0, 1, 1, 13, 0, new Insets(5, 5, 0, 0));
        this.txtKey.setPreferredSize(new Dimension(200, 20));
        GUIUtil.addGridBagComponent(layerPanel, this.txtKey, gbLayout2, 1, 0, 1, 1, 17, 0, new Insets(5, 5, 0, 0));
        GUIUtil.addGridBagComponent(layerPanel, this.lblName, gbLayout2, 0, 1, 1, 1, 13, 0, new Insets(5, 5, 0, 0));
        this.txtName.setPreferredSize(new Dimension(200, 20));
        GUIUtil.addGridBagComponent(layerPanel, this.txtName, gbLayout2, 1, 1, 1, 1, 17, 0, new Insets(5, 5, 0, 0));
        GUIUtil.addGridBagComponent(layerPanel, this.lblPrio, gbLayout2, 2, 1, 1, 1, 13, 0, new Insets(5, 5, 0, 0));
        this.txtPrio.setPreferredSize(new Dimension(80, 20));
        GUIUtil.addGridBagComponent(layerPanel, this.txtPrio, gbLayout2, 3, 1, 1, 1, 17, 0, new Insets(5, 5, 0, 0));
        GUIUtil.addGridBagComponent(layerPanel, this.lblFile, gbLayout2, 0, 2, 1, 1, 13, 0, new Insets(5, 5, 0, 0));
        this.txtFile.setPreferredSize(new Dimension(350, 20));
        GUIUtil.addGridBagComponent(layerPanel, this.txtFile, gbLayout2, 1, 2, 3, 1, 17, 0, new Insets(5, 5, 0, 0));
        GUIUtil.addGridBagComponent(layerPanel, this.btnFile, gbLayout2, 4, 2, 1, 1, 17, 0, new Insets(5, 5, 0, 0));
        GUIUtil.addGridBagComponent(layerPanel, this.lblDesc, gbLayout2, 0, 3, 1, 1, 12, 0, new Insets(5, 5, 0, 0));
        GUIUtil.addGridBagComponent(layerPanel, this.scrollPane1, gbLayout2, 1, 3, 3, 1, 17, 0, new Insets(5, 5, 0, 5));
        this.scrollPane1.setPreferredSize(new Dimension(350, 50));
        GUIUtil.addGridBagComponent(layerPanel, this.chkEdit, gbLayout2, 1, 4, 3, 1, 17, 0, new Insets(5, 5, 5, 0));
        GUIUtil.addGridBagComponent(layerPanel, this.chkSelectable, gbLayout2, 1, 5, 3, 1, 17, 0, new Insets(5, 5, 5, 0));
        GUIUtil.addGridBagComponent(layerPanel, this.chkVisibleInViewer, gbLayout2, 1, 6, 3, 1, 17, 0, new Insets(5, 5, 5, 0));
    }

    private static class LayerNameUndoableCommand
    extends UndoableCommand {
        private final Layerable ly;
        private final String strOldKey;
        private final String strNewKey;
        private final String strOldName;
        private final String strNewName;
        private final String strOldDesc;
        private final String strNewDesc;
        private final String strOldFile;
        private final String strNewFile;
        private final int intOldPrio;
        private final int intNewPrio;
        private final boolean bolOldEdit;
        private final boolean bolNewEdit;
        private final boolean bolOldVisInViewer;
        private final boolean bolNewVisInViewer;
        private final boolean bolOldSelectable;
        private final boolean bolNewSelectable;

        LayerNameUndoableCommand(Layerable layer, String strKey, String strName, String strDesc, int intPrio, boolean chkVisibleInViewer, boolean chkEditable, boolean chkSelectable, String strNewFile) {
            super("LayerNamePanel");
            File file;
            this.ly = layer;
            this.strOldKey = this.ly.getKey();
            this.strOldName = this.ly.getName();
            this.strOldDesc = this.ly.getDescription();
            this.intOldPrio = this.ly.getRenderPrio();
            this.bolOldVisInViewer = this.ly.isVisibleInViewerTree();
            if (this.ly instanceof Layer) {
                this.bolOldSelectable = ((Layer)this.ly).isSelectable();
                this.bolOldEdit = ((Layer)this.ly).isEditableInternal();
            } else {
                this.bolOldSelectable = false;
                this.bolOldEdit = false;
            }
            this.strOldFile = this.ly instanceof RedlineLayer ? ((file = ((RedlineLayer)this.ly).getDataStore().getFileInternal()) == null ? null : file.getAbsolutePath()) : null;
            this.strNewKey = strKey;
            this.strNewName = strName;
            this.strNewDesc = strDesc;
            this.intNewPrio = intPrio;
            this.bolNewVisInViewer = chkVisibleInViewer;
            if (this.ly instanceof Layer) {
                this.bolNewEdit = chkEditable;
                this.bolNewSelectable = chkSelectable;
            } else {
                this.bolNewEdit = false;
                this.bolNewSelectable = false;
            }
            this.strNewFile = this.ly instanceof RedlineLayer ? strNewFile : null;
        }

        @Override
        public void execute() {
            try {
                this.ly.setKey(this.strNewKey);
                this.ly.setName(this.strNewName);
                this.ly.setDescription(this.strNewDesc);
                this.ly.setRenderPrio(this.intNewPrio);
                this.ly.setVisibleInViewerTree(this.bolNewVisInViewer);
                if (this.ly instanceof Layer) {
                    ((Layer)this.ly).setEditable(this.bolNewEdit);
                    ((Layer)this.ly).setSelectable(this.bolNewSelectable);
                }
                if (this.ly instanceof RedlineLayer) {
                    ((RedlineLayer)this.ly).setFile(this.strNewFile == null ? null : new File(this.strNewFile));
                }
            }
            catch (Exception e) {
                LOG.error("Error executing change of LayerNamePanel.", (Throwable)e);
            }
        }

        @Override
        public void unexecute() {
            try {
                this.ly.setKey(this.strOldKey);
                this.ly.setName(this.strOldName);
                this.ly.setDescription(this.strOldDesc);
                this.ly.setRenderPrio(this.intOldPrio);
                this.ly.setVisibleInViewerTree(this.bolOldVisInViewer);
                if (this.ly instanceof Layer) {
                    ((Layer)this.ly).setEditable(this.bolOldEdit);
                    ((Layer)this.ly).setSelectable(this.bolOldSelectable);
                }
                if (this.ly instanceof RedlineLayer) {
                    ((RedlineLayer)this.ly).setFile(this.strOldFile == null ? null : new File(this.strOldFile));
                }
            }
            catch (Exception e) {
                LOG.error("Error unexecuting change of LayerNamePanel.", (Throwable)e);
            }
        }
    }
}

