/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.style.LayerStylePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class LayerCachePanel
extends JPanel
implements LayerStylePanel {
    private final DecimalFormat df = new DecimalFormat();
    private boolean doUpdateControls = true;
    private Layer layer = null;
    private boolean bolCacheAll = false;
    private boolean bolCacheMinEnv = false;
    private double dblMinEnv = 0.0;
    private JCheckBox cboCacheAll;
    private JCheckBox cboCacheEnv;
    private JLabel lblEnvHeight;
    private JLabel lblEnvSize;
    private JPanel pnlCaching;
    private JPanel pnlFiller;
    private JFormattedTextField txtEnvSize;

    public LayerCachePanel(Layer _layer) {
        try {
            this.layer = _layer;
            this.doUpdateControls = false;
            this.initComponents();
            this.df.setGroupingUsed(false);
            this.txtEnvSize.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
            this.txtEnvSize.setColumns(6);
            this.i18n();
        }
        finally {
            this.doUpdateControls = true;
        }
        this.updateControls();
    }

    private void i18n() {
        ((TitledBorder)this.pnlCaching.getBorder()).setTitle(I18N.get("ui.style.LayerCachePanel.caching"));
        this.cboCacheAll.setText(I18N.get("ui.style.LayerCachePanel.cache-all"));
        this.cboCacheEnv.setText(I18N.get("ui.style.LayerCachePanel.cache-min-env"));
        this.lblEnvSize.setText(I18N.get("ui.style.LayerCachePanel.env-size"));
        this.lblEnvHeight.setText("");
    }

    @Override
    public UndoableCommand updateLayer() {
        LayerCacheUndoableCommand undo = new LayerCacheUndoableCommand(this.layer, this.bolCacheAll, this.bolCacheMinEnv, this.dblMinEnv);
        return undo;
    }

    @Override
    public void setLayerable(Layerable _layer) {
        this.layer = (Layer)_layer;
        this.bolCacheAll = this.layer.getCacheAll();
        this.bolCacheMinEnv = this.layer.getCacheMinEnv();
        this.dblMinEnv = this.layer.getCacheEnvSize();
        this.updateControls();
    }

    private void updateControls() {
        if (!this.doUpdateControls) {
            return;
        }
        try {
            this.doUpdateControls = false;
            this.pnlCaching.setVisible(true);
            this.cboCacheAll.setSelected(this.bolCacheAll);
            this.cboCacheEnv.setSelected(this.bolCacheMinEnv);
            if (this.cboCacheEnv.isSelected()) {
                this.txtEnvSize.setEnabled(true);
                this.lblEnvSize.setEnabled(true);
            } else {
                this.txtEnvSize.setEnabled(false);
                this.lblEnvSize.setEnabled(false);
            }
            if (!this.bolCacheMinEnv) {
                this.txtEnvSize.setEnabled(false);
                this.txtEnvSize.setText("");
                this.dblMinEnv = 0.0;
                this.lblEnvHeight.setText("");
            } else {
                this.txtEnvSize.setEnabled(true);
                this.txtEnvSize.setText(this.df.format(this.dblMinEnv));
                this.lblEnvHeight.setText(" X " + this.df.format(this.dblMinEnv));
            }
        }
        finally {
            this.doUpdateControls = true;
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.LayerCachePanel.title");
    }

    @Override
    public String validateInput() {
        return null;
    }

    private void initComponents() {
        this.pnlCaching = new JPanel();
        this.cboCacheAll = new JCheckBox();
        this.cboCacheEnv = new JCheckBox();
        this.lblEnvSize = new JLabel();
        this.txtEnvSize = new JFormattedTextField();
        this.lblEnvHeight = new JLabel();
        this.pnlFiller = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pnlCaching.setBorder(BorderFactory.createTitledBorder("Ladeverhalten der Ebene"));
        this.pnlCaching.setLayout(new GridBagLayout());
        this.cboCacheAll.setText("Ebene immer komplett laden");
        this.cboCacheAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboCacheAll.setMargin(new Insets(0, 0, 0, 0));
        this.cboCacheAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerCachePanel.this.cboCacheAll_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlCaching.add((Component)this.cboCacheAll, gridBagConstraints);
        this.cboCacheEnv.setText("minimalen Ladebereich verwenden");
        this.cboCacheEnv.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboCacheEnv.setMargin(new Insets(0, 0, 0, 0));
        this.cboCacheEnv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerCachePanel.this.cboCacheEnv_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlCaching.add((Component)this.cboCacheEnv, gridBagConstraints);
        this.lblEnvSize.setText("Bereich:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 9, 9, 3);
        this.pnlCaching.add((Component)this.lblEnvSize, gridBagConstraints);
        this.txtEnvSize.setHorizontalAlignment(11);
        this.txtEnvSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayerCachePanel.this.txtEnvSize_onFocusLost(evt);
            }
        });
        this.txtEnvSize.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LayerCachePanel.this.txtEnvSize_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 9, 3);
        this.pnlCaching.add((Component)this.txtEnvSize, gridBagConstraints);
        this.lblEnvHeight.setText("x 100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 3, 9, 3);
        this.pnlCaching.add((Component)this.lblEnvHeight, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlCaching, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlFiller, gridBagConstraints);
    }

    private void txtEnvSize_onFocusLost(FocusEvent evt) {
        try {
            this.dblMinEnv = this.df.parse(this.txtEnvSize.getText()).doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblEnvHeight.setText(" X " + this.df.format(this.dblMinEnv));
    }

    private void txtEnvSize_onKeyReleased(KeyEvent evt) {
        try {
            this.dblMinEnv = this.df.parse(this.txtEnvSize.getText()).doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblEnvHeight.setText(" X " + this.df.format(this.dblMinEnv));
    }

    private void cboCacheEnv_onActionPerformed(ActionEvent evt) {
        this.bolCacheMinEnv = this.cboCacheEnv.isSelected();
        if (this.bolCacheMinEnv) {
            this.txtEnvSize.setEnabled(true);
            this.lblEnvSize.setEnabled(true);
        } else {
            this.txtEnvSize.setEnabled(false);
            this.lblEnvSize.setEnabled(false);
        }
    }

    private void cboCacheAll_onActionPerformed(ActionEvent evt) {
        this.bolCacheAll = this.cboCacheAll.isSelected();
    }

    private static class LayerCacheUndoableCommand
    extends UndoableCommand {
        private final Layer ly;
        private final boolean bolOldCacheAll;
        private final boolean bolNewCacheAll;
        private final boolean bolOldCacheMinEnv;
        private final boolean bolNewCacheMinEnv;
        private final double dblOldMinEnv;
        private final double dblNewMinEnv;

        LayerCacheUndoableCommand(Layer layer, boolean bolCacheAll, boolean bolCacheMinEnv, double dblMinEnv) {
            super("LayerCachePanel");
            this.ly = layer;
            this.bolOldCacheAll = this.ly.getCacheAll();
            this.bolOldCacheMinEnv = this.ly.getCacheMinEnv();
            this.dblOldMinEnv = this.ly.getCacheEnvSize();
            this.bolNewCacheAll = bolCacheAll;
            this.bolNewCacheMinEnv = bolCacheMinEnv;
            this.dblNewMinEnv = dblMinEnv;
        }

        @Override
        public void execute() {
            this.ly.setCacheAll(this.bolNewCacheAll);
            this.ly.setCacheMinEnv(this.bolNewCacheMinEnv);
            this.ly.setCacheEnvSize(this.dblNewMinEnv);
        }

        @Override
        public void unexecute() {
            this.ly.setCacheAll(this.bolOldCacheAll);
            this.ly.setCacheMinEnv(this.bolOldCacheMinEnv);
            this.ly.setCacheEnvSize(this.dblOldMinEnv);
        }
    }
}

