/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.components.ColorPanel;
import com.vividsolutions.jump.workbench.ui.style.AbstractPalettePanel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;

public class GridPalettePanel
extends AbstractPalettePanel {
    private static final int TILE_EXTENT = 26;
    private static final int ROWS = 6;
    private static final int COLUMNS = 5;

    public GridPalettePanel() {
        this.setLayout(new GridLayout(6, 5));
        Iterator<BasicStyleModel> k = GridPalettePanel.basicStyles().iterator();
        for (int i = 0; i < 6 && k.hasNext(); ++i) {
            for (int j = 0; j < 5 && k.hasNext(); ++j) {
                this.add(this.colorPanel(k.next()));
            }
        }
    }

    @Override
    public void setAlpha(int alpha, boolean bolArea, boolean bolLine) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ColorPanel colorPanel = (ColorPanel)this.getComponent(i);
            colorPanel.setFillColor(GUIUtil.alphaColor(colorPanel.getFillColor(), bolArea ? alpha : 255));
            colorPanel.setLineBaseColor(GUIUtil.alphaColor(colorPanel.getLineBaseColor(), bolLine ? alpha : 255));
        }
        this.repaint();
    }

    private Component colorPanel(final BasicStyleModel basicStyle) {
        ColorPanel colorPanel = new ColorPanel();
        colorPanel.setFillColor(RiwaJumpModelUtilities.colorByColorModel(basicStyle.getFillColor()));
        if (basicStyle.getLineBase() != null) {
            colorPanel.setLineBaseColor(RiwaJumpModelUtilities.colorByColorModel(basicStyle.getLineBase().getLineColor()));
        } else {
            colorPanel.setLineBaseColor(null);
        }
        colorPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GridPalettePanel.this.fireBasicStyleChosen(basicStyle);
            }
        });
        Dimension size = new Dimension(26, 26);
        colorPanel.setMaximumSize(size);
        colorPanel.setMinimumSize(size);
        colorPanel.setPreferredSize(size);
        return colorPanel;
    }
}

