/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.LayerStylePanel;
import com.vividsolutions.jump.workbench.ui.style.scale.ScaleRangeStylePanel;
import de.riwagis.geotools.feature.EmptyFeatureIterator;
import de.riwagis.geotools.feature.FeatureReaderIterator;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.gui.AttributePropertiesPanel;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JPanel;
import lombok.Generated;
import org.geotools.data.FeatureReader;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturestorePanel
extends JPanel
implements LayerStylePanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeaturestorePanel.class);
    private Layer layer = null;
    private DMDCollection dmdCol = null;
    private FeaturestoreMetadata fmdOri = null;
    private FeaturestoreMetadata fmdClone = null;
    private final de.riwagis.riwajump.data.gui.FeaturestorePanel pnlFeaturestore;
    private ScaleRangeStylePanel scalePanel = null;
    private FeaturestoreMetadata fmdRetriever = null;
    private AttributePropertiesPanel attributePropertiesPanel;
    private final FeatureRetriever featureRetriever = new FeatureRetriever(){

        @Override
        public SimpleFeatureType getFeatureType() {
            try {
                if (FeaturestorePanel.this.fmdRetriever == null || FeaturestorePanel.this.layer == null) {
                    return FeatureUtil.getEmptyFeatureType();
                }
                SimpleFeatureType fType = FeaturestorePanel.this.fmdRetriever.getQuerySchema(FeaturestorePanel.this.dmdCol);
                if (fType == null) {
                    return FeatureUtil.getEmptyFeatureType();
                }
                return fType;
            }
            catch (Throwable t) {
                log.warn("Could not retrieve feature type", t);
                return FeatureUtil.getEmptyFeatureType();
            }
        }

        @Override
        public String[] getAttributes() {
            if (FeaturestorePanel.this.fmdRetriever == null) {
                return new String[0];
            }
            return FeaturestorePanel.this.fmdRetriever.getAttributes();
        }

        @Override
        public FeatureIterator<SimpleFeature> getFeatureIterator(Filter filter) throws Exception {
            if (FeaturestorePanel.this.fmdRetriever == null || Objects.toString(FeaturestorePanel.this.fmdRetriever.getDatastoreName(), "").isEmpty()) {
                return new EmptyFeatureIterator();
            }
            FeatureReader<SimpleFeatureType, SimpleFeature> fr = FeaturestorePanel.this.fmdRetriever.getFeatureReader(FeaturestorePanel.this.dmdCol, filter);
            return new FeatureReaderIterator(fr);
        }

        @Override
        public String[] getTypeNames() {
            try {
                DatastoreMetadata dmd = FeaturestorePanel.this.dmdCol.getByName(FeaturestorePanel.this.fmdRetriever.getDatastoreName());
                if (dmd == null) {
                    throw new IOException(String.format(I18N.get("common.datastore-not-found"), FeaturestorePanel.this.fmdRetriever.getDatastoreName()));
                }
                return dmd.getDataStore().getTypeNames();
            }
            catch (Throwable t) {
                log.warn("Could not retrieve type names", t);
                return new String[0];
            }
        }

        @Override
        public SimpleFeatureType getFeatureType(String typeName) {
            try {
                if (FeaturestorePanel.this.fmdRetriever == null) {
                    return FeatureUtil.getEmptyFeatureType();
                }
                FeaturestoreMetadata fmdForName = FeaturestorePanel.this.fmdRetriever.clone();
                fmdForName.setDatatypeName(typeName);
                SimpleFeatureType fType = fmdForName.getSchema(FeaturestorePanel.this.dmdCol);
                if (fType == null) {
                    return FeatureUtil.getEmptyFeatureType();
                }
                return fType;
            }
            catch (Throwable t) {
                log.warn("Could not retrieve feature type", t);
                return FeatureUtil.getEmptyFeatureType();
            }
        }

        @Override
        public SimpleFeatureType getFeatureTypeWithAttributes(String typeName, String[] attributes) {
            try {
                if (FeaturestorePanel.this.fmdRetriever == null) {
                    return FeatureUtil.getEmptyFeatureType();
                }
                FeaturestoreMetadata fmdForName = FeaturestorePanel.this.fmdRetriever.clone();
                fmdForName.setDatatypeName(typeName);
                fmdForName.setAttributes(attributes);
                SimpleFeatureType fType = fmdForName.getQuerySchema(FeaturestorePanel.this.dmdCol);
                if (fType == null) {
                    return FeatureUtil.getEmptyFeatureType();
                }
                return fType;
            }
            catch (Throwable t) {
                log.warn("Could not retrieve feature type", t);
                return FeatureUtil.getEmptyFeatureType();
            }
        }

        @Override
        public String testConnection(String typeName, String[] attributes, String keyAttribute, String filter) {
            try {
                FeaturestoreMetadata fmdToCheck = new FeaturestoreMetadata("_internal");
                fmdToCheck.setDatastoreName(FeaturestorePanel.this.fmdRetriever.getDatastoreName());
                fmdToCheck.setDatatypeName(typeName);
                fmdToCheck.setAttributes(attributes);
                fmdToCheck.setKeyAtt(keyAttribute);
                fmdToCheck.setFilterText(filter);
                return fmdToCheck.testConnection(FeaturestorePanel.this.dmdCol);
            }
            catch (Throwable t) {
                log.warn("Could not retrieve feature type", t);
                return t.getLocalizedMessage();
            }
        }
    };
    private JButton butApply;
    private JButton butTestConnection;
    private JPanel pnlFeaturestoreSup;

    public FeaturestorePanel(Layerable _layer) {
        this.initComponents();
        this.pnlFeaturestore = (de.riwagis.riwajump.data.gui.FeaturestorePanel)this.pnlFeaturestoreSup;
        this.i18n();
        this.setLayerable(_layer);
        this.pnlFeaturestore.addActionListener(e -> this.butApply.setEnabled(true));
    }

    private void i18n() {
        this.butApply.setText(I18N.get("ui.style.FeaturestorePanel.apply"));
        this.butTestConnection.setText(I18N.get("ui.style.FeaturestorePanel.test-connection"));
    }

    public void setStyleCollection(StyleCollection _sCol) {
    }

    public void setScalePanel(ScaleRangeStylePanel _scalePanel) {
        this.scalePanel = _scalePanel;
    }

    public void setAttributePropertiesPanel(AttributePropertiesPanel attributePropertiesPanel) {
        this.attributePropertiesPanel = attributePropertiesPanel;
    }

    @Override
    public final void setLayerable(Layerable _layer) {
        this.layer = (Layer)_layer;
        this.dmdCol = this.layer.getLayerManager().getTask().getLocalDataStores();
        this.fmdOri = this.layer.getFMD();
        this.fmdClone = this.fmdOri.clone();
        this.pnlFeaturestore.setDMDCol(this.dmdCol);
        this.pnlFeaturestore.setFMD(this.fmdClone);
        this.pnlFeaturestore.setLayerType(this.layer.getLayerType());
        this.fmdRetriever = this.fmdClone.clone();
        this.butApply.setEnabled(false);
    }

    @Override
    public String isPanelEnabled() {
        return this.layer.hasUncommitedData() ? I18N.get("de.riwagis.gis.context.jump.VectorLayerContextImpl.uncommited-features") : null;
    }

    @Override
    public UndoableCommand updateLayer() {
        FeaturestorePanelUndoableCommand undo = new FeaturestorePanelUndoableCommand(this.layer, this.fmdOri.clone(), this.fmdClone.clone());
        return undo;
    }

    @Override
    public String validateInput() {
        String errorMessage = this.pnlFeaturestore.testConnection();
        if (errorMessage != null) {
            return this.getTitle() + ": " + errorMessage;
        }
        return null;
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.FeaturestorePanel.title");
    }

    public FeatureRetriever getFeatureRetriever() {
        return this.featureRetriever;
    }

    private void initComponents() {
        this.butApply = new JButton();
        this.pnlFeaturestoreSup = new de.riwagis.riwajump.data.gui.FeaturestorePanel();
        this.butTestConnection = new JButton();
        this.setLayout(new GridBagLayout());
        this.butApply.setText("Anwenden in Darstellung");
        this.butApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturestorePanel.this.butApply_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 9, 3);
        this.add((Component)this.butApply, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlFeaturestoreSup, gridBagConstraints);
        this.butTestConnection.setText("Datenzugriff testen");
        this.butTestConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturestorePanel.this.butTestConnectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 9, 3);
        this.add((Component)this.butTestConnection, gridBagConstraints);
    }

    private void butApply_onActionPerformed(ActionEvent evt) {
        String strError = this.pnlFeaturestore.testConnection();
        if (strError != null) {
            GUISupport.msgbox((Component)this, (String)I18N.getMessage("ui.style.FeaturestorePanel.apply-not-possible", strError), (String)I18N.get("common.error"));
            return;
        }
        this.fmdRetriever = this.fmdClone.clone();
        if (this.scalePanel != null) {
            this.scalePanel.setFeatureRetrieverToPanels();
        }
        if (this.attributePropertiesPanel != null) {
            this.attributePropertiesPanel.setFeatureRetriever(this.getFeatureRetriever());
        }
        this.butApply.setEnabled(false);
    }

    private void butTestConnectionActionPerformed(ActionEvent evt) {
        String strError = this.pnlFeaturestore.testConnection();
        if (strError == null) {
            GUISupport.msgbox((Component)this, (String)I18N.get("ui.style.FeaturestorePanel.connection-test-ok"), (String)I18N.get("common.message"));
        } else {
            GUISupport.msgbox((Component)this, (String)strError, (String)I18N.get("common.error"));
        }
    }

    private static class FeaturestorePanelUndoableCommand
    extends UndoableCommand {
        private final Layer ly;
        private final FeaturestoreMetadata fmdOld;
        private final FeaturestoreMetadata fmdNew;

        FeaturestorePanelUndoableCommand(Layer layer, FeaturestoreMetadata _fmdOld, FeaturestoreMetadata _fmdNew) {
            super("FeaturestorePanel");
            this.ly = layer;
            this.fmdOld = _fmdOld;
            this.fmdNew = _fmdNew;
        }

        @Override
        public void execute() {
            this.ly.setFMD(this.fmdNew);
        }

        @Override
        public void unexecute() {
            this.ly.setFMD(this.fmdOld);
        }
    }
}

