/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.style.BasicStyleDialog;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.ThemeSourcePanel;
import com.vividsolutions.jump.workbench.ui.style.theming.BeanShellCellRendererAndEditor;
import com.vividsolutions.jump.workbench.ui.style.theming.ModificatorCellRendererAndEditor;
import com.vividsolutions.jump.workbench.ui.style.theming.ModificatorI18N;
import com.vividsolutions.jump.workbench.ui.style.theming.ModificatorTableModel;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.data.gui.AttributeListDialog;
import de.riwagis.riwajump.data.gui.DatatypeListDialog;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.theme.DynamicThemeModificatorModel;
import de.riwagis.riwajump.model.style.theme.DynamicThemeModificators;
import de.riwagis.riwajump.model.style.theme.DynamicThemeSourceModel;
import de.riwagis.riwajump.model.style.theme.ThemeSourceModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicThemeSourcePanel
extends ThemeSourcePanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicThemeSourcePanel.class);
    private final ThemeStyleController themeStyleController;
    private DynamicThemeSourceModel dynamicSource;
    private AttributeListDialog dlgAttribute;
    private DatatypeListDialog dlgDatatype;
    private boolean blockEvents = false;
    private final SortedSet<String> sortedProperties;
    private final ModificatorI18N modificatorI18N = new ModificatorI18N();
    private JButton butAdd;
    private JButton butAttributes;
    private JButton butDatatype;
    private JButton butDelete;
    private JButton butEditTemplateStyle;
    private JButton butThemeLabelDef;
    private JComboBox<String> cmbKeyAtt;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblAttribute;
    private JLabel lblDatatype;
    private JLabel lblDefaultLabel;
    private JLabel lblFilter;
    private JLabel lblKeyAtt;
    private JLabel lblThemeLabel;
    private JTable modTable;
    private JToolBar tableBar;
    private JScrollPane tableScrollPane;
    private JTextArea txtAttribute;
    private JTextField txtDatatype;
    private JTextField txtDefaultLabel;
    private JTextArea txtFilter;
    private JTextField txtThemeLabelDef;

    public DynamicThemeSourcePanel(ThemeStyleController themeStyleController) {
        this.themeStyleController = themeStyleController;
        this.sortedProperties = DynamicThemeModificators.getInstance().getStyleApplierNames().stream().sorted().collect(Collectors.toCollection(TreeSet::new));
        this.initComponents();
        this.initTable();
        this.i18n();
    }

    private void initTable() {
        TableColumn columnKey = this.modTable.getColumnModel().getColumn(0);
        columnKey.setCellRenderer(new ModificatorCellRendererAndEditor());
        columnKey.setCellEditor(new ModificatorCellRendererAndEditor());
        TableColumn columnValue = this.modTable.getColumnModel().getColumn(1);
        columnValue.setCellRenderer(new BeanShellCellRendererAndEditor(this::promptModificatorBeanShell));
        columnValue.setCellEditor(new BeanShellCellRendererAndEditor(this::promptModificatorBeanShell));
        this.modTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.modTable.getSelectionModel().addListSelectionListener(e -> this.butDelete.setEnabled(this.modTable.getSelectedRowCount() > 0));
        this.modTable.getModel().addTableModelListener(e -> this.butAdd.setEnabled(this.modTable.getRowCount() < DynamicThemeModificators.getInstance().getStyleApplierNames().size()));
    }

    private void promptModificatorBeanShell(DynamicThemeModificatorModel mod) {
        SimpleFeatureType featureTypeWithAttributes = this.themeStyleController.getFeatureRetriever().getFeatureTypeWithAttributes(this.dynamicSource.getDatatypeName(), this.getAttributesAsArray());
        if (mod.getApplierType().canBeBeanShell()) {
            this.themeStyleController.promptAttributeDefinitionWithEscapeOption(featureTypeWithAttributes, new BeanShellDefinition(mod.getBsh(), mod.isResultBeanShell()), newDefinition -> {
                mod.setBsh(newDefinition.getSource());
                mod.setResultIsBeanShell(newDefinition.isResultBeanShell());
            });
        } else {
            this.themeStyleController.promptAttributeDefinition(featureTypeWithAttributes, mod.getBsh(), newValue -> {
                mod.setBsh(newValue);
                mod.setResultIsBeanShell(false);
            });
        }
    }

    private void i18n() {
        this.lblDatatype.setText(I18N.get("ui.style.DynamicThemeSourcePanel.datatype"));
        this.lblAttribute.setText(I18N.get("ui.style.DynamicThemeSourcePanel.attributes"));
        this.lblFilter.setText(I18N.get("ui.style.DynamicThemeSourcePanel.filter"));
        this.lblKeyAtt.setText(I18N.get("ui.style.DynamicThemeSourcePanel.scheme-attribute"));
        this.lblThemeLabel.setText(I18N.get("ui.style.DynamicThemeSourcePanel.scheme-label"));
        this.butEditTemplateStyle.setText(I18N.get("ui.style.DynamicThemeSourcePanel.edit-template-style"));
        this.lblDefaultLabel.setText(I18N.get("ui.style.DynamicThemeSourcePanel.default-label"));
        this.butAdd.setIcon(IconLoader.svgIcon((String)"common_add.svg"));
        this.butAdd.setToolTipText(I18N.get("ui.style.DynamicThemeSourcePanel.insert-modificator"));
        this.butDelete.setIcon(IconLoader.svgIcon((String)"common_delete.svg"));
        this.butDelete.setToolTipText(I18N.get("ui.style.DynamicThemeSourcePanel.delete-modificator"));
    }

    public DynamicThemeSourceModel getThemeSource() {
        return this.dynamicSource;
    }

    public void setThemeSource(ThemeSourceModel source) {
        if (!(source instanceof DynamicThemeSourceModel)) {
            throw new IllegalArgumentException("ThemeSource is not matching this panel");
        }
        this.dynamicSource = (DynamicThemeSourceModel)source;
        this.updateFromModel();
    }

    @Override
    public void updateFromModel() {
        try {
            this.blockEvents = true;
            if (this.dynamicSource == null) {
                return;
            }
            this.txtDatatype.setText(this.dynamicSource.getDatatypeName());
            this.txtAttribute.setText(this.dynamicSource.getAttributes().stream().collect(Collectors.joining(",")));
            this.txtFilter.setText(this.dynamicSource.getFilter());
            this.txtThemeLabelDef.setText(this.dynamicSource.getLabelTemplate());
            this.txtDefaultLabel.setText(this.dynamicSource.getDefaultLabel());
            this.updateAttributesUIFromModel();
            this.updateTableFromModel();
        }
        finally {
            this.blockEvents = false;
        }
    }

    private void updateTableFromModel() {
        ModificatorTableModel model = (ModificatorTableModel)this.modTable.getModel();
        this.dynamicSource.getModificators().sort(Comparator.comparing(DynamicThemeModificatorModel::getProperty));
        model.updateContent(this.dynamicSource.getModificators());
    }

    private void updateAttributesUIFromModel() {
        this.cmbKeyAtt.removeAllItems();
        if (this.dynamicSource == null) {
            return;
        }
        this.cmbKeyAtt.addItem("_PrimaryKey");
        if (!this.dynamicSource.getAttributes().contains(this.dynamicSource.getThemeAttribute())) {
            this.dynamicSource.setThemeAttribute("_PrimaryKey");
        }
        this.dynamicSource.getAttributes().stream().forEach(this.cmbKeyAtt::addItem);
        this.cmbKeyAtt.setSelectedItem(this.dynamicSource.getThemeAttribute());
    }

    public String validateInput() {
        if (StringUtils.isBlank((String)this.dynamicSource.getDatatypeName())) {
            return I18N.get("ui.style.DynamicThemeSourcePanel.table-should-not-be-empty");
        }
        if (StringUtils.isBlank((String)this.dynamicSource.getThemeAttribute())) {
            return I18N.get("ui.style.DynamicThemeSourcePanel.theme-attribute-should-not-be-empty");
        }
        if (this.dynamicSource.getAttributes().isEmpty()) {
            return I18N.get("ui.style.DynamicThemeSourcePanel.attributes-should-not-be-empty");
        }
        String schemaErrors = this.themeStyleController.getFeatureRetriever().testConnection(this.dynamicSource.getDatatypeName(), this.getAttributesAsArray(), this.dynamicSource.getThemeAttribute(), this.dynamicSource.getFilter());
        if (schemaErrors != null) {
            return schemaErrors;
        }
        List duplicateProperties = this.getThemeSource().getModificators().stream().collect(Collectors.groupingBy(mod -> mod.getProperty())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!duplicateProperties.isEmpty()) {
            String translatedProperties = duplicateProperties.stream().map(this.modificatorI18N::get).collect(Collectors.joining("\n"));
            return I18N.getMessage("ui.style.DynamicThemeSourcePanel.duplicate-properties", translatedProperties);
        }
        return null;
    }

    @Override
    public void updateStyleFromDialog(BasicStyleDialog basicStyleDialog) {
        basicStyleDialog.updateBasicStyle(this.dynamicSource.getTemplateStyle());
        this.themeStyleController.fireStyleChanged();
    }

    void showDefaultLabel(boolean visible) {
        this.txtDefaultLabel.setVisible(visible);
        this.lblDefaultLabel.setVisible(visible);
    }

    @Override
    void stopEditing() {
        this.stopCellEditing();
    }

    private void stopCellEditing() {
        TableCellEditor cellEditor = this.modTable.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        cellEditor.stopCellEditing();
    }

    @Override
    void refreshBasicStyleDialog() {
        this.themeStyleController.setBasicStyleToDialog(this.dynamicSource.getTemplateStyle());
    }

    private void initComponents() {
        this.lblDatatype = new JLabel();
        this.cmbKeyAtt = new JComboBox();
        this.lblKeyAtt = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtAttribute = new JTextArea();
        this.lblAttribute = new JLabel();
        this.txtDatatype = new JTextField();
        this.butDatatype = new JButton();
        this.butAttributes = new JButton();
        this.lblFilter = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.txtFilter = new JTextArea();
        this.butEditTemplateStyle = new JButton();
        this.lblThemeLabel = new JLabel();
        this.butThemeLabelDef = new JButton();
        this.txtThemeLabelDef = new JTextField();
        this.lblDefaultLabel = new JLabel();
        this.txtDefaultLabel = new JTextField();
        this.tableScrollPane = new JScrollPane();
        this.modTable = new JTable();
        this.tableBar = new JToolBar();
        this.butAdd = new JButton();
        this.butDelete = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblDatatype.setText("Tabelle:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 9, 3, 3);
        this.add((Component)this.lblDatatype, gridBagConstraints);
        this.cmbKeyAtt.setMinimumSize(new Dimension(130, 22));
        this.cmbKeyAtt.setPreferredSize(new Dimension(130, 22));
        this.cmbKeyAtt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamicThemeSourcePanel.this.cmbKeyAtt_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.cmbKeyAtt, gridBagConstraints);
        this.lblKeyAtt.setText("Thema-Attribut:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.add((Component)this.lblKeyAtt, gridBagConstraints);
        this.txtAttribute.setColumns(30);
        this.txtAttribute.setFont(this.txtDatatype.getFont());
        this.txtAttribute.setLineWrap(true);
        this.txtAttribute.setRows(2);
        this.txtAttribute.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DynamicThemeSourcePanel.this.txtAttribute_onKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.txtAttribute);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblAttribute.setText("Attribute:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.lblAttribute, gridBagConstraints);
        this.txtDatatype.setColumns(30);
        this.txtDatatype.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DynamicThemeSourcePanel.this.txtDatatype_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtDatatype, gridBagConstraints);
        this.butDatatype.setText("...");
        this.butDatatype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamicThemeSourcePanel.this.butDatatype_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butDatatype, gridBagConstraints);
        this.butAttributes.setText("...");
        this.butAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamicThemeSourcePanel.this.butAttributes_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butAttributes, gridBagConstraints);
        this.lblFilter.setText("Filter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblFilter, gridBagConstraints);
        this.txtFilter.setColumns(30);
        this.txtFilter.setFont(this.txtDatatype.getFont());
        this.txtFilter.setLineWrap(true);
        this.txtFilter.setRows(2);
        this.txtFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DynamicThemeSourcePanel.this.txtFilter_onKeyReleased(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.txtFilter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.butEditTemplateStyle.setText("Vorlagenstil bearbeiten...");
        this.butEditTemplateStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamicThemeSourcePanel.this.butEditTemplateStyleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butEditTemplateStyle, gridBagConstraints);
        this.lblThemeLabel.setText("Beschriftung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.add((Component)this.lblThemeLabel, gridBagConstraints);
        this.butThemeLabelDef.setText("...");
        this.butThemeLabelDef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamicThemeSourcePanel.this.butThemeLabelDef_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butThemeLabelDef, gridBagConstraints);
        this.txtThemeLabelDef.setEditable(false);
        this.txtThemeLabelDef.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtThemeLabelDef, gridBagConstraints);
        this.lblDefaultLabel.setText("Standard-Beschriftung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.add((Component)this.lblDefaultLabel, gridBagConstraints);
        this.txtDefaultLabel.setColumns(30);
        this.txtDefaultLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DynamicThemeSourcePanel.this.txtDefaultLabelKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtDefaultLabel, gridBagConstraints);
        this.tableScrollPane.setPreferredSize(new Dimension(400, 150));
        this.modTable.setModel(new ModificatorTableModel(Collections.emptyList()));
        this.modTable.setShowGrid(true);
        this.modTable.getTableHeader().setReorderingAllowed(false);
        this.tableScrollPane.setViewportView(this.modTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tableScrollPane, gridBagConstraints);
        this.tableBar.setRollover(true);
        this.butAdd.setHorizontalTextPosition(0);
        this.butAdd.setMaximumSize(new Dimension(22, 22));
        this.butAdd.setMinimumSize(new Dimension(22, 22));
        this.butAdd.setPreferredSize(new Dimension(22, 22));
        this.butAdd.setVerticalTextPosition(3);
        this.butAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamicThemeSourcePanel.this.butAdd_onActionPerformed(evt);
            }
        });
        this.tableBar.add(this.butAdd);
        this.butDelete.setHorizontalTextPosition(0);
        this.butDelete.setMaximumSize(new Dimension(22, 22));
        this.butDelete.setMinimumSize(new Dimension(22, 22));
        this.butDelete.setPreferredSize(new Dimension(22, 22));
        this.butDelete.setVerticalTextPosition(3);
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamicThemeSourcePanel.this.butDelete_onActionPerformed(evt);
            }
        });
        this.tableBar.add(this.butDelete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tableBar, gridBagConstraints);
    }

    private void cmbKeyAtt_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        Object selectedItem = this.cmbKeyAtt.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        this.dynamicSource.setThemeAttribute(selectedItem.toString());
    }

    private void txtAttribute_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        List attributes = Arrays.stream(this.txtAttribute.getText().split(",")).map(String::trim).filter(i -> !i.isEmpty()).collect(Collectors.toList());
        this.dynamicSource.setAttributes(attributes);
        this.updateAttributesUIFromModel();
    }

    private void txtDatatype_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.dynamicSource.setDatatypeName(this.txtDatatype.getText());
    }

    private void butDatatype_onActionPerformed(ActionEvent evt) {
        try {
            if (this.dlgDatatype == null) {
                this.dlgDatatype = DatatypeListDialog.createCenteredToWindow(this);
            }
            this.dlgDatatype.setTypeNames(this.themeStyleController.getFeatureRetriever().getTypeNames());
            if (this.dynamicSource.getDatatypeName() != null) {
                this.dlgDatatype.setDatatype(this.dynamicSource.getDatatypeName());
            }
            this.dlgDatatype.setVisible(true);
            if (this.dlgDatatype.wasOKPressed()) {
                this.dynamicSource.setDatatypeName(this.dlgDatatype.getDatatype());
                this.updateFromModel();
            }
        }
        catch (Exception e) {
            log.error("Error at table selection.", (Throwable)e);
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private void butAttributes_onActionPerformed(ActionEvent evt) {
        try {
            SimpleFeatureType featureType = this.themeStyleController.getFeatureRetriever().getFeatureType(this.dynamicSource.getDatatypeName());
            if (this.dlgAttribute == null) {
                this.dlgAttribute = AttributeListDialog.createCenteredToWindow(this);
            }
            this.dlgAttribute.setFeatureType(featureType);
            this.dlgAttribute.setAttributeNames(this.getAttributesAsArray());
            this.dlgAttribute.setVisible(true);
            if (this.dlgAttribute.wasOKPressed()) {
                this.dynamicSource.setAttributes(Arrays.asList(this.dlgAttribute.getAttributeNames()));
                this.updateFromModel();
            }
        }
        catch (Exception e) {
            log.error("Error at attribute selection.", (Throwable)e);
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private String[] getAttributesAsArray() {
        return (String[])this.dynamicSource.getAttributes().toArray(String[]::new);
    }

    private void txtFilter_onKeyReleased(KeyEvent evt) {
        this.dynamicSource.setFilter(this.txtFilter.getText());
    }

    private void butEditTemplateStyleActionPerformed(ActionEvent evt) {
        this.themeStyleController.promptBasicStyleDialog(this.dynamicSource.getTemplateStyle());
    }

    private void butThemeLabelDef_onActionPerformed(ActionEvent evt) {
        this.themeStyleController.promptAttributeDefinition(this.themeStyleController.getFeatureRetriever().getFeatureTypeWithAttributes(this.dynamicSource.getDatatypeName(), this.getAttributesAsArray()), this.dynamicSource.getLabelTemplate(), arg_0 -> ((DynamicThemeSourceModel)this.dynamicSource).setLabelTemplate(arg_0));
        this.updateFromModel();
    }

    private void txtDefaultLabelKeyReleased(KeyEvent evt) {
        this.dynamicSource.setDefaultLabel(this.txtDefaultLabel.getText());
    }

    private void butAdd_onActionPerformed(ActionEvent evt) {
        this.stopCellEditing();
        List modificators = this.getThemeSource().getModificators();
        Set propertiesInUse = modificators.stream().map(m -> m.getProperty()).distinct().collect(Collectors.toSet());
        String firstUnusedProperty = this.sortedProperties.stream().filter(p -> !propertiesInUse.contains(p)).findFirst().orElseThrow();
        modificators.add(new DynamicThemeModificatorModel(firstUnusedProperty, ""));
        ModificatorTableModel model = (ModificatorTableModel)this.modTable.getModel();
        model.updateContent(modificators);
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        this.stopCellEditing();
        ModificatorTableModel model = (ModificatorTableModel)this.modTable.getModel();
        List modificators = this.getThemeSource().getModificators();
        Set elementsToRemove = Arrays.stream(this.modTable.getSelectedRows()).mapToObj(modificators::get).collect(Collectors.toSet());
        modificators.removeAll(elementsToRemove);
        model.updateContent(modificators);
    }

    static interface ThemeStyleController {
        public void promptAttributeDefinitionWithEscapeOption(SimpleFeatureType var1, BeanShellDefinition var2, Consumer<BeanShellDefinition> var3);

        public void promptAttributeDefinition(SimpleFeatureType var1, String var2, Consumer<String> var3);

        public void promptBasicStyleDialog(BasicStyleModel var1);

        public void setBasicStyleToDialog(BasicStyleModel var1);

        public FeatureRetriever getFeatureRetriever();

        public LayerStyleCollection getStyleCollection();

        public PlugInContext getContext();

        public void fireStyleChanged();
    }

    static class BeanShellDefinition {
        private final String source;
        private final boolean resultIsBeanShell;

        public BeanShellDefinition(String source, boolean resultIsBeanShell) {
            this.source = source;
            this.resultIsBeanShell = resultIsBeanShell;
        }

        public String getSource() {
            return this.source;
        }

        public boolean isResultBeanShell() {
            return this.resultIsBeanShell;
        }
    }
}

